/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JFrame;

public class RasterCruncher {
    int countequal;
    int countdiff;
    boolean crunchdata;
    byte[] packeddata;
    FileDialog dialog;

    public static void main(String[] args) {
        RasterCruncher c = new RasterCruncher();
        c.unPack();
    }

    public void unPack() {
        if (this.dialog == null) {
            this.dialog = new FileDialog((Frame)new JFrame(), "Open", 0);
        }
        this.dialog.setVisible(true);
        String file = this.dialog.getFile();
        if (file != null) {
            String path = this.dialog.getDirectory();
            String[] files = new File(path).list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].toLowerCase().endsWith(".pkm") && !files[i].toLowerCase().endsWith(".pkz")) continue;
                this.unpack(path, files[i]);
            }
        }
        System.exit(0);
    }

    public void unpack(String path, String file) {
        File a = new File(path + file);
        byte[] toUncrunch = new byte[(int)a.length()];
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
            bin.read(toUncrunch);
            bin.close();
            byte[] unpacked = new byte[0xFA00000];
            this.uncrunch(toUncrunch, unpacked);
            int lastoff = unpacked.length;
            for (int i = unpacked.length - 1; i >= 0; --i) {
                int g = unpacked[i] & 0xFF;
                if (g == 0) {
                    --lastoff;
                }
                if (g != 0) break;
            }
            byte[] f = new byte[lastoff];
            System.arraycopy(unpacked, 0, f, 0, f.length);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(path + file + ".RAW")));
            bos.write(f);
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] uncrunch(byte[] packed) {
        int packedpos = 0;
        boolean unpackedpos = false;
        int tmppos = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        packedpos = 0;
        while (packedpos < packed.length) {
            int temp;
            if ((temp = packed[packedpos++] & 0xFF) > 127) {
                int i = temp;
                for (tmppos = 0; tmppos < i - 128; ++tmppos) {
                    temp = packed[packedpos++] & 0xFF;
                    bos.write(temp);
                }
                continue;
            }
            int temp2 = temp;
            temp = packed[packedpos++] & 0xFF;
            for (tmppos = 0; tmppos < temp2; ++tmppos) {
                bos.write(temp);
            }
        }
        return bos.toByteArray();
    }

    public byte[] uncrunch(byte[] packed, byte[] unpack) {
        byte[] unpacked = new byte[0xFA00000];
        int packedpos = 0;
        int unpackedpos = 0;
        int tmppos = 0;
        packedpos = 0;
        while (packedpos < packed.length) {
            int temp;
            if ((temp = packed[packedpos++] & 0xFF) > 127) {
                int j = temp;
                for (tmppos = 0; tmppos < j - 128; ++tmppos) {
                    temp = packed[packedpos++] & 0xFF;
                    unpacked[unpackedpos++] = (byte)temp;
                }
                continue;
            }
            int temp2 = temp;
            temp = packed[packedpos++] & 0xFF;
            for (tmppos = 0; tmppos < temp2; ++tmppos) {
                unpacked[unpackedpos++] = (byte)temp;
            }
        }
        int lastoff = unpacked.length;
        for (int i = unpacked.length - 1; i >= 0; --i) {
            int g = unpacked[i] & 0xFF;
            if (g == 0) {
                --lastoff;
            }
            if (g != 0) break;
        }
        byte[] f = new byte[lastoff];
        System.arraycopy(unpacked, 0, f, 0, f.length);
        return f;
    }

    public byte[] crunch(byte[] data) {
        int packedpos = 0;
        int unpackedpos = 0;
        int tempcount = 0;
        int tempunpackedpos = 0;
        int i = 0;
        this.packeddata = new byte[data.length * 2];
        int datalength = data.length - 1;
        unpackedpos = 0;
        packedpos = 0;
        this.countequal = 0;
        this.countdiff = 0;
        this.crunchdata = true;
        while (this.crunchdata) {
            byte temp = data[unpackedpos];
            if (data[unpackedpos] != data[unpackedpos + 1]) {
                tempcount = 0;
                for (tempunpackedpos = unpackedpos; tempcount < 126 && data[tempunpackedpos] != data[tempunpackedpos + 1] && tempunpackedpos < datalength - 1; ++tempcount, ++tempunpackedpos) {
                }
                ++tempunpackedpos;
                this.packeddata[packedpos] = (byte)(127 + tempcount + 1);
                ++packedpos;
                for (i = 0; i < tempcount; ++i) {
                    this.packeddata[packedpos] = data[unpackedpos];
                    ++packedpos;
                    ++unpackedpos;
                }
                if (tempunpackedpos < datalength - 1) continue;
                this.crunchdata = false;
                break;
            }
            for (tempcount = 0; tempcount < 126 && temp == data[unpackedpos + 1] && unpackedpos < datalength - 1; ++tempcount, ++unpackedpos) {
            }
            this.packeddata[packedpos] = (byte)(tempcount + 1);
            this.packeddata[packedpos + 1] = temp;
            packedpos += 2;
            if (++unpackedpos < datalength - 1) continue;
            this.crunchdata = false;
            break;
        }
        byte[] packed = new byte[packedpos];
        System.arraycopy(this.packeddata, 0, packed, 0, packed.length);
        return packed;
    }
}

