/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import JCPC.core.device.Device;
import com.jhlabs.image.AverageFilter;
import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.GainFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jemu.core.Util;
import jemu.core.samples.Samples;
import jemu.settings.DSettings;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.DOSHandler;
import jemu.system.cpc.GateArray;
import jemu.ui.JEMU;
import jemu.ui.cpcgamescd.CPCFileSystem;
import jemu.ui.paint.ImageFileView;
import jemu.ui.paint.ImageFilter;
import jemu.ui.paint.ImageFromClipboard;
import jemu.ui.paint.ImageImporter;
import jemu.ui.paint.ImagePreview;
import jemu.ui.paint.PaintCanvas;
import jemu.ui.paint.RasterCruncher;
import jemu.ui.paint.RasterData;
import jemu.ui.paint.RasterPaintColorSelector;
import jemu.util.ass.EditorPanel;

public class RasterPaint
extends JFrame {
    private ArrayList<DropTarget> dropTargetList;
    CPCFileSystem system;
    RasterData data;
    ContrastFilter contrastfilter = new ContrastFilter();
    AverageFilter softenfilter = new AverageFilter();
    GainFilter gainfilter = new GainFilter();
    FileDialog saveasm;
    FileDialog savecrunched;
    FileDialog savenormal;
    protected String asmcode;
    protected String asmcode2;
    boolean[][] render_zone = new boolean[8][200];
    boolean[] render_line = new boolean[200];
    int[][] manualPen1 = new int[8][200];
    boolean[][] manualP1 = new boolean[8][200];
    int[] manualPen2 = new int[200];
    boolean[] manualP2 = new boolean[200];
    int[] manualPen3 = new int[200];
    boolean[] manualP3 = new boolean[200];
    RasterPaintColorSelector selector;
    boolean rasterLock = false;
    EditorPanel assembler;
    Image zoomcursor;
    Color pSize;
    Thread Display;
    boolean isVisible = true;
    protected byte[] rasterTable;
    JFileChooser chooser = null;
    String loadname;
    protected String ffile;
    Image preLoaded;
    ImageImporter imageImporter;
    BufferedImage result;
    Image buffer;
    String internalname = "";
    BufferedImage CPCImage;
    BufferedImage loadedImage;
    BufferedImage previewImage;
    BufferedImage RGBImage;
    int mode = 1;
    float[] Gain;
    BufferedImage DitherImage;
    PaintCanvas can;
    boolean blink;
    BufferedImage zoomed;
    BufferedImage line;
    BufferedImage ditherline;
    BufferedImage rgbline;
    int[] pixels;
    int[] screenpixels;
    int[] mostPen;
    FileDialog create;
    FileDialog open;
    byte[] packedcode;
    byte[] packedrastercode;
    DOSHandler handler;
    RasterCruncher cruncher;
    int[] javacpcarea;
    int[] javacpcwarea;
    int[] javacpcsarea;
    int[] cpcarea;
    int[] cpcwarea;
    int[] cpcsarea;
    int[][] pen1;
    int[][] direction;
    boolean[][] block;
    int[] pen2;
    int[] pen3;
    int[][] mostPen1;
    int[] area;
    int[] warea;
    int[] sarea;
    int paper = 0;
    int rendermode = 640;
    protected int zone;
    int lastpen1;
    int lastpen2;
    int lastpen3;
    int[] cpcpic;
    int rastermode = 0;
    int pen1zone;
    int pen1line;
    int pen2line;
    int pen3line;
    MouseEvent lastMouse;
    BufferedImage overlay;
    int zoomf = 3;
    boolean flash;
    boolean flasher;
    boolean shift;
    boolean colormode = false;
    int blockdirection = 0;
    boolean linemode = false;
    boolean blur = false;
    private JCheckBox alt;
    private JCheckBox auto;
    private JSlider bright;
    private JSlider contrast;
    public static JPanel control;
    private JTextField diskname;
    private JCheckBox dither;
    private JLabel format;
    private JLabel free;
    private JSlider gain;
    private JSlider hDist;
    private JCheckBox hide;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButtonClip;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JComboBox<String> jComboBox1;
    private JFrame jFrame1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JList<String> jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextArea jTextArea3;
    private JTextArea jTextArea4;
    private JTextArea jTextArea5;
    private JCheckBox javacpc;
    private JCheckBox method;
    private JComboBox<String> p0;
    private JComboBox<String> p2;
    private JComboBox<String> p3;
    private JLabel picture;
    public static JCheckBox prerender;
    private JLabel psize;
    private JTextField rasname;
    public JPanel rasterpaint;
    public static JCheckBox reverse;
    private JSlider rslider;
    private JLabel size;
    private JLabel zoom;
    boolean clipimport = false;
    JPanel buttons = new JPanel();
    boolean ctrl = false;
    ImageFromClipboard clip;

    protected void lockRaster(boolean lock) {
        this.rasterLock = lock;
        this.Import(this.ffile);
    }

    protected void saveASM() {
        if (this.saveasm == null) {
            this.saveasm = new FileDialog((Frame)this, "Save ASM code(s)", 1);
        }
        this.saveasm.setVisible(true);
        if (this.saveasm.getFile() != null) {
            this.saveASM(this.saveasm.getDirectory(), this.saveasm.getFile(), false);
        }
    }

    protected void removeBlocks() {
        this.resetLines();
        this.Import(this.ffile);
    }

    protected void assembleIt() {
        if (this.saveasm == null) {
            this.saveasm = new FileDialog((Frame)this, "Save ASM code(s)", 1);
        }
        this.saveasm.setVisible(true);
        if (this.saveasm.getFile() != null) {
            this.saveASM(this.saveasm.getDirectory(), this.saveasm.getFile(), true);
        }
    }

    protected void saveASM(final String path, final String f, final boolean write) {
        Thread saveIt = new Thread(){

            @Override
            public void run() {
                String file2;
                String file3;
                RasterPaint.this.jButton11.setEnabled(false);
                RasterPaint.this.jButton4.setEnabled(false);
                String file = f;
                if (file.toLowerCase().endsWith(".asm")) {
                    file = file.substring(0, file.length() - 4);
                }
                String file4 = file3 = (file2 = file);
                String ASMname = file;
                ASMname = ASMname.toLowerCase().replace(".asm", "");
                while (ASMname.length() > 8) {
                    ASMname = ASMname.substring(0, ASMname.length() - 1);
                }
                ASMname = ASMname.toUpperCase();
                ASMname = ASMname + ".BIN";
                file = file + ".asm";
                String part1 = RasterPaint.this.jTextArea1.getText();
                if (RasterPaint.this.rasterLock) {
                    part1 = RasterPaint.this.jTextArea4.getText();
                }
                if (write) {
                    part1 = part1.replace("\t\t; First:", "\r\n\t\twrite direct \"a:" + ASMname + "\"\r\n\r\n\t\t; First:");
                }
                String part2 = RasterPaint.this.jTextArea2.getText();
                String part3 = RasterPaint.this.jTextArea3.getText();
                String part4 = RasterPaint.this.jTextArea5.getText();
                file2 = file2 + "_table.asm";
                file3 = file3 + "_screendata.asm";
                file4 = file4 + "2_screendata.asm";
                try {
                    if (RasterPaint.this.rasterLock) {
                        part1 = part1 + "\r\nDEFS 66\r\n\r\n";
                    }
                    part1 = part1 + "\r\n\r\nread \"" + file2 + "\"\r\n";
                    if (RasterPaint.this.rasterLock) {
                        part1 = part1 + "\r\nDEFS 304\r\n\r\n";
                    }
                    part1 = part1 + "read \"" + file3 + "\"\r\n";
                    if (RasterPaint.this.rasterLock) {
                        part1 = part1 + "read \"" + file4 + "\"\r\n";
                    }
                    byte[] data = part1.getBytes("UTF-8");
                    File a = new File(path + file);
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(a));
                    bos.write(data);
                    bos.close();
                    data = part2.getBytes("UTF-8");
                    a = new File(path + file2);
                    bos = new BufferedOutputStream(new FileOutputStream(a));
                    bos.write(data);
                    bos.close();
                    data = part3.getBytes("UTF-8");
                    a = new File(path + file3);
                    bos = new BufferedOutputStream(new FileOutputStream(a));
                    bos.write(data);
                    bos.close();
                    if (RasterPaint.this.rasterLock) {
                        data = part4.getBytes("UTF-8");
                        a = new File(path + file4);
                        bos = new BufferedOutputStream(new FileOutputStream(a));
                        bos.write(data);
                        bos.close();
                    }
                    if (write) {
                        if (RasterPaint.this.assembler == null) {
                            RasterPaint.this.assembler = new EditorPanel(null, 0);
                        }
                        System.out.println("Assembling " + path + file);
                        RasterPaint.this.assembler.assembleFile(path, file);
                    } else {
                        JEMU.openAsASM = path + file;
                    }
                    if (write) {
                        while (RasterPaint.this.assembler.isBusy()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                        Samples.FINISHED.play();
                    }
                    RasterPaint.this.jButton11.setEnabled(true);
                    RasterPaint.this.jButton4.setEnabled(true);
                    if (write) {
                        a = new File(path + ASMname);
                        if (a.exists()) {
                            a.delete();
                        }
                        if ((a = new File(path + ASMname.replace(".BIN", ".BI1"))).exists()) {
                            a.delete();
                        }
                        if ((a = new File(path + ASMname.replace(".BIN", ".BI2"))).exists()) {
                            a.delete();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        saveIt.start();
    }

    protected void resetLines() {
        int k;
        for (int j = 0; j < 8; ++j) {
            for (k = 0; k < 200; ++k) {
                this.block[j][k] = false;
                this.direction[j][k] = 0;
            }
        }
        for (int z = 0; z < 8; ++z) {
            for (k = 0; k < this.render_zone[z].length; ++k) {
                this.render_zone[z][k] = true;
            }
        }
        for (int i = 0; i < this.render_line.length; ++i) {
            this.render_line[i] = true;
        }
    }

    private static void registerDropListener(ArrayList<DropTarget> list, Container basePanel, DropListener myListener) {
        list.add(new DropTarget(basePanel, myListener));
        Component[] components = basePanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof Container) {
                RasterPaint.registerDropListener(list, (Container)component, myListener);
                continue;
            }
            list.add(new DropTarget(component, myListener));
        }
    }

    public void resetManualInks() {
        for (int zone = 0; zone < 8; ++zone) {
            for (int j = 0; j < 200; ++j) {
                this.manualPen1[zone][j] = -1;
                this.manualP1[zone][j] = false;
            }
        }
        for (int i = 0; i < 200; ++i) {
            this.manualPen2[i] = -1;
            this.manualP2[i] = false;
            this.manualPen3[i] = -1;
            this.manualP3[i] = false;
        }
    }

    public void init() {
        int i;
        if (this.asmcode == null) {
            this.asmcode = this.jTextArea1.getText();
            this.asmcode2 = this.jTextArea4.getText();
        }
        this.jTextArea1.setText("");
        this.jTextArea2.setText("");
        if (this.data == null) {
            this.data = new RasterData();
        }
        int adr = this.data.tableStart;
        if (this.rasterTable == null) {
            this.rasterTable = new byte[this.data.rasterTable.table.length];
            System.arraycopy(this.data.rasterTable.table, 0, this.rasterTable, 0, this.rasterTable.length);
        }
        System.arraycopy(this.rasterTable, 0, this.data.rasterTable.table, 0, this.rasterTable.length);
        for (i = 0; i < this.data.rasterTable.table.length; ++i) {
            CPC.POKE(adr++, this.data.rasterTable.table[i] & 0xFF);
        }
        adr = this.data.codeStart;
        for (i = 0; i < RasterData.code.length; ++i) {
            CPC.POKE(adr++, RasterData.code[i]);
        }
        GateArray.cpc.fromautoboot = true;
        GateArray.cpc.BasicAutoType("INK 0,26:BORDER 13:MODE 1:PAPER 1:PEN 0:CLS:PRINT\"JavaCPC RasterPaint Beta 0.9\":CALL &BD19:CALL &8000");
    }

    public RasterPaint() {
        String f;
        this.imageImporter = new ImageImporter();
        this.result = new BufferedImage(320, 200, 1);
        this.Gain = new float[]{-1.0f, -0.99f, -0.98f, -0.97f, -0.96f, -0.95f, -0.94f, -0.93f, -0.92f, -0.91f, -0.9f, -0.89f, -0.88f, -0.87f, -0.86f, -0.85f, -0.84f, -0.83f, -0.82f, -0.81f, -0.8f, -0.79f, -0.78f, -0.77f, -0.76f, -0.75f, -0.74f, -0.73f, -0.72f, -0.71f, -0.7f, -0.69f, -0.68f, -0.67f, -0.66f, -0.65f, -0.64f, -0.63f, -0.62f, -0.61f, -0.6f, -0.59f, -0.58f, -0.57f, -0.56f, -0.55f, -0.54f, -0.53f, -0.52f, -0.51f, -0.5f, -0.49f, -0.48f, -0.47f, -0.46f, -0.45f, -0.44f, -0.43f, -0.42f, -0.41f, -0.4f, -0.39f, -0.38f, -0.37f, -0.36f, -0.35f, -0.34f, -0.33f, -0.32f, -0.31f, -0.3f, -0.29f, -0.28f, -0.27f, -0.26f, -0.25f, -0.24f, -0.23f, -0.22f, -0.21f, -0.2f, -0.19f, -0.18f, -0.17f, -0.16f, -0.15f, -0.14f, -0.13f, -0.12f, -0.11f, -0.1f, -0.09f, -0.08f, -0.07f, -0.06f, -0.05f, -0.04f, -0.03f, -0.02f, -0.01f, 0.0f, 0.01f, 0.02f, 0.03f, 0.04f, 0.05f, 0.06f, 0.07f, 0.08f, 0.09f, 0.1f, 0.11f, 0.12f, 0.13f, 0.14f, 0.15f, 0.16f, 0.17f, 0.18f, 0.19f, 0.2f, 0.21f, 0.22f, 0.23f, 0.24f, 0.25f, 0.26f, 0.27f, 0.28f, 0.29f, 0.3f, 0.31f, 0.32f, 0.33f, 0.34f, 0.35f, 0.36f, 0.37f, 0.38f, 0.39f, 0.4f, 0.41f, 0.42f, 0.43f, 0.44f, 0.45f, 0.46f, 0.47f, 0.48f, 0.49f, 0.5f, 0.51f, 0.52f, 0.53f, 0.54f, 0.55f, 0.56f, 0.57f, 0.58f, 0.59f, 0.6f, 0.61f, 0.62f, 0.63f, 0.64f, 0.65f, 0.66f, 0.67f, 0.68f, 0.69f, 0.7f, 0.71f, 0.72f, 0.73f, 0.74f, 0.75f, 0.76f, 0.77f, 0.78f, 0.79f, 0.8f, 0.81f, 0.82f, 0.83f, 0.84f, 0.85f, 0.86f, 0.87f, 0.88f, 0.89f, 0.9f, 0.91f, 0.92f, 0.93f, 0.94f, 0.95f, 0.96f, 0.97f, 0.98f, 0.99f, 1.0f};
        this.DitherImage = new BufferedImage(320, 200, 1);
        this.can = new PaintCanvas();
        this.zoomed = new BufferedImage(960, 600, 1);
        this.line = new BufferedImage(320, 1, 1);
        this.ditherline = new BufferedImage(320, 1, 1);
        this.rgbline = new BufferedImage(320, 1, 1);
        this.pixels = new int[320];
        this.screenpixels = new int[64000];
        this.mostPen = new int[27];
        this.handler = new DOSHandler();
        this.cruncher = new RasterCruncher();
        this.javacpcarea = new int[]{40, 80, 120, 160, 200, 240, 280, 320};
        this.javacpcwarea = new int[]{40, 40, 40, 40, 40, 40, 40, 40};
        this.javacpcsarea = new int[]{0, 40, 80, 120, 160, 200, 240, 280, 320};
        this.cpcarea = new int[]{36, 76, 116, 156, 196, 236, 276, 320};
        this.cpcwarea = new int[]{36, 40, 40, 40, 40, 40, 40, 44};
        this.cpcsarea = new int[]{0, 36, 76, 116, 156, 196, 236, 276};
        this.pen1 = new int[8][200];
        this.direction = new int[8][200];
        this.block = new boolean[8][200];
        this.pen2 = new int[200];
        this.pen3 = new int[200];
        this.mostPen1 = new int[8][27];
        this.area = new int[]{36, 76, 116, 156, 196, 236, 276, 320};
        this.warea = new int[]{36, 40, 40, 40, 40, 40, 40, 44};
        this.sarea = new int[]{0, 36, 76, 116, 156, 196, 236, 276, 320};
        this.cpcpic = new int[64000];
        this.initComponents();
        this.pSize = this.psize.getForeground();
        this.picture.requestFocus();
        this.jFrame1.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                RasterPaint.this.jCheckBox1.setSelected(false);
                RasterPaint.this.picture.requestFocus();
                RasterPaint.this.isVisible = false;
            }

            @Override
            public void windowOpened(WindowEvent e) {
                RasterPaint.this.zoom.requestFocus();
            }
        });
        this.resetManualInks();
        this.selector = new RasterPaintColorSelector(this);
        this.selector.setPen1(1);
        this.selector.setPen2(2);
        this.selector.setPen3(3);
        this.dropTargetList = new ArrayList();
        DropListener myListener = new DropListener();
        RasterPaint.registerDropListener(this.dropTargetList, this, myListener);
        this.zoomcursor = this.createImage("zoomcursor.gif");
        BufferedImage cursorImg = new BufferedImage(16, 16, 2);
        Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "blank cursor");
        this.zoom.setCursor(blankCursor);
        this.resetLines();
        String p = Settings.get("rasterpath", null);
        if (p != null && (f = Settings.get("rasterfile", null)) != null) {
            this.openDSK(p, f);
        }
    }

    public void Import() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.addChoosableFileFilter(new ImageFilter());
            this.chooser.setAcceptAllFileFilterUsed(true);
            this.chooser.setFileView(new ImageFileView());
            this.chooser.setAccessory(new ImagePreview(this.chooser));
            this.chooser.setPreferredSize(new Dimension(800, 600));
            this.chooser.setMultiSelectionEnabled(false);
        }
        this.chooser.setCurrentDirectory(new File(DSettings.get("paint_path", "")));
        if (this.chooser.showOpenDialog(this) == 0) {
            String filename;
            this.clipimport = false;
            DSettings.set("paint_path", this.chooser.getSelectedFile().getPath());
            this.loadname = filename = this.chooser.getSelectedFile().getAbsolutePath();
            if (this.loadname.length() > 2) {
                this.preImport(this.loadname);
            }
        }
    }

    public void preImport(String file) {
        if (this.clipimport) {
            this.ImportClipboard();
            return;
        }
        try {
            if (file.toUpperCase().endsWith(".RAS")) {
                try {
                    File a = new File(file);
                    byte[] packedcode = new byte[(int)a.length()];
                    BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
                    bin.read(packedcode);
                    bin.close();
                    this.uncrunch(packedcode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            String filename = file;
            this.preLoaded = this.imageImporter.readImage(filename);
            this.ffile = file;
            if (this.preLoaded.getWidth(this) > this.rendermode) {
                this.preLoaded = this.preLoaded.getScaledInstance(this.rendermode, -1, 4);
            }
            this.Import(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Import(String file) {
        if (this.clipimport) {
            this.ImportClipboard();
            return;
        }
        try {
            int w = this.preLoaded.getWidth(this);
            int h = this.preLoaded.getHeight(this);
            this.loadedImage = new BufferedImage(w, h, 1);
            this.loadedImage.createGraphics().drawImage(this.preLoaded, 0, 0, this);
            this.loadedImage = this.preCalc(this.loadedImage, file);
            this.prepareImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ImportClipboard() {
        if (this.clip == null) {
            this.clip = new ImageFromClipboard();
        }
        try {
            this.preLoaded = this.clip.getImageFromClipboard();
            BufferedImage bum = new BufferedImage(this.preLoaded.getWidth(this), this.preLoaded.getHeight(this), 1);
            bum.createGraphics().drawImage(this.preLoaded, 0, 0, this);
            ImageIO.write((RenderedImage)bum, "PNG", new File("Bufferpicture.png"));
            if (this.preLoaded == null) {
                this.clipimport = false;
                return;
            }
            this.clipimport = true;
            if (this.preLoaded.getWidth(this) > this.rendermode) {
                this.preLoaded = this.preLoaded.getScaledInstance(this.rendermode, -1, 4);
            }
            int w = this.preLoaded.getWidth(this);
            int h = this.preLoaded.getHeight(this);
            this.loadedImage = new BufferedImage(w, h, 1);
            this.loadedImage.createGraphics().drawImage(this.preLoaded, 0, 0, this);
            this.loadedImage = this.preCalc(this.loadedImage, "Clipboard");
            this.prepareImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    BufferedImage preCalc(BufferedImage image, String name) {
        this.result = new BufferedImage(320, 200, this.method.isSelected() ? 13 : 1);
        Graphics2D g = this.result.createGraphics();
        g.setColor(Color.black);
        g.fillRect(0, 0, 320, 200);
        int w = image.getWidth();
        int h = image.getHeight();
        if (w == 320 && h == 200) {
            return image;
        }
        if (w == 640) {
            this.buffer = image.getScaledInstance(320, -1, 2);
        } else if (h == 400) {
            this.buffer = image.getScaledInstance(-1, 200, 2);
        }
        if (w == 768) {
            this.buffer = image.getScaledInstance(384, -1, 2);
        } else if (h == 572) {
            this.buffer = image.getScaledInstance(-1, 286, 2);
        } else {
            if (w < 320 && h < 200) {
                this.buffer = image.getScaledInstance(w, h, 2);
                w = this.buffer.getWidth(this);
                h = this.buffer.getHeight(this);
                int i = 320 - w >> 1;
                int j = 200 - h >> 1;
                this.result.createGraphics().drawImage(this.buffer, i, j, null);
                return this.result;
            }
            if (w < 320 && h > 200 || w > 320 && h < 200) {
                this.buffer = image.getScaledInstance(w / 2, h / 2, 2);
                w = this.buffer.getWidth(this);
                h = this.buffer.getHeight(this);
                int i = 320 - w >> 1;
                int j = 200 - h >> 1;
                this.result.createGraphics().drawImage(this.buffer, i, j, null);
                return this.result;
            }
            double ratio = w / h;
            this.buffer = ratio >= 1.6 ? image.getScaledInstance(-1, 200, 2) : image.getScaledInstance(320, -200, 2);
        }
        w = this.buffer.getWidth(this);
        h = this.buffer.getHeight(this);
        int wdist = 320 - w >> 1;
        if (200 - h >> 1 != this.hDist.getMinimum() || !this.internalname.equals(name)) {
            this.internalname = name;
            this.hDist.setMaximum(h - 200 >> 1);
            this.hDist.setMinimum(200 - h >> 1);
            this.hDist.setValue(200 - h >> 1);
        }
        int hdist = (200 - h >> 1) - this.hDist.getValue();
        this.result.createGraphics().drawImage(this.buffer, wdist, hdist, null);
        return this.result;
    }

    public void prepareImage() {
        this.jTextArea1.setText("");
        this.jTextArea2.setText("");
        PaintCanvas.filled = 0;
        if (this.CPCImage == null) {
            this.RGBImage = new BufferedImage(320, 200, 1);
            this.CPCImage = new BufferedImage(320, 200, 1);
        }
        this.CPCImage.getGraphics().drawImage(this.loadedImage, 0, 0, 320, 200, this);
        this.RGBImage.getGraphics().drawImage(this.loadedImage, 0, 0, 320, 200, this);
        if (this.blur) {
            this.CPCImage = this.softenfilter.filter(this.CPCImage, this.CPCImage);
            this.RGBImage = this.softenfilter.filter(this.RGBImage, this.RGBImage);
        }
        this.contrastfilter.setBrightness(this.Gain[this.bright.getValue()] + 1.0f);
        this.contrastfilter.setContrast(this.Gain[this.contrast.getValue()] + 1.0f);
        this.softenfilter.setEdgeAction(10);
        this.gainfilter.setGain(this.Gain[this.gain.getValue()]);
        this.CPCImage = this.contrastfilter.filter(this.CPCImage, this.CPCImage);
        this.CPCImage = this.gainfilter.filter(this.CPCImage, this.CPCImage);
        this.RGBImage = this.contrastfilter.filter(this.RGBImage, this.RGBImage);
        this.RGBImage = this.gainfilter.filter(this.RGBImage, this.RGBImage);
        this.DitherImage.createGraphics().drawImage((Image)this.CPCImage, 0, 0, this);
        if (!this.alt.isSelected()) {
            PaintCanvas.ditherval = this.dither.isSelected() ? this.rslider.getValue() : 120;
        }
        this.can.buildCPCScreen(this.CPCImage, this.data.GateArrayColors, true);
        PaintCanvas.ditherval = this.dither.isSelected() ? this.rslider.getValue() : 120;
        this.can.buildCPCScreen(this.DitherImage, this.data.GateArrayColors, true);
        if (this.auto.isSelected()) {
            this.doRaster(false);
        }
        this.previewImage = new BufferedImage(640, 400, 1);
        Graphics2D g = this.previewImage.createGraphics();
        if (this.auto.isSelected()) {
            g.drawImage(this.CPCImage, 0, 0, 640, 400, this);
        } else {
            g.drawImage(this.DitherImage, 0, 0, 640, 400, this);
        }
        g.setColor(new Color(128, 128, 128, 128));
        if (this.rastermode == 1 || this.rastermode == 3 || this.colormode) {
            for (int z = 0; z < 8; ++z) {
                for (int y = 0; y < 400; y += 2) {
                    if (!this.render_zone[z][y >> 1]) continue;
                    g.drawLine(this.sarea[z] << 1, y, this.sarea[z + 1] << 1, y);
                }
            }
        }
        if (!(this.colormode || this.rastermode != 2 && this.rastermode != 3)) {
            for (int y = 1; y < 400; y += 2) {
                if (!this.render_line[y >> 1]) continue;
                g.drawLine(0, y, 1280, y);
            }
        }
        if (this.colormode) {
            g.setColor(Color.green);
            g.drawRect(0, 0, 639, 399);
        }
        this.picture.setIcon(new ImageIcon(this.previewImage));
        this.drawZoomed(this.lastMouse);
    }

    protected void doRaster(boolean imp) {
        int i;
        if (imp) {
            this.Import(this.ffile);
        }
        this.calculatePen0();
        for (int y = 0; y < 200; ++y) {
            this.ditherline.createGraphics().drawImage(this.DitherImage, 0, 0 - y, 320, 200, this);
            this.line.createGraphics().drawImage(this.CPCImage, 0, 0 - y, 320, 200, this);
            this.rgbline.createGraphics().drawImage(this.RGBImage, 0, 0 - y, 320, 200, this);
            this.calculatePixels(y);
        }
        int adr = this.data.tableStart;
        StringBuilder builder = new StringBuilder();
        String firstcode = this.asmcode;
        if (this.rasterLock) {
            firstcode = this.asmcode2;
        }
        if (this.javacpc.isSelected()) {
            firstcode = firstcode.replace("CPCPlus EQU 1", "CPCPlus EQU 0");
        }
        firstcode = firstcode.replace("B,Paper", "B," + this.paper);
        firstcode = firstcode.replace("C,Paper", "C," + this.paper);
        builder.append(firstcode);
        if (this.rasterLock) {
            this.jTextArea4.setText(builder.toString());
        } else {
            this.jTextArea1.setText(builder.toString());
        }
        builder = new StringBuilder();
        if (this.rasterLock) {
            builder.append("ORG &3700\r\n");
        } else {
            builder.append("ORG &9900\r\n");
        }
        for (i = 0; i < this.data.rasterTable.table.length; ++i) {
            CPC.POKE(adr++, this.data.rasterTable.table[i] & 0xFF);
            if (i % 10 == 0) {
                builder.append("DB ");
            }
            builder.append("&" + Util.hex(this.data.rasterTable.table[i]));
            if (i % 10 < 9) {
                builder.append(",");
            }
            if (i % 10 != 9) continue;
            builder.append("\r\n");
        }
        this.jTextArea2.setText(builder.toString());
        builder = new StringBuilder();
        adr = this.data.codeStart;
        for (i = 0; i < RasterData.code.length; ++i) {
            CPC.POKE(adr++, RasterData.code[i]);
        }
        adr = 49152;
        if (this.rasterLock) {
            builder.append("\r\nORG &C000\r\n");
        } else {
            builder.append("\r\nORG &4000\r\n");
        }
        for (i = 0; i < 16384; ++i) {
            if (i % 16 == 0) {
                builder.append("DB ");
            }
            builder.append("&").append(Util.hex((byte)CPC.PEEK(adr++)));
            if (i % 16 < 15) {
                builder.append(",");
            }
            if (i % 16 != 15) continue;
            builder.append("\r\n");
        }
        if (this.rasterLock) {
            this.jTextArea5.setText(builder.toString());
        } else {
            this.jTextArea3.setText(builder.toString());
        }
        GateArray.cpc.setInk(0, this.data.GateArrayINKs[this.paper]);
        GateArray.cpc.setInk(1, this.data.GateArrayINKs[this.pen1[0][0]]);
        GateArray.cpc.setInk(2, this.data.GateArrayINKs[this.pen2[0]]);
        GateArray.cpc.setInk(3, this.data.GateArrayINKs[this.pen3[0]]);
        GateArray.cpc.setInk(16, this.data.GateArrayINKs[this.paper]);
        this.crunch();
    }

    public void crunch() {
        String kk;
        byte[] screen = new byte[16384];
        for (int i = 0; i < 16384; ++i) {
            screen[i] = (byte)CPC.PEEK(49152 + i);
        }
        byte[] table = this.cruncher.crunch(this.data.rasterTable.table);
        screen = this.cruncher.crunch(screen);
        this.packedcode = new byte[table.length + screen.length + 6];
        int off = 0;
        this.packedcode[off++] = (byte)this.mode;
        this.packedcode[off++] = (byte)this.paper;
        Device.putWord(this.packedcode, off, table.length);
        System.arraycopy(table, 0, this.packedcode, off += 2, table.length);
        Device.putWord(this.packedcode, off += table.length, screen.length);
        System.arraycopy(screen, 0, this.packedcode, off += 2, screen.length);
        short packedsize = (short)this.packedcode.length;
        this.psize.setText("&" + Util.hex(packedsize));
        if (packedsize > 16368) {
            this.jButton5.setEnabled(false);
            this.jButton7.setEnabled(false);
            this.psize.setForeground(Color.RED);
            this.size.setForeground(Color.RED);
        } else {
            this.psize.setForeground(this.pSize);
            this.size.setForeground(this.pSize);
            this.jButton5.setEnabled(!reverse.isSelected());
            this.jButton7.setEnabled(!reverse.isSelected());
        }
        double kb = (double)packedsize / 1024.0;
        int k = packedsize / 1024;
        if (kb - (double)k > 0.0) {
            ++k;
        }
        if ((kk = "" + k).length() < 2) {
            kk = "0" + kk;
        }
        this.size.setText(kk + "K");
        this.packedcode = this.handler.makeHeader(this.packedcode, 16384, this.packedcode.length, "RASPACK");
        this.packedrastercode = GateArray.cpc.getRom("RASTER.COD", 5825);
        this.packedrastercode = this.handler.makeHeader(this.packedrastercode, 8192, this.packedrastercode.length, "RASTERPK");
    }

    public void uncrunch(byte[] packedcode) {
        int j;
        byte[] buffer = new byte[packedcode.length - 128];
        System.arraycopy(packedcode, 128, buffer, 0, buffer.length);
        packedcode = new byte[buffer.length];
        System.arraycopy(buffer, 0, packedcode, 0, packedcode.length);
        byte[] utable = new byte[8192];
        byte[] uscreen = new byte[16384];
        int off = 0;
        this.mode = packedcode[off++];
        this.paper = packedcode[off++];
        byte[] table = new byte[Device.getWord(packedcode, off)];
        System.arraycopy(packedcode, off += 2, table, 0, table.length);
        byte[] screen = new byte[Device.getWord(packedcode, off += table.length)];
        System.arraycopy(packedcode, off += 2, screen, 0, screen.length);
        this.cruncher.uncrunch(table, utable);
        this.cruncher.uncrunch(screen, uscreen);
        for (int i = 0; i < 16384; ++i) {
            CPC.POKE(49152 + i, uscreen[i]);
        }
        System.arraycopy(utable, 0, this.rasterTable, 0, this.rasterTable.length);
        GateArray.cpc.setInk(0, this.data.GateArrayINKs[this.paper]);
        GateArray.cpc.setInk(16, this.data.GateArrayINKs[this.paper]);
        int adr = this.data.tableStart;
        System.arraycopy(this.rasterTable, 0, this.data.rasterTable.table, 0, this.rasterTable.length);
        for (j = 0; j < this.rasterTable.length; ++j) {
            CPC.POKE(adr++, this.rasterTable[j] & 0xFF);
        }
        adr = this.data.codeStart;
        for (j = 0; j < RasterData.code.length; ++j) {
            CPC.POKE(adr++, RasterData.code[j]);
        }
        this.crunch();
    }

    public void saveNormal(String path, String file) {
        byte[] screen = new byte[16384];
        int p = 0;
        for (int i = 0; i < 16384; ++i) {
            byte pixel = (byte)CPC.PEEK(49152 + i);
            screen[p++] = pixel;
        }
        screen = this.handler.makeHeader(screen, 49152, screen.length, "RASSCRN");
        byte[] table = this.handler.makeHeader(this.data.rasterTable.table, 39168, this.data.rasterTable.table.length, "RASTABLE");
    }

    public void saveCrunched() {
        if (this.savecrunched == null) {
            this.savecrunched = new FileDialog((Frame)this, "Save Binary code(s)", 1);
        }
        this.savecrunched.setVisible(true);
        if (this.savecrunched.getFile() != null) {
            this.saveCrunched(this.savecrunched.getDirectory(), this.savecrunched.getFile());
        }
    }

    public void createDSK() {
        if (this.create == null) {
            this.create = new FileDialog((Frame)this, "Save DSK File", 1);
        }
        this.create.setVisible(true);
        if (this.create.getFile() != null) {
            this.createDSK(this.create.getDirectory(), this.create.getFile());
        }
    }

    public void openDSK() {
        if (this.open == null) {
            this.open = new FileDialog((Frame)this, "Open DSK File", 0);
        }
        this.open.setVisible(true);
        if (this.open.getFile() != null) {
            this.openDSK(this.open.getDirectory(), this.open.getFile());
            Settings.set("rasterpath", this.open.getDirectory());
            Settings.set("rasterfile", this.open.getFile());
        }
    }

    public void createDSK(String path, String file) {
        if (this.system == null) {
            this.system = new CPCFileSystem();
        }
        byte[] dsk = this.system.getEmptyDSK();
        try {
            if (!file.toLowerCase().endsWith(".dsk")) {
                file = file + ".dsk";
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(path + file)));
            bos.write(dsk);
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.diskname.setText(path + file);
        this.jList1.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings;
            {
                this.strings = RasterPaint.this.system.DIR();
            }

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.free.setText(this.system.getDataSpace() + 6 + "K");
    }

    public void openDSK(String path, String file) {
        if (this.system == null) {
            this.system = new CPCFileSystem();
        }
        try {
            File a = new File(path + file);
            int size = (int)a.length();
            if (size != 204544) {
                this.diskname.setText("Bad disk format, please create a new DSK");
                return;
            }
            this.system.buffer = new byte[(int)a.length()];
            BufferedInputStream bos = new BufferedInputStream(new FileInputStream(new File(path + file)));
            bos.read(this.system.buffer);
            bos.close();
        }
        catch (Exception e) {
            return;
        }
        this.diskname.setText(path + file);
        this.jList1.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings;
            {
                this.strings = RasterPaint.this.system.DIR();
            }

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.free.setText(this.system.getDataSpace() + 6 + "K");
    }

    public void writeToDsk() {
        BufferedOutputStream bos2;
        String disk;
        if (this.system == null) {
            this.system = new CPCFileSystem();
        }
        if ((disk = this.diskname.getText()) == null || disk.length() < 1) {
            disk = "Rasterdisk.dsk";
            File file = new File(disk);
            int count = 1;
            while (file.exists()) {
                disk = "Rasterdisk_" + count + ".dsk";
                file = new File(disk);
                ++count;
            }
            this.diskname.setText(disk);
            byte[] dsk = this.system.getEmptyDSK();
            try {
                bos2 = new BufferedOutputStream(new FileOutputStream(file));
                bos2.write(dsk);
                bos2.close();
            }
            catch (Exception bos2) {
                // empty catch block
            }
        }
        this.system.DIR();
        String rasfile = this.rasname.getText();
        if (rasfile.contains(".")) {
            while (rasfile.length() > 13) {
                rasfile = rasfile.substring(0, rasfile.length() - 1);
            }
        } else {
            while (rasfile.length() > 8) {
                rasfile = rasfile.substring(0, rasfile.length() - 1);
            }
            rasfile = rasfile + ".RAS";
        }
        this.rasname.setText(rasfile);
        this.saveCrunched("", rasfile);
        this.system.copyToDSK("", rasfile, disk);
        this.system.DIR();
        this.system.Delete("RASTER  .RST");
        this.system.DIR();
        this.system.copyToDSK("", "RASTER.RST", disk);
        this.system.DIR();
        String basic = this.generateBasic();
        this.system.Delete("DISC    .BAS");
        this.system.DIR();
        File a = new File("DISC.BAS");
        try {
            bos2 = new BufferedOutputStream(new FileOutputStream(a));
            bos2.write(basic.getBytes("UTF-8"));
            bos2.close();
            this.system.copyToDSK("", "DISC.BAS", disk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.jList1.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings;
            {
                this.strings = RasterPaint.this.system.DIR();
            }

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.free.setText(this.system.getDataSpace() + "K");
        a.delete();
        a = new File(rasfile);
        a.delete();
        a = new File("RASTER.RST");
        a.delete();
        try {
            GateArray.cpc.DSK_Load("buffer", this.system.buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String generateBasic() {
        try {
            String bascode = "10 MODE 1:INK 0,0:BORDER 0:MEMORY &1FFF:LOAD\"RASTER.RST\"\r\n";
            String files = "";
            int forLoop = 0;
            String[] strings = this.system.DIR();
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i] == null) continue;
                String entry = strings[i].toUpperCase();
                entry = entry.replace(" ", "");
                if (files.toUpperCase().contains(entry) || entry.toUpperCase().contains("RASTER.RST") || entry.toUpperCase().contains("DISC.BAS")) continue;
                files = files + entry + ",";
                ++forLoop;
            }
            files = files.substring(0, files.length() - 1);
            files = "20 DATA " + files + "\r\n";
            bascode = bascode + files;
            bascode = bascode + "30 RESTORE 20:FOR T=1 TO " + forLoop + ": READ A$:LOAD A$:CALL &2000:CLS:NEXT\r\n";
            return bascode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveCrunched(String path, String file) {
        if (file.contains(".")) {
            while (file.contains(".")) {
                file = file.substring(0, file.length() - 1);
            }
        }
        while (file.length() > 8) {
            file = file.substring(0, file.length() - 1);
        }
        file = file + ".ras";
        file = file.toUpperCase();
        try {
            File pack = new File(path + file);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(pack));
            bos.write(this.packedcode);
            bos.close();
            pack = new File(path + "RASTER.RST");
            bos = new BufferedOutputStream(new FileOutputStream(pack));
            bos.write(this.packedrastercode);
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int putRGB(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    protected void calculatePen0() {
        if (this.p0.getSelectedIndex() > 0) {
            this.paper = this.p0.getSelectedIndex() - 1;
            return;
        }
        int off = 0;
        for (int j = 0; j < this.mostPen.length; ++j) {
            this.mostPen[j] = 0;
        }
        for (int x = 0; x < 320; ++x) {
            for (int y = 0; y < 200; ++y) {
                Color col = new Color(this.CPCImage.getRGB(x, y));
                this.screenpixels[off++] = this.putRGB(col.getRed(), col.getGreen(), col.getBlue());
            }
        }
        for (int i = 0; i < this.screenpixels.length; ++i) {
            for (int m = 0; m < this.data.GateArrayColors.length; ++m) {
                if (this.screenpixels[i] != this.data.GateArrayColors[m]) continue;
                this.mostPen[m] = this.mostPen[m] + 1;
            }
        }
        int v = 0;
        for (int k = 0; k < this.mostPen.length; ++k) {
            if (this.paper >= this.mostPen[k]) continue;
            this.paper = this.mostPen[k];
            this.mostPen[k] = 0;
            v = k;
        }
        this.paper = v;
    }

    protected void calculatePixels(int renderline) {
        int k;
        int i;
        this.lastpen2 = this.lastpen3 = this.paper;
        this.lastpen1 = this.lastpen3;
        for (int x = 0; x < 320; ++x) {
            Color col = new Color(this.line.getRGB(x, 0));
            this.pixels[x] = this.putRGB(col.getRed(), col.getGreen(), col.getBlue());
        }
        if (this.render_line[renderline] && !this.rasterLock) {
            this.pen3[renderline] = 0;
            this.pen2[renderline] = 0;
            for (i = 0; i < this.mostPen.length; ++i) {
                this.mostPen[i] = 0;
            }
        }
        this.zone = 0;
        while (this.zone < 8) {
            if (this.render_zone[this.zone][renderline]) {
                for (i = 0; i < this.mostPen1[this.zone].length; ++i) {
                    this.mostPen1[this.zone][i] = 0;
                }
            }
            ++this.zone;
        }
        int v = -1;
        if (this.render_line[renderline]) {
            int i2;
            for (i2 = 0; i2 < this.pixels.length; ++i2) {
                for (k = 0; k < this.mostPen.length; ++k) {
                    if (this.pixels[i2] != this.data.GateArrayColors[k]) continue;
                    this.mostPen[k] = this.mostPen[k] + 1;
                }
            }
            for (i2 = 0; i2 < this.mostPen.length; ++i2) {
                if (this.pen2[renderline] >= this.mostPen[i2] || i2 == this.paper || this.rasterLock) continue;
                this.pen2[renderline] = this.mostPen[i2];
                v = i2;
            }
            if (v == -1) {
                v = this.lastpen2;
            } else {
                this.lastpen2 = v;
                this.mostPen[v] = -1;
            }
            if (!this.rasterLock) {
                this.pen2[renderline] = v;
            }
            if (this.p2.getSelectedIndex() > 0 && !this.rasterLock) {
                this.pen2[renderline] = this.p2.getSelectedIndex() - 1;
            }
            v = -1;
            for (i2 = 0; i2 < this.mostPen.length; ++i2) {
                if (this.rasterLock || this.pen3[renderline] > this.mostPen[i2] || i2 == this.paper || i2 == this.pen2[renderline]) continue;
                this.pen3[renderline] = this.mostPen[i2];
                v = i2;
            }
            if (v == -1) {
                v = this.lastpen3;
            } else {
                this.lastpen3 = v;
            }
            if (!this.rasterLock) {
                this.pen3[renderline] = v;
            }
            if (this.p3.getSelectedIndex() > 0 && !this.rasterLock) {
                this.pen3[renderline] = this.p3.getSelectedIndex() - 1;
            }
        } else if (renderline > 0) {
            this.pen2[renderline] = this.pen2[renderline - 1];
            this.pen3[renderline] = this.pen3[renderline - 1];
        }
        if (this.linemode) {
            if (!this.rasterLock) {
                block25: for (int i3 = 0; i3 < this.pixels.length; ++i3) {
                    if (this.render_zone[0][renderline]) {
                        if (!this.block[0][renderline]) {
                            this.pen1[0][renderline] = 0;
                        }
                        for (k = 0; k < this.data.GateArrayColors.length; ++k) {
                            if (this.pixels[i3] != this.data.GateArrayColors[k]) continue;
                            this.mostPen1[0][k] = this.mostPen1[0][k] + 1;
                        }
                        continue;
                    }
                    if (this.render_zone[0][renderline]) continue;
                    switch (this.direction[0][renderline]) {
                        case 0: {
                            if (renderline <= 0) continue block25;
                            this.pen1[0][renderline] = this.pen1[0][renderline - 1];
                            continue block25;
                        }
                        case 1: {
                            this.pen1[0][renderline] = this.pen1[1][renderline];
                            continue block25;
                        }
                        case 3: {
                            if (renderline >= 200) continue block25;
                            this.pen1[0][renderline] = this.pen1[0][renderline + 1];
                        }
                    }
                }
            }
            if (!this.rasterLock) {
                for (int i4 = 1; i4 < 8; ++i4) {
                    this.pen1[i4][renderline] = 0;
                    for (k = 0; k < this.data.GateArrayColors.length; ++k) {
                        this.mostPen1[i4][k] = this.mostPen1[0][k];
                    }
                }
            }
        } else {
            block29: for (int i5 = 0; i5 < this.pixels.length; ++i5) {
                this.zone = i5 < this.area[0] ? 0 : (i5 < this.area[1] ? 1 : (i5 < this.area[2] ? 2 : (i5 < this.area[3] ? 3 : (i5 < this.area[4] ? 4 : (i5 < this.area[5] ? 5 : (i5 < this.area[6] ? 6 : 7))))));
                if (this.render_zone[this.zone][renderline] && !this.rasterLock) {
                    this.pen1[this.zone][renderline] = 0;
                    for (k = 0; k < this.data.GateArrayColors.length; ++k) {
                        if (this.pixels[i5] != this.data.GateArrayColors[k]) continue;
                        this.mostPen1[this.zone][k] = this.mostPen1[this.zone][k] + 1;
                    }
                    continue;
                }
                if (this.render_zone[this.zone][renderline]) continue;
                switch (this.direction[this.zone][renderline]) {
                    case 0: {
                        if (renderline <= 0) continue block29;
                        this.pen1[this.zone][renderline] = this.pen1[this.zone][renderline - 1];
                        continue block29;
                    }
                    case 1: {
                        if (this.zone >= 7) continue block29;
                        this.pen1[this.zone][renderline] = this.pen1[this.zone + 1][renderline];
                        continue block29;
                    }
                    case 2: {
                        if (renderline >= 199) continue block29;
                        this.pen1[this.zone][renderline] = this.pen1[this.zone][renderline + 1];
                        continue block29;
                    }
                    case 3: {
                        if (this.zone <= 0) continue block29;
                        this.pen1[this.zone][renderline] = this.pen1[this.zone - 1][renderline];
                    }
                }
            }
        }
        v = -1;
        this.zone = 0;
        while (this.zone < 8) {
            if (this.render_zone[this.zone][renderline] && !this.rasterLock) {
                for (int i6 = 0; i6 < this.mostPen1[this.zone].length; ++i6) {
                    if (this.pen1[this.zone][renderline] > this.mostPen1[this.zone][i6] || i6 == this.paper || i6 == this.pen2[renderline] || i6 == this.pen3[renderline]) continue;
                    this.pen1[this.zone][renderline] = this.mostPen1[this.zone][i6];
                    this.mostPen1[this.zone][i6] = -1;
                    v = i6;
                }
                if (v == -1) {
                    v = this.lastpen1;
                } else {
                    this.lastpen1 = v;
                }
                this.pen1[this.zone][renderline] = v;
                v = -1;
            } else if (!this.render_zone[this.zone][renderline]) {
                switch (this.direction[this.zone][renderline]) {
                    case 0: {
                        if (renderline <= 0) break;
                        this.pen1[this.zone][renderline] = this.pen1[this.zone][renderline - 1];
                        break;
                    }
                    case 1: {
                        if (this.zone >= 7) break;
                        this.block[this.zone + 1][renderline] = true;
                        this.pen1[this.zone][renderline] = this.pen1[this.zone + 1][renderline];
                        break;
                    }
                    case 2: {
                        if (renderline >= 199) break;
                        this.block[this.zone][renderline + 1] = true;
                        this.pen1[this.zone][renderline] = this.pen1[this.zone][renderline + 1];
                        break;
                    }
                    case 3: {
                        if (this.zone <= 0) break;
                        this.block[this.zone - 1][renderline] = true;
                        this.pen1[this.zone][renderline] = this.pen1[this.zone - 1][renderline];
                    }
                }
            }
            if (this.manualPen1[this.zone][renderline] >= 0 && this.manualP1[this.zone][renderline] && !this.rasterLock) {
                this.pen1[this.zone][renderline] = this.manualPen1[this.zone][renderline];
            }
            ++this.zone;
        }
        int[] palette = new int[2];
        if (this.manualPen2[renderline] >= 0 && this.manualP2[renderline] && !this.rasterLock) {
            this.pen2[renderline] = this.manualPen2[renderline];
        }
        if (this.manualPen3[renderline] >= 0 && this.manualP3[renderline] && !this.rasterLock) {
            this.pen3[renderline] = this.manualPen3[renderline];
        }
        palette[0] = this.pen2[renderline];
        palette[1] = this.pen3[renderline];
        if (!this.rasterLock) {
            this.data.writeINK(renderline, 8, this.data.GateArrayINKs[this.pen2[renderline]]);
            this.data.writeINK(renderline, 9, this.data.GateArrayINKs[this.pen3[renderline]]);
        }
        this.zone = 0;
        while (this.zone < 8) {
            if (!this.rasterLock) {
                this.data.writeINK(renderline, this.zone, this.data.GateArrayINKs[this.pen1[this.zone][renderline]]);
            }
            int[] zonepalette = new int[]{this.data.GateArrayColors[this.paper], this.data.GateArrayColors[this.pen1[this.zone][renderline]], this.data.GateArrayColors[this.pen2[renderline]], this.data.GateArrayColors[this.pen3[renderline]]};
            this.manualPen1[this.zone][renderline] = this.pen1[this.zone][renderline];
            this.manualPen2[renderline] = this.pen2[renderline];
            this.manualPen3[renderline] = this.pen3[renderline];
            BufferedImage strip = new BufferedImage(this.warea[this.zone], 1, 1);
            PaintCanvas.ditherval = 120;
            if (this.alt.isSelected()) {
                strip.getGraphics().drawImage(this.ditherline, 0 - this.sarea[this.zone], 0, null);
            } else {
                strip.getGraphics().drawImage(this.line, 0 - this.sarea[this.zone], 0, null);
            }
            this.can.buildCPCScreen(strip, zonepalette, false);
            Graphics2D g = this.CPCImage.createGraphics();
            for (int i7 = 0; i7 < this.warea[this.zone]; ++i7) {
                Color test2 = new Color(strip.getRGB(i7, 0));
                int col = this.putRGB(test2.getRed(), test2.getGreen(), test2.getBlue());
                g.setColor(test2);
                g.fillRect(this.sarea[this.zone] + i7, renderline, 1, 1);
                if (col == this.data.GateArrayColors[this.paper]) {
                    CPC.PLOT(this.sarea[this.zone] + i7, renderline, 0, 1, false);
                } else if (col == this.data.GateArrayColors[this.pen1[this.zone][renderline]]) {
                    CPC.PLOT(this.sarea[this.zone] + i7, renderline, 1, 1, false);
                } else if (col == this.data.GateArrayColors[this.pen2[renderline]]) {
                    CPC.PLOT(this.sarea[this.zone] + i7, renderline, 2, 1, false);
                } else if (col == this.data.GateArrayColors[this.pen3[renderline]]) {
                    CPC.PLOT(this.sarea[this.zone] + i7, renderline, 3, 1, false);
                } else {
                    System.err.println("no pixel found! Debug info: x=" + i7 + " zone=" + this.zone + " line=" + renderline);
                }
                if (renderline != 0 || !this.hide.isSelected()) continue;
                CPC.PLOT(this.sarea[this.zone] + i7, renderline, 0, 1, false);
            }
            this.CPCImage.createGraphics().drawImage((Image)strip, this.sarea[this.zone], renderline, null);
            ++this.zone;
        }
    }

    private void initComponents() {
        this.javacpc = new JCheckBox();
        this.jFrame1 = new JFrame();
        this.zoom = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButton10 = new JButton();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel17 = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.jTextArea5 = new JTextArea();
        this.jScrollPane5 = new JScrollPane();
        this.jTextArea4 = new JTextArea();
        this.hide = new JCheckBox();
        this.rasterpaint = new JPanel();
        control = new JPanel();
        this.jButton1 = new JButton();
        this.dither = new JCheckBox();
        this.alt = new JCheckBox();
        this.bright = new JSlider();
        this.jLabel1 = new JLabel();
        this.contrast = new JSlider();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.gain = new JSlider();
        this.jButton2 = new JButton();
        this.auto = new JCheckBox();
        this.p0 = new JComboBox();
        this.p2 = new JComboBox();
        this.p3 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jButton3 = new JButton();
        this.jButtonClip = new JButton();
        this.jButton4 = new JButton();
        this.jLabel7 = new JLabel();
        this.psize = new JLabel();
        this.jButton5 = new JButton();
        this.rslider = new JSlider();
        this.size = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.method = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        prerender = new JCheckBox();
        reverse = new JCheckBox();
        this.jButton9 = new JButton();
        this.jButton11 = new JButton();
        this.format = new JLabel();
        this.hDist = new JSlider();
        this.picture = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.diskname = new JTextField();
        this.jButton6 = new JButton();
        this.jLabel9 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel10 = new JLabel();
        this.rasname = new JTextField();
        this.jButton7 = new JButton();
        this.jLabel11 = new JLabel();
        this.free = new JLabel();
        this.jButton8 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea3 = new JTextArea();
        this.javacpc.setText("CPC Plus Renderer");
        this.javacpc.setFocusable(false);
        this.javacpc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.javacpcActionPerformed(evt);
            }
        });
        this.jFrame1.setTitle("Zoom view");
        this.jFrame1.setResizable(false);
        this.zoom.setMaximumSize(new Dimension(960, 600));
        this.zoom.setMinimumSize(new Dimension(960, 600));
        this.zoom.setPreferredSize(new Dimension(960, 600));
        this.zoom.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                RasterPaint.this.zoomMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                RasterPaint.this.zoomMouseMoved(evt);
            }
        });
        this.zoom.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                RasterPaint.this.zoomMouseReleased(evt);
            }
        });
        this.zoom.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RasterPaint.this.zoomKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                RasterPaint.this.zoomKeyReleased(evt);
            }
        });
        this.jFrame1.getContentPane().add((Component)this.zoom, "Center");
        this.jPanel2.setPreferredSize(new Dimension(960, 46));
        this.jButton10.setText("Remove blocked zones");
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton10ActionPerformed(evt);
            }
        });
        this.jLabel12.setText("PEN 1: Inherit color from:");
        this.jLabel13.setHorizontalAlignment(0);
        this.jLabel13.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/paint/icons/ar_up.png")));
        this.jLabel14.setText("(Use Arrow keys to change)");
        this.jLabel15.setText("Edit mode (Right click to change):");
        this.jLabel16.setText("Disabled");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"3x", "4x", "5x"}));
        this.jComboBox1.setFocusable(false);
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RasterPaint.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.jLabel17.setText("Zoom:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14).addGap(18, 18, 18).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16).addContainerGap(199, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel16, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel17))).addComponent(this.jLabel13, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jButton10).addGap(0, 1, Short.MAX_VALUE)).addComponent(this.jLabel12, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.jFrame1.getContentPane().add((Component)this.jPanel2, "North");
        this.jTextArea5.setColumns(20);
        this.jTextArea5.setRows(5);
        this.jScrollPane6.setViewportView(this.jTextArea5);
        this.jTextArea4.setColumns(20);
        this.jTextArea4.setRows(5);
        this.jTextArea4.setText("\t\t;-----------------------------------------\n\t\t;\t\tJavaCPC RasterPaint Assembly code\n\t\t;\t\tAuthors; Oliver M. Lenz, Markus Hohmann\n\t\t;-----------------------------------------\n\n\t\torg &2000  ; CALL &2000\n\t\tnolist\n\n\t\t; First: Let's detect if we have a Plus machine\n\t\tld\t\tbc,#F782\n\t\tld\t\te,c\n\t\tout\t\t(c),c\n\t\tdec\t\tb\n\t\tld\t\tc,#0f\n\t\tout\t\t(c),c\n\t\tinc\t\tb\n\t\tld\t\ta,e\n\t\tout\t\t(c),a\n\t\tdec\t\tb\n\t\tin\t\ta,(c)\n\t\tcp\t\tc\n\t\tjr\t\tz,Plus ; Plus found\n\t\tor\t\ta\n\t\tjr\t\tz,CpcOld ; Old CPC found\nPlus\n\t\t; ASIC Unlock routine\n\t\tdi\n\t\tld\t\tb,&bc\n\t\tld\t\thl,sequence\n\t\tld\t\te,17\nseq\n\t\tld\t\ta,(hl)\n\t\tout\t\t(c),a\n\t\tinc\t\thl\n\t\tdec\t\te\n\t\tjr\t\tnz,seq\n\t\tei\n\nhardwarescroll\n\n\t\tld\t\tbc,&7fb8 ; Jump into ASIC RAM\n\t\tout\t\t(c),c\n\t\tld\t\ta,142\t; Do a hardware scroll to the left\n\t\tld\t\t(&6804),a\n\t\tld\t\tbc,&7fa0\t; Jump back into CPC RAM\n\t\tout\t\t(c),c\n\nCpcOld\n\t\tCPCNew EQU 1 ; Set this to 0 for Older CPC Models.\n\t\tTableData EQU &3700\n\t\tdi\n\n\t\tld\t\tA,0  ; Define Background Color\n\t\tld\t\tB,Paper\n\t\tld\t\tC,Paper\n\t\tcall\t\t&BC32\n\t\tld\t\tB,Paper\n\t\tld\t\tC,Paper\n\t\tcall\t\t&BC38\n\t\tcall\t\t&bd19\n\t\tcall\t\t&bd19\n\t\tcall\t\t&bd19\n\n\t\tim\t\t1\n\t\tei\n\nnewframe:\n\n\t\tld \t\tBC,&BC0C\n\t\tout\t\t(C),C\t\t; select CRTC register 12\n\t\tinc\t\tB\n\t\tld\t\tA,(scradr)\n\t\tout\t\t(C),A\n\t\tXOR\t\t&20\n\t\tld\t\t(scradr),A\n\t\t\n\t\tld\t\tHL,(&0038)\n\t\tld\t\t(rstsave),HL\n\t\tld\t\tHL,&C9FB\n\t\tld\t\t(&0038),HL\n\n\t\tld\t\tB,&F5\n.waitvsync\n\t\tin\t\tA,(C)\n\t\trra\n\t\tjp\t\tnc,waitvsync\n\n\n\t\thalt\n\t\thalt\n\n\t\tdi\n\t\tld\t\tDE,&1702\n\n.waitforstart\n\t\tdec\t\tD\n\t\tjr\t\tnz,waitforstart\n\t\tdec\t\tE\n\t\tjr\t\tnz,waitforstart\n\n\t\tIF\t\tCPCNew\n\t\tnop\n\t\tENDIF\n\n\n\t\tld\t\tBC,&7F80\n\t\tld\t\tHL,TableData\n\t\tld\t\tDE,&0203\n\t\tld\t\tA,&01\n\t\tout\t\t(C),A  ; select pen 1\n\t\tinc     B\n\n.nextline\nrepeat 200\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\t;\t\t40\n\n\t\tout\t\t(C),D  ; 4 ; pen 2\n\t\tld\t\tB,C  ; 1\n\t\touti\t\t; 5\n\t\tout\t\t(C),E  ; 4 ; pen 3\n\t\touti\t\t; 5\n\t\tout\t\t(C),A  ; 4 ; pen 1\n\t\tld\t\tB,C  ; 1\n\t\t;\t\t--\n\t\t;\t\t64 microseconds\nrend\n\n\t\tld\t\tHL,(rstsave)\n\t\tld\t\t(&0038),HL\n\t\tei\n\n\t\tLD\t\tA,&45 ; from &40 to &49 with bdir/bc1=01\n\t\tLD\t\tD,0\n\t\tLD\t\tBC,&F782 ; PPI port A out /C out\n\t\tOUT\t\t(C),C\n\t\tLD\t\tBC,&F40E ; Select Ay reg 14 on ppi port A\n\t\tOUT\t\t(C),C\n\t\tLD\t\tBC,&F6C0 ; This value is an AY index (R14)\n\t\tOUT\t\t(C),C\n\t\tOUT\t\t(C),D ; Validate!! out (c),0\n\t\tLD\t\tBC,&F792 ; PPI port A in/C out\n\t\tOUT\t\t(C),C\n\t\tDEC\t\tB\n\t\tOUT\t\t(C),A ; Send KbdLine on reg 14 AY through ppi port A\n\t\tLD\t\tB,&F4 ; Read ppi port A\n\t\tIN\t\tA,(C) ; e.g. AY R14 (AY port A)\n\t\tLD\t\tBC,&F782 ; PPI port A out / C out\n\t\tOUT\t\t(C),C\n\t\tDEC\t\tB ; Reset PPI Write\n\t\tOUT\t\t(C),D ; out (c),0\n\t\tbit\t\t7,A\n\t\tjp\t\tnz,newframe\n\t\tld\t\tBC,&BC0C ; Select CRTC Register 12\n\t\tout\t\t(C),C\n\t\tLD\t\tBC,&BD30 ; Return to screen offset #C000\n\t\tOUT\t\t(C),C\n\t\tld\t\tbc,&7fb8 ; Jump into ASIC RAM\n\t\tout\t\t(c),c\n\t\tld\t\ta,0\t; reset hardware scroll\n\t\tld\t\t(&6804),a\n\t\tld\t\tbc,&7fa0\t; Jump back into CPC RAM\n\t\tout\t\t(c),c\n\n\t\tret\n\n.rstsave\n\t\tdb\t\t0,0\n\n.scradr\n\t\tdb\t\t&10\n.sequence\n\t\tdefb\t\t&ff,&00,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee\n\n\t\t;;\t\t------------------------------------------------");
        this.jScrollPane5.setViewportView(this.jTextArea4);
        this.hide.setText("Hide first line");
        this.hide.setFocusable(false);
        this.hide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.hideActionPerformed(evt);
            }
        });
        this.setTitle("JavaCPC RasterPaint Beta 0.9");
        this.setResizable(false);
        this.rasterpaint.setPreferredSize(new Dimension(660, 500));
        control.setBorder(BorderFactory.createEtchedBorder());
        control.setPreferredSize(new Dimension(10, 120));
        this.jButton1.setText("Import");
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton1ActionPerformed(evt);
            }
        });
        this.dither.setText("Dither");
        this.dither.setFocusable(false);
        this.dither.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.ditherActionPerformed(evt);
            }
        });
        this.alt.setText("Alt.");
        this.alt.setFocusable(false);
        this.alt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.altActionPerformed(evt);
            }
        });
        this.bright.setMaximum(180);
        this.bright.setMinimum(20);
        this.bright.setMinorTickSpacing(20);
        this.bright.setPaintTicks(true);
        this.bright.setValue(100);
        this.bright.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RasterPaint.this.brightStateChanged(evt);
            }
        });
        this.jLabel1.setText("Bright");
        this.contrast.setMaximum(180);
        this.contrast.setMinimum(20);
        this.contrast.setMinorTickSpacing(20);
        this.contrast.setPaintTicks(true);
        this.contrast.setValue(100);
        this.contrast.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RasterPaint.this.contrastStateChanged(evt);
            }
        });
        this.jLabel2.setText("Contrast:");
        this.jLabel3.setText("Gain:");
        this.gain.setMaximum(195);
        this.gain.setMinimum(105);
        this.gain.setMinorTickSpacing(15);
        this.gain.setPaintTicks(true);
        this.gain.setValue(150);
        this.gain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RasterPaint.this.gainStateChanged(evt);
            }
        });
        this.jButton2.setText("Rasterize");
        this.jButton2.setEnabled(false);
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton2ActionPerformed(evt);
            }
        });
        this.auto.setSelected(true);
        this.auto.setText("Auto");
        this.auto.setFocusable(false);
        this.auto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.autoActionPerformed(evt);
            }
        });
        this.p0.setModel(new DefaultComboBoxModel<String>(new String[]{"-", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"}));
        this.p0.setMaximumSize(new Dimension(45, Short.MAX_VALUE));
        this.p0.setMinimumSize(new Dimension(3, 22));
        this.p0.setPreferredSize(new Dimension(50, 24));
        this.p0.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RasterPaint.this.p0ItemStateChanged(evt);
            }
        });
        this.p2.setModel(new DefaultComboBoxModel<String>(new String[]{"-", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"}));
        this.p2.setMaximumSize(new Dimension(45, Short.MAX_VALUE));
        this.p2.setMinimumSize(new Dimension(3, 22));
        this.p2.setPreferredSize(new Dimension(50, 24));
        this.p2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RasterPaint.this.p2ItemStateChanged(evt);
            }
        });
        this.p3.setModel(new DefaultComboBoxModel<String>(new String[]{"-", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"}));
        this.p3.setMaximumSize(new Dimension(45, Short.MAX_VALUE));
        this.p3.setMinimumSize(new Dimension(3, 22));
        this.p3.setPreferredSize(new Dimension(50, 24));
        this.p3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RasterPaint.this.p3ItemStateChanged(evt);
            }
        });
        this.jLabel4.setText("Force - Paper:");
        this.jLabel5.setText("Pen 2:");
        this.jLabel6.setText("Pen 3:");
        this.jButton3.setText("Default");
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButtonClip.setText("Paste");
        this.jButtonClip.setFocusable(false);
        this.jButtonClip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButtonClipActionPerformed(evt);
            }
        });
        this.jButton4.setText("Save ASM Code");
        this.jButton4.setFocusable(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton4ActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Packed size:");
        this.psize.setFont(new Font("Monospaced", 0, 14));
        this.psize.setText("&0000");
        this.jButton5.setText("Save Packed");
        this.jButton5.setFocusable(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton5ActionPerformed(evt);
            }
        });
        this.rslider.setMaximum(120);
        this.rslider.setMinimum(10);
        this.rslider.setMinorTickSpacing(11);
        this.rslider.setPaintTicks(true);
        this.rslider.setValue(120);
        this.rslider.setInverted(true);
        this.rslider.setMaximumSize(new Dimension(200, 29));
        this.rslider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RasterPaint.this.rsliderStateChanged(evt);
            }
        });
        this.size.setFont(new Font("Monospaced", 0, 14));
        this.size.setText("00k");
        this.jCheckBox1.setText("Zoom");
        this.jCheckBox1.setFocusable(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.method.setText("Ord. Dither");
        this.method.setFocusable(false);
        this.method.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.methodActionPerformed(evt);
            }
        });
        this.jCheckBox2.setText("Rendermode");
        this.jCheckBox2.setFocusable(false);
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jCheckBox3.setText("Soften");
        this.jCheckBox3.setFocusable(false);
        this.jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jCheckBox3ActionPerformed(evt);
            }
        });
        this.jCheckBox4.setText("Linemode");
        this.jCheckBox4.setFocusable(false);
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jCheckBox4ActionPerformed(evt);
            }
        });
        prerender.setText("PreRender");
        prerender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.prerenderActionPerformed(evt);
            }
        });
        reverse.setText("Make Flipscreen");
        reverse.setEnabled(false);
        reverse.setFocusable(false);
        reverse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.reverseActionPerformed(evt);
            }
        });
        this.jButton9.setText("Remove blocked zones");
        this.jButton9.setFocusable(false);
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton9ActionPerformed(evt);
            }
        });
        this.jButton11.setText("Assemble to DSK");
        this.jButton11.setFocusable(false);
        this.jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton11ActionPerformed(evt);
            }
        });
        this.format.setFont(new Font("Tahoma", 1, 11));
        this.format.setText("Format: Raster screen");
        GroupLayout controlLayout = new GroupLayout(control);
        control.setLayout(controlLayout);
        controlLayout.setHorizontalGroup(controlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlLayout.createSequentialGroup().addContainerGap().addGroup(controlLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(controlLayout.createSequentialGroup().addGroup(controlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlLayout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dither).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rslider, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bright, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contrast, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gain, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttons)).addGroup(controlLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.p0, -2, -1, -2).addGap(6, 6, 6).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.p2, -2, -1, -2).addGap(6, 6, 6).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.p3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.auto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.size).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton11))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(controlLayout.createSequentialGroup().addComponent(this.jCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.method).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(prerender).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.format, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(reverse).addGap(129, 129, 129)))));
        controlLayout.setVerticalGroup(controlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlLayout.createSequentialGroup().addGroup(controlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlLayout.createSequentialGroup().addGap(8, 8, 8).addGroup(controlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.bright, -2, -1, -2).addComponent(this.contrast, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.gain, -2, -1, -2).addGroup(controlLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.alt).addComponent(this.dither).addComponent(this.jButton1)).addComponent(this.rslider, -2, -1, -2))).addGroup(controlLayout.createSequentialGroup().addContainerGap().addComponent(this.buttons).addContainerGap())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.p0, -2, -1, -2).addComponent(this.p2, -2, -1, -2).addComponent(this.p3, -2, -1, -2).addComponent(this.jButton2).addComponent(this.auto).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.psize).addComponent(this.jButton5).addComponent(this.jButton4).addComponent(this.size).addComponent(this.jButton11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox2).addComponent(this.jCheckBox3).addComponent(this.jCheckBox4).addComponent(this.method).addComponent(this.jCheckBox1).addComponent(prerender).addComponent(reverse).addComponent(this.jButton9).addComponent(this.format)).addContainerGap(-1, Short.MAX_VALUE)));
        this.hDist.setOrientation(1);
        this.hDist.setPaintTrack(false);
        this.hDist.setFocusable(false);
        this.hDist.setMaximumSize(new Dimension(21, 100));
        this.hDist.setMinimumSize(new Dimension(21, 100));
        this.hDist.setPreferredSize(new Dimension(20, 100));
        this.hDist.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RasterPaint.this.hDistStateChanged(evt);
            }
        });
        this.picture.setMaximumSize(new Dimension(640, 400));
        this.picture.setMinimumSize(new Dimension(640, 400));
        this.picture.setOpaque(true);
        this.picture.setPreferredSize(new Dimension(640, 400));
        this.picture.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RasterPaint.this.pictureMouseClicked(evt);
            }
        });
        this.picture.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RasterPaint.this.pictureKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                RasterPaint.this.pictureKeyReleased(evt);
            }
        });
        this.jTabbedPane1.setMaximumSize(new Dimension(390, 400));
        this.jTabbedPane1.setMinimumSize(new Dimension(390, 400));
        this.jLabel8.setText("DSK file:");
        this.diskname.setEditable(false);
        this.jButton6.setText("Create");
        this.jButton6.setFocusable(false);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton6ActionPerformed(evt);
            }
        });
        this.jLabel9.setText("DIR:");
        this.jScrollPane4.setMinimumSize(new Dimension(25, 164));
        this.jList1.setFont(new Font("Monospaced", 0, 13));
        this.jList1.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"no disk"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane4.setViewportView(this.jList1);
        this.jLabel10.setText("Filename:");
        this.rasname.setColumns(12);
        this.rasname.setText("SCREEN1");
        this.jButton7.setText("Write");
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton7ActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Free:");
        this.free.setText("0K");
        this.jButton8.setText("Open");
        this.jButton8.setFocusable(false);
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPaint.this.jButton8ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.diskname))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.free)).addComponent(this.rasname, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, -1, Short.MAX_VALUE))).addGap(0, 146, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.diskname, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton6).addComponent(this.jButton8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane4, -1, 246, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.rasname, -2, -1, -2).addComponent(this.jButton7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.free)).addContainerGap()));
        this.jTabbedPane1.addTab("Disk", this.jPanel1);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("\t\t;-----------------------------------------\n\t\t;\t\tJavaCPC RasterPaint Assembly code\n\t\t;\t\tAuthors: Oliver M. Lenz, Markus Hohmann\n\t\t;-----------------------------------------\n\n\t\torg &8000  ; CALL &8000\n\n\t\t; First: Let's detect if we have a Plus machine\n\t\tld\t\tbc,#F782\n\t\tld\t\te,c\n\t\tout\t\t(c),c\n\t\tdec\t\tb\n\t\tld\t\tc,#0f\n\t\tout\t\t(c),c\n\t\tinc\t\tb\n\t\tld\t\ta,e\n\t\tout\t\t(c),a\n\t\tdec\t\tb\n\t\tin\t\ta,(c)\n\t\tcp\t\tc\n\t\tjr\t\tz,Plus ; Plus found\n\t\tor\t\ta\n\t\tjr\t\tz,CpcOld ; Old CPC found\nPlus\n\t\t; ASIC Unlock routine\n\t\tdi\n\t\tld\t\tb,&bc\n\t\tld\t\thl,sequence\n\t\tld\t\te,17\nseq\n\t\tld\t\ta,(hl)\n\t\tout\t\t(c),a\n\t\tinc\t\thl\n\t\tdec\t\te\n\t\tjr\t\tnz,seq\n\t\tei\n\nhardwarescroll\n\n\t\tld\t\tbc,&7fb8 ; Jump into ASIC RAM\n\t\tout\t\t(c),c\n\t\tld\t\ta,142\t; Do a hardware scroll to the left\n\t\tld\t\t(&6804),a\n\t\tld\t\tbc,&7fa0\t; Jump back into CPC RAM\n\t\tout\t\t(c),c\n\nCpcOld\n\t\tCPCNew EQU 1 ; Set this to 0 for older CPC Models.\n\t\tTableData EQU &9900\n\t\tdi\n\n\t\tld\t\tA,0  ; Define Background Color\n\t\tld\t\tB,Paper\n\t\tld\t\tC,Paper\n\t\tcall\t\t&BC32\n\t\tld\t\tB,Paper\n\t\tld\t\tC,Paper\n\t\tcall\t\t&BC38\n\n\t\tld\t\tDE,&C000 ; Copy Pixel Data to Screen\n\t\tld\t\tHL,&4000\n\t\tld\t\tBC,&4000\n\t\tldir\n\n\t\tim\t\t1\n\t\tei\n\nnewframe:\n\t\tld\t\tHL,(&0038)\n\t\tld\t\t(rstsave),HL\n\t\tld\t\tHL,&C9FB\n\t\tld\t\t(&0038),HL\n\n\t\tld\t\tB,&F5\n.waitvsync\n\t\tin\t\tA,(C)\n\t\trra\n\t\tjp\t\tnc,waitvsync\n\n\n\t\thalt\n\t\thalt\n\n\t\tdi\n\t\tld\t\tDE,&1702\n.waitforstart\n\t\tdec\t\tD\n\t\tjr\t\tnz,waitforstart\n\t\tdec\t\tE\n\t\tjr\t\tnz,waitforstart\n\n\t\tIF\t\tCPCNew\n\t\tnop\n\t\tENDIF\n\n\t\tld\t\tBC,&7F80\n\t\tld\t\tHL,TableData\n\t\tld\t\tDE,&0203\n\t\tld\t\tA,&01\n\t\tout\t\t(C),A  ; select pen 1\n\t\tinc     B\n\n.nextline\nrepeat 200\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\touti\t\t; 5\n\t\t;\t\t40\n\n\t\tout\t\t(C),D  ; 4 ; pen 2\n\t\tld\t\tB,C  ; 1\n\t\touti\t\t; 5\n\t\tout\t\t(C),E  ; 4 ; pen 3\n\t\touti\t\t; 5\n\t\tout\t\t(C),A  ; 4 ; pen 1\n\t\tld\t\tB,C  ; 1\n\t\t;\t\t--\n\t\t;\t\t64 microseconds\nrend\n\n\t\tld\t\tHL,(rstsave)\n\t\tld\t\t(&0038),HL\n\t\tei\n\n\t\tLD\t\tA,&45 ; from &40 to &49 with bdir/bc1=01\n\t\tLD\t\tD,0\n\t\tLD\t\tBC,&F782 ; PPI port A out /C out\n\t\tOUT\t\t(C),C\n\t\tLD\t\tBC,&F40E ; Select Ay reg 14 on ppi port A\n\t\tOUT\t\t(C),C\n\t\tLD\t\tBC,&F6C0 ; This value is an AY index (R14)\n\t\tOUT\t\t(C),C\n\t\tOUT\t\t(C),D ; Validate!! out (c),0\n\t\tLD\t\tBC,&F792 ; PPI port A in/C out\n\t\tOUT\t\t(C),C\n\t\tDEC\t\tB\n\t\tOUT\t\t(C),A ; Send KbdLine on reg 14 AY through ppi port A\n\t\tLD\t\tB,&F4 ; Read ppi port A\n\t\tIN\t\tA,(C) ; e.g. AY R14 (AY port A)\n\t\tLD\t\tBC,&F782 ; PPI port A out / C out\n\t\tOUT\t\t(C),C\n\t\tDEC\t\tB ; Reset PPI Write\n\t\tOUT\t\t(C),D ; out (c),0\n\t\tbit\t\t7,A\n\t\tjp\t\tnz,newframe\n\t\tld\t\tbc,&7fb8 ; Jump into ASIC RAM\n\t\tout\t\t(c),c\n\t\tld\t\ta,0\t; reset hardware scroll\n\t\tld\t\t(&6804),a\n\t\tld\t\tbc,&7fa0\t; Jump back into CPC RAM\n\t\tout\t\t(c),c\n\t\tret\n\n.rstsave\n\t\tdb\t\t0,0\n\n.sequence\n\t\tdefb\t\t&ff,&00,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee\n\n\t\t;;\t\t------------------------------------------------");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jTabbedPane1.addTab("Code", this.jScrollPane1);
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea2.setRows(5);
        this.jTextArea2.setText("db &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F\ndb &44,&55,&57,&46,&5F,&52,&5E,&4C,&4D,&4F");
        this.jScrollPane2.setViewportView(this.jTextArea2);
        this.jTabbedPane1.addTab("Rasterdata", this.jScrollPane2);
        this.jTextArea3.setColumns(20);
        this.jTextArea3.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextArea3);
        this.jTabbedPane1.addTab("Pixeldata", this.jScrollPane3);
        GroupLayout rasterpaintLayout = new GroupLayout(this.rasterpaint);
        this.rasterpaint.setLayout(rasterpaintLayout);
        this.buttons.setLayout(new BorderLayout());
        this.buttons.add((Component)this.jButton3, "West");
        this.buttons.add((Component)this.jButtonClip, "Center");
        rasterpaintLayout.setHorizontalGroup(rasterpaintLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rasterpaintLayout.createSequentialGroup().addContainerGap().addGroup(rasterpaintLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(control, -1, 1058, Short.MAX_VALUE).addGroup(rasterpaintLayout.createSequentialGroup().addComponent(this.hDist, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.picture, -2, 640, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -1, -1, -2))).addContainerGap()));
        rasterpaintLayout.setVerticalGroup(rasterpaintLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rasterpaintLayout.createSequentialGroup().addContainerGap().addGroup(rasterpaintLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.picture, -1, -1, Short.MAX_VALUE).addComponent(this.hDist, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(control, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.rasterpaint, -2, 1078, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.rasterpaint, -2, 553, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
        this.can.addMouseListener(this);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.Import();
    }

    private void ditherActionPerformed(ActionEvent evt) {
        this.Import(this.ffile);
    }

    private void altActionPerformed(ActionEvent evt) {
        this.Import(this.ffile);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.doRaster(true);
    }

    private void p0ItemStateChanged(ItemEvent evt) {
        this.Import(this.ffile);
    }

    private void p2ItemStateChanged(ItemEvent evt) {
        this.Import(this.ffile);
    }

    private void p3ItemStateChanged(ItemEvent evt) {
        this.Import(this.ffile);
    }

    private void autoActionPerformed(ActionEvent evt) {
        this.Import(this.ffile);
        this.jButton2.setEnabled(!this.auto.isSelected());
    }

    private void javacpcActionPerformed(ActionEvent evt) {
        this.Import(this.ffile);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.bright.setValue(100);
        this.contrast.setValue(100);
        this.gain.setValue(150);
        this.rslider.setValue(120);
        this.p0.setSelectedIndex(0);
        this.p2.setSelectedIndex(0);
        this.p3.setSelectedIndex(0);
        this.resetLines();
        this.Import(this.ffile);
    }

    private void jButtonClipActionPerformed(ActionEvent evt) {
        this.bright.setValue(100);
        this.contrast.setValue(100);
        this.gain.setValue(150);
        this.rslider.setValue(120);
        this.p0.setSelectedIndex(0);
        this.p2.setSelectedIndex(0);
        this.p3.setSelectedIndex(0);
        this.resetLines();
        if (this.clip != null) {
            this.clip.locked = false;
        }
        this.ImportClipboard();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.saveASM();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.saveCrunched();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.writeToDsk();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.createDSK();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.openDSK();
    }

    private void rsliderStateChanged(ChangeEvent evt) {
        if (this.dither.isSelected()) {
            this.Import(this.ffile);
        }
    }

    private void gainStateChanged(ChangeEvent evt) {
        this.Import(this.ffile);
    }

    private void pictureMouseClicked(MouseEvent evt) {
        this.picture.requestFocus();
    }

    private void contrastStateChanged(ChangeEvent evt) {
        this.Import(this.ffile);
    }

    private void brightStateChanged(ChangeEvent evt) {
        this.Import(this.ffile);
    }

    private void hideActionPerformed(ActionEvent evt) {
        this.Import(this.ffile);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.jFrame1.setVisible(this.jCheckBox1.isSelected());
        if (this.jFrame1.isVisible()) {
            this.zoom.requestFocus();
            this.isVisible = true;
            this.Display = new Thread(){

                @Override
                public void run() {
                    while (RasterPaint.this.isVisible) {
                        RasterPaint.this.drawZoomed(RasterPaint.this.lastMouse);
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception exception) {}
                    }
                    System.out.println("Zoom window closed");
                }
            };
            this.Display.start();
        } else {
            this.isVisible = false;
        }
        this.jFrame1.pack();
        this.Import(this.ffile);
    }

    public void reImport() {
        this.Import(this.ffile);
    }

    private void drawZoomed(MouseEvent evt) {
        if (this.previewImage == null) {
            this.previewImage = new BufferedImage(640, 400, 1);
        }
        if (this.overlay == null) {
            this.overlay = new BufferedImage(640, 400, 2);
        }
        Graphics2D g2d = this.overlay.createGraphics();
        g2d.setBackground(new Color(0, 0, 0, 0));
        g2d.clearRect(0, 0, this.overlay.getWidth(), this.overlay.getHeight());
        boolean bl = this.blink = !this.blink;
        if (this.blink) {
            boolean bl2 = this.flash = !this.flash;
            if (this.flash) {
                boolean bl3 = this.flasher = !this.flasher;
            }
        }
        if (this.flasher) {
            g2d.setColor(new Color(255, 0, 0, 128));
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 400; j += 2) {
                    if (!this.block[i][j >> 1]) continue;
                    g2d.drawLine(this.sarea[i] << 1, j + 1, this.sarea[i + 1] << 1, j + 1);
                }
            }
            g2d.setColor(new Color(0, 255, 0, 128));
            for (int yy = 0; yy < 400; yy += 2) {
                if (this.render_line[yy >> 1] || yy >> 1 <= 0) continue;
                g2d.drawLine(0, yy - 1, 640, yy - 1);
            }
        }
        int x = 0;
        int y = 0;
        if (this.zoomed.getWidth() != this.zoom.getWidth() && this.zoom.getWidth() > 0 && this.zoom.getHeight() > 0) {
            this.zoomed = new BufferedImage(this.zoom.getWidth(), this.zoom.getHeight(), 1);
        }
        Graphics2D g = this.zoomed.createGraphics();
        g.drawImage(this.previewImage, 0, 0, this.zoomed.getWidth(), this.zoomed.getHeight(), this);
        g.drawImage(this.overlay, 0, 0, this.zoomed.getWidth(), this.zoomed.getHeight(), this);
        int n = this.zoomed.getWidth() == 960 ? 3 : (this.zoomf = this.zoomed.getWidth() == 1280 ? 4 : 5);
        if (evt != null) {
            x = evt.getX() / this.zoomf;
            y = evt.getY() / this.zoomf;
        }
        x *= this.zoomf;
        y *= this.zoomf;
        int blocks = 0;
        int lineblocks = 0;
        for (int z = 0; z < 8; ++z) {
            lineblocks = 0;
            for (int l = 0; l < 200; ++l) {
                if (this.block[z][l]) {
                    ++blocks;
                }
                if (this.render_line[l]) continue;
                ++lineblocks;
            }
        }
        this.jFrame1.setTitle("Zoom view - Blocked zones: " + blocks + " Blocked lines: " + lineblocks);
        g.drawImage(this.zoomcursor, x - 12, y - 12, this);
        this.zoom.setIcon(new ImageIcon(this.zoomed));
    }

    private void zoomMouseMoved(MouseEvent evt) {
        this.lastMouse = evt;
    }

    private void pictureKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 16) {
            this.shift = true;
        }
        if (evt.getKeyCode() == 17) {
            this.ctrl = true;
        }
        if (this.ctrl && evt.getKeyCode() == 86) {
            this.ctrl = false;
            if (this.clip != null) {
                this.clip.locked = false;
            }
            this.ImportClipboard();
        }
    }

    private void pictureKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 16) {
            this.shift = false;
        }
        if (evt.getKeyCode() == 17) {
            this.ctrl = false;
        }
        if (evt.getKeyCode() == 32) {
            this.colormode = !this.colormode;
            this.Import(this.ffile);
        }
    }

    private void zoomKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 16) {
            this.shift = true;
        }
        if (evt.getKeyCode() == 38) {
            this.blockdirection = 0;
        }
        if (evt.getKeyCode() == 39) {
            this.blockdirection = 1;
        }
        if (evt.getKeyCode() == 40) {
            this.blockdirection = 2;
        }
        if (evt.getKeyCode() == 37) {
            this.blockdirection = 3;
        }
        switch (this.blockdirection) {
            case 0: {
                this.jLabel13.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/paint/icons/ar_up.png")));
                break;
            }
            case 1: {
                this.jLabel13.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/paint/icons/ar_right.png")));
                break;
            }
            case 2: {
                this.jLabel13.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/paint/icons/ar_down.png")));
                break;
            }
            case 3: {
                this.jLabel13.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/paint/icons/ar_left.png")));
            }
        }
    }

    private void zoomKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 16) {
            this.shift = false;
        }
        if (evt.getKeyCode() == 32) {
            this.colormode = !this.colormode;
            this.Import(this.ffile);
        }
    }

    private void hDistStateChanged(ChangeEvent evt) {
        this.Import(this.ffile);
    }

    private void methodActionPerformed(ActionEvent evt) {
        this.Import(this.ffile);
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        this.rendermode = this.jCheckBox2.isSelected() ? 320 : 640;
        this.preImport(this.ffile);
    }

    private void jCheckBox3ActionPerformed(ActionEvent evt) {
        this.blur = this.jCheckBox3.isSelected();
        this.Import(this.ffile);
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
        this.linemode = this.jCheckBox4.isSelected();
        this.Import(this.ffile);
    }

    private void prerenderActionPerformed(ActionEvent evt) {
        reverse.setEnabled(prerender.isSelected());
        if (!reverse.isEnabled()) {
            reverse.setSelected(false);
            this.jButton7.setEnabled(true);
            this.jButton5.setEnabled(true);
            this.lockRaster(false);
        }
        this.Import(this.ffile);
    }

    private void reverseActionPerformed(ActionEvent evt) {
        this.lockRaster(reverse.isSelected());
        this.format.setText(this.rasterLock ? "Format: Flipraster screen" : "Format: Raster screen");
        this.jButton7.setEnabled(!reverse.isSelected());
        this.jButton5.setEnabled(!reverse.isSelected());
    }

    private void zoomMouseReleased(MouseEvent evt) {
        this.lastMouse = evt;
        this.zoom.requestFocus();
        if (evt.getButton() != 1 && !this.colormode) {
            ++this.rastermode;
            this.rastermode %= 4;
            switch (this.rastermode) {
                case 0: {
                    this.jLabel16.setText("Disabled");
                    break;
                }
                case 1: {
                    this.jLabel16.setText("Cells (PEN 1)");
                    break;
                }
                case 2: {
                    this.jLabel16.setText("Lines (PEN 2+3)");
                    break;
                }
                case 3: {
                    this.jLabel16.setText("Cells + Lines");
                }
            }
            this.Import(this.ffile);
            return;
        }
        if (this.colormode) {
            int zn = 0;
            int px = evt.getX() / this.zoomf;
            int py = evt.getY() / this.zoomf;
            zn = px < this.area[0] ? 0 : (px < this.area[1] ? 1 : (px < this.area[2] ? 2 : (px < this.area[3] ? 3 : (px < this.area[4] ? 4 : (px < this.area[5] ? 5 : (px < this.area[6] ? 6 : 7))))));
            this.pen1zone = zn;
            this.pen2line = this.pen3line = py;
            this.pen1line = this.pen3line;
            this.selector.setPen1(this.manualPen1[zn][py]);
            this.selector.setPen2(this.manualPen2[py]);
            this.selector.setPen3(this.manualPen3[py]);
            this.selector.setVisible(true);
            return;
        }
        int y = evt.getY() / this.zoomf;
        int x = evt.getX() / this.zoomf;
        if (this.rastermode == 0) {
            return;
        }
        int z = x < this.area[0] ? 0 : (x < this.area[1] ? 1 : (x < this.area[2] ? 2 : (x < this.area[3] ? 3 : (x < this.area[4] ? 4 : (x < this.area[5] ? 5 : (x < this.area[6] ? 6 : 7))))));
        if (evt.getButton() != 1) {
            return;
        }
        if (this.rastermode == 1) {
            this.render_zone[z][y] = !this.render_zone[z][y];
            this.direction[z][y] = this.blockdirection;
            this.block[z][y] = false;
            if (y > 0) {
                this.block[z][y - 1] = false;
            }
            if (z < 7) {
                this.block[z + 1][y] = false;
            }
            if (y < 199) {
                this.block[z][y + 1] = false;
            }
            if (z > 0) {
                this.block[z - 1][y] = false;
            }
            switch (this.blockdirection) {
                case 0: {
                    if (y <= 0) break;
                    this.block[z][y - 1] = !this.render_zone[z][y];
                    break;
                }
                case 1: {
                    if (z >= 7) break;
                    this.block[z + 1][y] = !this.render_zone[z][y];
                    break;
                }
                case 2: {
                    if (y >= 199) break;
                    this.block[z][y + 1] = !this.render_zone[z][y];
                    break;
                }
                case 3: {
                    if (z <= 0) break;
                    this.block[z - 1][y] = !this.render_zone[z][y];
                }
            }
        } else if (this.rastermode == 2 || this.rastermode == 3) {
            if (this.rastermode == 3) {
                this.render_zone[z][y] = !this.render_zone[z][y];
                this.direction[z][y] = this.blockdirection;
                this.block[z][y] = false;
                if (y > 0) {
                    this.block[z][y - 1] = false;
                }
                if (z < 7) {
                    this.block[z + 1][y] = false;
                }
                if (y < 199) {
                    this.block[z][y + 1] = false;
                }
                if (z > 0) {
                    this.block[z - 1][y] = false;
                }
                switch (this.blockdirection) {
                    case 0: {
                        if (y <= 0) break;
                        this.block[z][y - 1] = !this.render_zone[z][y];
                        break;
                    }
                    case 1: {
                        if (z >= 7) break;
                        this.block[z + 1][y] = !this.render_zone[z][y];
                        break;
                    }
                    case 2: {
                        if (y >= 199) break;
                        this.block[z][y + 1] = !this.render_zone[z][y];
                        break;
                    }
                    case 3: {
                        if (z <= 0) break;
                        this.block[z - 1][y] = !this.render_zone[z][y];
                    }
                }
            }
            this.render_line[y] = !this.render_line[y];
        }
        this.Import(this.ffile);
        this.drawZoomed(evt);
    }

    private void zoomMouseDragged(MouseEvent evt) {
        this.drawZoomed(evt);
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.removeBlocks();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.removeBlocks();
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        this.assembleIt();
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        int h;
        int w;
        int index = this.jComboBox1.getSelectedIndex();
        switch (index) {
            case 1: {
                w = 1280;
                h = 800;
                break;
            }
            case 2: {
                w = 1600;
                h = 1000;
                break;
            }
            default: {
                w = 960;
                h = 600;
            }
        }
        this.zoom.setPreferredSize(new Dimension(w, h));
        this.zoom.setSize(new Dimension(w, h));
        this.zoom.setMaximumSize(new Dimension(w, h));
        this.zoom.setMinimumSize(new Dimension(w, h));
        this.jFrame1.pack();
        this.drawZoomed(this.lastMouse);
    }

    protected Image createImage(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL).getImage();
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RasterPaint.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(RasterPaint.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(RasterPaint.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(RasterPaint.class.getName()).log(Level.SEVERE, (String)null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new RasterPaint().setVisible(true);
            }
        });
    }

    private class DropListener
    extends DropTargetAdapter {
        private DropListener() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(3);
                    Object userObject = t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (userObject instanceof List) {
                        String filename = ((List)userObject).get(0).toString();
                        File a = new File(filename);
                        String path = a.getPath();
                        String file = a.getName();
                        path = path.replace(file, "");
                        RasterPaint.this.clipimport = false;
                        RasterPaint.this.preImport(path + file);
                    }
                    dtde.dropComplete(true);
                }
            }
            catch (Exception ex) {
                System.out.println("[MainForm::DropListener]" + ex);
            }
        }
    }
}

