/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.ilbm;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import org.monte.media.AbortException;
import org.monte.media.ParseException;
import org.monte.media.iff.IFFChunk;
import org.monte.media.iff.IFFParser;
import org.monte.media.iff.IFFVisitor;
import org.monte.media.iff.MC68000InputStream;
import org.monte.media.ilbm.CRNGColorCycle;
import org.monte.media.ilbm.ColorCycle;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.ilbm.DRNGColorCycle;
import org.monte.media.ilbm.HAMColorModel;
import org.monte.media.image.BitmapImage;

public class ILBMDecoder
implements IFFVisitor {
    protected static final int ILBM_ID = IFFParser.stringToID("ILBM");
    protected static final int BMHD_ID = IFFParser.stringToID("BMHD");
    protected static final int CMAP_ID = IFFParser.stringToID("CMAP");
    protected static final int CAMG_ID = IFFParser.stringToID("CAMG");
    protected static final int CCRT_ID = IFFParser.stringToID("CCRT");
    protected static final int CRNG_ID = IFFParser.stringToID("CRNG");
    protected static final int DRNG_ID = IFFParser.stringToID("DRNG");
    protected static final int BODY_ID = IFFParser.stringToID("BODY");
    protected static final int VDAT_ID = IFFParser.stringToID("VDAT");
    private static final int AUTH_ID = IFFParser.stringToID("AUTH");
    private static final int ANNO_ID = IFFParser.stringToID("ANNO");
    private static final int COPYRIGHT_ID = IFFParser.stringToID("(c) ");
    protected static final int MONITOR_ID_MASK = -61440;
    protected static final int DEFAULT_MONITOR_ID = 0;
    protected static final int NTSC_MONITOR_ID = 69632;
    protected static final int PAL_MONITOR_ID = 135168;
    protected static final int VGA_MONITOR_ID = 200704;
    protected static final int A2024_MONITOR_ID = 266240;
    protected static final int PROTO_MONITOR_ID = 331776;
    protected static final int EURO72_MONITOR_ID = 397312;
    protected static final int EURO36_MONITOR_ID = 462848;
    protected static final int SUPER72_MONITOR_ID = 528384;
    protected static final int DBLNTSC_MONITOR_ID = 593920;
    protected static final int DBLPAL_MONITOR_ID = 4096;
    protected static final int MODE_INDEXED_COLORS = 0;
    protected static final int MODE_DIRECT_COLORS = 1;
    protected static final int MODE_EHB = 2;
    protected static final int MODE_HAM6 = 3;
    protected static final int MODE_HAM8 = 4;
    protected static final int HAM_MASK = 2048;
    protected static final int EHB_MASK = 128;
    protected static final int HAM_KEY = 2048;
    protected static final int EXTRAHALFBRITE_KEY = 128;
    protected static final int MSK_NONE = 0;
    protected static final int MSK_HAS_MASK = 1;
    protected static final int MSK_HAS_TRANSPARENT_COLOR = 2;
    protected static final int MSK_LASSO = 3;
    protected static final int CMP_NONE = 0;
    protected static final int CMP_BYTE_RUN_1 = 1;
    protected static final int CMP_VERTICAL = 2;
    protected InputStream inputStream;
    protected URL location;
    protected ArrayList<ColorCyclingMemoryImageSource> sources;
    protected ArrayList<BitmapImage> bitmapSources;
    protected Hashtable properties;
    protected int bmhdWidth;
    protected int bmhdHeight;
    protected int bmhdXPosition;
    protected int bmhdYPosition;
    protected int bmhdNbPlanes;
    protected int bmhdMasking;
    protected int bmhdCompression;
    protected int bmhdTransparentColor;
    protected int bmhdXAspect;
    protected int bmhdYAspect;
    protected int bmhdPageWidth;
    protected int bmhdPageHeight;
    protected int camg = 69632;
    protected int camgMode;
    protected ColorModel cmapColorModel;
    protected BitmapImage bodyBitmap;

    public ILBMDecoder(InputStream in) {
        this.inputStream = in;
    }

    public ILBMDecoder(URL location) {
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ColorCyclingMemoryImageSource> produce() throws IOException {
        boolean mustCloseStream;
        InputStream in = null;
        this.sources = new ArrayList();
        this.bitmapSources = null;
        if (this.inputStream != null) {
            in = this.inputStream;
            mustCloseStream = false;
        } else {
            in = this.location.openStream();
            mustCloseStream = true;
        }
        try {
            IFFParser iff = new IFFParser();
            this.registerChunks(iff);
            iff.parse(in, this);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        catch (AbortException e) {
            e.printStackTrace();
        }
        finally {
            if (mustCloseStream) {
                in.close();
            }
        }
        return this.sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BitmapImage> produceBitmaps() throws IOException {
        boolean mustCloseStream;
        InputStream in = null;
        this.sources = null;
        this.bitmapSources = new ArrayList();
        if (this.inputStream != null) {
            in = this.inputStream;
            mustCloseStream = false;
        } else {
            in = this.location.openStream();
            mustCloseStream = true;
        }
        try {
            IFFParser iff = new IFFParser();
            this.registerChunks(iff);
            iff.parse(in, this);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        catch (AbortException e) {
            e.printStackTrace();
        }
        finally {
            if (mustCloseStream) {
                in.close();
            }
        }
        return this.bitmapSources;
    }

    public void registerChunks(IFFParser iff) {
        iff.declareGroupChunk(ILBM_ID, 1179603533);
        iff.declarePropertyChunk(ILBM_ID, BMHD_ID);
        iff.declarePropertyChunk(ILBM_ID, CMAP_ID);
        iff.declarePropertyChunk(ILBM_ID, CAMG_ID);
        iff.declareDataChunk(ILBM_ID, BODY_ID);
        iff.declareCollectionChunk(ILBM_ID, ANNO_ID);
        iff.declareCollectionChunk(ILBM_ID, COPYRIGHT_ID);
        iff.declareCollectionChunk(ILBM_ID, AUTH_ID);
        iff.declareCollectionChunk(ILBM_ID, CRNG_ID);
        iff.declareCollectionChunk(ILBM_ID, DRNG_ID);
        iff.declareCollectionChunk(ILBM_ID, CCRT_ID);
    }

    @Override
    public void enterGroup(IFFChunk chunk) {
    }

    @Override
    public void leaveGroup(IFFChunk chunk) {
    }

    @Override
    public void visitChunk(IFFChunk group, IFFChunk chunk) throws ParseException, AbortException {
        int i;
        String s;
        this.decodeBMHD(group.getPropertyChunk(BMHD_ID));
        this.decodeCAMG(group.getPropertyChunk(CAMG_ID));
        boolean is4BitsPerChannel = (this.camg & 0xFFFF1000) == 0;
        this.decodeCMAP(group.getPropertyChunk(CMAP_ID), is4BitsPerChannel);
        this.decodeBODY(chunk);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        double aspect = (double)this.bmhdXAspect / (double)this.bmhdYAspect;
        if (this.bmhdXAspect == 0 || this.bmhdYAspect == 0) {
            aspect = 1.0;
        }
        props.put("aspect", new Double(aspect));
        switch (this.camgMode) {
            case 0: {
                s = "Indexed Colors";
                break;
            }
            case 1: {
                s = "Direct Colors";
                break;
            }
            case 2: {
                s = "EHB";
                break;
            }
            case 3: {
                s = "HAM 6";
                break;
            }
            case 4: {
                s = "HAM 8";
                break;
            }
            default: {
                s = "unknown";
            }
        }
        props.put("screenMode", s);
        props.put("nbPlanes", "" + this.bmhdNbPlanes + ((this.bmhdMasking & 1) != 0 ? "+mask" : ""));
        props.put("CAMG", new Integer(this.camg));
        StringBuffer comment = new StringBuffer();
        IFFChunk[] chunks = group.getCollectionChunks(ANNO_ID);
        for (i = 0; i < chunks.length; ++i) {
            if (comment.length() > 0) {
                comment.append('\n');
            }
            comment.append(new String(chunks[i].getData()));
        }
        chunks = group.getCollectionChunks(AUTH_ID);
        for (i = 0; i < chunks.length; ++i) {
            if (comment.length() > 0) {
                comment.append('\n');
            }
            comment.append("Author: ");
            comment.append(new String(chunks[i].getData()));
        }
        chunks = group.getCollectionChunks(COPYRIGHT_ID);
        for (i = 0; i < chunks.length; ++i) {
            if (comment.length() > 0) {
                comment.append('\n');
            }
            comment.append("\u00a9 ");
            comment.append(new String(chunks[i].getData()));
        }
        if (comment.length() > 0) {
            props.put("comment", comment.toString());
        }
        this.bodyBitmap.setEnforceDirectColors(false);
        if (this.sources != null) {
            ColorCyclingMemoryImageSource mis = this.bodyBitmap.convertToChunky() == 1 ? new ColorCyclingMemoryImageSource(this.bmhdWidth, this.bmhdHeight, this.cmapColorModel, this.bodyBitmap.getBytePixels(), 0, this.bmhdWidth, props) : new ColorCyclingMemoryImageSource(this.bmhdWidth, this.bmhdHeight, this.bodyBitmap.getChunkyColorModel(), this.bodyBitmap.getIntPixels(), 0, this.bmhdWidth, props);
            IFFChunk[] ccrtChunks = group.getCollectionChunks(CCRT_ID);
            IFFChunk[] crngChunks = group.getCollectionChunks(CRNG_ID);
            IFFChunk[] drngChunks = group.getCollectionChunks(DRNG_ID);
            int activeCycles = 0;
            int j = 0;
            int k = 0;
            int l = 0;
            int n = ccrtChunks.length + crngChunks.length + drngChunks.length;
            for (int i2 = 0; i2 < n; ++i2) {
                ColorCycle cc;
                if (!(j >= crngChunks.length || k < drngChunks.length && crngChunks[j].getScan() >= drngChunks[k].getScan() || l < ccrtChunks.length && crngChunks[j].getScan() >= ccrtChunks[l].getScan())) {
                    cc = this.decodeCRNG(crngChunks[j]);
                    if (cc != null) {
                        mis.addColorCycle(cc);
                        if (cc.isActive()) {
                            ++activeCycles;
                        }
                    }
                    ++j;
                    continue;
                }
                if (k < drngChunks.length && (l >= ccrtChunks.length || drngChunks[k].getScan() < ccrtChunks[l].getScan())) {
                    cc = this.decodeDRNG(drngChunks[k]);
                    if (cc != null) {
                        mis.addColorCycle(cc);
                        if (cc.isActive()) {
                            ++activeCycles;
                        }
                    }
                    ++k;
                    continue;
                }
                cc = this.decodeCCRT(ccrtChunks[l]);
                if (cc != null) {
                    mis.addColorCycle(cc);
                    if (cc.isActive()) {
                        ++activeCycles;
                    }
                }
                ++l;
            }
            if (activeCycles > 0) {
                mis.setAnimated(true);
                props.put("colorCycling", activeCycles);
            }
            this.sources.add(mis);
        }
        if (this.bitmapSources != null) {
            this.bitmapSources.add(this.bodyBitmap.clone());
        }
    }

    protected void decodeBMHD(IFFChunk chunk) throws ParseException {
        if (chunk == null) {
            throw new ParseException("no BMHD -> no Picture");
        }
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            this.bmhdWidth = in.readUWORD();
            this.bmhdHeight = in.readUWORD();
            this.bmhdXPosition = in.readWORD();
            this.bmhdYPosition = in.readWORD();
            this.bmhdNbPlanes = in.readUBYTE();
            this.bmhdMasking = in.readUBYTE();
            this.bmhdCompression = in.readUBYTE();
            in.skip(1L);
            this.bmhdTransparentColor = in.readUWORD();
            this.bmhdXAspect = in.readUBYTE();
            this.bmhdYAspect = in.readUBYTE();
            this.bmhdPageWidth = in.readWORD();
            this.bmhdPageHeight = in.readWORD();
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    protected void decodeCAMG(IFFChunk chunk) throws ParseException {
        this.camg = 0;
        if (chunk != null) {
            try {
                MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
                this.camg = in.readLONG();
                in.close();
            }
            catch (IOException e) {
                throw new ParseException(e.toString());
            }
        }
        switch (this.camg & 0x880) {
            case 128: {
                this.camgMode = 2;
                break;
            }
            case 2048: {
                if (this.bmhdNbPlanes == 6) {
                    this.camgMode = 3;
                    break;
                }
                if (this.bmhdNbPlanes == 8) {
                    this.camgMode = 4;
                    break;
                }
                throw new ParseException("unsupported Ham Mode with " + this.bmhdNbPlanes + " bitplanes");
            }
            default: {
                this.camgMode = this.bmhdNbPlanes <= 8 ? 0 : 1;
            }
        }
    }

    protected void decodeCMAP(IFFChunk chunk, boolean is4BitsPerChannel) throws ParseException {
        int i;
        int size = 0;
        int colorsToRead = 0;
        if (chunk == null && this.camgMode != 1) {
            if (this.camgMode == 0) {
                size = 1 << this.bmhdNbPlanes;
                byte[] red = new byte[size];
                byte[] green = new byte[size];
                byte[] blue = new byte[size];
                for (int i2 = 0; i2 < size; ++i2) {
                    green[i2] = blue[i2] = (byte)((float)i2 / (float)(size - 1) * 255.0f);
                    red[i2] = blue[i2];
                }
                this.cmapColorModel = new IndexColorModel(8, size, red, green, blue);
                return;
            }
            if (size == 0) {
                throw new ParseException("No CMAP, not supported for this CAMG mode.");
            }
        }
        switch (this.camgMode) {
            case 2: {
                size = (this.bmhdMasking & 1) != 0 ? 128 : 64;
                colorsToRead = Math.min(32, (int)chunk.getSize() / 3);
                break;
            }
            case 3: 
            case 4: {
                if ((this.bmhdMasking & 1) != 0) {
                    throw new ParseException("Masking for HAM not supported");
                }
                size = 1 << this.bmhdNbPlanes - 2;
                colorsToRead = Math.min(size, (int)chunk.getSize() / 3);
                break;
            }
            case 0: {
                size = (this.bmhdMasking & 1) != 0 ? 2 << this.bmhdNbPlanes : 1 << this.bmhdNbPlanes;
                colorsToRead = Math.min(size, (int)chunk.getSize() / 3);
                break;
            }
            case 1: {
                if (this.bmhdMasking != 0) {
                    throw new ParseException("Masking for true color not supported");
                }
                this.cmapColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                return;
            }
            default: {
                throw new ParseException("Unsupported CAMG mode :" + this.camgMode);
            }
        }
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        byte[] data = chunk.getData();
        int j = 0;
        if (is4BitsPerChannel) {
            for (i = 0; i < colorsToRead; ++i) {
                red[i] = (byte)(data[j] & 0xF0 | (data[j] & 0xF0) >>> 4);
                green[i] = (byte)(data[j + 1] & 0xF0 | (data[j + 1] & 0xF0) >>> 4);
                blue[i] = (byte)(data[j + 2] & 0xF0 | (data[j + 2] & 0xF0) >>> 4);
                j += 3;
            }
        } else {
            for (i = 0; i < colorsToRead; ++i) {
                red[i] = data[j++];
                green[i] = data[j++];
                blue[i] = data[j++];
            }
        }
        int transparentColorIndex = (this.bmhdMasking & 2) != 0 ? this.bmhdTransparentColor : -1;
        switch (this.camgMode) {
            case 2: {
                j = 32;
                int i3 = 0;
                while (i3 < 32) {
                    red[j] = (byte)((red[i3] & 0xFF) / 2);
                    green[j] = (byte)((green[i3] & 0xFF) / 2);
                    blue[j] = (byte)((blue[i3] & 0xFF) / 2);
                    ++i3;
                    ++j;
                }
                if ((this.bmhdMasking & 1) != 0) {
                    System.arraycopy(red, 0, red, 64, 64);
                    System.arraycopy(green, 0, green, 64, 64);
                    System.arraycopy(green, 0, green, 64, 64);
                    byte[] alpha = new byte[128];
                    for (i3 = 0; i3 < 64; ++i3) {
                        alpha[i3] = -1;
                    }
                    this.cmapColorModel = new IndexColorModel(8, 64, red, green, blue, alpha);
                    break;
                }
                this.cmapColorModel = new IndexColorModel(8, 64, red, green, blue, transparentColorIndex);
                break;
            }
            case 3: {
                this.cmapColorModel = new HAMColorModel(6, 16, red, green, blue, false);
                break;
            }
            case 4: {
                this.cmapColorModel = new HAMColorModel(8, 64, red, green, blue, false);
                break;
            }
            case 0: {
                if ((this.bmhdMasking & 1) != 0) {
                    System.arraycopy(red, 0, red, red.length / 2, red.length / 2);
                    System.arraycopy(green, 0, green, green.length / 2, green.length / 2);
                    System.arraycopy(blue, 0, blue, blue.length / 2, blue.length / 2);
                    byte[] alpha = new byte[red.length];
                    int n = red.length / 2;
                    for (int i4 = 0; i4 < n; ++i4) {
                        alpha[i4] = -1;
                    }
                    this.cmapColorModel = new IndexColorModel(8, red.length, red, green, blue, alpha);
                    break;
                }
                this.cmapColorModel = new IndexColorModel(8, red.length, red, green, blue, transparentColorIndex);
            }
        }
    }

    protected ColorCycle decodeCCRT(IFFChunk chunk) throws ParseException {
        CRNGColorCycle cc;
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            short direction = in.readWORD();
            int start = in.readUBYTE();
            int end = in.readUBYTE();
            long seconds = in.readULONG();
            long microseconds = in.readULONG();
            short pad = in.readWORD();
            cc = new CRNGColorCycle(1000000 / (int)(seconds * 1000L + microseconds / 1000L), 1000, start, end, direction == 1 || direction == -1, direction == 1, this.camgMode == 2);
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
        return cc;
    }

    protected ColorCycle decodeCRNG(IFFChunk chunk) throws ParseException {
        CRNGColorCycle cc;
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int pad1 = in.readUWORD();
            int rate = in.readUWORD();
            int flags = in.readUWORD();
            int low = in.readUBYTE();
            int high = in.readUBYTE();
            cc = new CRNGColorCycle(rate, 273, low, high, (flags & 1) != 0 && rate > 36 && high > low, (flags & 2) != 0, this.camgMode == 2);
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
        return cc;
    }

    protected ColorCycle decodeDRNG(IFFChunk chunk) throws ParseException {
        DRNGColorCycle cc;
        try {
            int cell;
            int i;
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int min = in.readUBYTE();
            int max = in.readUBYTE();
            int rate = in.readUWORD();
            int flags = in.readUWORD();
            int ntrue = in.readUBYTE();
            int nregs = in.readUBYTE();
            DRNGColorCycle.Cell[] cells = new DRNGColorCycle.Cell[ntrue + nregs];
            for (i = 0; i < ntrue; ++i) {
                cell = in.readUBYTE();
                int rgb = in.readUBYTE() << 16 | in.readUBYTE() << 8 | in.readUBYTE();
                cells[i] = new DRNGColorCycle.DColorCell(cell, rgb);
            }
            for (i = 0; i < nregs; ++i) {
                cell = in.readUBYTE();
                int index = in.readUBYTE();
                cells[i + ntrue] = new DRNGColorCycle.DIndexCell(cell, index);
            }
            cc = new DRNGColorCycle(rate, 273, min, max, (flags & 1) != 0 && rate > 36 && min <= max && ntrue + nregs > 1, this.camgMode == 2, cells);
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
        return cc;
    }

    protected void decodeBODY(IFFChunk chunk) throws ParseException {
        this.bodyBitmap = (this.bmhdMasking & 1) != 0 ? new BitmapImage(this.bmhdWidth, this.bmhdHeight, this.bmhdNbPlanes + 1, this.cmapColorModel) : new BitmapImage(this.bmhdWidth, this.bmhdHeight, this.bmhdNbPlanes, this.cmapColorModel);
        byte[] data = chunk.getData();
        switch (this.bmhdCompression) {
            case 0: {
                System.arraycopy(data, 0, this.bodyBitmap.getBitmap(), 0, data.length);
                break;
            }
            case 1: {
                ILBMDecoder.unpackByteRun1(data, this.bodyBitmap.getBitmap());
                break;
            }
            case 2: {
                this.unpackVertical(data, this.bodyBitmap);
                break;
            }
            default: {
                throw new ParseException("unknown compression method: " + this.bmhdCompression);
            }
        }
    }

    public static int unpackByteRun1(byte[] in, byte[] out) throws ParseException {
        try {
            return MC68000InputStream.unpackByteRun1(in, out);
        }
        catch (IOException ex) {
            ParseException e = new ParseException("couldn't decompress body");
            e.initCause(ex);
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void unpackVertical(byte[] in, BitmapImage bm) throws ParseException {
        out = bm.getBitmap();
        iIn = 0;
        endOfData = 0;
        buf = new byte[this.bmhdWidth * this.bmhdHeight / 8];
        scanlineStride = bm.getScanlineStride();
        columnCount = this.bmhdWidth / 8 * this.bmhdHeight;
        columnStride = this.bmhdHeight * 2;
        try {
            for (p = 0; p < this.bmhdNbPlanes; ++p) {
                iBuf = 0;
                iIn = endOfData;
                if ((id = (in[iIn++] & 255) << 24 | (in[iIn++] & 255) << 16 | (in[iIn++] & 255) << 8 | in[iIn++] & 255) != ILBMDecoder.VDAT_ID) {
                    throw new ParseException("Illegal VDAT chunk ID:" + IFFParser.idToString(id) + " at " + (iIn - 4));
                }
                if ((long)iIn + (length = ((long)in[iIn++] & 255L) << 24 | ((long)in[iIn++] & 255L) << 16 | ((long)in[iIn++] & 255L) << 8 | (long)in[iIn++] & 255L) > (long)in.length) {
                    throw new ParseException("Illegal VDAT chunk length:" + length + " at " + (iIn - 4));
                }
                endOfData = (int)((long)endOfData + (length + 8L));
                cnt = (in[iIn++] & 255) << 8 | in[iIn++] & 255;
                iCmd = iIn;
                iIn = iIn + cnt - 2;
lbl20:
                // 5 sources

                try {
                    for (i = cnt - 2; i > 0 && iIn < endOfData; --i) {
                        block16: {
                            block15: {
                                block14: {
                                    if ((cmd = in[iCmd++]) != 0) break block14;
                                    n = (in[iIn++] & 255) << 8 | in[iIn++] & 255;
                                    n *= 2;
                                    while (n > 0) {
                                        buf[iBuf++] = in[iIn++];
                                        --n;
                                    }
                                    ** GOTO lbl20
                                }
                                if (cmd != 1) break block15;
                                n = (in[iIn++] & 255) << 8 | in[iIn++] & 255;
                                dhigh = in[iIn++];
                                dlow = in[iIn++];
                                while (n > 0) {
                                    buf[iBuf++] = dhigh;
                                    buf[iBuf++] = dlow;
                                    --n;
                                }
                                ** GOTO lbl20
                            }
                            if (cmd < 2) break block16;
                            dhigh = in[iIn++];
                            dlow = in[iIn++];
                            for (n = cmd; n > 0; --n) {
                                buf[iBuf++] = dhigh;
                                buf[iBuf++] = dlow;
                            }
                            ** GOTO lbl20
                        }
                        for (n = cmd * -2; n > 0; --n) {
                            buf[iBuf++] = in[iIn++];
                        }
                        ** GOTO lbl20
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.println("IndexOutOfBounds in bitplane " + p);
                    e.printStackTrace();
                }
                bitplaneOffset = bm.getBitplaneStride() * p;
                xBuf = 0;
                xOut = 0;
                while (xBuf < columnCount) {
                    yBuf = 0;
                    yOut = bitplaneOffset;
                    while (yBuf < columnStride) {
                        out[xOut + yOut] = buf[xBuf + yBuf];
                        out[xOut + 1 + yOut] = buf[xBuf + 1 + yBuf];
                        yBuf += 2;
                        yOut += scanlineStride;
                    }
                    xBuf += columnStride;
                    xOut += 2;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }
}

