/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.io.ByteArrayImageOutputStream;

public class PNGCodec
extends AbstractVideoCodec {
    public PNGCodec() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image"})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class})});
    }

    @Override
    public Format setOutputFormat(Format f) {
        String mimeType = f.get(VideoFormatKeys.MimeTypeKey, "video/quicktime");
        if (mimeType != null && !mimeType.equals("video/avi")) {
            return super.setOutputFormat(new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24}).append(f));
        }
        return super.setOutputFormat(new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24}).append(f));
    }

    @Override
    public int process(Buffer in, Buffer out) {
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        BufferedImage image = this.getBufferedImage(in);
        if (image == null) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        ByteArrayImageOutputStream tmp = out.data instanceof byte[] ? new ByteArrayImageOutputStream((byte[])out.data) : new ByteArrayImageOutputStream();
        try {
            ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/png").next();
            ImageWriteParam iwParam = iw.getDefaultWriteParam();
            iw.setOutput(tmp);
            IIOImage img = new IIOImage(image, null, null);
            iw.write(null, img, iwParam);
            iw.dispose();
            out.setFlag(BufferFlag.KEYFRAME);
            out.header = null;
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }
}

