/*
 * Decompiled with CFR 0.152.
 */
package tiled.core;

import java.awt.Graphics;
import java.awt.Image;
import java.util.Iterator;
import tiled.core.Sprite;
import tiled.core.Tile;
import tiled.core.TileSet;
import tiled.util.TiledConfiguration;

public class AnimatedTile
extends Tile {
    private Sprite sprite;

    public AnimatedTile() {
    }

    public AnimatedTile(TileSet set) {
        super(set);
    }

    public AnimatedTile(Tile[] frames) {
        this();
        if (!TiledConfiguration.node("animation").getBoolean("safe", false)) {
            this.sprite = new Sprite(frames);
        }
    }

    public AnimatedTile(Sprite s) {
        this();
        this.setSprite(s);
    }

    public void setSprite(Sprite s) {
        this.sprite = s;
    }

    public int countAnimationFrames() {
        return this.sprite.getTotalFrames();
    }

    public int countKeys() {
        return this.sprite.getTotalKeys();
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    @Override
    public Image getScaledImage(double zoom) {
        try {
            Iterator itr = this.sprite.getKeys();
            while (itr.hasNext()) {
                Sprite.KeyFrame key = (Sprite.KeyFrame)itr.next();
                for (int i = 0; i < key.getTotalFrames(); ++i) {
                    key.getFrame(i).getScaledImage(zoom);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.sprite.getCurrentFrame().getScaledImage(zoom);
    }

    @Override
    public void draw(Graphics g, int x, int y, double zoom) {
        this.sprite.getCurrentFrame().draw(g, x, y, zoom);
        this.sprite.iterateFrame();
    }
}

