/*
 * Decompiled with CFR 0.152.
 */
package tiled.core;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.Properties;
import tiled.core.Map;

public abstract class MapLayer
implements Cloneable {
    public static final int MIRROR_HORIZONTAL = 1;
    public static final int MIRROR_VERTICAL = 2;
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    protected String name;
    protected boolean isVisible = true;
    protected boolean bLocked = false;
    protected Map myMap;
    protected float opacity = 1.0f;
    protected Rectangle bounds = new Rectangle();
    private Properties properties;

    public MapLayer() {
        this.setMap(null);
        this.properties = new Properties();
    }

    public MapLayer(int w, int h) {
        this(new Rectangle(0, 0, w, h));
    }

    public MapLayer(Rectangle r) {
        this();
        this.setBounds(r);
    }

    MapLayer(Map map) {
        this();
        this.setMap(map);
    }

    public MapLayer(Map map, int w, int h) {
        this(w, h);
        this.setMap(map);
    }

    public void translate(int dx, int dy) {
        this.bounds.x += dx;
        this.bounds.y += dy;
    }

    public abstract void rotate(int var1);

    public abstract void mirror(int var1);

    protected void setBounds(Rectangle bounds) {
        this.bounds = new Rectangle(bounds);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMap(Map map) {
        this.myMap = map;
    }

    public void setOpacity(float opacity) {
        if (this.opacity != opacity) {
            this.opacity = opacity;
            if (this.isVisible() && this.myMap != null) {
                this.myMap.fireMapChanged();
            }
        }
    }

    public void setVisible(boolean visible) {
        if (this.isVisible != visible) {
            this.isVisible = visible;
            if (this.myMap != null) {
                this.myMap.fireMapChanged();
            }
        }
    }

    public void setOffset(int xOff, int yOff) {
        this.bounds.x = xOff;
        this.bounds.y = yOff;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public void getBounds(Rectangle rect) {
        rect.setBounds(this.bounds);
    }

    public boolean contains(int x, int y) {
        return this.bounds.contains(x, y);
    }

    public float getOpacity() {
        return this.opacity;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public abstract void mergeOnto(MapLayer var1);

    public abstract void maskedMergeOnto(MapLayer var1, Area var2);

    public abstract void copyFrom(MapLayer var1);

    public abstract void maskedCopyFrom(MapLayer var1, Area var2);

    public abstract MapLayer createDiff(MapLayer var1);

    public abstract void copyTo(MapLayer var1);

    public abstract boolean isEmpty();

    public Object clone() throws CloneNotSupportedException {
        MapLayer clone = (MapLayer)super.clone();
        clone.bounds = new Rectangle(this.bounds);
        clone.properties = (Properties)this.properties.clone();
        return clone;
    }

    public abstract void resize(int var1, int var2, int var3, int var4);

    public boolean getLocked() {
        return this.bLocked;
    }

    public void setLocked(boolean lock) {
        this.bLocked = lock;
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean canEdit() {
        return !this.getLocked() && this.isVisible();
    }
}

