/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.selection;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.prefs.Preferences;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.util.TiledConfiguration;

public class SelectionLayer
extends TileLayer {
    private Color highlightColor;
    private Tile selTile;
    private Area selection;

    public SelectionLayer() {
        this.init();
    }

    public SelectionLayer(int w, int h) {
        super(w, h);
        this.init();
    }

    private void init() {
        Preferences prefs = TiledConfiguration.root();
        try {
            this.highlightColor = Color.decode(prefs.get("selectionColor", "#0000FF"));
        }
        catch (NumberFormatException e) {
            this.highlightColor = Color.blue;
        }
        this.selTile = new Tile();
        this.selection = new Area();
    }

    public Area getSelectedArea() {
        return this.selection;
    }

    public Rectangle getSelectedAreaBounds() {
        return this.selection.getBounds();
    }

    public void add(Area area) {
        this.selection.add(area);
        this.fillRegion(this.selection, this.selTile);
    }

    public void subtract(Area area) {
        this.clearRegion(area);
        this.selection.subtract(area);
    }

    public void selectRegion(Shape region) {
        this.clearRegion(this.selection);
        this.selection = new Area(region);
        this.fillRegion(this.selection, this.selTile);
    }

    public void select(int tx, int ty) {
        this.setTileAt(tx, ty, this.selTile);
        Area a = new Area(new Rectangle2D.Double(tx, ty, 1.0, 1.0));
        if (this.selection == null) {
            this.selection = a;
        } else if (!this.selection.contains(tx, ty)) {
            this.selection.add(a);
        }
    }

    public void setHighlightColor(Color c) {
        this.highlightColor = c;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    private void fillRegion(Area region, Tile fill) {
        Rectangle bounded = region.getBounds();
        for (int i = bounded.y; i < bounded.y + bounded.height; ++i) {
            for (int j = bounded.x; j < bounded.x + bounded.width; ++j) {
                if (region.contains(j, i)) {
                    this.setTileAt(j + this.bounds.x, i + this.bounds.y, fill);
                    continue;
                }
                this.setTileAt(j + this.bounds.x, i + this.bounds.y, null);
            }
        }
    }

    private void clearRegion(Area region) {
        this.fillRegion(region, null);
    }

    public void invert() {
        this.selection.exclusiveOr(new Area(this.bounds));
        for (int i = this.bounds.y; i < this.bounds.y + this.bounds.height; ++i) {
            for (int j = this.bounds.x; j < this.bounds.x + this.bounds.width; ++j) {
                if (this.selection.contains(j, i)) {
                    this.setTileAt(j, i, this.selTile);
                    continue;
                }
                this.setTileAt(j, i, null);
            }
        }
    }
}

