/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.util;

import java.awt.Component;
import java.awt.Image;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import tiled.core.Tile;
import tiled.mapeditor.Resources;

public class TileDialogListRenderer
extends DefaultListCellRenderer {
    private static final String TILE = Resources.getString("general.tile.tile");
    private static final String NOTILE = Resources.getString("general.tile.notile");
    private double zoom = 1.0;

    public TileDialogListRenderer() {
        this.setOpaque(true);
    }

    public TileDialogListRenderer(double zoom) {
        this();
        this.zoom = zoom;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Tile tile = (Tile)value;
        if (tile != null) {
            Image scaledImage = tile.getScaledImage(this.zoom);
            if (scaledImage != null) {
                this.setIcon(new ImageIcon(scaledImage));
            }
            this.setText(TILE + " " + tile.getId());
        } else {
            this.setIcon(null);
            this.setText(NOTILE);
        }
        return this;
    }
}

