/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import tiled.mapeditor.brush.Brush;
import tiled.mapeditor.brush.ShapeBrush;

public class BrushBrowser
extends JPanel {
    private int maxWidth = 25;
    private Brush selectedBrush;
    private final LinkedList<Brush> brushes = new LinkedList();

    public BrushBrowser() {
        this.initPresets();
        MouseInputAdapter listener = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int perLine = BrushBrowser.this.getWidth() / BrushBrowser.this.maxWidth;
                int x = e.getX() / BrushBrowser.this.maxWidth;
                int y = e.getY() / BrushBrowser.this.maxWidth;
                int selectedIndex = y * perLine + (x > perLine - 1 ? perLine - 1 : x);
                if (selectedIndex >= 0 && selectedIndex < BrushBrowser.this.brushes.size()) {
                    Brush previousBrush = BrushBrowser.this.selectedBrush;
                    BrushBrowser.this.selectedBrush = (Brush)BrushBrowser.this.brushes.get(selectedIndex);
                    BrushBrowser.this.firePropertyChange("selectedbrush", previousBrush, BrushBrowser.this.selectedBrush);
                    BrushBrowser.this.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mousePressed(e);
            }
        };
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    @Override
    public Dimension getPreferredSize() {
        int perLine = this.getWidth() / this.maxWidth;
        if (perLine > 0) {
            int lines = (this.brushes.size() + (perLine - 1)) / perLine;
            return new Dimension(this.maxWidth, this.maxWidth * lines);
        }
        return new Dimension(this.maxWidth, 150);
    }

    private void initPresets() {
        int[] dimensions = new int[]{1, 2, 4, 8, 12, 20};
        for (int n = 1; n < dimensions.length; ++n) {
            ShapeBrush brush = new ShapeBrush();
            brush.makeCircleBrush(dimensions[n] / 2);
            this.brushes.add(brush);
        }
        for (int dimension : dimensions) {
            ShapeBrush brush = new ShapeBrush();
            brush.makeQuadBrush(new Rectangle(0, 0, dimension, dimension));
            this.brushes.add(brush);
        }
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clipRect = g.getClipBounds();
        g.setColor(Color.white);
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.black);
        Iterator itr = this.brushes.iterator();
        int x = 0;
        while (itr.hasNext()) {
            Brush brush = (Brush)itr.next();
            Rectangle bb = brush.getBounds();
            float o = (float)this.maxWidth / 2.0f - (float)bb.width / 2.0f;
            g.translate((int)o, (int)o);
            brush.drawPreview((Graphics2D)g, new Dimension(this.maxWidth, this.maxWidth), null);
            g.translate((int)(-o), (int)(-o));
            if (brush == this.selectedBrush) {
                g.drawRect(0, 0, this.maxWidth, this.maxWidth);
            }
            g.translate(this.maxWidth, 0);
            if ((x += this.maxWidth) + this.maxWidth <= this.getWidth()) continue;
            g.translate(-x, this.maxWidth);
            x = 0;
        }
    }

    public void setSelectedBrush(Brush selectedBrush) {
        for (Brush brush : this.brushes) {
            if (!brush.equals(selectedBrush)) continue;
            this.selectedBrush = brush;
            break;
        }
    }

    public Brush getSelectedBrush() {
        return this.selectedBrush;
    }
}

