/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.widget;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.MouseInputAdapter;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;
import tiled.core.TilesetChangeListener;
import tiled.core.TilesetChangedEvent;
import tiled.mapeditor.util.TileRegionSelectionEvent;
import tiled.mapeditor.util.TileSelectionEvent;
import tiled.mapeditor.util.TileSelectionListener;

public class TilePalettePanel
extends JPanel
implements Scrollable,
TilesetChangeListener {
    private static final int TILES_PER_ROW = 4;
    private TileSet tileset;
    private List<TileSelectionListener> tileSelectionListeners = new LinkedList<TileSelectionListener>();
    private Vector<Tile> tilesetMap;
    private Rectangle selection;

    public TilePalettePanel() {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private Point origin;

            @Override
            public void mousePressed(MouseEvent e) {
                this.origin = TilePalettePanel.this.getTileCoordinates(e.getX(), e.getY());
                TilePalettePanel.this.setSelection(new Rectangle(this.origin.x, this.origin.y, 0, 0));
                TilePalettePanel.this.scrollTileToVisible(this.origin);
                Tile clickedTile = TilePalettePanel.this.getTileAt(this.origin.x, this.origin.y);
                if (clickedTile != null) {
                    TilePalettePanel.this.fireTileSelectionEvent(clickedTile);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Point point = TilePalettePanel.this.getTileCoordinates(e.getX(), e.getY());
                Rectangle select = new Rectangle(this.origin.x, this.origin.y, 0, 0);
                select.add(point);
                if (!select.equals(TilePalettePanel.this.selection)) {
                    TilePalettePanel.this.setSelection(select);
                    TilePalettePanel.this.scrollTileToVisible(point);
                }
                if (TilePalettePanel.this.selection.getWidth() > 0.0 || TilePalettePanel.this.selection.getHeight() > 0.0) {
                    TilePalettePanel.this.fireTileRegionSelectionEvent(TilePalettePanel.this.selection);
                }
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
    }

    public void addTileSelectionListener(TileSelectionListener listener) {
        this.tileSelectionListeners.add(listener);
    }

    public void removeTileSelectionListener(TileSelectionListener listener) {
        this.tileSelectionListeners.remove(listener);
    }

    private void fireTileSelectionEvent(Tile selectedTile) {
        TileSelectionEvent event = new TileSelectionEvent(this, selectedTile);
        for (TileSelectionListener listener : this.tileSelectionListeners) {
            listener.tileSelected(event);
        }
    }

    private void fireTileRegionSelectionEvent(Rectangle selection) {
        TileLayer region = this.createTileLayerFromRegion(selection);
        TileRegionSelectionEvent event = new TileRegionSelectionEvent(this, region);
        for (TileSelectionListener listener : this.tileSelectionListeners) {
            listener.tileRegionSelected(event);
        }
    }

    private TileLayer createTileLayerFromRegion(Rectangle rect) {
        TileLayer layer = new TileLayer(rect.width + 1, rect.height + 1);
        for (int y = rect.y; y <= rect.y + rect.height; ++y) {
            for (int x = rect.x; x <= rect.x + rect.width; ++x) {
                layer.setTileAt(x - rect.x, y - rect.y, this.getTileAt(x, y));
            }
        }
        return layer;
    }

    public void setTileset(TileSet tileset) {
        if (this.tileset != null) {
            this.tileset.removeTilesetChangeListener(this);
        }
        this.tileset = tileset;
        if (this.tileset != null) {
            this.tileset.addTilesetChangeListener(this);
        }
        if (tileset != null) {
            this.tilesetMap = tileset.generateGaplessVector();
        }
        this.revalidate();
        this.repaint();
    }

    public TileSet getTileset() {
        return this.tileset;
    }

    @Override
    public void tilesetChanged(TilesetChangedEvent event) {
        this.tilesetMap = this.tileset.generateGaplessVector();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void nameChanged(TilesetChangedEvent event, String oldName, String newName) {
    }

    @Override
    public void sourceChanged(TilesetChangedEvent event, String oldSource, String newSource) {
    }

    private Point getTileCoordinates(int x, int y) {
        int twidth = this.tileset.getTileWidth() + 1;
        int theight = this.tileset.getTileHeight() + 1;
        int tileCount = this.tilesetMap.size();
        int tilesPerRow = this.getTilesPerRow();
        int rows = tileCount / tilesPerRow + (tileCount % tilesPerRow > 0 ? 1 : 0);
        int tileX = Math.max(0, Math.min(x / twidth, tilesPerRow - 1));
        int tileY = Math.max(0, Math.min(y / theight, rows - 1));
        return new Point(tileX, tileY);
    }

    private Tile getTileAt(int x, int y) {
        int tilesPerRow = this.getTilesPerRow();
        int tileAt = y * tilesPerRow + x;
        if (tileAt >= this.tilesetMap.size()) {
            return null;
        }
        return this.tilesetMap.get(tileAt);
    }

    private int getTilesPerRow() {
        if (this.tileset.getTilesPerRow() == 0) {
            int twidth = this.tileset.getTileWidth() + 1;
            return Math.max(1, (this.getWidth() - 1) / twidth);
        }
        return this.tileset.getTilesPerRow();
    }

    private void setSelection(Rectangle rect) {
        this.repaintSelection();
        this.selection = rect;
        this.repaintSelection();
    }

    private void repaintSelection() {
        if (this.selection != null) {
            int twidth = this.tileset.getTileWidth() + 1;
            int theight = this.tileset.getTileHeight() + 1;
            this.repaint(this.selection.x * twidth, this.selection.y * theight, (this.selection.width + 1) * twidth + 1, (this.selection.height + 1) * theight + 1);
        }
    }

    private void scrollTileToVisible(Point tile) {
        int twidth = this.tileset.getTileWidth() + 1;
        int theight = this.tileset.getTileHeight() + 1;
        this.scrollRectToVisible(new Rectangle(tile.x * twidth, tile.y * theight, twidth + 1, theight + 1));
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        TilePalettePanel.paintBackground(g);
        if (this.tileset != null) {
            int twidth = this.tileset.getTileWidth() + 1;
            int theight = this.tileset.getTileHeight() + 1;
            int tilesPerRow = this.getTilesPerRow();
            int startY = clip.y / theight;
            int endY = (clip.y + clip.height) / theight + 1;
            int tileAt = tilesPerRow * startY;
            int gy = startY * theight;
            for (int y = startY; y < endY; ++y) {
                int gx = 1;
                for (int x = 0; x < tilesPerRow && tileAt < this.tilesetMap.size(); ++x, ++tileAt) {
                    Tile tile = this.tilesetMap.get(tileAt);
                    if (tile != null) {
                        tile.drawRaw(g, gx, gy + theight, 1.0);
                    }
                    gx += twidth;
                }
                gy += theight;
            }
            if (this.selection != null) {
                g.setColor(new Color(100, 100, 255));
                g.draw3DRect(this.selection.x * twidth, this.selection.y * theight, (this.selection.width + 1) * twidth, (this.selection.height + 1) * theight, false);
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(10, 0.2f));
                g.fillRect(this.selection.x * twidth + 1, this.selection.y * theight + 1, (this.selection.width + 1) * twidth - 1, (this.selection.height + 1) * theight - 1);
            }
        }
    }

    private static void paintBackground(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int side = 10;
        int startX = clip.x / side;
        int startY = clip.y / side;
        int endX = (clip.x + clip.width) / side + 1;
        int endY = (clip.y + clip.height) / side + 1;
        g.setColor(Color.WHITE);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(Color.LIGHT_GRAY);
        for (int y = startY; y < endY; ++y) {
            for (int x = startX; x < endX; ++x) {
                if ((y + x) % 2 != 1) continue;
                g.fillRect(x * side, y * side, side, side);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.tileset == null) {
            return new Dimension(0, 0);
        }
        int twidth = this.tileset.getTileWidth() + 1;
        int theight = this.tileset.getTileHeight() + 1;
        int tileCount = this.tilesetMap.size();
        int tilesPerRow = this.getTilesPerRow();
        int rows = tileCount / tilesPerRow + (tileCount % tilesPerRow > 0 ? 1 : 0);
        return new Dimension(tilesPerRow * twidth + 1, rows * theight + 1);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.tileset != null) {
            int twidth = this.tileset.getTileWidth() + 1;
            return new Dimension(4 * twidth + 1, 200);
        }
        return new Dimension(0, 0);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.tileset != null) {
            return this.tileset.getTileWidth();
        }
        return 0;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.tileset != null) {
            return this.tileset.getTileWidth();
        }
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.tileset == null || this.tileset.getTilesPerRow() == 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

