/*
 * Decompiled with CFR 0.152.
 */
package classes;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Properties;

public class UpdateInfo {
    private static File file = new File(System.getProperty("user.home"), "/JavaCPC/Update.ini");
    private static final UpdateInfo instance = new UpdateInfo();
    private final Properties props = new Properties();

    private UpdateInfo() {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkRead(file.getAbsolutePath());
            }
            this.props.load(new FileInputStream(file));
            System.out.println("loaded " + this.props.size() + " user settings");
        }
        catch (Throwable t) {
            System.out.println("can't load user settings (" + t.getMessage() + ")");
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = UpdateInfo.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static int getInt(String key, int defaultValue) {
        String value = UpdateInfo.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static void setBoolean(String key, boolean value) {
        UpdateInfo.instance.props.setProperty(key, value ? "true" : "false");
        UpdateInfo.save();
    }

    public static String get(String key, String defaultValue) {
        String value = UpdateInfo.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void set(String key, String value) {
        if (value.equals(UpdateInfo.get(key, null))) {
            return;
        }
        UpdateInfo.instance.props.setProperty(key, value);
        UpdateInfo.save();
    }

    private static void save() {
        try {
            File f = new File(System.getProperty("user.home"), "JavaCPC");
            f.mkdir();
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkWrite(file.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(file);
            UpdateInfo.instance.props.store(fos, null);
            StringBuilder contents = new StringBuilder();
            BufferedReader reader = null;
            FileReader fre = new FileReader(file);
            reader = new BufferedReader(fre);
            String text = null;
            while ((text = reader.readLine()) != null) {
                contents.append(text).append(System.getProperty("line.separator"));
            }
            reader.close();
            fre.close();
            String result = contents.toString();
            Object[] res = result.split("\n");
            Arrays.sort(res);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            for (int i = 0; i < res.length; ++i) {
                bos.write(((String)res[i] + '\n').getBytes("UTF-8"));
            }
            bos.close();
        }
        catch (Throwable t) {
            System.out.println("can't save user settings (" + t.getMessage() + ")");
        }
    }
}

