/*
 * Decompiled with CFR 0.152.
 */
package tiled.plugins.lua;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.zip.GZIPOutputStream;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.MapObject;
import tiled.core.ObjectGroup;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;
import tiled.io.MapWriter;
import tiled.io.PluginLogger;
import tiled.mapeditor.selection.SelectionLayer;
import tiled.util.Base64;
import tiled.util.TiledConfiguration;

public class LuaMapWriter
implements MapWriter {
    private static final int LAST_BYTE = 255;
    private PluginLogger logger;
    private Writer writer;
    private String indent;

    private void writeIndent() throws IOException {
        this.writer.write(this.indent);
    }

    private void addIndent() {
        this.indent = this.indent + "  ";
    }

    private void minusIndent() {
        this.indent = this.indent.substring(2);
    }

    private void writeString(String string) throws IOException {
        this.writeIndent();
        this.writer.write(string);
    }

    private void writelnString(String string) throws IOException {
        this.writeString(string + "\n");
    }

    private void writelnKeyAndValue(String string, String string2) throws IOException {
        this.writelnString("[\"" + string + "\"] = \"" + string2 + "\";");
    }

    private void writelnKeyAndValue(String string, int n) throws IOException {
        this.writelnString("[\"" + string + "\"] = " + String.valueOf(n) + ";");
    }

    private void writelnKeyAndValue(String string, float f) throws IOException {
        this.writelnString("[\"" + string + "\"] = " + String.valueOf(f) + ";");
    }

    private void startTable(String string) throws IOException {
        this.writelnString("[\"" + string + "\"] = {");
        this.addIndent();
    }

    private void startTable() throws IOException {
        this.writelnString("{");
        this.addIndent();
    }

    private void endTable() throws IOException {
        this.minusIndent();
        this.writelnString("};");
    }

    private void writeProperties(Properties properties) throws IOException {
        if (!properties.isEmpty()) {
            this.startTable("properties");
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.writelnKeyAndValue(string, properties.getProperty(string));
            }
            this.endTable();
        }
    }

    private void writeObject(MapObject mapObject) throws IOException {
        ObjectGroup objectGroup = mapObject.getObjectGroup();
        Rectangle rectangle = objectGroup.getBounds();
        this.startTable();
        this.writelnKeyAndValue("label", "object");
        this.writelnKeyAndValue("x", mapObject.getX() + rectangle.x);
        this.writelnKeyAndValue("y", mapObject.getY() + rectangle.y);
        this.writelnKeyAndValue("type", mapObject.getType());
        if (mapObject.getImageSource().length() > 0) {
            this.startTable();
            this.writelnKeyAndValue("label", "image");
            String string = mapObject.getImageSource().substring(mapObject.getImageSource().replace("/", "\\").lastIndexOf("\\") + 1);
            this.writelnKeyAndValue("source", string);
            this.endTable();
        }
        this.writeProperties(mapObject.getProperties());
        this.endTable();
    }

    private void writeObjectGroup(ObjectGroup objectGroup) throws IOException {
        Iterator iterator = objectGroup.getObjects();
        while (iterator.hasNext()) {
            this.writeObject((MapObject)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTilesetReference(TileSet tileSet) throws IOException {
        String string = tileSet.getSource();
        if (string == null) {
            this.writeTileset(tileSet);
        } else {
            this.startTable();
            this.writelnKeyAndValue("label", "tileset");
            try {
                this.writelnKeyAndValue("firstgid", tileSet.getFirstGid());
                this.writelnKeyAndValue("source", string.substring(string.lastIndexOf(File.separatorChar) + 1));
                if (tileSet.getBaseDir() != null) {
                    this.writelnKeyAndValue("basedir", tileSet.getBaseDir());
                }
            }
            finally {
                this.endTable();
            }
        }
    }

    private void writeTileset(TileSet tileSet) throws IOException {
        String string = tileSet.getTilebmpFile();
        String string2 = tileSet.getName();
        this.startTable();
        this.writelnKeyAndValue("label", "tileset");
        if (string2 != null) {
            this.writelnKeyAndValue("name", string2);
        }
        this.writelnKeyAndValue("firstgid", tileSet.getFirstGid());
        if (string != null) {
            this.writelnKeyAndValue("tilewidth", tileSet.getTileWidth());
            this.writelnKeyAndValue("tileheight", tileSet.getTileHeight());
            int n = tileSet.getTileSpacing();
            if (n != 0) {
                this.writelnKeyAndValue("spacing", n);
            }
        }
        if (tileSet.getBaseDir() != null) {
            this.writelnKeyAndValue("basedir", tileSet.getBaseDir());
        }
        if (string != null) {
            this.startTable();
            this.writelnKeyAndValue("label", "image");
            String string3 = string.substring(string.replace("/", "\\").lastIndexOf("\\") + 1);
            this.writelnKeyAndValue("source", string3);
            Color color = tileSet.getTransparentColor();
            if (color != null) {
                this.writelnKeyAndValue("trans", Integer.toHexString(color.getRGB()).substring(2));
            }
            this.endTable();
            for (Tile tile : tileSet) {
                if (tile == null || tile.getProperties().isEmpty()) continue;
                this.startTable();
                this.writelnKeyAndValue("label", "tile");
                this.writelnKeyAndValue("id", tile.getId());
                this.writeProperties(tile.getProperties());
                this.endTable();
            }
        } else {
            this.logger.error((Object)"Embedded tilesets are not supported!");
        }
        this.endTable();
    }

    private void writeMapLayer(MapLayer mapLayer) throws IOException {
        Preferences preferences = TiledConfiguration.node((String)"saving");
        boolean bl = preferences.getBoolean("encodeLayerData", true);
        boolean bl2 = preferences.getBoolean("layerCompression", true) && bl;
        Rectangle rectangle = mapLayer.getBounds();
        this.startTable();
        if (mapLayer.getClass() == SelectionLayer.class) {
            this.writelnKeyAndValue("label", "selection");
        } else if (mapLayer instanceof ObjectGroup) {
            this.writelnKeyAndValue("label", "objectgroup");
        } else {
            this.writelnKeyAndValue("label", "layer");
        }
        this.writelnKeyAndValue("name", mapLayer.getName());
        this.writelnKeyAndValue("width", rectangle.width);
        this.writelnKeyAndValue("height", rectangle.height);
        if (rectangle.x != 0) {
            this.writelnKeyAndValue("x", rectangle.x);
        }
        if (rectangle.y != 0) {
            this.writelnKeyAndValue("y", rectangle.y);
        }
        if (!mapLayer.isVisible()) {
            this.writelnKeyAndValue("visible", "0");
        }
        if (mapLayer.getOpacity() < 1.0f) {
            this.writelnKeyAndValue("opacity", mapLayer.getOpacity());
        }
        this.writeProperties(mapLayer.getProperties());
        if (mapLayer instanceof ObjectGroup) {
            this.writeObjectGroup((ObjectGroup)mapLayer);
        } else {
            this.startTable("data");
            if (bl) {
                OutputStream outputStream;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.writelnKeyAndValue("encoding", "base64");
                if (bl2) {
                    this.writelnKeyAndValue("compression", "gzip");
                    outputStream = new GZIPOutputStream(byteArrayOutputStream);
                } else {
                    outputStream = byteArrayOutputStream;
                }
                for (int i = 0; i < mapLayer.getHeight(); ++i) {
                    for (int j = 0; j < mapLayer.getWidth(); ++j) {
                        Tile tile = ((TileLayer)mapLayer).getTileAt(j + rectangle.x, i + rectangle.y);
                        int n = 0;
                        if (tile != null) {
                            n = tile.getGid();
                        }
                        outputStream.write(n & 0xFF);
                        outputStream.write(n >> 8 & 0xFF);
                        outputStream.write(n >> 16 & 0xFF);
                        outputStream.write(n >> 24 & 0xFF);
                    }
                }
                if (bl2) {
                    ((GZIPOutputStream)outputStream).finish();
                }
                this.writelnKeyAndValue("content", new String(Base64.encode((byte[])byteArrayOutputStream.toByteArray())));
            } else {
                for (int i = 0; i < mapLayer.getHeight(); ++i) {
                    for (int j = 0; j < mapLayer.getWidth(); ++j) {
                        Tile tile = ((TileLayer)mapLayer).getTileAt(j, i);
                        int n = 0;
                        if (tile != null) {
                            n = tile.getGid();
                        }
                        this.startTable();
                        this.writelnKeyAndValue("label", "tile");
                        this.writelnKeyAndValue("gid", n);
                        this.endTable();
                    }
                }
            }
            this.endTable();
        }
        this.endTable();
    }

    public void writeMap(Map map, String string) throws IOException {
        this.writeMap(map, new FileOutputStream(string));
    }

    public void writeMap(Map map, OutputStream outputStream) throws IOException {
        Object object2;
        this.writer = new OutputStreamWriter(outputStream);
        this.indent = "";
        this.writelnString("-- Generated by Tiled's Lua Exporter Plugin.");
        this.writeString("map = ");
        this.startTable();
        this.writelnKeyAndValue("label", "map");
        this.writelnKeyAndValue("version", "0.99b");
        this.writelnKeyAndValue("luaversion", "5.1");
        switch (map.getOrientation()) {
            case 1: {
                this.writelnKeyAndValue("orientation", "orthogonal");
                break;
            }
            case 2: {
                this.writelnKeyAndValue("orientation", "isometric");
                break;
            }
            case 4: {
                this.writelnKeyAndValue("orientation", "hexagonal");
                break;
            }
            case 5: {
                this.writelnKeyAndValue("orientation", "shifted");
            }
        }
        this.writelnKeyAndValue("width", map.getWidth());
        this.writelnKeyAndValue("height", map.getHeight());
        this.writelnKeyAndValue("tilewidth", map.getTileWidth());
        this.writelnKeyAndValue("tileheight", map.getTileHeight());
        this.writeProperties(map.getProperties());
        this.startTable("tilesets");
        int n = 1;
        for (Object object2 : map.getTilesets()) {
            object2.setFirstGid(n);
            this.writeTilesetReference((TileSet)object2);
            n += object2.getMaxTileId() + 1;
        }
        this.endTable();
        this.startTable("layers");
        object2 = map.getLayers();
        while (object2.hasNext()) {
            MapLayer mapLayer = (MapLayer)object2.next();
            this.writeMapLayer(mapLayer);
        }
        this.endTable();
        this.endTable();
        this.writelnString("-- EOF");
        this.writer.flush();
        this.writer = null;
    }

    public void writeTileset(TileSet tileSet, OutputStream outputStream) throws Exception {
        this.logger.error((Object)"Tilesets are not supported!");
    }

    public void writeTileset(TileSet tileSet, String string) throws Exception {
        this.logger.error((Object)"Tilesets are not supported!");
        this.logger.error((Object)("(asked to write " + string + ")"));
    }

    public boolean accept(File file) {
        try {
            String string = file.getCanonicalPath();
            if (string.endsWith(".lua")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public String getFilter() throws Exception {
        return "*.lua";
    }

    public String getName() {
        return "Tiled Lua exporter";
    }

    public String getDescription() {
        return "Lua Table Export Plugin\n(c) 2007 William C. Bubel\ninmatarian@gmail.com\nReleased under the terms of the GPLv2.\n";
    }

    public String getPluginPackage() {
        return "Tiled Lua Writer";
    }

    public void setLogger(PluginLogger pluginLogger) {
        this.logger = pluginLogger;
    }
}

