/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.util.java2d.Synthetica2DUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.plaf.synth.SynthContext;

public class MenuPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.MenuPainter";
    private static Icon topMarkerIcon;
    private static Icon bottomMarkerIcon;

    protected MenuPainter() {
    }

    public static MenuPainter getInstance() {
        return MenuPainter.getInstance(null);
    }

    public static MenuPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(MenuPainter.getPainterClassName(synthContext, MenuPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = MenuPainter.getInstance(synthContext, MenuPainter.class, UI_KEY);
        }
        return (MenuPainter)syntheticaComponentPainter;
    }

    public static void reinitialize() {
        topMarkerIcon = null;
        bottomMarkerIcon = null;
    }

    public void paintMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintPopupMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintMenuBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintPopupMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JPopupMenu jPopupMenu = (JPopupMenu)synthContext.getComponent();
        boolean bl = SyntheticaLookAndFeel.isToplevelPopupMenu(jPopupMenu);
        this.paintPopupMenuBackground(jPopupMenu, bl, graphics, n, n2, n3, n4);
        if (bl) {
            Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.toplevel.insets", (Component)jPopupMenu, false);
            this.paintToplevelPopupMenuMarker(jPopupMenu, insets, graphics, n, n2, n3, n4);
            Component[] componentArray = jPopupMenu.getComponents();
            int n5 = componentArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Component component = componentArray[n6];
                if (component instanceof JComponent && SyntheticaLookAndFeel.getClientProperty("Synthetica.popupMenu.title", (JComponent)component, false).booleanValue()) {
                    Rectangle rectangle = component.getBounds();
                    this.paintToplevelPopupMenuTitleBackground(jPopupMenu, graphics, insets.left, rectangle.y, n3 - insets.left - insets.right, rectangle.height);
                }
                ++n6;
            }
        }
    }

    public void paintPopupMenuBackground(JPopupMenu jPopupMenu, boolean bl, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        Object object2;
        int n5;
        Object object3;
        Object object4;
        Insets insets;
        boolean bl2;
        Component component = jPopupMenu.getInvoker();
        boolean bl3 = bl2 = SyntheticaLookAndFeel.get("Synthetica.comboPopup.insets", jPopupMenu) != null;
        if (!bl2 && jPopupMenu.getName() != null && jPopupMenu.getName().startsWith("ComboPopup")) {
            if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
                Component component2 = SyntheticaLookAndFeel.findComponent(JList.class, (Container)jPopupMenu);
                if (component2 != null) {
                    graphics.setColor(component2.getBackground());
                } else {
                    graphics.setColor(jPopupMenu.getBackground());
                }
                graphics.fillRect(n, n2, n3, n4);
            }
            return;
        }
        JComponent jComponent = (JComponent)jPopupMenu.getParent();
        Object object5 = SyntheticaLookAndFeel.getString("Synthetica.popupMenu.background", jPopupMenu);
        Insets insets2 = insets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.background.insets", jPopupMenu);
        if (bl) {
            insets2 = insets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.toplevel.background.insets", (Component)jPopupMenu, false);
            object4 = MenuPainter.popupIsBelowInvoker(component, jPopupMenu);
            if (object4 == null) {
                object4 = false;
            }
            if ((object5 = SyntheticaLookAndFeel.getString("Synthetica.popupMenu.toplevel" + (((Boolean)object4).booleanValue() ? ".belowInvoker.background" : ".aboveInvoker.background"), jPopupMenu)) == null) {
                object5 = SyntheticaLookAndFeel.getString("Synthetica.popupMenu.toplevel.background", jPopupMenu);
            }
        }
        if ((object4 = (BufferedImage)jComponent.getClientProperty("POPUP_BACKGROUND")) != null) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.blur.enabled", jPopupMenu)) {
                if (!((Boolean)jComponent.getClientProperty("POPUP_LIGHTWEIGHT")).booleanValue()) {
                    object3 = new ImagePainter((Image)object4, graphics, n, n2, n3, n4, insets, insets2);
                    ((ImagePainter)object3).drawBorder();
                }
                object3 = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.blur.insets", jPopupMenu);
                n5 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.blur.size", jPopupMenu, 5);
                object2 = Synthetica2DUtils.createBlurredImage((BufferedImage)object4, n5);
                ImagePainter imagePainter = new ImagePainter((Image)object2, graphics, n, n2, n3, n4, (Insets)object3, (Insets)object3);
                imagePainter.drawCenter();
                object = SyntheticaLookAndFeel.getString("Synthetica.popupMenu.blur.background", jPopupMenu);
                if (object != null && !bl) {
                    object5 = object;
                }
            } else {
                graphics.drawImage((Image)object4, n, n2, null);
            }
        }
        object3 = new ImagePainter(graphics, n, n2, n3, n4, (String)object5, insets, insets2, 0, 0);
        ((ImagePainter)object3).draw();
        object5 = SyntheticaLookAndFeel.getString("Synthetica.popupMenu.iconSeparator", jPopupMenu);
        if (object5 != null && (SyntheticaLookAndFeel.preservePopupIconSpace(jPopupMenu) || SyntheticaLookAndFeel.popupHasCheckRadio(jPopupMenu)) && !SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(jPopupMenu)) {
            n5 = jPopupMenu.getComponentOrientation().isLeftToRight() ? 1 : 0;
            object2 = jPopupMenu.getInsets();
            int n6 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.gap", jPopupMenu, 24);
            object = (Integer)jPopupMenu.getClientProperty("Synthetica.menuItem.maxIconWidth");
            int n7 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.width", jPopupMenu, 1);
            if (object != null && (Integer)object > 0) {
                n7 += (Integer)object - 16;
            }
            jPopupMenu.putClientProperty("Synthetica.flipHorizontal", n5 == 0);
            int n8 = n + (n5 != 0 ? n6 : n3 - ((Insets)object2).right - n6 - n7 + ((Insets)object2).left);
            int n9 = n2 + ((Insets)object2).top;
            int n10 = n4 - ((Insets)object2).top - ((Insets)object2).bottom;
            insets2 = insets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.iconSeparator.insets", (Component)jPopupMenu, new Insets(0, 0, 0, 2));
            object3 = new ImagePainter(jPopupMenu, graphics, n8, n9, n7, n10, (String)object5, insets, insets2, 0, 0);
            ((ImagePainter)object3).draw();
            jPopupMenu.putClientProperty("Synthetica.flipHorizontal", false);
        }
    }

    protected void paintToplevelPopupMenuMarker(JPopupMenu jPopupMenu, Insets insets, Graphics graphics, int n, int n2, int n3, int n4) {
        Icon icon;
        Component component;
        Boolean bl;
        if (topMarkerIcon == null) {
            topMarkerIcon = SyntheticaLookAndFeel.loadIcon("Synthetica.popupMenu.toplevel.topMarker.image");
        }
        if (bottomMarkerIcon == null) {
            bottomMarkerIcon = SyntheticaLookAndFeel.loadIcon("Synthetica.popupMenu.toplevel.bottomMarker.image");
        }
        Icon icon2 = (bl = MenuPainter.popupIsBelowInvoker(component = jPopupMenu.getInvoker(), jPopupMenu)) == null ? null : (icon = bl != false ? topMarkerIcon : bottomMarkerIcon);
        if (icon != null) {
            Point point = SwingUtilities.convertPoint(component, component.getWidth() / 2, n2, jPopupMenu);
            int n5 = bl != false ? n2 : n2 + n4 - icon.getIconHeight();
            icon.paintIcon(jPopupMenu, graphics, point.x - icon.getIconWidth() / 2, n5);
        }
    }

    protected void paintToplevelPopupMenuTitleBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
        String string = SyntheticaLookAndFeel.getString("Synthetica.popupMenu.toplevel.title.background", jComponent);
        if (string != null) {
            Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.toplevel.title.background.insets", (Component)jComponent, false);
            ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets, 0, 0);
            imagePainter.draw();
        }
    }

    static Boolean popupIsBelowInvoker(Component component, JPopupMenu jPopupMenu) {
        Point point = component.getLocation();
        SwingUtilities.convertPointToScreen(point, component.getParent());
        Point point2 = new Point(0, jPopupMenu.getLocation().y);
        SwingUtilities.convertPointToScreen(point2, jPopupMenu.getParent());
        if (point2.y >= point.y + component.getHeight() / 2) {
            return Boolean.TRUE;
        }
        if (point2.y + jPopupMenu.getHeight() <= point.y + component.getHeight() / 2) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void paintMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        boolean bl2;
        String string = null;
        JMenu jMenu = (JMenu)synthContext.getComponent();
        int n5 = synthContext.getComponentState();
        boolean bl3 = (n5 & 8) > 0;
        boolean bl4 = (n5 & 0x200) > 0;
        Boolean bl5 = (Boolean)jMenu.getClientProperty("Synthetica.MOUSE_OVER");
        boolean bl6 = bl2 = bl5 == null ? false : bl5;
        if (bl2) {
            n5 |= 2;
        }
        boolean bl7 = bl = (n5 & 2) > 0;
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
            try {
                object3 = synthContext.getStyle().getIcon(synthContext, "Menu.arrowIcon");
                object2 = (BasicMenuUI)((JMenu)synthContext.getComponent()).getUI();
                object = Class.forName("javax.swing.plaf.basic.BasicMenuItemUI");
                Field field = ((Class)object).getDeclaredField("arrowIcon");
                field.setAccessible(true);
                field.set(object2, object3);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        string = "Synthetica.menu";
        object3 = null;
        if (jMenu.isTopLevelMenu()) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.menu.toplevel.paintMenuBarBackground", jMenu.getParent())) {
                string = String.valueOf(string) + ".toplevel.menuBarBackground";
                object2 = jMenu.getParent();
                string = this.isSingleTopLevelMenu(jMenu, (Container)object2) ? String.valueOf(string) + ".single" : (this.isFirstTopLevelMenu(jMenu, (Container)object2) ? String.valueOf(string) + ".first" : (this.isLastTopLevelMenu(jMenu, (Container)object2) ? String.valueOf(string) + ".last" : String.valueOf(string) + ".middle"));
                string = SyntheticaLookAndFeel.getString(string, jMenu);
                object3 = SyntheticaLookAndFeel.getInsets("Synthetica.menu.toplevel.menuBarBackground.insets", (Component)jMenu, false);
                object = new ImagePainter(graphics, n, n2, n3, n4, string, (Insets)object3, (Insets)object3, 0, 0);
                ((ImagePainter)object).draw();
                string = "Synthetica.menu";
            }
            string = String.valueOf(string) + ".toplevel.background";
            if (bl3) {
                string = String.valueOf(string) + ".disabled";
            } else if (bl4) {
                string = String.valueOf(string) + ".selected";
            } else if (bl) {
                string = String.valueOf(string) + (SyntheticaLookAndFeel.getString(String.valueOf(string) + ".hover", jMenu) != null ? ".hover" : ".selected");
            }
            string = SyntheticaLookAndFeel.getString(string, jMenu);
            object3 = SyntheticaLookAndFeel.getInsets("Synthetica.menu.toplevel.background.insets", jMenu);
        } else {
            if (bl3) {
                string = String.valueOf(string) + ".disabled";
            } else if (bl) {
                string = String.valueOf(string) + ".hover";
            } else if (bl4) {
                string = SyntheticaLookAndFeel.getString(String.valueOf(string) + ".selected", jMenu) == null ? String.valueOf(string) + ".hover" : String.valueOf(string) + ".selected";
            }
            string = SyntheticaLookAndFeel.getString(string, jMenu);
            object3 = SyntheticaLookAndFeel.getInsets("Synthetica.menu.insets", jMenu);
        }
        if (string != null) {
            object2 = object3;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (bl || bl4) {
                n5 |= 2;
                n6 = SyntheticaLookAndFeel.getInt("Synthetica.menu.hover.animation.cycles", jMenu, 1);
                n7 = SyntheticaLookAndFeel.getInt("Synthetica.menu.hover.animation.delay", jMenu, 50);
                n8 = SyntheticaLookAndFeel.getInt("Synthetica.menu.hover.animation.type", jMenu, 1);
            } else {
                n6 = SyntheticaLookAndFeel.getInt("Synthetica.menu.animation.cycles", jMenu, 1);
                n7 = SyntheticaLookAndFeel.getInt("Synthetica.menu.animation.delay", jMenu, 50);
                n8 = SyntheticaLookAndFeel.getInt("Synthetica.menu.animation.type", jMenu, 2);
            }
            ImagePainter imagePainter = new ImagePainter((JComponent)jMenu, n6, n7, n8, n5, graphics, n, n2, n3, n4, string, (Insets)object3, (Insets)object2, 0, 0);
            imagePainter.draw();
        }
    }

    protected boolean isSingleTopLevelMenu(JMenu jMenu, Container container) {
        return this.isFirstTopLevelMenu(jMenu, container) && this.isLastTopLevelMenu(jMenu, container);
    }

    protected boolean isFirstTopLevelMenu(JMenu jMenu, Container container) {
        JMenu jMenu2 = null;
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (jMenu2 == null && component == jMenu) {
                return true;
            }
            if (jMenu2 != null) {
                return false;
            }
            if (component instanceof JMenu) {
                jMenu2 = (JMenu)component;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isLastTopLevelMenu(JMenu jMenu, Container container) {
        JMenu jMenu2 = null;
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JMenu) {
                jMenu2 = (JMenu)component;
            }
            ++n2;
        }
        return jMenu2 == jMenu;
    }

    public void paintMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        JComponent jComponent = synthContext.getComponent();
        String string = "Synthetica.menuItem";
        int n5 = synthContext.getComponentState();
        boolean bl2 = (n5 & 8) > 0;
        boolean bl3 = bl = (n5 & 2) > 0;
        if (bl2) {
            string = String.valueOf(string) + ".disabled";
        } else if (bl) {
            string = String.valueOf(string) + ".hover";
        }
        string = SyntheticaLookAndFeel.getString(string, jComponent);
        if (string != null) {
            Insets insets;
            Insets insets2 = insets = SyntheticaLookAndFeel.getInsets("Synthetica.menuItem.insets", jComponent);
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (bl) {
                n6 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.hover.animation.cycles", jComponent, 1);
                n7 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.hover.animation.delay", jComponent, 50);
                n8 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.hover.animation.type", jComponent, 1);
            } else {
                n6 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.animation.cycles", jComponent, 1);
                n7 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.animation.delay", jComponent, 50);
                n8 = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.animation.type", jComponent, 2);
            }
            ImagePainter imagePainter = new ImagePainter(jComponent, n6, n7, n8, n5, graphics, n, n2, n3, n4, string, insets, insets2, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintRadioButtonMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
    }

    public void paintRadioButtonMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintCheckBoxMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
    }

    public void paintCheckBoxMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintMenuBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintMenuBarBackground(synthContext.getComponent(), new SyntheticaState(synthContext.getComponentState()), graphics, n, n2, n3, n4);
    }

    public void paintMenuBarBackground(JComponent jComponent, SyntheticaState syntheticaState, Graphics graphics, int n, int n2, int n3, int n4) {
        Container container = jComponent.getRootPane().getParent();
        boolean bl = true;
        if (container instanceof Window) {
            bl = ((Window)container).isActive();
        } else if (container instanceof JInternalFrame) {
            bl = ((JInternalFrame)container).isSelected();
        }
        String string = "Synthetica.menuBar.background";
        string = bl ? String.valueOf(string) + ".active" : String.valueOf(string) + ".inactive";
        string = SyntheticaLookAndFeel.getString(string, jComponent);
        if (string != null) {
            Insets insets;
            Insets insets2 = SyntheticaLookAndFeel.getInsets("Synthetica.menuBar.background.insets", jComponent);
            if (insets2 == null) {
                insets2 = new Insets(0, 0, 0, 0);
            }
            Insets insets3 = insets = insets2;
            int n5 = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.menuBar.background.horizontalTiled", jComponent)) {
                n5 = 1;
            }
            int n6 = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.menuBar.background.verticalTiled", jComponent)) {
                n6 = 1;
            }
            ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets3, n5, n6);
            imagePainter.draw();
            string = "Synthetica.menuBar.background.light";
            string = bl ? String.valueOf(string) + ".active" : String.valueOf(string) + ".inactive";
            string = SyntheticaLookAndFeel.getString(string, jComponent);
            if (string != null) {
                imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets3, 0, n6);
                imagePainter.draw();
            }
        }
    }
}

