/*
 * Decompiled with CFR 0.152.
 */
package tiled.plugins.tmw;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import tiled.core.Map;
import tiled.core.TileSet;
import tiled.io.MapWriter;
import tiled.io.PluginLogger;
import tiled.plugins.tmw.WLKWriter;

public class TMWServerMapWriter
implements MapWriter {
    private static final int FIRST_BYTE = 255;
    private PluginLogger logger;

    public void writeMap(Map map, String string) throws Exception {
        this.writeMap(map, new FileOutputStream(string));
    }

    public void writeTileset(TileSet tileSet, String string) throws Exception {
        this.logger.error((Object)"Tilesets are not supported!");
        this.logger.error((Object)("(asked to write " + string + ")"));
    }

    public void writeMap(Map map, OutputStream outputStream) throws Exception {
        WLKWriter.writeMap(map, outputStream);
    }

    public void writeTileset(TileSet tileSet, OutputStream outputStream) throws Exception {
        System.out.println("Tilesets are not supported!");
    }

    public String getFilter() throws Exception {
        return "*.wlk";
    }

    public String getDescription() {
        return "+---------------------------------------------+\n|    An exporter for The Mana World server    |\n|                  map files.                 |\n|          (c) 2005 Bjorn Lindeijer           |\n|              bjorn@lindeijer.nl             |\n+---------------------------------------------+";
    }

    public String getPluginPackage() {
        return "The Mana World export plugin";
    }

    public String getName() {
        return "The Mana World exporter";
    }

    public boolean accept(File file) {
        try {
            String string = file.getCanonicalPath().toLowerCase();
            if (string.endsWith(".wlk")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void setLogger(PluginLogger pluginLogger) {
        this.logger = pluginLogger;
    }
}

