/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device;

import JCPC.core.device.Device;

public class IOPort
extends Device {
    public static final int READ = 0;
    public static final int WRITE = 255;
    protected Device inputDevice = null;
    protected int inputPort = 0;
    protected Device outputDevice = null;
    protected int outputPort = 0;
    protected int readMask = 255;
    protected int writeMask = 0;
    protected int input = 255;
    protected int output = 255;
    protected boolean latched = false;

    public IOPort() {
        this(0);
    }

    public IOPort(int mode) {
        super("Input/Output Port");
        this.setPortMode(mode);
    }

    public void setInputDevice(Device device, int port) {
        this.inputDevice = device;
        this.inputPort = port;
    }

    public void setOutputDevice(Device device, int port) {
        this.outputDevice = device;
        this.outputPort = port;
    }

    public void setPortMode(int mask) {
        this.setPortMode(mask ^ 0xFF, mask);
    }

    public void setPortMode(int readMask, int writeMask) {
        this.writeMask = writeMask;
        this.readMask = readMask;
    }

    public int getPortMode() {
        return this.writeMask;
    }

    @Override
    public int readPort(int port) {
        return this.read();
    }

    @Override
    public void writePort(int port, int value) {
        this.write(value);
    }

    public int read() {
        if (!this.latched && this.inputDevice != null) {
            this.input = this.inputDevice.readPort(this.inputPort);
        }
        return this.output & (this.readMask ^ 0xFF) | this.input & this.readMask;
    }

    public void latch() {
        this.input = this.inputDevice == null ? 255 : this.inputDevice.readPort(this.inputPort);
    }

    public void write(int value) {
        this.output = value;
        if (this.inputDevice == null) {
            this.input = value;
        }
        if (this.outputDevice != null && this.writeMask != 0) {
            this.outputDevice.writePort(this.outputPort, value & this.writeMask | this.input & (this.writeMask ^ 0xFF));
        }
    }

    public void setOutput(int value) {
        this.output = value;
    }

    public int getOutput() {
        return this.output;
    }

    public int readOutput() {
        return this.output & this.writeMask;
    }

    public void setInput(int value) {
        this.input = value;
    }

    public int getInput() {
        return this.input;
    }

    public void setLatched(boolean value) {
        this.latched = value;
    }

    public boolean isLatched() {
        return this.latched;
    }
}

