/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.Util;
import JCPC.core.cpu.Processor;
import JCPC.core.device.Computer;
import JCPC.core.device.Device;
import JCPC.core.device.DeviceMapping;
import JCPC.core.device.crtc.Basic6845;
import JCPC.core.device.floppy.Drive;
import JCPC.core.device.floppy.UPD765A;
import JCPC.core.device.io.PPI8255;
import JCPC.core.device.memory.Memory;
import JCPC.core.device.sound.AY_3_8910;
import JCPC.core.device.sound.AmDrum;
import JCPC.core.device.sound.DigiBlaster;
import JCPC.core.device.tape.CDT2WAV;
import JCPC.system.cpc.CPCDiscImage;
import JCPC.system.cpc.CPCMemory;
import JCPC.system.cpc.GateArray;
import JCPC.system.cpc.Keyboard;
import JCPC.system.cpc.Poker;
import JCPC.system.cpc.Samples;
import JCPC.system.cpc.Z80;
import JCPC.system.cpc.plus.ASIC;
import JCPC.system.cpc.plus.CPRLoader;
import JCPC.system.cpc.plus.CSDGui;
import JCPC.system.cpc.plus.JukeBox;
import JCPC.ui.Autotype;
import JCPC.ui.Display;
import JCPC.ui.GX4000;
import JCPC.ui.GX4000Menu;
import JCPC.util.diss.Disassembler;
import JCPC.util.diss.DissZ80;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;

public class CPC
extends Computer
implements ActionListener {
    public static boolean gx4000 = false;
    boolean rubbercheat = false;
    protected Disassembler disassembler = new DissZ80();
    String[] random = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"};
    String[] random2 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"};
    public static boolean CSD = false;
    private CSDGui csd;
    private int computername = 7;
    public CPRLoader[] cprload = new CPRLoader[13];
    protected AY_3_8910 psg = (AY_3_8910)this.addDevice(new AY_3_8910());
    protected final int[] PSG_VALUES;
    protected static final int PSG_PORT_A = -1;
    protected static final int PPI_PORT_B = -2;
    protected static final int PPI_PORT_C = -3;
    protected static final int CYCLES_PER_SECOND = 1000000;
    protected static final int AUDIO_TEST = 0x40000000;
    public Z80 z80;
    protected Basic6845 crtc;
    protected GateArray gateArray;
    public CPCMemory memory;
    protected ASIC asic;
    protected JukeBox jukebox;
    protected PPI8255 ppi;
    protected UPD765A fdc;
    protected Keyboard keyboard;
    protected int audioAdd;
    protected int audioCount;
    protected Drive[] floppies;
    protected AmDrum amdrum;
    protected DigiBlaster digiblaster;
    private int previousPortValue;
    private boolean relay;
    private boolean stoptape;
    private int tapestopper;
    private int playcount;
    private int pause;
    public static int tapePosition = 0;
    private int tape_delay;
    public static byte[] tapesample = new byte[0];
    private boolean play;
    private int portB;
    private int tapesound;
    public static boolean internal = false;
    public int cprslot;
    Poker poker;
    public static int cartindex = 2;
    public static boolean loadedplus = false;
    int donewreset;
    long doscratch;
    boolean cycle;
    long sp1;
    long sp2;
    int poop;
    int old;
    int adder;
    int lc;
    String[] basictypetext;
    int basictypelength;
    int basicchecktype;
    int basictypepos;
    protected int BUFFER_START;
    public boolean doTurbo;
    Autotype typ;
    int prepare;
    String typetext;
    int divider;
    int olddiv;
    int citron;
    boolean windows;
    int PPI_TAPE_READ_DATA;
    int PPI_CENTRONICS_BUSY;
    int PPI_EXPANSION_PORT;
    int PPI_SCREEN_REFRESH_50HZ;
    int PPI_SCREEN_REFRESH_60HZ;
    int VSYNC_ACTIVE;
    protected int[] internalCSD;
    protected String[] carts;
    public static int turbospeed = 2;
    boolean ctrl;
    protected boolean resna;
    protected boolean stosna;
    protected static final String CDT_HEADER = "ZXTAPE";
    protected static final String SNA_HEADER = "MV - SNA";
    protected static final String CSW_HEADER = "Compressed Square Wave";
    protected static final String CPR_HEADER = "RIFF";
    protected static final int CRTC_FLAG_VSYNC_ACTIVE = 1;
    protected static final int CRTC_FLAG_HSYNC_ACTIVE = 2;
    protected static final int CRTC_FLAG_HDISP_ACTIVE = 4;
    protected static final int CRTC_FLAG_VDISP_ACTIVE = 8;
    protected static final int CRTC_FLAG_HTOT_REACHED = 16;
    protected static final int CRTC_FLAG_VTOT_REACHED = 32;
    protected static final int CRTC_FLAG_MAXIMUM_RASTER_COUNT_REACHED = 64;
    protected static final int SNAPSHOT_ID = 0;
    protected static final int VERSION = 16;
    protected static final int F = 17;
    protected static final int A = 18;
    protected static final int C = 19;
    protected static final int B = 20;
    protected static final int E = 21;
    protected static final int D = 22;
    protected static final int L = 23;
    protected static final int H = 24;
    protected static final int AF = 17;
    protected static final int BC = 19;
    protected static final int DE = 21;
    protected static final int HL = 23;
    protected static final int R = 25;
    protected static final int I = 26;
    protected static final int IFF1 = 27;
    protected static final int IFF2 = 28;
    protected static final int IX = 29;
    protected static final int IY = 31;
    protected static final int SP = 33;
    protected static final int PC = 35;
    protected static final int IM = 37;
    protected static final int AF1 = 38;
    protected static final int BC1 = 40;
    protected static final int DE1 = 42;
    protected static final int HL1 = 44;
    protected static final int GA_PEN = 46;
    protected static final int GA_INKS = 47;
    protected static final int GA_ROM = 64;
    protected static final int GA_RAM = 65;
    protected static final int CRTC_REG = 66;
    protected static final int CRTC_REGS = 67;
    protected static final int UPPER_ROM = 85;
    protected static final int PPI_A = 86;
    protected static final int PPI_B = 87;
    protected static final int PPI_C = 88;
    protected static final int PPI_CONTROL = 89;
    protected static final int PSG_REG = 90;
    protected static final int PSG_REGS = 91;
    protected static final int MEM_SIZE = 107;
    final int PLUS_SPRITE_DATA = 0;
    final int PLUS_SPRITE_ATTRIBUTES = 2048;
    final int PLUS_PALETTE = 2176;
    byte[] storedSnapshot;
    int porta;
    int portb;
    int portc;
    CDT2WAV cdt2wav;
    public boolean saveallowed;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.poker != null && e.getSource() == this.poker.poke) {
            int s = this.poker.preset.getSelectedIndex();
            switch (s) {
                case 0: {
                    this.POKE(this.poker.getAddress(), this.poker.getValue());
                    break;
                }
                case 1: {
                    this.POKE(16176, 9);
                    this.POKE(18183, 0);
                    this.display.requestFocus();
                    break;
                }
                case 2: {
                    this.POKE(2015, 153);
                    this.rubbercheat = true;
                    this.display.requestFocus();
                    break;
                }
                case 3: {
                    this.POKE(17574, 58);
                    this.display.requestFocus();
                    break;
                }
                case 4: {
                    this.POKE(11837, 0);
                    this.POKE(9848, 0);
                    this.POKE(37771, 57);
                    this.POKE(37772, 57);
                    this.POKE(37773, 57);
                    this.display.requestFocus();
                    break;
                }
                case 5: {
                    this.POKE(7616, 0);
                    this.POKE(10185, 183);
                    this.POKE(10195, 183);
                    this.display.requestFocus();
                    break;
                }
                case 6: {
                    this.POKE(3020, 112);
                    this.POKE(3024, 108);
                    this.POKE(2834, 201);
                    this.display.requestFocus();
                    break;
                }
                case 7: {
                    this.POKE(4302, 201);
                    this.display.requestFocus();
                }
            }
            return;
        }
        if (this.csd == null) {
            return;
        }
        if (e.getSource() == this.csd.load1) {
            this.loadCSD(1);
        }
        if (e.getSource() == this.csd.load2) {
            this.loadCSD(2);
        }
        if (e.getSource() == this.csd.load3) {
            this.loadCSD(3);
        }
        if (e.getSource() == this.csd.load4) {
            this.loadCSD(4);
        }
        if (e.getSource() == this.csd.load5) {
            this.loadCSD(5);
        }
        if (e.getSource() == this.csd.load6) {
            this.loadCSD(6);
        }
        if (e.getSource() == this.csd.load7) {
            this.loadCSD(7);
        }
        if (e.getSource() == this.csd.load8) {
            this.loadCSD(8);
        }
        if (e.getSource() == this.csd.load9) {
            this.loadCSD(9);
        }
        if (e.getSource() == this.csd.load10) {
            this.loadCSD(10);
        }
        if (e.getSource() == this.csd.load11) {
            this.loadCSD(11);
        }
        if (e.getSource() == this.csd.load12) {
            this.loadCSD(12);
        }
        if (e.getSource() == this.csd.shuffle) {
            this.loadShuffledCSD();
        }
        if (e.getSource() == this.csd.jRadioButton1) {
            this.jukebox.setTimer(0);
        }
        if (e.getSource() == this.csd.jRadioButton2) {
            this.jukebox.setTimer(1);
        }
        if (e.getSource() == this.csd.jRadioButton3) {
            this.jukebox.setTimer(2);
        }
        if (e.getSource() == this.csd.jRadioButton4) {
            this.jukebox.setTimer(3);
        }
        if (e.getSource() == this.csd.jRadioButton5) {
            this.jukebox.setTimer(4);
        }
        if (e.getSource() == this.csd.csdmode) {
            byte[] cpr;
            this.reset();
            boolean bl = CSD = !CSD;
            if (!CSD) {
                this.csd.csdmode.setText("Start CSD Mode");
                cpr = this.getRom("plus/CPC_PLUS.CPR", 131156);
                this.cprslot = 0;
                this.CPRLoad(cpr, "CPC_PLUS.CPR");
            }
            if (CSD) {
                this.csd.csdmode.setText("Exit CSD Mode");
                cpr = this.getRom("plus/CSD.CPR", 32976);
                this.cprslot = 0;
                this.CPRLoad(cpr, "CSD.CPR");
            }
            this.reSync();
        }
    }

    public void loadShuffledCSD() {
        System.arraycopy(this.random2, 0, this.random, 0, this.random.length);
        Collections.shuffle(Arrays.asList(this.random));
        for (int i = 1; i < 13; ++i) {
            this.loadInternalCSD(Integer.parseInt(this.random[i - 1]), i);
        }
    }

    protected void loadInternalCSD(int game, int slot) {
    }

    protected void loadCSD(int slot) {
        int old = this.cprslot;
        this.cprslot = slot;
        FileDialog filedia = new FileDialog(new Frame(), "Open CPC+ Cartridge file", 0);
        filedia.setFile("*.cpr");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        try {
            if (filedia.getFile() != null) {
                filename = filedia.getDirectory() + filedia.getFile();
                byte[] data = this.getFile(filename);
                System.out.println("Loading " + filename + " to CSD slot " + slot);
                this.cprload[this.cprslot].readCPR2(data, filename);
                String name = filedia.getFile();
                switch (slot) {
                    case 1: {
                        this.csd.cpr01.setText(name);
                        break;
                    }
                    case 2: {
                        this.csd.cpr02.setText(name);
                        break;
                    }
                    case 3: {
                        this.csd.cpr03.setText(name);
                        break;
                    }
                    case 4: {
                        this.csd.cpr04.setText(name);
                        break;
                    }
                    case 5: {
                        this.csd.cpr05.setText(name);
                        break;
                    }
                    case 6: {
                        this.csd.cpr06.setText(name);
                        break;
                    }
                    case 7: {
                        this.csd.cpr07.setText(name);
                        break;
                    }
                    case 8: {
                        this.csd.cpr08.setText(name);
                        break;
                    }
                    case 9: {
                        this.csd.cpr09.setText(name);
                        break;
                    }
                    case 10: {
                        this.csd.cpr10.setText(name);
                        break;
                    }
                    case 11: {
                        this.csd.cpr11.setText(name);
                        break;
                    }
                    case 12: {
                        this.csd.cpr12.setText(name);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cprslot = old;
        this.reSync();
    }

    public void Z80_AcknowledgeInterrupt() {
        this.gateArray.GateArray_AcknowledgeInterrupt();
        this.asic.ASIC_AcknowledgeInterrupt();
        this.z80.Z80_ClearInterruptRequest();
    }

    public AY_3_8910 getPSG() {
        return this.psg;
    }

    public void setKeyMapping(int map) {
        this.keyboard.setKeyMapping(map);
        gx4000 = map == 1;
        this.display.menupos = -600;
        this.display.menumode = false;
        this.memory.changeRamType(gx4000 ? 0 : 255);
        if (gx4000) {
            this.loadGX();
        } else {
            this.cprslot = 0;
            this.CPRLoad(this.getCart(cartindex), this.carts[cartindex]);
        }
        this.reset();
    }

    public void loadGX() {
        if (CSD) {
            byte[] cpr = this.getRom("plus/CSD.CPR", 32976);
            this.cprslot = 0;
            this.CPRLoad(cpr, "CSD.CPR");
            return;
        }
        byte[] cpr = this.getRom("plus/cpr/logo.cpr", 262284);
        this.cprslot = 0;
        this.CPRLoad(cpr, "logo.cpr");
    }

    public void changeMemory(int RAM) {
        this.memory = new CPCMemory(RAM, this, this.gateArray);
        this.z80.setMemoryDevice(this.memory);
        this.reset();
    }

    public CPC(Applet applet, String name) {
        super(applet, name);
        int i;
        int[] nArray = new int[4];
        nArray[0] = this.psg.BC2_MASK;
        int n = this.psg.BC2_MASK;
        this.psg.getClass();
        nArray[1] = n | 1;
        nArray[2] = this.psg.BC2_MASK | this.psg.BDIR_MASK;
        int n2 = this.psg.BC2_MASK | this.psg.BDIR_MASK;
        this.psg.getClass();
        nArray[3] = n2 | 1;
        this.PSG_VALUES = nArray;
        this.z80 = new Z80(1000000L);
        this.crtc = (Basic6845)this.addDevice(new Basic6845(this));
        this.gateArray = (GateArray)this.addDevice(new GateArray(this));
        this.asic = (ASIC)this.addDevice(new ASIC(this, this.gateArray, this.crtc, this.psg, this.z80));
        this.jukebox = (JukeBox)this.addDevice(new JukeBox());
        this.ppi = (PPI8255)this.addDevice(new PPI8255());
        this.fdc = (UPD765A)this.addDevice(new UPD765A(4));
        this.keyboard = new Keyboard();
        this.audioAdd = this.psg.getSoundPlayer().getClockAdder(0x40000000, 1000000);
        this.audioCount = 0;
        this.floppies = new Drive[2];
        this.amdrum = (AmDrum)this.addDevice(new AmDrum());
        this.digiblaster = (DigiBlaster)this.addDevice(new DigiBlaster());
        this.stoptape = false;
        this.tapestopper = 0;
        this.playcount = 0;
        this.pause = 0;
        this.tape_delay = 22;
        this.play = false;
        this.portB = 1;
        this.cprslot = 0;
        this.donewreset = 0;
        this.doscratch = 0L;
        this.poop = 0;
        this.basictypelength = -1;
        this.basicchecktype = 0;
        this.basictypepos = 0;
        this.BUFFER_START = 44170;
        this.doTurbo = false;
        this.prepare = 0;
        this.typetext = null;
        this.divider = 1;
        this.olddiv = 1;
        this.citron = 0;
        this.PPI_TAPE_READ_DATA = 128;
        this.PPI_CENTRONICS_BUSY = 64;
        this.PPI_EXPANSION_PORT = 32;
        this.PPI_SCREEN_REFRESH_50HZ = 16;
        this.PPI_SCREEN_REFRESH_60HZ = 0;
        this.VSYNC_ACTIVE = 1;
        this.internalCSD = new int[]{-1, 2, 3, 5, 6, 7, 10, 11, 13, 16, 17, 18, 22, 24};
        this.carts = new String[]{"barbarian2", "batman", "burninrubber", "copter271", "crazycars2", "dicktracy", "epyxworldofsports", "fireandforget2", "klax", "mystical", "navyseals", "noexit", "operationthunderbolt", "pang", "panzakickboxing", "plotting", "protennistour", "robocop2", "skeetshot", "superpinballmagic", "switchblade", "tenniscup2", "theenforcer", "tintinonthemoon", "wildstreets", "cpc_plus"};
        this.PLUS_SPRITE_DATA = 0;
        this.PLUS_SPRITE_ATTRIBUTES = 2048;
        this.PLUS_PALETTE = 2176;
        this.cdt2wav = new CDT2WAV();
        this.saveallowed = false;
        if (gx4000) {
            this.memory = new CPCMemory(0, this, this.gateArray);
            if (GX4000.isStandalone) {
                GX4000Menu.keyb2.setSelected(true);
            }
        } else {
            this.memory = new CPCMemory(255, this, this.gateArray);
            if (GX4000.isStandalone) {
                GX4000Menu.keyb1.setSelected(true);
            }
        }
        this.keyboard.setKeyMapping(gx4000 ? 1 : 0);
        this.z80.setMemoryDevice(this.memory);
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.memory, 8192, 0));
        this.z80.setInterruptDevice(this.gateArray);
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.asic, 32768, 0));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.asic, 65280, 32512));
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.jukebox, 65516, 64480));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.jukebox, 65516, 64480));
        this.z80.setCycleDevice(this);
        this.crtc.setRegisterSelectMask(768, 0);
        this.crtc.setRegisterWriteMask(768, 256);
        this.crtc.setRegisterReadMask(768, 768);
        this.crtc.setRegisterStatusMask(768, 512);
        this.crtc.setCRTCListener(this.gateArray);
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.crtc, 16384, 0));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.crtc, 16384, 0));
        this.ppi.setPortMasks(256, 256, 512, 512);
        this.ppi.setReadDevice(1, this, -2);
        this.ppi.setWriteDevice(2, this, -3);
        this.ppi.setReadDevice(0, this.psg, 0);
        this.ppi.setWriteDevice(0, this.psg, 0);
        this.psg.setReadDevice(this.psg.PORT_A, this, -1);
        this.psg.setClockSpeed(1000000);
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.ppi, 2048, 0));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.ppi, 2048, 0));
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.fdc, 1408, 256));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.fdc, 1408, 256));
        this.z80.addOutputDeviceMapping(new DeviceMapping(this, 1409, 0));
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.amdrum, 65280, 65280));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.amdrum, 65280, 65280));
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.digiblaster, 4096, 0));
        for (i = 0; i < 2; ++i) {
            this.floppies[i] = new Drive(i == 0 ? 1 : 2);
            this.fdc.setDrive(i, this.floppies[i]);
            this.fdc.setDrive(i, null);
        }
        this.setBasePath("cpc");
        if (this.csd == null) {
            this.csd = new CSDGui();
            this.csd.setCSD(CSD);
            this.csd.load1.addActionListener(this);
            this.csd.load2.addActionListener(this);
            this.csd.load3.addActionListener(this);
            this.csd.load4.addActionListener(this);
            this.csd.load5.addActionListener(this);
            this.csd.load6.addActionListener(this);
            this.csd.load7.addActionListener(this);
            this.csd.load8.addActionListener(this);
            this.csd.load9.addActionListener(this);
            this.csd.load10.addActionListener(this);
            this.csd.load11.addActionListener(this);
            this.csd.load12.addActionListener(this);
            this.csd.shuffle.addActionListener(this);
            this.csd.jRadioButton1.addActionListener(this);
            this.csd.jRadioButton2.addActionListener(this);
            this.csd.jRadioButton3.addActionListener(this);
            this.csd.jRadioButton4.addActionListener(this);
            this.csd.jRadioButton5.addActionListener(this);
            this.csd.csdmode.addActionListener(this);
        }
        if (CSD) {
            // empty if block
        }
        for (i = 0; i < 13; ++i) {
            try {
                this.cprload[i] = new CPRLoader();
                this.cprslot = i;
                if (CSD) {
                    if (i == 0 || GX4000.isStandalone) continue;
                    String filename = "file/test" + i + ".zip";
                    System.err.println("Opening " + filename);
                    this.loadFile(0, filename);
                    continue;
                }
                if (i == 0) continue;
                this.loadInternalCSD(this.internalCSD[i], i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void checkPoker() {
        if (this.poker == null) {
            this.poker = new Poker(this);
            this.poker.poke.addActionListener(this);
        }
        this.poker.setVisible(true);
    }

    public void checkCSD() {
        if (CSD) {
            this.csd.csdmode.setText("Exit CSD Mode");
        } else {
            this.csd.csdmode.setText("Start CSD Mode");
        }
        this.csd.setVisible(true);
    }

    public Basic6845 CRTC() {
        return this.crtc;
    }

    @Override
    public void initialise() {
        byte[] cpr;
        this.windows = Util.isWindows();
        this.gateArray.setMemory(this.memory.getMemory());
        super.initialise();
        this.psg.getSoundPlayer().play();
        if (internal) {
            this.cprslot = 0;
            this.CPRLoad(this.getCart(cartindex), this.carts[cartindex]);
        }
        if (CSD) {
            cpr = this.getRom("plus/CSD.CPR", 32976);
            this.cprslot = 0;
            this.CPRLoad(cpr, "CSD.CPR");
        }
        if (gx4000) {
            cpr = this.getRom("plus/cpr/logo.cpr", 262284);
            this.cprslot = 0;
            this.CPRLoad(cpr, "logo.cpr");
        }
        internal = false;
    }

    public GateArray getGateArray() {
        return this.gateArray;
    }

    public ASIC getAsic() {
        return this.asic;
    }

    public int storing() {
        return this.fdc.saveTimer;
    }

    public void loadSystem() {
        if (CSD) {
            byte[] cpr = this.getRom("plus/CSD.CPR", 32976);
            this.cprslot = 0;
            this.CPRLoad(cpr, "CSD.CPR");
            return;
        }
        if (gx4000) {
            byte[] cpr = this.getRom("plus/cpr/logo.cpr", 262284);
            this.cprslot = 0;
            this.CPRLoad(cpr, "logo.cpr");
            return;
        }
        byte[] cpr = this.getRom("plus/CPC_PLUS.CPR", 131156);
        this.cprslot = 0;
        this.CPRLoad(cpr, "CPC_PLUS.CPR");
    }

    public void openCartridge() {
        FileDialog filedia = new FileDialog(new Frame(), "Open CPC+ Cartridge file", 0);
        filedia.setFile("*.cpr");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filedia.getFile() != null) {
            filename = filedia.getDirectory() + filedia.getFile();
            this.openCartridge(filename);
        }
    }

    public void putPlusRoms() {
        for (int i = 0; i < 32; ++i) {
            byte[] rom = this.cprload[this.cprslot].getData(i);
            this.memory.setPlusROM(i, rom);
        }
    }

    public void openCartridge(String filename) {
        if (filename.contains("http")) {
            try {
                this.cprload[this.cprslot].openCPR(new URL(filename));
                loadedplus = true;
                this.putPlusRoms();
                this.memory.setCartridge(this.cprload[this.cprslot].getCPR());
                this.gateArray.setMemory(this.memory.getMemory());
                this.memory.remap();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        this.cprload[this.cprslot].openCPR(filename);
        loadedplus = true;
        this.putPlusRoms();
        this.memory.setCartridge(this.cprload[this.cprslot].getCPR());
        this.gateArray.setMemory(this.memory.getMemory());
        this.memory.remap();
    }

    public void CPRLoad(byte[] data, String filename) {
        System.out.println("Loading data...");
        this.cprload[this.cprslot].readCPR(data, filename);
        loadedplus = true;
        this.putPlusRoms();
        this.memory.setCartridge(this.cprload[this.cprslot].getCPR());
        this.gateArray.setMemory(this.memory.getMemory());
        this.memory.remap();
        this.start();
    }

    public void remapCPR(boolean reset) {
        reset = true;
        try {
            if (reset) {
                super.reset();
            }
            this.putPlusRoms();
            this.memory.setCartridge(this.cprload[this.cprslot].getCPR());
            this.gateArray.resetCPCColours();
            this.gateArray.setMemory(this.memory.getMemory());
            if (reset) {
                this.asic.reset();
                this.crtc.reset();
                this.gateArray.init();
                this.memory.reset(false);
                this.z80.reset();
                this.z80.setPC(65535);
                this.donewreset = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadCPR() {
        try {
            this.putPlusRoms();
            this.memory.setCartridge(this.cprload[this.cprslot].getCPR());
            this.gateArray.setMemory(this.memory.getMemory());
            loadedplus = true;
            this.gateArray.resetCPCColours();
            this.doscratch = 0L;
            this.gateArray.init();
            this.memory.remap();
            this.z80.reset();
            tapePosition = 0;
            this.pause = 0;
            this.play = false;
            this.reSync();
            this.cprslot = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void softReset() {
        super.reset();
        this.jukebox.resetJukeBox();
        this.rubbercheat = false;
        this.donewreset = 1;
        this.gateArray.reset();
        this.memory.plus = true;
        this.cprslot = 0;
        if (this.memory.plus) {
            try {
                this.putPlusRoms();
                this.memory.setCartridge(this.cprload[this.cprslot].getCPR());
                this.gateArray.setMemory(this.memory.getMemory());
                loadedplus = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.gateArray.setMemory(this.memory.getMemory());
        this.gateArray.resetCPCColours();
        try {
            this.asic.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doscratch = 0L;
        this.gateArray.init();
        this.memory.reset(false);
        this.z80.reset();
        tapePosition = 0;
        this.pause = 0;
        this.play = false;
        this.reSync();
    }

    @Override
    public void reset() {
        super.reset();
        this.portB = 1;
        this.jukebox.resetJukeBox();
        this.rubbercheat = false;
        this.donewreset = 1;
        this.gateArray.reset();
        this.memory.plus = true;
        this.cprslot = 0;
        if (this.memory.plus) {
            try {
                this.putPlusRoms();
                this.memory.setCartridge(this.cprload[this.cprslot].getCPR());
                this.gateArray.setMemory(this.memory.getMemory());
                loadedplus = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.gateArray.setMemory(this.memory.getMemory());
        this.gateArray.resetCPCColours();
        try {
            this.asic.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doscratch = 0L;
        this.gateArray.init();
        this.memory.reset(true);
        this.z80.reset();
        tapePosition = 0;
        this.pause = 0;
        this.play = false;
        this.reSync();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.psg.getSoundPlayer().dispose();
    }

    public Basic6845 getCRTC() {
        return this.crtc;
    }

    @Override
    public void cycle() {
        if (this.divider < 3) {
            this.sp1 = System.currentTimeMillis();
        }
        this.fdc.cycle();
        this.psg.cycle();
        if ((this.audioCount += this.audioAdd / this.divider) >= 0x40000000) {
            this.psg.writeAudio();
            this.audioCount -= 0x40000000;
        }
        if (this.crtc.Scratchdemo) {
            if (this.cycle) {
                this.gateArray.cycle();
                this.gateArray.cycle();
                ++this.doscratch;
            }
            if (this.doscratch > 17128089L) {
                this.crtc.Scratchdemo = false;
                this.doscratch = 0L;
            }
            this.cycle = !this.cycle;
        } else {
            if (!this.crtc.Scratchdemo) {
                this.doscratch = 0L;
            }
            this.doscratch = 0L;
            this.gateArray.cycle();
        }
        if (this.relay && this.play) {
            this.tapeCycle();
        }
        if (this.divider < 3) {
            this.sp2 = System.currentTimeMillis() - this.sp1;
            if (this.sp2 > (long)(200 * this.divider)) {
                this.reSync();
            }
        }
    }

    public static int ChecksumAMSDOS(byte[] pHeader) {
        int Checksum = 0;
        for (int i = 0; i < 67; ++i) {
            int CheckSumByte = pHeader[i] & 0xFF;
            Checksum += CheckSumByte;
        }
        return Checksum;
    }

    public static boolean CheckAMSDOS(byte[] pHeader) {
        int CalculatedChecksum;
        try {
            CalculatedChecksum = CPC.ChecksumAMSDOS(pHeader);
        }
        catch (Exception e) {
            return false;
        }
        int ChecksumFromHeader = pHeader[67] & 0xFF | (pHeader[68] & 0xFF) << 8;
        if (ChecksumFromHeader == CalculatedChecksum && ChecksumFromHeader != 0) {
            System.out.println("Has AMSDOS header");
            return true;
        }
        System.out.println("Without header");
        return false;
    }

    public void loadBinary(byte[] data) {
        int start = Device.getWord(data, 21);
        int exec = Device.getWord(data, 26);
        byte[] file = new byte[data.length - 128];
        System.arraycopy(data, 128, file, 0, file.length);
        System.out.println("loading to " + Util.hex((short)start));
        for (int i = 0; i < file.length; ++i) {
            this.POKE(start + i, file[i] & 0xFF);
        }
        if (exec != 0) {
            this.AutoType("'Start: &" + Util.hex((short)exec));
        }
    }

    @Override
    public void setDisplay(Display value) {
        super.setDisplay(value);
        this.gateArray.setDisplay(value);
    }

    @Override
    public void setFrameSkip(int value) {
        super.setFrameSkip(value);
        this.gateArray.setRendering(value == 0);
    }

    @Override
    public void AutoType(String input) {
        input = input.replace("\r", "");
        this.basictypetext = input.split("\n");
        this.basictypelength = this.basictypetext.length - 1;
        this.basictypepos = 0;
        this.doTurbo = true;
    }

    public void autotype() {
        if (this.typ == null) {
            this.typ = new Autotype();
            this.typ.setVisible(false);
            this.typ.send.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CPC.this.typ.setVisible(false);
                    Autotype cfr_ignored_0 = CPC.this.typ;
                    CPC.this.AutoType(Autotype.text.getText());
                }
            });
        }
        this.typ.setVisible(true);
    }

    public void BasicAutoType() {
        if (this.basictypetext == null) {
            this.basictypelength = -1;
            this.doTurbo = false;
            return;
        }
        if (this.basictypepos >= this.basictypelength) {
            this.doTurbo = false;
        }
        if (this.basictypepos > this.basictypelength) {
            this.doTurbo = false;
            this.basictypepos = 0;
            this.basictypelength = -1;
            this.basictypetext = null;
            return;
        }
        this.BasicPutText(this.basictypetext[this.basictypepos++]);
    }

    public void BasicPutText(String input) {
        int i;
        if (input.length() > 255) {
            return;
        }
        if (input.length() < 1) {
            this.basicchecktype = 1;
            return;
        }
        for (i = 0; i < 255; ++i) {
            this.memory.writeByte(this.BUFFER_START + i, 0);
        }
        for (i = 0; i < input.length(); ++i) {
            this.memory.writeByte(this.BUFFER_START + i, input.charAt(i));
        }
        System.out.println(input);
        this.basicchecktype = 1;
    }

    @Override
    public void prepareAutotype(String input) {
        this.prepare = 1;
        this.typetext = input;
    }

    public void vSync() {
        if (this.citron > 0) {
            if (this.citron == 500) {
                this.pressCITRON();
                System.out.println("Citron keys pressed");
            }
            if (this.citron == 1) {
                this.releaseCITRON();
                System.out.println("Citron keys released");
            }
            --this.citron;
        }
        if (this.rubbercheat) {
            this.POKE(2015, 153);
        }
        if (this.donewreset != 0) {
            ++this.donewreset;
            if (this.donewreset == 2) {
                this.donewreset = 0;
                this.asic.reset();
                this.crtc.reset();
                this.gateArray.init();
                this.memory.reset(false);
                this.z80.reset();
                this.z80.setPC(65535);
            }
        }
        if (this.olddiv != this.divider) {
            this.olddiv = this.divider;
            this.reSync();
        }
        if (this.prepare != 0) {
            ++this.prepare;
            if (this.prepare == 90) {
                this.keyPressed(97);
            }
            if (this.prepare == 95) {
                this.keyReleased(97);
            }
            if (this.prepare == 120) {
                this.prepare = 0;
                this.AutoType(this.typetext);
            }
        }
        this.divider = this.doTurbo ? turbospeed : 1;
        try {
            this.display.turbo = this.doTurbo;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.basictypelength > -1) {
            ++this.basicchecktype;
            if (this.basicchecktype == 1) {
                this.BasicAutoType();
            }
            if (this.basicchecktype == 2) {
                this.keyboard.keyPressed(10);
            }
            if (this.memory.readByte(this.BUFFER_START) == 0 && this.basicchecktype > 3) {
                this.basicchecktype = 0;
                this.keyboard.keyReleased(10);
            }
        }
        if (this.stosna) {
            this.stosna = false;
            this.storeSNA();
            return;
        }
        if (this.resna) {
            this.resna = false;
            this.restoreSNA();
            return;
        }
        if (this.frameSkip == 0) {
            try {
                this.display.updateImage(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.syncProcessor(this.psg.getSoundPlayer());
        if (this.stoptape && this.tapestopper >= 1) {
            ++this.tapestopper;
            if (this.tapestopper == 2) {
                this.StopTape();
                this.tapestopper = 0;
            }
        }
    }

    @Override
    public Memory getMemory() {
        return this.memory;
    }

    @Override
    public Processor getProcessor() {
        return this.z80;
    }

    @Override
    public Dimension getDisplaySize(boolean large) {
        return this.gateArray.getDisplaySize(true);
    }

    @Override
    public Disassembler getDisassembler() {
        return this.disassembler;
    }

    @Override
    public Dimension getDisplayScale(boolean large) {
        return Display.SCALE_1x2;
    }

    boolean CPC_Get50Hz() {
        return true;
    }

    boolean Printer_GetBusyState() {
        return true;
    }

    boolean ASIC_GetHasCassetteInterface() {
        return false;
    }

    @Override
    public int readPort(int port) {
        int result = 255;
        switch (port) {
            case -3: {
                result = 1;
                break;
            }
            case -2: {
                result = 0;
                result |= (this.computername & 7) << 1;
                if (this.CPC_Get50Hz()) {
                    result |= this.PPI_SCREEN_REFRESH_50HZ;
                }
                if (!gx4000) {
                    if (!this.memory.lower) {
                        result |= this.PPI_EXPANSION_PORT;
                    }
                } else {
                    result |= this.PPI_EXPANSION_PORT;
                }
                if (!gx4000) {
                    if (this.Printer_GetBusyState()) {
                        result |= this.PPI_CENTRONICS_BUSY;
                    }
                } else {
                    result |= this.PPI_CENTRONICS_BUSY;
                }
                if (this.crtc.isVSync()) {
                    result |= 1;
                }
                if (!gx4000 && this.ASIC_GetHasCassetteInterface()) {
                    if (!this.relay) break;
                    result |= this.PPI_TAPE_READ_DATA;
                    break;
                }
                result |= this.PPI_TAPE_READ_DATA;
                break;
            }
            case -1: {
                this.porta = result = this.keyboard.readSelectedRow();
            }
        }
        return result;
    }

    @Override
    public void writePort(int port, int value) {
        switch (port) {
            case -3: {
                this.psg.setBDIR_BC2_BC1(this.PSG_VALUES[value >> 6], this.ppi.readOutput(0));
                this.keyboard.setSelectedRow(value & 0xF);
                if ((value & 0x20) == 32) {
                    AY_3_8910.digicount = 1;
                }
                if (((value ^ this.previousPortValue) & 0x10) == 0 && (value & 0x10) != 16) break;
                this.TapeRelayCheck(value);
                break;
            }
            default: {
                if ((port & 0x581) != 0 || port < 64000) break;
                if ((value & 1) == 0) {
                    Display.ledOn = false;
                    Samples.MOTOR.play();
                    break;
                }
                Samples.MOTOR.loop2();
                Display.ledOn = true;
            }
        }
    }

    public void loadCart(int index) {
        this.CPRLoad(this.getCart(index), this.carts[index]);
        this.reset();
    }

    protected byte[] getCart(int index) {
        return this.getRom("plus/cpr/" + this.carts[index] + ".bin", 131072);
    }

    public void pressCITRON() {
        this.keyboard.keyPressed(67);
        this.keyboard.keyPressed(73);
        this.keyboard.keyPressed(84);
        this.keyboard.keyPressed(82);
        this.keyboard.keyPressed(79);
        this.keyboard.keyPressed(78);
    }

    public void releaseCITRON() {
        this.keyboard.keyReleased(67);
        this.keyboard.keyReleased(73);
        this.keyboard.keyReleased(84);
        this.keyboard.keyReleased(82);
        this.keyboard.keyReleased(79);
        this.keyboard.keyReleased(78);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 19) {
            this.checkCSD();
            e.consume();
        }
        if (e.getKeyCode() == 17) {
            this.ctrl = true;
        }
        if (e.getKeyCode() == 154) {
            e.consume();
        }
        if (e.getKeyCode() == 117) {
            return;
        }
        if (e.getKeyCode() == 122) {
            return;
        }
        if (e.getKeyCode() == 119) {
            return;
        }
        if (e.getKeyCode() == 120) {
            if (this.ctrl) {
                this.softReset();
                return;
            }
            if (!this.doTurbo) {
                this.doTurbo = !this.doTurbo;
            } else if (++turbospeed > 6) {
                turbospeed = 2;
                this.doTurbo = false;
            }
        }
        this.keyboard.keyPressed(e.getKeyCode());
        if (e.getKeyCode() == 96) {
            this.keyboard.keyPressed(33);
        }
        if (e.getKeyCode() == 101) {
            this.keyboard.keyPressed(155);
        }
        if (e.getKeyCode() == 100) {
            this.keyboard.keyPressed(127);
        }
        if (e.getKeyCode() == 104) {
            this.keyboard.keyPressed(36);
        }
        if (e.getKeyCode() == 102) {
            this.keyboard.keyPressed(34);
        }
        if (e.getKeyCode() == 98) {
            this.keyboard.keyPressed(35);
        }
    }

    @Override
    public void keyPressed(int e) {
        this.keyboard.keyPressed(e);
    }

    @Override
    public void keyReleased(int e) {
        this.keyboard.keyReleased(e);
    }

    @Override
    public void openCPR() {
        this.cprload[0].OpenCPR();
        this.memory.setCartridge(this.cprload[this.cprslot].getCPR());
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.ctrl = false;
        }
        if (e.getKeyCode() == 19) {
            e.consume();
        }
        this.keyboard.keyReleased(e.getKeyCode());
        if (e.getKeyCode() == 96) {
            this.keyboard.keyReleased(33);
        }
        if (e.getKeyCode() == 101) {
            this.keyboard.keyReleased(155);
        }
        if (e.getKeyCode() == 100) {
            this.keyboard.keyReleased(127);
        }
        if (e.getKeyCode() == 104) {
            this.keyboard.keyReleased(36);
        }
        if (e.getKeyCode() == 102) {
            this.keyboard.keyReleased(34);
        }
        if (e.getKeyCode() == 98) {
            this.keyboard.keyReleased(35);
        }
        if (e.getKeyCode() == 115) {
            // empty if block
        }
        if (e.getKeyCode() == 116) {
            // empty if block
        }
    }

    @Override
    public void loadFile(int type, String name) throws Exception {
        byte[] data = this.getFile(name);
        if (CPC.CheckAMSDOS(data)) {
            this.loadBinary(data);
            return;
        }
        if (SNA_HEADER.equals(new String(data, 0, SNA_HEADER.length()))) {
            this.storedSnapshot = data;
            this.resna = true;
            return;
        }
        if (CDT_HEADER.equals(new String(data, 0, CDT_HEADER.length()).toUpperCase())) {
            System.out.println("Open CDT tape file");
            this.CDT_Load(name, data);
            return;
        }
        if (CSW_HEADER.equals(new String(data, 0, CSW_HEADER.length())) || name.toUpperCase().endsWith(".CSW")) {
            System.out.println("Open CSW tape file");
            this.CSWLoad(name, data);
            return;
        }
        if (CPR_HEADER.equals(new String(data, 0, CPR_HEADER.length()))) {
            System.out.println("Open CPR cartridge file");
            try {
                this.CPRLoad(data, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        this.DSK_Load(name, data);
        this.reSync();
    }

    @Override
    public void reSync() {
        this.psg.getSoundPlayer().resync();
    }

    private void SNA_Load(byte[] data) {
        boolean intrequest;
        int i;
        this.z80.stop();
        this.z80.setAF(CPC.getWord(data, 17));
        this.z80.setBC(CPC.getWord(data, 19));
        this.z80.setDE(CPC.getWord(data, 21));
        this.z80.setHL(CPC.getWord(data, 23));
        this.z80.setR(data[25]);
        this.z80.setI(data[26]);
        this.z80.setIFF1(data[27] != 0);
        this.z80.setIFF2(data[28] != 0);
        this.z80.setIX(CPC.getWord(data, 29));
        this.z80.setIY(CPC.getWord(data, 31));
        this.z80.setSP(CPC.getWord(data, 33));
        this.z80.setPC(CPC.getWord(data, 35));
        this.z80.setIM(data[37]);
        this.z80.setAF1(CPC.getWord(data, 38));
        this.z80.setBC1(CPC.getWord(data, 40));
        this.z80.setDE1(CPC.getWord(data, 42));
        this.z80.setHL1(CPC.getWord(data, 44));
        this.gateArray.setSelectedInk(data[46]);
        for (i = 0; i < 17; ++i) {
            this.gateArray.setInk(i, data[47 + i]);
        }
        this.asic.romconfig = data[64];
        this.asic.setModeAndROMEnable();
        this.memory.setRAMBank(data[65]);
        this.crtc.setSelectedRegister(data[66]);
        for (i = 0; i < 18; ++i) {
            this.crtc.setRegister(i, data[67 + i]);
        }
        this.ppi.setControl(data[89] & 0xFF | 0x80);
        this.ppi.setOutputValue(0, data[86] & 0xFF);
        this.ppi.setOutputValue(1, data[87] & 0xFF);
        int portC = data[88] & 0xFF;
        this.ppi.setOutputValue(2, portC);
        this.psg.setBDIR_BC2_BC1(this.PSG_VALUES[portC >> 6], this.ppi.readOutput(0));
        this.psg.setSelectedRegister(data[90]);
        for (int i2 = 0; i2 < 14; ++i2) {
            this.psg.setRegister(i2, data[91 + i2] & 0xFF);
        }
        int memSize = CPC.getWord(data, 107) * 1024;
        byte[] mem = this.memory.getMemory();
        System.arraycopy(data, 256, mem, 0, memSize);
        System.arraycopy(data, 256, GateArray.screenmemory, 0, 65536);
        this.gateArray.InterruptSyncCount = data[178] & 0xFF;
        this.gateArray.InterruptLineCount = data[179] & 0xFF;
        boolean bl = intrequest = data[180] != 0;
        if (intrequest) {
            this.asic.ASIC_SetRasterInterrupt();
            this.z80.Z80_SetInterruptRequest();
        } else {
            this.z80.Z80_ClearInterruptRequest();
        }
        try {
            int i3;
            int i4;
            int plussize = CPC.getDWord(data, memSize + 260);
            System.out.println(Util.hex(plussize));
            byte[] plussna = new byte[plussize];
            System.arraycopy(data, 264 + memSize, plussna, 0, plussna.length);
            this.asic.checkLockStatus(plussna[plussna.length - 1] != 0 ? 125 : 0);
            int off = 0;
            for (i4 = 0; i4 < 2048; ++i4) {
                this.memory.writeByte(16384 + off++, plussna[i4] >> 4 & 0xF);
                this.memory.writeByte(16384 + off++, plussna[i4] & 0xF);
                this.memory.writeASIC(i4 * 2, plussna[i4] >> 4 & 0xF);
                this.memory.writeASIC(i4 * 2 + 1, plussna[i4] & 0xF);
            }
            off = 0;
            for (i4 = 2176; i4 < 2239; ++i4) {
                this.memory.writeASIC(25600 + off++, plussna[i4] & 0xFF);
            }
            this.asic.setRasterInterruptLine(plussna[2240] & 0xFF);
            this.asic.setRasterSplitLine(plussna[2241] & 0xFF);
            int splitaddress = CPC.getWord(plussna, 2242);
            this.asic.setAsicScreenMA(splitaddress);
            this.gateArray.setSoftScroll(plussna[2244]);
            byte iv = plussna[2245];
            this.asic.setInterruptVectorFromSNA(iv & 0xFF);
            off = 2256;
            for (i3 = 0; i3 < 3; ++i3) {
                this.asic.setDMAChannelAddress(i3, plussna[off++], plussna[off++]);
                this.asic.setDMAPrescale(i3, plussna[off++]);
                ++off;
            }
            this.asic.setDMAControl(plussna[2271]);
            off = 2272;
            for (i3 = 0; i3 < 3; ++i3) {
                this.asic.setDMALoopStart(i3, CPC.getWord(plussna, off += 2));
                this.asic.setDMARepeatCount(i3, CPC.getWord(plussna, off += 2));
                this.asic.setDMAPauseCount(i3, CPC.getWord(plussna, off += 2));
                this.asic.setDMAPrescalarCount(i3, CPC.getWord(plussna, off++));
            }
            for (i3 = 0; i3 < 17; ++i3) {
                this.memory.pluspalette(i3);
            }
        }
        catch (Exception e) {
            System.out.println("Unsupported or no uncompressed CPC plus snapshot");
        }
        this.start();
        this.reSync();
    }

    @Override
    public void loadEntry(int index) {
        try {
            if (this.disknames[index].toLowerCase().endsWith("dsk")) {
                this.DSK_Load(this.disknames[index], this.disks[index]);
            }
            if (this.disknames[index].toLowerCase().endsWith("sna")) {
                this.SNA_Load(this.disks[index]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void DSK_Load(String name, byte[] data) {
        CPCDiscImage image = new CPCDiscImage(name, data);
        int drive = this.getCurrentDrive();
        this.floppies[drive].setSides(image.getNumberOfSides());
        int heads = image.getNumberOfSides() == 1 ? 1 : 3;
        this.fdc.setDrive(drive, this.floppies[drive]);
        this.fdc.getDrive(drive).setDisc(heads, image);
        this.fdc.poll();
        this.reSync();
    }

    @Override
    public void displayLostFocus() {
        this.keyboard.reset();
    }

    @Override
    public Drive[] getFloppyDrives() {
        return this.floppies;
    }

    public int PEEK(int address) {
        return this.memory.readByte(address);
    }

    public void POKE(int address, int value) {
        if (address < 0 || value < 0) {
            return;
        }
        this.memory.writeByte(address, value);
    }

    public void storeSNA() {
        int i;
        this.z80.stop();
        int memSize = 131072;
        this.storedSnapshot = new byte[256 + memSize];
        try {
            System.arraycopy(SNA_HEADER.getBytes("UTF-8"), 0, this.storedSnapshot, 0, SNA_HEADER.length());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.storedSnapshot[16] = 1;
        CPC.putWord(this.storedSnapshot, 17, this.z80.getRegisterValue(1));
        CPC.putWord(this.storedSnapshot, 19, this.z80.getRegisterValue(7));
        CPC.putWord(this.storedSnapshot, 21, this.z80.getRegisterValue(5));
        CPC.putWord(this.storedSnapshot, 23, this.z80.getRegisterValue(3));
        this.storedSnapshot[25] = (byte)this.z80.getRegisterValue(14);
        this.storedSnapshot[26] = (byte)this.z80.getRegisterValue(12);
        this.storedSnapshot[27] = (byte)this.z80.getIFF1();
        this.storedSnapshot[28] = (byte)this.z80.getIFF2();
        CPC.putWord(this.storedSnapshot, 29, this.z80.getRegisterValue(9));
        CPC.putWord(this.storedSnapshot, 31, this.z80.getRegisterValue(11));
        CPC.putWord(this.storedSnapshot, 33, this.z80.getRegisterValue(10));
        CPC.putWord(this.storedSnapshot, 35, this.z80.getRegisterValue(13));
        this.storedSnapshot[37] = (byte)this.z80.getIM();
        CPC.putWord(this.storedSnapshot, 38, this.z80.getRegisterValue(2));
        CPC.putWord(this.storedSnapshot, 40, this.z80.getRegisterValue(8));
        CPC.putWord(this.storedSnapshot, 42, this.z80.getRegisterValue(6));
        CPC.putWord(this.storedSnapshot, 44, this.z80.getRegisterValue(4));
        this.storedSnapshot[46] = (byte)this.gateArray.getSelectedInk();
        for (i = 0; i < 17; ++i) {
            this.storedSnapshot[47 + i] = (byte)GateArray.getInks(i);
        }
        this.storedSnapshot[66] = (byte)this.crtc.getSelectedRegister();
        for (i = 0; i < 18; ++i) {
            this.storedSnapshot[67 + i] = (byte)this.crtc.getReg(i);
        }
        this.storedSnapshot[89] = (byte)this.ppi.getControl();
        this.storedSnapshot[86] = (byte)this.ppi.getOutputValue(0);
        this.storedSnapshot[87] = (byte)this.ppi.getOutputValue(1);
        this.storedSnapshot[88] = (byte)this.ppi.getOutputValue(2);
        this.storedSnapshot[90] = (byte)this.psg.getSelectedRegister();
        for (i = 0; i < 16; ++i) {
            this.storedSnapshot[91 + i] = (byte)this.psg.getRegister(i);
        }
        this.storedSnapshot[64] = (byte)this.gateArray.getMode();
        this.storedSnapshot[65] = (byte)(this.gateArray.getRAMBank() & 0x3F);
        this.storedSnapshot[107] = -128;
        byte[] mem = this.memory.getMemory();
        System.arraycopy(mem, 0, this.storedSnapshot, 256, memSize);
        try {
            File out = new File("output.sna");
            int hold = 0;
            while (out.exists()) {
                out = new File("output_" + hold++ + ".sna");
            }
            FileOutputStream os = new FileOutputStream(out);
            os.write(this.storedSnapshot);
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.start();
    }

    public void restoreSNA() {
        if (this.storedSnapshot != null) {
            this.z80.stop();
            this.SNA_Load(this.storedSnapshot);
            this.start();
        }
    }

    public void CDT_Load(String name, byte[] data) throws Exception {
        this.pause = 0;
        int freq = 44100;
        tapesample = null;
        System.gc();
        this.cdt2wav.set(data, freq);
        try {
            tapesample = this.cdt2wav.convert();
        }
        catch (Exception e) {
            tapesample = null;
        }
        if (tapesample == null) {
            tapesample = new byte[0];
        }
        this.tape_delay = 1100000 / freq;
        tapePosition = 0;
        this.play = true;
    }

    public void TapeRelayCheck(int value) {
        this.previousPortValue = value;
        if (value == 16 && !this.relay) {
            this.relay = true;
            System.out.println("Tape relay on... ");
        }
        if ((value & 0x10) == 0 && this.relay) {
            this.stoptape = true;
            this.tapestopper = 1;
        } else {
            this.stoptape = false;
            this.tapestopper = 0;
        }
    }

    public void StopTape() {
        this.relay = false;
        this.stoptape = false;
        System.out.println("Tape relay off... ");
    }

    public void tapeCycle() {
        ++this.pause;
        if (this.pause > 2000000) {
            this.pause = 2000000;
            ++this.playcount;
            if (this.playcount > this.tape_delay) {
                this.playcount = 0;
                if (tapePosition >= tapesample.length - 4) {
                    this.play = false;
                    tapePosition = 0;
                    this.pause = 0;
                    return;
                }
                this.portB = tapesample[tapePosition];
                ++tapePosition;
                this.portB = 128 - this.portB;
                this.tapesound = 16 * this.portB / 128;
                Display.ledOn = this.portB == 0;
                AY_3_8910.digicount = 10;
                AY_3_8910.digiblast = this.psg.readRegister(7) == 63 && (this.psg.readRegister(8) == 0 || this.psg.readRegister(9) == 0 || this.psg.readRegister(10) == 0);
                AY_3_8910.blasterA = AY_3_8910.blasterB = this.tapesound;
            }
        }
    }

    public void CSWLoad(String name, byte[] data) {
        tapesample = null;
        System.gc();
        this.pause = 0;
        int length = data.length;
        int frequency = CPC.getWord(data, 25);
        if (data[27] != 1) {
            return;
        }
        int polarity = 127 + data[28] % 2;
        boolean odd = (data[28] + 2) % 2 == 0;
        this.tape_delay = 1010000 / frequency;
        int size = 0;
        int i = 32;
        while (i < length) {
            int a;
            if ((a = data[i++] & 0xFF) == 0) {
                a = data[i++] + (data[i++] << 8) + (data[i++] << 16) + (data[i++] << 24);
            }
            while (a-- > 0) {
                ++size;
            }
        }
        tapesample = new byte[size + 1];
        int tapecount = 0;
        i = 32;
        while (i < length) {
            int a;
            if ((a = data[i++] & 0xFF) == 0) {
                a = data[i++] + (data[i++] << 8) + (data[i++] << 16) + (data[i++] << 24);
            }
            if (!odd) {
                polarity = 255 - polarity;
            }
            while (a-- > 0) {
                CPC.tapesample[tapecount] = (byte)(polarity ^ 0x80);
                CPC.tapesample[tapecount] = tapesample[tapecount] == 0 ? -38 : 38;
                ++tapecount;
            }
            if (!odd) continue;
            polarity = 255 - polarity;
        }
        this.play = true;
    }
}

