/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc.plus;

import JCPC.core.Util;
import JCPC.core.device.Device;
import JCPC.core.device.crtc.Basic6845;
import JCPC.core.device.sound.AY_3_8910;
import JCPC.system.cpc.CPC;
import JCPC.system.cpc.GateArray;
import JCPC.system.cpc.Z80;
import JCPC.system.cpc.plus.ASICSecondaryScreenAddress;
import JCPC.system.cpc.plus.ASIC_DATA;
import JCPC.system.cpc.plus.ASIC_DMA_CHANNEL;

public class ASIC
extends Device {
    public boolean DMA_Sound_Enabled = true;
    public ASIC_DATA ASIC_Data = new ASIC_DATA();
    boolean nodma = false;
    int ASIC_DCSR2;
    protected boolean ASIC_InterruptRequest;
    protected final int SEQUENCE_SYNCHRONISE_FIRST_BYTE = 0;
    protected final int SEQUENCE_SYNCHRONISE_SECOND_BYTE = 1;
    protected final int SEQUENCE_RECOGNISE = 2;
    protected final int SEQUENCE_GET_LOCK_STATUS = 3;
    protected final int SEQUENCE_SYNCHRONISE_THIRD_BYTE = 4;
    protected int CurrentSequencePos;
    protected int RecogniseSequenceState;
    protected int selInk = 0;
    protected boolean DEBUG = false;
    CPC cpc;
    Z80 z80;
    AY_3_8910 psg;
    boolean asicLocked = true;
    boolean asicRamActive = false;
    int lowRomLoc;
    int lowRomPage;
    protected final int[] plusPalette = new int[]{1638, 1638, 3846, 4086, 6, 246, 1542, 1782, 246, 4086, 4080, 4095, 240, 255, 1776, 1791, 6, 3846, 3840, 3855, 0, 15, 1536, 1551, 102, 3942, 3936, 3951, 96, 111, 1632, 1647};
    protected int[][] RGB = new int[32][2];
    GateArray gateArray;
    Basic6845 crtc;
    int IV = 255;
    int rambank;
    protected int readport;
    protected int writeport;
    protected int[] ASIC_EnableSequence = new int[]{255, 119, 179, 81, 168, 212, 98, 57, 156, 70, 43, 21, 138, 205};
    int CRTC_LineCounter;
    int CRTC_RasterCounter;
    int rc;
    int lc;
    int line;
    int oldVector;
    public int romconfig;
    ASICSecondaryScreenAddress ASIC_SecondaryScreenAddress = new ASICSecondaryScreenAddress();
    public final int ASIC_UNUSED_RAM_DATA = 176;
    int olddata = -1;
    int lockvalue = 205;

    public ASIC(CPC cpc, GateArray gateArray, Basic6845 crtc, AY_3_8910 psg, Z80 z80) {
        super("Amstrad 40489 ASIC");
        this.cpc = cpc;
        this.gateArray = gateArray;
        this.crtc = crtc;
        this.psg = psg;
        this.z80 = z80;
    }

    @Override
    public void reset() {
        int i;
        super.reset();
        this.ASIC_InterruptRequest = false;
        this.romconfig = 0;
        System.out.println("ASIC reset");
        for (i = 0; i < 16; ++i) {
            this.ASIC_Data.Sprites[i].SpriteMag = -1;
            this.ASIC_Data.Sprites[i].SpriteX.SpriteX_Bh = -1;
            this.ASIC_Data.Sprites[i].SpriteX.SpriteX_Bl = -1;
            this.ASIC_Data.Sprites[i].SpriteY.SpriteY_Bh = -1;
            this.ASIC_Data.Sprites[i].SpriteY.SpriteY_Bl = -1;
            this.cpc.memory.writeASIC(24576 + (i << 3) + 4, Util.random(255));
        }
        this.ASIC_Data.ASIC_RasterInterruptLine = 0;
        this.ASIC_Data.ASIC_RasterSplitLine = 0;
        this.olddata = -1;
        this.ASIC_SetIVR(this.IV);
        System.out.println("Interruptvector = " + this.ASIC_Data.ASIC_InterruptVector);
        int vector = this.ASIC_CalculateInterruptVector();
        this.z80.setInterruptVector(vector);
        this.gateArray.ASIC_SetSoftScrollRegister(0);
        this.cpc.memory.writeASIC(27663, 0);
        for (i = 0; i < 8; ++i) {
            this.cpc.memory.writeASIC(26632 + i, 255);
        }
        this.RecogniseSequenceState = 0;
        this.ASIC_DCSR2 = 0;
        this.ASIC_Data.InterruptRequest = 0;
        this.ASIC_UpdateRAMWithInternalDCSR();
        this.asicLocked = true;
        this.asicRamActive = false;
        this.selInk = 0;
        this.lowRomLoc = 0;
        this.lowRomPage = 0;
        this.setModeAndROMEnable();
    }

    public void setRasterInterruptLine(int line) {
        this.ASIC_Data.ASIC_RasterInterruptLine = line & 0xFF;
    }

    public void setRasterSplitLine(int line) {
        this.ASIC_Data.ASIC_RasterSplitLine = line & 0xFF;
    }

    public void setInterruptVectorFromSNA(int IV) {
        this.ASIC_SetIVR(IV);
        System.out.println("Interruptvector = " + this.ASIC_Data.ASIC_InterruptVector);
        int vector = this.ASIC_CalculateInterruptVector();
        this.z80.setInterruptVector(vector);
    }

    protected void setPal(int ink, int value) {
        this.RGB[ink][0] = value & 0xFF;
        this.RGB[ink][1] = value >> 8 & 0xFF;
    }

    public boolean isLocked() {
        return this.asicLocked;
    }

    @Override
    public void writePort(int port, int value) {
        if (!this.cpc.memory.plus) {
            return;
        }
        if ((port & 0x8000) == 0) {
            this.readport = this.cpc.memory.readByte(this.z80.getPC() - 1);
            this.writeport = port;
            if ((value & 0xE0) == 160) {
                this.lowRomPage = value & 7;
                switch (value >> 3 & 3) {
                    case 0: {
                        this.CurrentSequencePos = 0;
                        this.RecogniseSequenceState = 0;
                        this.asicRamActive = false;
                        this.lowRomLoc = 0;
                        this.cpc.memory.enableAsicRam(this.asicRamActive, this.lowRomLoc, this.lowRomPage);
                        if (!this.DEBUG) break;
                        System.out.println("case 0: &0000-&3fff - asic RAM disabled");
                        break;
                    }
                    case 1: {
                        this.CurrentSequencePos = 0;
                        this.RecogniseSequenceState = 0;
                        this.asicRamActive = false;
                        this.lowRomLoc = 2;
                        this.cpc.memory.enableAsicRam(this.asicRamActive, this.lowRomLoc, this.lowRomPage);
                        if (!this.DEBUG) break;
                        System.out.println("case 1: &4000-&7fff - asic RAM disabled");
                        break;
                    }
                    case 2: {
                        this.CurrentSequencePos = 0;
                        this.RecogniseSequenceState = 0;
                        this.asicRamActive = false;
                        this.lowRomLoc = 4;
                        this.cpc.memory.enableAsicRam(this.asicRamActive, this.lowRomLoc, this.lowRomPage);
                        if (!this.DEBUG) break;
                        System.out.println("case 2: &8000-&bfff - asic RAM disabled");
                        break;
                    }
                    case 3: {
                        this.CurrentSequencePos = 0;
                        this.RecogniseSequenceState = 0;
                        this.asicRamActive = true;
                        this.lowRomLoc = 0;
                        this.cpc.memory.enableAsicRam(this.asicRamActive, this.lowRomLoc, this.lowRomPage);
                        if (!this.DEBUG) break;
                        System.out.println("case 2: &0000-&3fff - asic RAM enabled");
                    }
                }
            } else if ((value & 0x80) == 0) {
                if ((value & 0x40) == 0) {
                    this.selInk = (value &= 0x1F) < 16 ? value : 16;
                } else {
                    this.setPal(this.selInk, this.plusPalette[value & 0x1F]);
                    this.cpc.memory.writeASIC(25600 + (this.selInk << 1), this.RGB[this.selInk][0]);
                    this.cpc.memory.writeASIC(25601 + (this.selInk << 1), this.RGB[this.selInk][1]);
                    this.gateArray.setPlusPalette(this.selInk, (this.RGB[this.selInk][0] >> 4 & 0xF) << 4, (this.RGB[this.selInk][1] & 0xF) << 4, (this.RGB[this.selInk][0] & 0xF) << 4);
                }
            } else if ((value & 0x40) == 0) {
                this.romconfig = value;
                this.setModeAndROMEnable();
            } else {
                this.cpc.memory.setRAMBank(value);
                this.rambank = value;
            }
        } else {
            this.cpc.memory.setUpperROM(value & 0xFF);
        }
    }

    @Override
    public int readPort(int port) {
        if (port >= 32512 && port < 32768) {
            this.writePort(this.writeport, this.readport);
            return this.readport;
        }
        System.err.println("bad port read on " + Util.hex((short)port));
        return 255;
    }

    public boolean ASIC_RasterSplitLineMatch(int CRTC_LineCounter, int CRTC_RasterCounter) {
        if (this.asicLocked) {
            return false;
        }
        return this.ASIC_LineMatch(this.ASIC_Data.ASIC_RasterSplitLine, CRTC_LineCounter, CRTC_RasterCounter, 31);
    }

    public void ASIC_RefreshRasterInterrupt() {
        if (!this.asicLocked && this.ASIC_Data.ASIC_RasterInterruptLine != 0 && this.ASIC_Data.ASIC_InterruptVector == this.IV) {
            this.CRTC_LineCounter = this.crtc.LineCounter;
            this.CRTC_RasterCounter = this.crtc.RasterCounter;
            int CurrLine = (this.CRTC_LineCounter & 0x3F) << 3 | this.CRTC_RasterCounter & 7;
            if (CurrLine == this.ASIC_Data.ASIC_RasterInterruptLine) {
                this.z80.Z80_SetInterruptRequest();
                this.ASIC_InterruptRequest = true;
                return;
            }
        }
        this.ASIC_TriggerInterrupt();
    }

    public void ASIC_HSync() {
        this.CRTC_LineCounter = this.crtc.LineCounter;
        this.CRTC_RasterCounter = this.crtc.RasterCounter;
        if (!this.asicLocked) {
            this.ASIC_DoDMA();
            if (this.ASIC_LineMatch(this.ASIC_Data.ASIC_RasterInterruptLine, this.CRTC_LineCounter, this.CRTC_RasterCounter, 63)) {
                this.ASIC_SetRasterInterrupt();
                this.z80.Z80_SetInterruptRequest();
                this.ASIC_InterruptRequest = true;
                return;
            }
        }
        this.ASIC_TriggerInterrupt();
    }

    public boolean ASIC_LineMatch(int inLine, int CRTC_LineCounter, int CRTC_RasterCounter, int mask) {
        if (inLine == 0) {
            return false;
        }
        return inLine == ((CRTC_LineCounter & mask) << 3 | CRTC_RasterCounter & 7);
    }

    private void ASIC_UpdateRAMWithInternalDCSR() {
        int thisDCSR = this.ASIC_Data.InterruptRequest & 0x7F | this.ASIC_DCSR2;
        for (int i = 15; i >= 0; --i) {
            this.cpc.memory.writeASIC(27648 + i, thisDCSR);
        }
    }

    public void ASIC_TriggerInterrupt() {
        this.ASIC_InterruptRequest = false;
        if ((this.ASIC_Data.InterruptRequest & 0xF0) != 0) {
            int vector = this.ASIC_CalculateInterruptVector();
            this.z80.setInterruptVector(vector);
            this.z80.Z80_SetInterruptRequest();
            this.ASIC_InterruptRequest = true;
        }
    }

    public int ASIC_GetDataInterruptRequest() {
        return this.ASIC_Data.InterruptRequest;
    }

    public boolean ASIC_GetInterruptRequest() {
        return (this.ASIC_Data.InterruptRequest & 0xF0) != 0;
    }

    int ASIC_CalculateInterruptVector() {
        int Vector2 = 0;
        if ((this.ASIC_Data.InterruptRequest & 0x40) != 0) {
            Vector2 = 4;
        }
        if ((this.ASIC_Data.InterruptRequest & 0x20) != 0) {
            Vector2 = 2;
        }
        if ((this.ASIC_Data.InterruptRequest & 0x10) != 0) {
            Vector2 = 0;
        }
        if ((this.ASIC_Data.InterruptRequest & 0x80) != 0) {
            Vector2 = 6;
        }
        return (this.ASIC_Data.ASIC_InterruptVector & 0xF8) + Vector2;
    }

    public void setModeAndROMEnable() {
        this.cpc.memory.setLowerEnabled((this.romconfig & 4) == 0);
        this.cpc.memory.setUpperEnabled((this.romconfig & 8) == 0);
        if ((this.romconfig & 0x10) != 0) {
            this.cpc.memory.setSecondaryRomMapping(this.ASIC_GateArray_CheckForSecondaryRomMapping(this.romconfig));
            if (this.asicLocked) {
                this.gateArray.GateArray_ClearInterrupt();
            }
        }
        this.cpc.memory.remap();
        this.gateArray.newMode = this.romconfig & 3;
    }

    public void setModeAndROMEnable2() {
        this.cpc.memory.setLowerEnabled((this.romconfig & 4) == 0);
        this.cpc.memory.setUpperEnabled((this.romconfig & 8) == 0);
    }

    boolean ASIC_GateArray_CheckForSecondaryRomMapping(int Function2) {
        return !this.asicLocked && (Function2 & 0xE0) == 160;
    }

    void ASIC_DMA_EnableChannel(int ChannelIndex) {
    }

    void ASIC_DMA_DisableChannel(int ChannelIndex) {
        ASIC_DMA_CHANNEL[] pChannel = this.ASIC_Data.pChannel;
        pChannel[ChannelIndex].PrescaleCount = 0;
        pChannel[ChannelIndex].PauseCount = 0;
        pChannel[ChannelIndex].PauseActive = false;
        pChannel[ChannelIndex].RepeatCount = 0;
    }

    void ASIC_DMA_EnableChannels(int Data2) {
        if ((Data2 & 1) != 0) {
            this.ASIC_DMA_EnableChannel(0);
        }
        if ((Data2 & 2) != 0) {
            this.ASIC_DMA_EnableChannel(1);
        }
        if ((Data2 & 4) != 0) {
            this.ASIC_DMA_EnableChannel(2);
        }
    }

    void ASIC_DMA_DisableChannels(int Data2) {
        if ((Data2 & 1) == 0) {
            this.ASIC_DMA_DisableChannel(0);
        }
        if ((Data2 & 2) == 0) {
            this.ASIC_DMA_DisableChannel(1);
        }
        if ((Data2 & 4) == 0) {
            this.ASIC_DMA_DisableChannel(2);
        }
    }

    public void ASIC_ClearDMAInterruptsManual(int Data2) {
        this.ASIC_Data.InterruptRequest &= ~(Data2 & 0x70);
    }

    public void ASIC_ClearDMAInterruptsAutomatic() {
        if ((this.ASIC_Data.InterruptRequest & 0x10) != 0) {
            this.ASIC_Data.InterruptRequest &= 0xFFFFFFEF;
            return;
        }
        if ((this.ASIC_Data.InterruptRequest & 0x20) != 0) {
            this.ASIC_Data.InterruptRequest &= 0xFFFFFFDF;
            return;
        }
        if ((this.ASIC_Data.InterruptRequest & 0x40) != 0) {
            this.ASIC_Data.InterruptRequest &= 0xFFFFFFBF;
        }
    }

    void ASIC_ClearDMAInterrupts() {
        this.ASIC_ClearDMAInterruptsAutomatic();
        this.ASIC_UpdateRAMWithInternalDCSR();
    }

    public boolean ASIC_RasterIntEnabled() {
        return this.ASIC_Data.ASIC_RasterInterruptLine != 0;
    }

    public void ASIC_SetRasterInterrupt() {
        this.ASIC_DCSR2 = 128;
        this.ASIC_Data.InterruptRequest |= 0x80;
        this.ASIC_TriggerInterrupt();
    }

    public void ASIC_ClearRasterInterrupt() {
        this.ASIC_Data.InterruptRequest &= 0x7F;
        this.ASIC_TriggerInterrupt();
    }

    public int ASIC_GetDCSR() {
        return this.ASIC_Data.InterruptRequest & 0x7F | this.ASIC_DCSR2;
    }

    public int ASIC_ScreenMA() {
        return this.ASIC_SecondaryScreenAddress.Addr.getAddr_W();
    }

    public void setAsicScreenMA(int ma) {
        this.ASIC_SecondaryScreenAddress.Addr.writeAddr(ma);
    }

    public void setDMARepeatCount(int ChannelIndex, int Data2) {
        ASIC_DMA_CHANNEL[] pChannel = this.ASIC_Data.pChannel;
        pChannel[ChannelIndex].RepeatCount = Data2 & 0xFFFF;
    }

    public void setDMALoopStart(int ChannelIndex, int Data2) {
        ASIC_DMA_CHANNEL[] pChannel = this.ASIC_Data.pChannel;
        pChannel[ChannelIndex].LoopStart = Data2 & 0xFFFF;
    }

    public void setDMAPauseCount(int ChannelIndex, int Data2) {
        ASIC_DMA_CHANNEL[] pChannel = this.ASIC_Data.pChannel;
        pChannel[ChannelIndex].PauseCount = Data2 & 0xFFFF;
    }

    public void setDMAPrescalarCount(int ChannelIndex, int Data2) {
        ASIC_DMA_CHANNEL[] pChannel = this.ASIC_Data.pChannel;
        pChannel[ChannelIndex].PrescaleCount = Data2 & 0xFFFF;
    }

    public void setDMAPrescale(int ChannelIndex, int Data2) {
        this.ASIC_Data.DMA[ChannelIndex].Prescale = Data2 & 0xFF;
    }

    public void setDMAChannelAddress(int ChannelIndex, int High, int Low) {
        this.ASIC_Data.DMA[ChannelIndex].Addr.Addr_B.l = Low & 0xFE;
        this.ASIC_Data.DMA[ChannelIndex].Addr.Addr_B.h = High & 0xFF;
    }

    public void setDMAControl(int Data2) {
        this.ASIC_ClearDMAInterruptsManual(Data2 &= 0xFF);
        if ((Data2 & 7) != 7) {
            this.ASIC_DMA_DisableChannels(Data2);
        }
        this.ASIC_Data.InterruptRequest = this.ASIC_Data.InterruptRequest & 0x7F | Data2 & 7;
        this.ASIC_UpdateRAMWithInternalDCSR();
    }

    public void ASIC_WriteRam(int Addr, int Data2) {
        if ((Addr & 0xC000) != 16384) {
            return;
        }
        Data2 &= 0xFF;
        if (((Addr &= 0x3FFF) & 0xF000) == 0) {
            this.cpc.memory.writeASIC(Addr, Data2 & 0xF);
            return;
        }
        if ((Addr & 0x3F80) == 8192) {
            int SpriteIndex = (Addr & 0x78) >> 3;
            switch (Addr & 7) {
                case 0: {
                    if (this.ASIC_Data.Sprites[SpriteIndex].SpriteX.SpriteX_Bl == Data2) {
                        return;
                    }
                    this.ASIC_Data.Sprites[SpriteIndex].SpriteX.SpriteX_Bl = Data2;
                    this.cpc.memory.writeASIC(Addr + 4, Data2);
                    break;
                }
                case 1: {
                    int LocalData;
                    int PokeData = LocalData = Data2 & 3;
                    if (PokeData == 3) {
                        PokeData = 255;
                    }
                    this.cpc.memory.writeASIC(Addr, PokeData);
                    this.cpc.memory.writeASIC(Addr + 4, PokeData);
                    if (this.ASIC_Data.Sprites[SpriteIndex].SpriteX.SpriteX_Bh == LocalData) {
                        return;
                    }
                    this.ASIC_Data.Sprites[SpriteIndex].SpriteX.SpriteX_Bh = LocalData;
                    break;
                }
                case 2: {
                    if (this.ASIC_Data.Sprites[SpriteIndex].SpriteY.SpriteY_Bl == Data2) {
                        return;
                    }
                    this.ASIC_Data.Sprites[SpriteIndex].SpriteY.SpriteY_Bl = Data2;
                    this.cpc.memory.writeASIC(Addr + 4, Data2);
                    break;
                }
                case 3: {
                    int LocalData;
                    int PokeData = LocalData = Data2 & 1;
                    if (PokeData != 0) {
                        PokeData = 255;
                    }
                    this.cpc.memory.writeASIC(Addr, PokeData);
                    this.cpc.memory.writeASIC(Addr + 4, PokeData);
                    if (this.ASIC_Data.Sprites[SpriteIndex].SpriteY.SpriteY_Bh == LocalData) {
                        return;
                    }
                    this.ASIC_Data.Sprites[SpriteIndex].SpriteY.SpriteY_Bh = LocalData;
                    break;
                }
                default: {
                    if (this.ASIC_Data.Sprites[SpriteIndex].SpriteMag == (Data2 & 0xF)) {
                        this.cpc.memory.writeASIC(Addr, this.cpc.memory.readASIC(Addr & 0x3FFB));
                        return;
                    }
                    this.ASIC_Data.Sprites[SpriteIndex].SpriteMag = Data2 & 0xF;
                    this.cpc.memory.setMag(SpriteIndex, this.ASIC_Data.Sprites[SpriteIndex].SpriteMag);
                    this.cpc.memory.writeASIC(Addr, this.cpc.memory.readASIC(Addr & 0x3FFB));
                }
            }
            this.ASIC_SetupSpriteRenderInfo(SpriteIndex);
            return;
        }
        if ((Addr & 0xFFF8) == 10240) {
            switch (Addr & 7) {
                case 0: {
                    this.setRasterInterruptLine(Data2);
                    if (this.ASIC_LineMatch(this.ASIC_Data.ASIC_RasterInterruptLine & 0x3F, this.CRTC_LineCounter, this.CRTC_RasterCounter, 63)) {
                        this.ASIC_SetRasterInterrupt();
                    }
                    return;
                }
                case 1: {
                    this.setRasterSplitLine(Data2);
                    this.crtc.ASICCRTC_ScreenSplit();
                    return;
                }
                case 2: {
                    this.ASIC_SecondaryScreenAddress.Addr.Addr_B.h = Data2;
                    return;
                }
                case 3: {
                    this.ASIC_SecondaryScreenAddress.Addr.Addr_B.l = Data2;
                    return;
                }
                case 4: {
                    this.gateArray.ASIC_SetSoftScrollRegister(Data2 & 0xFF);
                    return;
                }
                case 5: {
                    if (this.olddata != Data2) {
                        System.out.println("Write: Interruptvector = " + Data2);
                        this.olddata = Data2;
                    }
                    this.ASIC_SetIVR(Data2);
                    int vector = this.ASIC_CalculateInterruptVector();
                    this.z80.setInterruptVector(vector);
                    this.ASIC_InterruptRequest = true;
                    return;
                }
            }
            return;
        }
        if ((Addr & 0x3FF8) == 10248) {
            return;
        }
        if ((Addr & 0xFFC0) == 9216) {
            int Index = ((Addr &= 0x3FFE) & 0x3F) >> 1;
            this.cpc.memory.writeASIC(Addr + 1, this.cpc.memory.readASIC(Addr + 1) & 0xF);
            int PackedRGBLookup = this.cpc.memory.readASIC(Addr) | this.cpc.memory.readASIC(Addr + 1) << 8;
            this.setPal(Index, PackedRGBLookup);
            this.gateArray.setPlusPalette(Index, (this.RGB[Index][0] >> 4 & 0xF) << 4, (this.RGB[Index][1] & 0xF) << 4, (this.RGB[Index][0] & 0xF) << 4);
            if ((Addr & 1) == 0) {
                // empty if block
            }
            return;
        }
        if (this.nodma) {
            return;
        }
        if ((Addr & 0xFFF0) == 11264) {
            if (Addr == 11279) {
                this.ASIC_ClearDMAInterruptsManual(Data2);
                if ((Data2 & 7) != 7) {
                    this.ASIC_DMA_DisableChannels(Data2);
                }
                this.ASIC_Data.InterruptRequest = this.ASIC_Data.InterruptRequest & 0x7F | Data2 & 7;
                this.ASIC_UpdateRAMWithInternalDCSR();
                return;
            }
            int ChannelIndex = (Addr & 0xF) >> 2;
            if (ChannelIndex > 2) {
                System.err.println("Channel?!?" + ChannelIndex + "," + Data2);
                return;
            }
            switch (Addr & 3) {
                case 0: {
                    this.ASIC_Data.DMA[ChannelIndex].Addr.Addr_B.l = Data2 & 0xFE;
                    break;
                }
                case 1: {
                    this.ASIC_Data.DMA[ChannelIndex].Addr.Addr_B.h = Data2;
                    break;
                }
                case 2: {
                    this.ASIC_Data.DMA[ChannelIndex].Prescale = Data2;
                }
            }
            this.ASIC_UpdateRAMWithInternalDCSR();
            return;
        }
        this.cpc.memory.writeASIC(Addr, 176);
    }

    private void ASIC_SetupSpriteRenderInfo(int SpriteIndex) {
        this.cpc.memory.setSpriteX(SpriteIndex, this.ASIC_Data.Sprites[SpriteIndex].SpriteX.getAddr_W());
        this.cpc.memory.setSpriteY(SpriteIndex, this.ASIC_Data.Sprites[SpriteIndex].SpriteY.getAddr_W());
        this.cpc.memory.setSpritePos(SpriteIndex);
    }

    public void ASIC_SetIVR(int IVR) {
        this.ASIC_Data.ASIC_InterruptVector = IVR;
    }

    public void ASIC_AcknowledgeInterrupt() {
        if ((this.ASIC_Data.InterruptRequest & 0x80) == 0) {
            this.ASIC_DCSR2 = 0;
            if ((this.ASIC_Data.ASIC_InterruptVector & 1) == 0) {
                this.ASIC_ClearDMAInterrupts();
            }
        } else {
            if (this.ASIC_Data.ASIC_RasterInterruptLine != 0) {
                this.ASIC_InterruptRequest = false;
            }
            this.ASIC_Data.InterruptRequest &= 0xFFFFFF7F;
            this.ASIC_DCSR2 = 128;
            this.ASIC_ClearRasterInterrupt();
        }
        this.ASIC_UpdateRAMWithInternalDCSR();
        this.ASIC_DCSR2 = 0;
    }

    void ASIC_DoDMA() {
        if ((this.ASIC_Data.InterruptRequest & 7) == 0) {
            return;
        }
        if ((this.ASIC_Data.InterruptRequest & 1) != 0) {
            this.ASIC_DMA_HandleChannel(0);
        }
        if ((this.ASIC_Data.InterruptRequest & 2) != 0) {
            this.ASIC_DMA_HandleChannel(1);
        }
        if ((this.ASIC_Data.InterruptRequest & 4) != 0) {
            this.ASIC_DMA_HandleChannel(2);
        }
    }

    int ASIC_DMA_GetOpcode(int Addr) {
        return this.Z80_RD_BASE_WORD(Addr);
    }

    int Z80_RD_BASE_WORD(int Addr) {
        int a = this.Z80_RD_BASE_BYTE(Addr) | this.Z80_RD_BASE_BYTE(Addr + 1) << 8;
        return a;
    }

    int Z80_RD_BASE_BYTE(int Addr) {
        return this.cpc.memory.readLowByte(Addr) & 0xFF;
    }

    int ASIC_DMA_GetChannelPrescale(int ChannelIndex) {
        return this.ASIC_Data.DMA[ChannelIndex].Prescale;
    }

    int ASIC_DMA_GetChannelAddr(int ChannelIndex) {
        return this.ASIC_Data.DMA[ChannelIndex].Addr.getAddr_W();
    }

    void ASIC_DMA_WriteChannelAddr(int ChannelIndex, int Addr) {
        this.ASIC_Data.DMA[ChannelIndex].Addr.writeAddr_W(Addr & 0xFFFF);
    }

    void ASIC_DMA_ExecuteCommand(int ChannelIndex) {
        ASIC_DMA_CHANNEL[] pChannel = this.ASIC_Data.pChannel;
        int Addr = this.ASIC_Data.DMA[ChannelIndex].Addr.getAddr_W();
        int Command = this.ASIC_DMA_GetOpcode(Addr & 0xFFFE);
        int CommandOpcode = (Command & 0x7000) >> 12;
        Addr += 2;
        if (CommandOpcode == 0) {
            int Register2 = Command >> 8 & 0xF;
            int Data2 = Command & 0xFF;
            if (this.DMA_Sound_Enabled) {
                this.psg.setRegister(Register2, Data2);
            }
        } else {
            int PauseCount;
            if ((CommandOpcode & 1) != 0 && (PauseCount = Command & 0xFFF) - 1 != 0) {
                if (PauseCount - 1 >= 0) {
                    pChannel[ChannelIndex].PauseCount = PauseCount - 1;
                }
                pChannel[ChannelIndex].PrescaleCount = 0;
                pChannel[ChannelIndex].PauseActive = true;
            }
            if ((CommandOpcode & 2) != 0) {
                pChannel[ChannelIndex].RepeatCount = Command & 0xFFF;
                pChannel[ChannelIndex].LoopStart = Addr & 0xFFFF;
            }
            if ((CommandOpcode & 4) != 0) {
                if ((Command & 1) != 0 && pChannel[ChannelIndex].RepeatCount != 0) {
                    --pChannel[ChannelIndex].RepeatCount;
                    Addr = pChannel[ChannelIndex].LoopStart;
                }
                if ((Command & 0x10) != 0) {
                    this.ASIC_Data.InterruptRequest |= 1 << 6 - ChannelIndex;
                }
                if ((Command & 0x20) != 0) {
                    this.ASIC_Data.InterruptRequest &= ~(1 << ChannelIndex);
                }
            }
        }
        this.ASIC_DMA_WriteChannelAddr(ChannelIndex, Addr);
        this.ASIC_UpdateRAMWithInternalDCSR();
    }

    void ASIC_DMA_HandleChannel(int ChannelIndex) {
        ASIC_DMA_CHANNEL[] pChannel = this.ASIC_Data.pChannel;
        if (pChannel[ChannelIndex].PauseActive) {
            if (pChannel[ChannelIndex].PrescaleCount == 0) {
                pChannel[ChannelIndex].PrescaleCount = this.ASIC_Data.DMA[ChannelIndex].Prescale;
                if (pChannel[ChannelIndex].PauseCount == 0) {
                    pChannel[ChannelIndex].PauseActive = false;
                } else {
                    --pChannel[ChannelIndex].PauseCount;
                }
            } else {
                --pChannel[ChannelIndex].PrescaleCount;
            }
        }
        if (!pChannel[ChannelIndex].PauseActive) {
            this.ASIC_DMA_ExecuteCommand(ChannelIndex);
        }
    }

    public void ASIC_EnableDisable(int value) {
        value &= 0xFF;
        switch (this.RecogniseSequenceState) {
            case 0: {
                if (value == 0) break;
                this.RecogniseSequenceState = 1;
                break;
            }
            case 1: {
                if (value != 0) break;
                this.RecogniseSequenceState = 4;
                break;
            }
            case 4: {
                if (value == 255) {
                    this.RecogniseSequenceState = 2;
                    this.CurrentSequencePos = 1;
                    break;
                }
                if (value == 0) break;
                this.RecogniseSequenceState = 1;
                break;
            }
            case 2: {
                if (value == 0) {
                    this.RecogniseSequenceState = 4;
                    break;
                }
                ++this.CurrentSequencePos;
                if (this.CurrentSequencePos != this.ASIC_EnableSequence.length) break;
                this.lockvalue = value;
                if (this.lockvalue != 205) {
                    this.checkLockStatus(value);
                }
                this.RecogniseSequenceState = 3;
                break;
            }
            case 3: {
                this.checkLockStatus(value);
            }
        }
    }

    public void checkLockStatus(int value) {
        if (this.asicLocked != (this.lockvalue != 205)) {
            boolean bl = this.asicLocked = this.lockvalue != 205;
            if (!this.asicLocked) {
                this.setModeAndROMEnable();
            }
            System.out.println("ASIC " + (this.asicLocked ? "L" : "Unl") + "ocked - " + Util.hex((byte)this.lockvalue));
            this.lockvalue = 205;
            this.cpc.memory.asiclocked = this.asicLocked;
        }
        this.RecogniseSequenceState = value != 0 ? 1 : 0;
    }
}

