/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Card;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;

public class PCPoker
extends Applet
implements Runnable,
MouseListener {
    int width;
    int height;
    int card_width;
    protected Card[] pcCards = new Card[5];
    protected Thread pcThread;
    int score;
    int bet;
    int play_state = 0;
    int betx0;
    int betx1;
    int dealx0;
    int dealy0;
    int dealx1;
    int dealy1;
    protected Random pcRandom = new Random();
    protected int[] int_pccards = new int[10];
    BufferedImage offScreenImage;
    Graphics offScreengg;
    String winMessage = "";
    public int self_play = 1;
    FontMetrics localFontMetrics;
    long sleep = 15L;
    int[] humancards = new int[5];
    int[] humancolors = new int[5];
    boolean reshufflesecond;
    boolean reshufflefirst;
    int[] arrayOfInt1 = new int[5];
    int[] arrayOfInt2 = new int[5];
    int[] arrayOfInt3 = new int[5];
    int[] arrayOfInt4 = new int[5];
    int[] arrayOfInt5 = new int[4];
    public int scores;
    public int endscores;

    public void setSelfPlay(boolean self) {
        this.self_play = self ? 1 : 0;
    }

    @Override
    public void init() {
        this.width = 320;
        this.height = 200;
        this.offScreenImage = new BufferedImage(this.width, this.height, 1);
        this.offScreengg = this.offScreenImage.getGraphics();
        this.localFontMetrics = this.offScreengg.getFontMetrics();
        this.card_width = 275;
        this.bet = 5;
        this.dealx0 = this.width - this.localFontMetrics.stringWidth("Deal") - 8;
        this.dealx1 = this.width - 2;
        this.dealy0 = this.height - 25;
        this.dealy1 = this.height - 8;
        this.betx0 = this.dealx0 - this.localFontMetrics.stringWidth("Change Bet") - 8;
        this.betx1 = this.dealx0 - 4;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addMouseListener(this);
    }

    @Override
    public void start() {
        this.updateOffscreen();
        this.pcThread = new Thread(this);
        this.pcThread.start();
    }

    public void PCdealStart() {
        int i;
        for (i = 0; i < 5; ++i) {
            if (this.pcCards[i] == null) continue;
            this.pcCards[i] = null;
            this.updateOffscreen();
            this.paint(this.getGraphics());
            try {
                Thread.sleep(this.sleep);
                continue;
            }
            catch (Exception localException1) {
                System.out.println("Error: " + localException1.toString());
            }
        }
        i = 0;
        block9: for (i = 0; i < 10; ++i) {
            int k = this.pcRandom.nextInt() % 52;
            if (k < 0) {
                k = -k;
            }
            this.int_pccards[i] = k;
            for (int j = 0; j < i; ++j) {
                if (this.int_pccards[j] != k) continue;
                --i;
                continue block9;
            }
        }
        for (i = 0; i < 5; ++i) {
            this.pcCards[i] = new Card(50, 100, this.int_pccards[i] % 4, this.int_pccards[i] / 4 + 2);
            this.pcCards[i].suggested = 0;
            this.updateOffscreen();
            this.paint(this.getGraphics());
            try {
                Thread.sleep(this.sleep);
                continue;
            }
            catch (Exception localException2) {
                System.out.println("Error: " + localException2.toString());
            }
        }
        for (i = 0; i < 5; ++i) {
            if (this.pcCards[i] != null) {
                this.pcCards[i].flipped = 1;
            }
            this.updateOffscreen();
            this.paint(this.getGraphics());
            try {
                Thread.sleep(this.sleep);
                continue;
            }
            catch (Exception localException3) {
                System.out.println("Error: " + localException3.toString());
            }
        }
        this.reshufflefirst = false;
        try {
            for (i = 0; i < 5; ++i) {
                for (int p = 0; p < 5; ++p) {
                    if (this.humancards[p] != this.pcCards[i].getcardValue() || this.humancolors[p] != this.pcCards[i].getcardColor()) continue;
                    this.reshufflefirst = true;
                    break;
                }
                if (this.reshufflefirst) break;
            }
            for (i = 0; i < 5; ++i) {
                for (int p = 0; p < 5; ++p) {
                    if (this.humancards[p] != this.pcCards[i].getcardValue() || this.humancolors[p] != this.pcCards[i].getcardColor()) continue;
                    this.reshufflefirst = true;
                    break;
                }
                if (!this.reshufflefirst) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.reshufflefirst = true;
        }
        if (!this.reshufflefirst) {
            this.suggest();
            this.updateOffscreen();
            this.paint(this.getGraphics());
            this.play_state = 3;
        }
    }

    public void feedCard(int card, int value, int color) {
        this.humancards[card] = value;
        this.humancolors[card] = color;
    }

    public void dealSecond() {
        int i = 0;
        for (i = 0; i < 5; ++i) {
            if (this.pcCards[i] == null) continue;
            this.pcCards[i].suggested = 0;
        }
        for (i = 0; i < 5; ++i) {
            if (this.pcCards[i].flipped != 0) continue;
            this.updateOffscreen();
            this.paint(this.getGraphics());
            try {
                Thread.sleep(this.sleep);
                continue;
            }
            catch (Exception localException1) {
                System.out.println("Error: " + localException1.toString());
            }
        }
        int j = 5;
        for (i = 0; i < 5; ++i) {
            if (this.pcCards[i].flipped != 0) continue;
            this.pcCards[i] = new Card(50, 100, this.int_pccards[j] % 4, this.int_pccards[j] / 4 + 2);
            ++j;
            this.updateOffscreen();
            this.paint(this.getGraphics());
            try {
                Thread.sleep(this.sleep);
                continue;
            }
            catch (Exception localException2) {
                System.out.println("Error: " + localException2.toString());
            }
        }
        for (i = 0; i < 5; ++i) {
            this.pcCards[i].suggested = 0;
            if (this.pcCards[i].flipped == 1) continue;
            this.pcCards[i].flipped = 1;
            this.updateOffscreen();
            this.paint(this.getGraphics());
            try {
                Thread.sleep(this.sleep);
                continue;
            }
            catch (Exception localException3) {
                System.out.println("Error: " + localException3.toString());
            }
        }
        this.reshufflesecond = false;
        try {
            for (i = 0; i < 5; ++i) {
                for (int p = 0; p < 5; ++p) {
                    if (this.humancards[i] != this.pcCards[p].getcardValue() || this.humancolors[i] != this.pcCards[p].getcardColor()) continue;
                    this.reshufflesecond = true;
                    break;
                }
                if (!this.reshufflesecond) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.reshufflesecond = true;
        }
        if (!this.reshufflesecond) {
            this.suggest();
        }
    }

    public void suggest() {
        int j;
        int i;
        boolean m = false;
        for (int i2 = 0; i2 < 5; ++i2) {
            this.arrayOfInt1[i2] = this.pcCards[i2].cardVal;
            this.arrayOfInt2[i2] = i2;
            this.arrayOfInt3[i2] = this.pcCards[i2].cardVal;
            if (this.arrayOfInt3[i2] == 14) {
                this.arrayOfInt3[i2] = 1;
            }
            this.arrayOfInt4[i2] = i2;
        }
        for (i = 0; i < 5; ++i) {
            for (j = 4; j > i; --j) {
                int k;
                if (this.arrayOfInt1[j - 1] > this.arrayOfInt1[j]) {
                    k = this.arrayOfInt1[j];
                    this.arrayOfInt1[j] = this.arrayOfInt1[j - 1];
                    this.arrayOfInt1[j - 1] = k;
                    k = this.arrayOfInt2[j];
                    this.arrayOfInt2[j] = this.arrayOfInt2[j - 1];
                    this.arrayOfInt2[j - 1] = k;
                }
                if (this.arrayOfInt3[j - 1] <= this.arrayOfInt3[j]) continue;
                k = this.arrayOfInt3[j];
                this.arrayOfInt3[j] = this.arrayOfInt3[j - 1];
                this.arrayOfInt3[j - 1] = k;
                k = this.arrayOfInt4[j];
                this.arrayOfInt4[j] = this.arrayOfInt4[j - 1];
                this.arrayOfInt4[j - 1] = k;
            }
        }
        for (i = 0; i < 4 && this.arrayOfInt1[i] == this.arrayOfInt1[i + 1] - 1; ++i) {
        }
        if (i != 4 && this.arrayOfInt1[0] == 2 && this.arrayOfInt1[3] == 5 && this.arrayOfInt1[4] == 14) {
            i = 4;
        }
        if (i == 4) {
            for (i = 0; i < 5; ++i) {
                this.pcCards[i].suggested = 1;
            }
            m = true;
        } else {
            for (i = 0; i < 4 && this.pcCards[i].cardColor == this.pcCards[i + 1].cardColor; ++i) {
            }
            if (i == 4) {
                for (i = 0; i < 5; ++i) {
                    this.pcCards[i].suggested = 1;
                }
                m = true;
            } else {
                for (i = 0; i < 4; ++i) {
                    if (this.arrayOfInt1[i] != this.arrayOfInt1[i + 1]) continue;
                    this.pcCards[this.arrayOfInt2[i]].suggested = 1;
                    this.pcCards[this.arrayOfInt2[i + 1]].suggested = 1;
                    m = true;
                }
            }
        }
        if (m) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            this.arrayOfInt5[i] = 0;
        }
        for (i = 0; i < 5; ++i) {
            int n = this.pcCards[i].cardColor;
            this.arrayOfInt5[n] = this.arrayOfInt5[n] + 1;
        }
        for (i = 0; i < 4; ++i) {
            if (this.arrayOfInt5[i] < 4) continue;
            for (j = 0; j < 5; ++j) {
                if (this.pcCards[j].cardColor != i) continue;
                this.pcCards[j].suggested = 1;
            }
            return;
        }
        if (this.arrayOfInt1[4] - this.arrayOfInt1[1] == 4 || this.arrayOfInt1[4] - this.arrayOfInt1[1] == 3) {
            for (i = 1; i < 5; ++i) {
                this.pcCards[this.arrayOfInt2[i]].suggested = 1;
            }
            return;
        }
        if (this.arrayOfInt1[3] - this.arrayOfInt1[0] == 4 || this.arrayOfInt1[3] - this.arrayOfInt1[0] == 3) {
            for (i = 0; i < 4; ++i) {
                this.pcCards[this.arrayOfInt2[i]].suggested = 1;
            }
            return;
        }
        if (this.arrayOfInt3[4] - this.arrayOfInt3[1] == 4 || this.arrayOfInt3[4] - this.arrayOfInt3[1] == 3) {
            for (i = 1; i < 5; ++i) {
                this.pcCards[this.arrayOfInt4[i]].suggested = 1;
            }
            return;
        }
        if (this.arrayOfInt3[3] - this.arrayOfInt3[0] == 4 || this.arrayOfInt3[3] - this.arrayOfInt3[0] == 3) {
            for (i = 0; i < 4; ++i) {
                this.pcCards[this.arrayOfInt4[i]].suggested = 1;
            }
            return;
        }
        if (this.arrayOfInt1[4] > 10) {
            this.pcCards[this.arrayOfInt2[4]].suggested = 1;
        }
    }

    public void checkHand() {
        int m;
        int k;
        int j;
        int[] arrayOfInt1 = new int[5];
        int[] arrayOfInt2 = new int[2];
        int i = 0;
        for (int j2 = 0; j2 < 5; ++j2) {
            arrayOfInt1[j2] = this.pcCards[j2].cardVal;
        }
        for (j = 0; j < 5; ++j) {
            for (k = 4; k > j; --k) {
                if (arrayOfInt1[k - 1] <= arrayOfInt1[k]) continue;
                m = arrayOfInt1[k];
                arrayOfInt1[k] = arrayOfInt1[k - 1];
                arrayOfInt1[k - 1] = m;
            }
        }
        for (j = 0; j < 4 && arrayOfInt1[j] == arrayOfInt1[j + 1] - 1; ++j) {
        }
        if (j != 4 && arrayOfInt1[0] == 2 && arrayOfInt1[3] == 5 && arrayOfInt1[4] == 14) {
            j = 4;
        }
        if (j == 4) {
            for (j = 0; j < 4 && this.pcCards[j].cardColor == this.pcCards[j + 1].cardColor; ++j) {
            }
            if (j != 4) {
                this.winMessage = "Straight";
                i = 5;
            } else if (arrayOfInt1[0] == 10) {
                this.winMessage = "Royal Flush";
                i = 250;
            } else {
                this.winMessage = "Straight Flush";
                i = 50;
            }
        } else {
            for (j = 0; j < 4 && this.pcCards[j].cardColor == this.pcCards[j + 1].cardColor; ++j) {
            }
            if (j == 4) {
                this.winMessage = "Flush";
                i = 6;
            } else {
                m = 0;
                int n = 0;
                k = 0;
                arrayOfInt2[0] = 0;
                arrayOfInt2[1] = 0;
                for (j = 0; j < 4; ++j) {
                    if (n != 0 && arrayOfInt1[j] != n) {
                        n = 0;
                        ++m;
                    }
                    if (arrayOfInt1[j] != arrayOfInt1[j + 1]) continue;
                    int n2 = m;
                    arrayOfInt2[n2] = arrayOfInt2[n2] + 1;
                    k = n = arrayOfInt1[j];
                }
                if (n != 0) {
                    ++m;
                }
                if (m == 1) {
                    if (arrayOfInt2[0] == 1 && k >= 11) {
                        this.winMessage = "Pair of Jacks or Better";
                        i = 2;
                    } else if (arrayOfInt2[0] == 1 && k >= 2) {
                        this.winMessage = "One pair";
                        i = 1;
                    } else if (arrayOfInt2[0] == 2) {
                        this.winMessage = "Three Of A Kind";
                        i = 4;
                    } else if (arrayOfInt2[0] == 3) {
                        this.winMessage = "Four Of A Kind";
                        i = 25;
                    } else {
                        this.winMessage = "";
                    }
                } else if (m == 2) {
                    if (arrayOfInt2[0] == 1 && arrayOfInt2[1] == 1) {
                        this.winMessage = "Two Pair";
                        i = 3;
                    } else {
                        this.winMessage = "Full House";
                        i = 9;
                    }
                } else {
                    this.winMessage = "";
                }
            }
        }
        this.score = 0;
        for (j = 0; j < i * this.bet; ++j) {
            ++this.score;
            this.updateOffscreen();
            this.paint(this.getGraphics());
            try {
                Thread.sleep(this.sleep);
                continue;
            }
            catch (Exception localException) {
                System.out.println("Error: " + localException.toString());
            }
        }
        System.out.println(this.score);
    }

    public void setBet(int value) {
        this.bet = value;
    }

    public int getHand() {
        int m;
        int k;
        int j;
        int[] arrayOfInt1 = new int[5];
        int[] arrayOfInt2 = new int[2];
        int i = 0;
        for (int j2 = 0; j2 < 5; ++j2) {
            arrayOfInt1[j2] = this.pcCards[j2].cardVal;
        }
        for (j = 0; j < 5; ++j) {
            for (k = 4; k > j; --k) {
                if (arrayOfInt1[k - 1] <= arrayOfInt1[k]) continue;
                m = arrayOfInt1[k];
                arrayOfInt1[k] = arrayOfInt1[k - 1];
                arrayOfInt1[k - 1] = m;
            }
        }
        for (j = 0; j < 4 && arrayOfInt1[j] == arrayOfInt1[j + 1] - 1; ++j) {
        }
        if (j != 4 && arrayOfInt1[0] == 2 && arrayOfInt1[3] == 5 && arrayOfInt1[4] == 14) {
            j = 4;
        }
        if (j == 4) {
            for (j = 0; j < 4 && this.pcCards[j].cardColor == this.pcCards[j + 1].cardColor; ++j) {
            }
            if (j != 4) {
                this.winMessage = "Straight";
                i = 5;
            } else if (arrayOfInt1[0] == 10) {
                this.winMessage = "Royal Flush";
                i = 250;
            } else {
                this.winMessage = "Straight Flush";
                i = 50;
            }
        } else {
            for (j = 0; j < 4 && this.pcCards[j].cardColor == this.pcCards[j + 1].cardColor; ++j) {
            }
            if (j == 4) {
                this.winMessage = "Flush";
                i = 6;
            } else {
                m = 0;
                int n = 0;
                k = 0;
                arrayOfInt2[0] = 0;
                arrayOfInt2[1] = 0;
                for (j = 0; j < 4; ++j) {
                    if (n != 0 && arrayOfInt1[j] != n) {
                        n = 0;
                        ++m;
                    }
                    if (arrayOfInt1[j] != arrayOfInt1[j + 1]) continue;
                    int n2 = m;
                    arrayOfInt2[n2] = arrayOfInt2[n2] + 1;
                    k = n = arrayOfInt1[j];
                }
                if (n != 0) {
                    ++m;
                }
                if (m == 1) {
                    if (arrayOfInt2[0] == 1 && k >= 11) {
                        this.winMessage = "Pair of Jacks or Better";
                        i = 2;
                    } else if (arrayOfInt2[0] == 1 && k >= 2) {
                        this.winMessage = "One pair";
                        i = 1;
                    } else if (arrayOfInt2[0] == 2) {
                        this.winMessage = "Three Of A Kind";
                        i = 4;
                    } else if (arrayOfInt2[0] == 3) {
                        this.winMessage = "Four Of A Kind";
                        i = 25;
                    } else {
                        this.winMessage = "";
                    }
                } else if (m == 2) {
                    if (arrayOfInt2[0] == 1 && arrayOfInt2[1] == 1) {
                        this.winMessage = "Two Pair";
                        i = 3;
                    } else {
                        this.winMessage = "Full House";
                        i = 9;
                    }
                } else {
                    this.winMessage = "";
                }
            }
        }
        return i;
    }

    @Override
    public void run() {
        this.pcRandom.setSeed(System.currentTimeMillis() / 3L);
        while (true) {
            try {
                Thread.sleep(this.sleep);
            }
            catch (Exception localException) {
                System.out.println("Error: " + localException.toString());
            }
            if (this.play_state == 0 && this.self_play == 1) {
                this.play_state = 1;
            }
            if (this.play_state < 2) {
                this.scores = 0;
            }
            if (this.play_state == 2 && this.self_play == 1) {
                this.updateOffscreen();
                this.paint(this.getGraphics());
                this.play_state = 3;
            }
            if (this.play_state == 1) {
                this.reshufflefirst = true;
                while (this.reshufflefirst) {
                    this.PCdealStart();
                }
                for (int i = 0; i < 5; ++i) {
                    this.pcCards[i].flipped = this.pcCards[i].suggested;
                }
                this.play_state = 2;
                this.endscores = 0;
                this.updateOffscreen();
                this.paint(this.getGraphics());
                this.scores = this.getHand();
                continue;
            }
            if (this.play_state != 3) continue;
            this.reshufflesecond = true;
            while (this.reshufflesecond) {
                try {
                    this.dealSecond();
                }
                catch (Exception e) {
                    this.reshufflesecond = false;
                }
            }
            try {
                this.endscores = this.getHand();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.play_state = 0;
            this.updateOffscreen();
            this.paint(this.getGraphics());
        }
    }

    @Override
    public void stop() {
    }

    public void updateOffscreen() {
        try {
            this.offScreengg.setColor(Color.black);
            this.offScreengg.fillRect(0, 0, this.width, this.height);
            this.offScreengg.setColor(Color.cyan);
            this.offScreengg.drawString(this.winMessage, this.width / 2 - this.localFontMetrics.stringWidth(this.winMessage) / 2, 50);
            int k = this.height / 2 - 50;
            int j = this.width / 2 - this.card_width / 2;
            for (int i = 0; i < 5; ++i) {
                if (this.pcCards[i] != null) {
                    this.pcCards[i].drawCard(this.offScreengg, j, k);
                }
                j += 54;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void redo() {
        this.paint(this.getGraphics());
    }

    BufferedImage get(String name) {
        BufferedImage card = null;
        URL in = this.getClass().getResource("/classes/" + name);
        try {
            card = ImageIO.read(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return card;
    }

    public BufferedImage getCard(int i) {
        if (this.pcCards[i] == null) {
            return null;
        }
        try {
            BufferedImage p;
            if (this.pcCards[i].flipped == 0) {
                return this.get("cards/cardback.gif");
            }
            int cardValue = this.pcCards[i].getcardValue();
            BufferedImage card = this.get("cards/" + (cardValue > 10 ? "cardfront2.gif" : "cardfront1.gif"));
            Graphics2D g = card.createGraphics();
            int cardColor = this.pcCards[i].getcardColor();
            if (cardValue == 11) {
                p = cardColor == 0 ? this.get("cards/caro_jack.gif") : (cardColor == 1 ? this.get("cards/heart_jack.gif") : (cardColor == 2 ? this.get("cards/cross_jack.gif") : this.get("cards/pik_jack.gif")));
                g.drawImage((Image)p, 4, 4, this);
            }
            if (cardValue == 12) {
                p = cardColor == 0 ? this.get("cards/caro_queen.gif") : (cardColor == 1 ? this.get("cards/heart_queen.gif") : (cardColor == 2 ? this.get("cards/cross_queen.gif") : this.get("cards/pik_queen.gif")));
                g.drawImage((Image)p, 4, 3, this);
            }
            if (cardValue == 13) {
                p = cardColor == 0 ? this.get("cards/caro_king.gif") : (cardColor == 1 ? this.get("cards/heart_king.gif") : (cardColor == 2 ? this.get("cards/cross_king.gif") : this.get("cards/pik_king.gif")));
                g.drawImage((Image)p, 4, 4, this);
            }
            BufferedImage color = null;
            BufferedImage color2 = null;
            BufferedImage fcolor = null;
            BufferedImage fcolor2 = null;
            if (cardColor == 0) {
                color = this.get("cards/caro_large.gif");
                color2 = this.get("cards/caro_small.gif");
            }
            if (cardColor == 1) {
                color = this.get("cards/heart_large.gif");
                color2 = this.get("cards/heart_small.gif");
            }
            if (cardColor == 2) {
                color = this.get("cards/cross_large.gif");
                color2 = this.get("cards/cross_small.gif");
            }
            if (cardColor == 3) {
                color = this.get("cards/pik_large.gif");
                color2 = this.get("cards/pik_small.gif");
            }
            fcolor = this.flip(color);
            fcolor2 = this.flip(color2);
            if (cardValue < 11 || cardValue > 13) {
                g.drawImage((Image)color2, 2, 11, this);
                g.drawImage((Image)fcolor2, card.getWidth() - 2 - fcolor2.getWidth(), card.getHeight() - 11 - fcolor2.getHeight(), this);
            } else {
                g.drawImage((Image)color, 2, 12, this);
                g.drawImage((Image)fcolor, card.getWidth() - 2 - fcolor.getWidth(), card.getHeight() - 12 - fcolor.getHeight(), this);
            }
            int outer_left = 10;
            int outer_right = 26;
            int inner = 18;
            switch (cardValue) {
                case 1: 
                case 14: {
                    g.drawImage((Image)color, inner, 26, this);
                    break;
                }
                case 2: {
                    g.drawImage((Image)color, inner, 6, this);
                    g.drawImage((Image)fcolor, inner, 44, this);
                    break;
                }
                case 3: {
                    g.drawImage((Image)color, inner, 26, this);
                    g.drawImage((Image)color, inner, 6, this);
                    g.drawImage((Image)fcolor, inner, 44, this);
                    break;
                }
                case 4: {
                    g.drawImage((Image)color, outer_left, 6, this);
                    g.drawImage((Image)fcolor, outer_left, 44, this);
                    g.drawImage((Image)color, outer_right, 6, this);
                    g.drawImage((Image)fcolor, outer_right, 44, this);
                    break;
                }
                case 5: {
                    g.drawImage((Image)color, inner, 26, this);
                    g.drawImage((Image)color, outer_left, 6, this);
                    g.drawImage((Image)color, outer_right, 6, this);
                    g.drawImage((Image)fcolor, outer_left, 44, this);
                    g.drawImage((Image)fcolor, outer_right, 44, this);
                    break;
                }
                case 6: {
                    g.drawImage((Image)color, outer_left, 6, this);
                    g.drawImage((Image)color, outer_right, 6, this);
                    g.drawImage((Image)color, outer_right, 26, this);
                    g.drawImage((Image)color, outer_left, 26, this);
                    g.drawImage((Image)fcolor, outer_right, 44, this);
                    g.drawImage((Image)fcolor, outer_left, 44, this);
                    break;
                }
                case 7: {
                    g.drawImage((Image)color, outer_left, 6, this);
                    g.drawImage((Image)color, outer_right, 6, this);
                    g.drawImage((Image)color, inner, 12, this);
                    g.drawImage((Image)color, outer_left, 26, this);
                    g.drawImage((Image)color, outer_right, 26, this);
                    g.drawImage((Image)fcolor, outer_right, 44, this);
                    g.drawImage((Image)fcolor, outer_left, 44, this);
                    break;
                }
                case 8: {
                    g.drawImage((Image)color, outer_left, 6, this);
                    g.drawImage((Image)color, outer_right, 6, this);
                    g.drawImage((Image)color, inner, 12, this);
                    g.drawImage((Image)color, outer_left, 26, this);
                    g.drawImage((Image)color, outer_right, 26, this);
                    g.drawImage((Image)fcolor, inner, 37, this);
                    g.drawImage((Image)fcolor, outer_right, 44, this);
                    g.drawImage((Image)fcolor, outer_left, 44, this);
                    break;
                }
                case 9: {
                    g.drawImage((Image)color, outer_left, 6, this);
                    g.drawImage((Image)color, outer_right, 6, this);
                    g.drawImage((Image)color, outer_right, 19, this);
                    g.drawImage((Image)color, outer_left, 19, this);
                    g.drawImage((Image)color, inner, 26, this);
                    g.drawImage((Image)fcolor, outer_right, 32, this);
                    g.drawImage((Image)fcolor, outer_left, 32, this);
                    g.drawImage((Image)fcolor, outer_right, 44, this);
                    g.drawImage((Image)fcolor, outer_left, 44, this);
                    break;
                }
                case 10: {
                    g.drawImage((Image)color, outer_left, 6, this);
                    g.drawImage((Image)color, outer_right, 6, this);
                    g.drawImage((Image)color, inner, 12, this);
                    g.drawImage((Image)color, outer_right, 19, this);
                    g.drawImage((Image)color, outer_left, 19, this);
                    g.drawImage((Image)fcolor, outer_right, 32, this);
                    g.drawImage((Image)fcolor, outer_left, 32, this);
                    g.drawImage((Image)color, inner, 39, this);
                    g.drawImage((Image)fcolor, outer_right, 44, this);
                    g.drawImage((Image)fcolor, outer_left, 44, this);
                }
            }
            return card;
        }
        catch (Exception e) {
            return null;
        }
    }

    BufferedImage flip(BufferedImage in) {
        BufferedImage flipped = new BufferedImage(in.getWidth(), in.getHeight(), 2);
        for (int x = 0; x < in.getWidth(); ++x) {
            for (int y = 0; y < in.getHeight(); ++y) {
                int rgb = in.getRGB(in.getWidth() - x - 1, in.getHeight() - y - 1);
                flipped.setRGB(x, y, rgb);
            }
        }
        return flipped;
    }

    @Override
    public void paint(Graphics paramGraphics) {
        try {
            paramGraphics.drawImage(this.offScreenImage, 0, 0, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mousePressed(MouseEvent paramMouseEvent) {
        int i = paramMouseEvent.getX();
        int j = paramMouseEvent.getY();
        if (i > this.dealx0 && i < this.dealx1 && j > this.dealy0 && j < this.dealy1) {
            if (this.self_play == 1) {
                this.self_play = 0;
                return;
            }
            if (this.play_state == 0) {
                this.winMessage = "";
                this.play_state = 1;
            } else if (this.play_state == 2) {
                this.play_state = 3;
            }
        } else if (i > this.betx0 && i < this.betx1 && j > this.dealy0 && j < this.dealy1 && this.play_state == 0) {
            this.winMessage = "";
        }
        if (this.play_state != 0) {
            int n = this.width / 2 - this.card_width / 2;
            int m = this.height / 2 - 50;
            for (int k = 0; k < 5; ++k) {
                if (this.pcCards[k] == null) continue;
                if (i > n && i < n + this.pcCards[k].width && j > m && j < m + this.pcCards[k].height) {
                    this.pcCards[k].flipped ^= 1;
                    this.updateOffscreen();
                    this.paint(this.getGraphics());
                }
                n += 54;
            }
        }
    }

    public boolean toggled(int k) {
        return this.pcCards[k].flipped != 0;
    }

    public void toggleCard(int k) {
        this.pcCards[k].flipped ^= 1;
    }

    public int cardValue(int k) {
        return this.pcCards[k].getcardValue();
    }

    public int cardColor(int k) {
        return this.pcCards[k].getcardColor();
    }

    public void mouseDragged(MouseEvent paramMouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent paramMouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent paramMouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent paramMouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent paramMouseEvent) {
    }
}

