/*
 * Decompiled with CFR 0.152.
 */
package classes;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public enum WAVPlayer {
    MUSIC("classes/title.wav");

    public static Volume volume;
    private Clip clip;
    private boolean audioProblem;
    int framepos;

    private WAVPlayer(String soundFileName) {
        block6: {
            this.audioProblem = false;
            this.framepos = 0;
            try {
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(soundFileName);
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(url);
                AudioFormat format = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                this.clip = (Clip)AudioSystem.getLine(info);
                this.clip.open(audioInputStream);
            }
            catch (UnsupportedAudioFileException e) {
                if (!this.audioProblem) {
                    System.out.println("Your system does not accept input AudioFormat. Skipping samples.");
                    this.audioProblem = true;
                }
            }
            catch (IOException e) {
                if (!this.audioProblem) {
                    System.out.println("I can't find your files... Skipping samples.");
                    this.audioProblem = true;
                }
            }
            catch (LineUnavailableException e) {
                if (this.audioProblem) break block6;
                System.out.println("Line is unavailable. Skipping samples.");
                this.audioProblem = true;
            }
        }
    }

    public int getPos() {
        return this.clip.getFramePosition() / 1000;
    }

    public void setPos(int pos) {
        this.clip.setFramePosition(pos * 1000);
    }

    public int getSize() {
        return this.clip.getFrameLength() / 1000;
    }

    public void play() {
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    public void loop() {
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.start();
            while (this.clip.isRunning()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            this.loop();
        }
    }

    public void loop2() {
        if (volume != Volume.MUTE && !this.clip.isRunning()) {
            this.clip.setFramePosition(this.framepos);
            this.clip.loop(-1);
        }
    }

    public void stop() {
        if (this.clip.isRunning()) {
            this.clip.stop();
        }
        this.framepos = this.clip.getFramePosition();
        this.clip.setFramePosition(0);
        this.clip.stop();
    }

    static void init() {
        WAVPlayer.values();
    }

    static {
        volume = Volume.HIGH;
    }

    public static enum Volume {
        MUTE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

