/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.c64utils;

import com.dreamfabric.c64utils.TCPPacket;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class IPPacket {
    byte[] data;
    byte[] header;

    public IPPacket() {
    }

    public IPPacket(byte[] header, byte[] data) {
        this.header = header;
        this.data = data;
    }

    public void readIPPacket(InputStream fs) throws IOException {
        byte[] header = new byte[20];
        int pos = 0;
        int c = 0;
        boolean startFound = false;
        while (pos < 20 && (c = fs.read()) != -1) {
            if (c == 69) {
                startFound = true;
            }
            if (!startFound) continue;
            header[pos++] = (byte)c;
        }
        this.header = header;
        int dataLen = this.getTotalLength() - 20;
        this.data = new byte[dataLen];
        int n = dataLen;
        for (int i = 0; i < n && (c = fs.read()) != -1; ++i) {
            this.data[i] = (byte)(c & 0xFF);
        }
    }

    public int getVersion() {
        return this.header[0] >> 4 & 0xF;
    }

    public int getHeaderLengthBytes() {
        return 4 * (this.header[0] & 0xF);
    }

    public int getServiceType() {
        return this.header[1] & 0xFF;
    }

    public int getTotalLength() {
        return this.get16(2);
    }

    public int getID() {
        return this.get16(4);
    }

    public int getFlags() {
        return this.header[6] >> 5 & 7;
    }

    public int getFragment0() {
        return (this.header[6] & 0x1F) << 8 + this.header[7];
    }

    public int getTTL() {
        return this.header[8] & 0xFF;
    }

    public int getProtocol() {
        return this.header[9] & 0xFF;
    }

    public int getChecksum() {
        return this.get16(10);
    }

    public long getSourceIP() {
        return this.get32(12);
    }

    public long getDestinationIP() {
        return this.get32(16);
    }

    int get16(int pos) {
        return (this.header[pos] & 0xFF) << 8 | this.header[pos + 1] & 0xFF;
    }

    long get32(int pos) {
        return ((long)this.get16(pos) << 16) + (long)this.get16(pos + 2);
    }

    int getData8(int pos) {
        return this.data[pos] & 0xFF;
    }

    int getData16(int pos) {
        return (this.data[pos] & 0xFF) << 8 | this.data[pos + 1] & 0xFF;
    }

    long getData32(int pos) {
        return ((long)this.get16(pos) << 16) + (long)this.get16(pos + 2);
    }

    public static String getIPStr(long adr) {
        return "" + (adr >> 24 & 0xFFL) + "." + (adr >> 16 & 0xFFL) + "." + (adr >> 8 & 0xFFL) + "." + (adr & 0xFFL);
    }

    public static void main(String[] args) throws IOException {
        FileInputStream fs = new FileInputStream("test.txt");
        IPPacket p = new IPPacket();
        p.readIPPacket(fs);
        System.out.println("---- IP Data -----");
        System.out.println("Version: " + p.getVersion());
        System.out.println("HDL: " + p.getHeaderLengthBytes());
        System.out.println("TotLen: " + p.getTotalLength());
        System.out.println("Protocol: " + p.getProtocol());
        System.out.println("IP Adr dst: " + IPPacket.getIPStr(p.getDestinationIP()));
        System.out.println("IP Adr src: " + IPPacket.getIPStr(p.getSourceIP()));
        if (p.getProtocol() == 6) {
            TCPPacket tcp = new TCPPacket(p);
            System.out.println("---- TCP Data -----");
            System.out.println("Source Port: " + tcp.getSourcePort());
            System.out.println("Destination Port: " + tcp.getDestinationPort());
            System.out.println("SeqNo: " + tcp.getSequenceNumber());
            System.out.println("TCP Header length: " + tcp.getTCPHeaderLengthBytes());
            int offset = tcp.getTCPHeaderLengthBytes();
            int len = tcp.getTotalLength() - tcp.getHeaderLengthBytes() - offset;
            System.out.println("Content: " + len);
            int n = len;
            for (int i = 0; i < n; ++i) {
                System.out.print("" + (char)tcp.data[offset + i]);
            }
        }
    }
}

