/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C64Reader;
import com.dreamfabric.jac64.DiskChannel;
import java.io.ByteArrayOutputStream;
import java.util.Observable;

public class C1541
extends Observable {
    public static final int IO_OFFSET = 12288;
    public static final boolean DEBUG = true;
    public static final int SERIAL_ATN = 8;
    public static final int SERIAL_CLK_OUT = 16;
    public static final int SERIAL_DATA_OUT = 32;
    public static final int SERIAL_CLK_IN = 64;
    public static final int SERIAL_DATA_IN = 128;
    public static final int TALK = 64;
    public static final int LISTEN = 32;
    public static final int DATA = 96;
    public static final int OPEN = 240;
    public static final int CLOSE = 224;
    private int[] memory;
    private C64Reader reader;
    private static final int IDLE = 0;
    private static final int ATN = 1;
    private static final int RECEIVING = 2;
    private static final int SENDING = 3;
    private static final int READ_BIT = 4;
    private static final int WAIT_BIT = 5;
    private static final int READ_BYTE = 6;
    private static final int WRITE_BYTE = 7;
    private static final int LOAD_FILE = 1;
    private static final int SAVE_FILE = 2;
    private static final int LOGICAL_CHANNEL = 3;
    private static final int ATN_SEEN = 10;
    private static final int ATN_READ_BIT = 11;
    private static final int ATN_WAIT_BIT = 12;
    private static final int WAIT_LISTENER_READY = 13;
    private static final int WRITE_BIT_CLK1 = 14;
    private static final int WRITE_BIT_CLK2 = 15;
    private static final int WRITE_END = 16;
    private static final int WAIT_LISTENER_EOI_HANDSHAKE = 17;
    private static final int READ_FILENAME = 1;
    private DiskChannel[] channel = new DiskChannel[16];
    private boolean atnLast = false;
    private int mode = 0;
    private long eoiTimeout = 0L;
    private int eoi;
    private boolean lastChar = false;
    private int role = 0;
    private int floppyMode = 0;
    private int floppyChannel = 0;
    private String filename;
    private long waitTimeout = 0L;
    private int readMode = 1;
    private String tmpFilename = "";
    int rbState;
    int rbByte;
    int rbCtr = 0;
    int eoiCtr = 0;
    int wByte;
    int wBitPos;
    int wBytePos;
    int wState;
    long wCyclesWait;
    byte[] bytesToWrite;
    boolean wEOI = false;

    public C1541(int[] memory) {
        this.memory = memory;
        this.reader = new C64Reader();
        int n = 16;
        for (int i = 0; i < n; ++i) {
            this.channel[i] = new DiskChannel(i);
        }
    }

    public void reset() {
        this.mode = 0;
        this.role = 0;
        this.rbState = 0;
        this.rbByte = 0;
        this.floppyMode = 0;
        this.floppyChannel = 0;
        this.clockHi();
    }

    public C64Reader getReader() {
        return this.reader;
    }

    public void tick(long cycles) {
        if (this.waitTimeout != 0L && this.waitTimeout < cycles) {
            System.out.print(".");
            this.tick(cycles, true);
        }
    }

    public void tick(long cycles, boolean timeout) {
        int data = this.memory[68864];
        boolean atn = (data & 8) != 0;
        boolean dataOut = (data & 0x20) != 0;
        boolean clkOut = (data & 0x10) != 0;
        boolean atnInvoked = atn & !this.atnLast;
        switch (this.mode) {
            case 6: {
                if (atnInvoked) {
                    this.mode = 0;
                    return;
                }
                int b = this.readByte(data, cycles, false, timeout);
                if (b == 0) break;
                this.mode = 0;
                if (atn) {
                    this.handleATNByte(b);
                    break;
                }
                System.out.println("//// Read byte: " + Integer.toString(b, 16) + " => " + (char)b);
                this.dataLo();
                if (this.readMode != 1) break;
                this.tmpFilename = this.tmpFilename + (char)b;
                if (!this.lastChar) break;
                System.out.println("Filename: " + this.tmpFilename);
                this.filename = this.tmpFilename;
                break;
            }
            case 7: {
                if (atnInvoked) {
                    this.mode = 0;
                    return;
                }
                if (!this.writeByte(data, cycles, timeout)) break;
                this.reset();
                break;
            }
            case 10: {
                if (atn && !clkOut) {
                    this.dataHi();
                    this.mode = 6;
                    this.readByte(data, cycles, true, false);
                    break;
                }
                if (atn) break;
                this.mode = 0;
                break;
            }
            case 0: {
                if (atn & clkOut) {
                    System.out.println("C1541: ATN Seen...");
                    this.dataLo();
                    this.mode = 10;
                }
                if (!atn && this.role == 64) {
                    if (clkOut || !dataOut) break;
                    this.mode = 7;
                    this.initWrite(cycles);
                    break;
                }
                if (atn || this.role == 0 || clkOut) break;
                this.mode = 6;
                this.readByte(data, cycles, true, false);
            }
        }
        this.atnLast = atn;
    }

    private int readByte(int data, long cycles, boolean restart, boolean timeout) {
        boolean clkOut;
        boolean dataOut = (data & 0x20) != 0;
        boolean bl = clkOut = (data & 0x10) != 0;
        if (restart) {
            this.rbCtr = 0;
            this.rbByte = 0;
            this.rbState = 5;
            this.dataHi();
            System.out.println("Start reading byte - data lo");
            this.waitTimeout = 200L + cycles;
            this.eoiCtr = 0;
            this.lastChar = false;
            return 0;
        }
        if (timeout) {
            System.out.println("//// EOI Timeout???");
            if (this.eoiCtr == 0) {
                System.out.println("//// EOI 1 => dataLo");
                this.dataLo();
                this.waitTimeout = 80L + cycles;
            } else {
                System.out.println("///// EOI 2 => dataHi");
                this.dataHi();
                this.waitTimeout = 0L;
                this.lastChar = true;
            }
            ++this.eoiCtr;
        }
        if (this.rbState == 5) {
            if (clkOut) {
                this.rbState = 4;
            }
        } else if (!clkOut) {
            this.rbByte |= dataOut ? 0 : 1 << this.rbCtr;
            this.rbState = 5;
            ++this.rbCtr;
            this.waitTimeout = 0L;
        }
        if (this.rbCtr == 8) {
            return this.rbByte;
        }
        return 0;
    }

    private void initWriteByte(int data, long cycles) {
        int b = data > 32 ? data : 46;
        System.out.print("***>> InitW: " + Integer.toString(data & 0xFF, 16) + " '" + (char)b + "' ");
        this.wByte = data;
        this.wBitPos = 0;
        this.wCyclesWait = cycles + 100L;
        this.waitTimeout = cycles + 100L;
        this.wState = 13;
    }

    private boolean writeByte(int data, long cycles, boolean timeout) {
        boolean dataOut;
        boolean bl = dataOut = (data & 0x20) != 0;
        if (this.wCyclesWait > cycles) {
            return false;
        }
        switch (this.wState) {
            case 13: {
                this.clockHi();
                if (!dataOut) {
                    if (this.bytesToWrite == null) {
                        this.waitTimeout = 0L;
                        return true;
                    }
                    if (!this.wEOI) {
                        System.out.print("[R]");
                        this.wState = 15;
                        break;
                    }
                    System.out.print("[R(EOI)]");
                    this.wState = 17;
                    break;
                }
                System.out.print("[-R]");
                break;
            }
            case 17: {
                if (!dataOut) break;
                System.out.println("EOI handshake!!!");
                this.wEOI = false;
                this.wState = 13;
                break;
            }
            case 14: {
                if ((this.wByte & 1 << this.wBitPos) == 0) {
                    this.dataLo();
                } else {
                    this.dataHi();
                }
                ++this.wBitPos;
                this.clockHi();
                this.wCyclesWait = cycles + 70L;
                if (this.wBitPos < 8) {
                    this.wState = 15;
                    break;
                }
                this.wState = 16;
                break;
            }
            case 15: {
                this.clockLo();
                this.dataLo();
                this.wCyclesWait = cycles + 70L;
                this.wState = 14;
                break;
            }
            case 16: {
                this.clockLo();
                if (!dataOut) break;
                System.out.println("Ack: " + Integer.toString(this.memory[164], 16));
                ++this.wBytePos;
                if (this.wBytePos % 10 == 0) {
                    this.setChanged();
                    this.notifyObservers("Loading " + this.filename + " " + 100 * this.wBytePos / this.bytesToWrite.length + "%");
                }
                if (this.wBytePos == this.bytesToWrite.length - 1) {
                    this.wEOI = true;
                } else if (this.wBytePos >= this.bytesToWrite.length) {
                    this.waitTimeout = 0L;
                    this.wEOI = false;
                    System.out.println("******** Write finished!!!");
                    this.setChanged();
                    this.notifyObservers("");
                    return true;
                }
                this.initWriteByte(this.bytesToWrite[this.wBytePos], cycles);
            }
        }
        return false;
    }

    private void initWrite(long cycles) {
        this.clockLo();
        this.wBytePos = 0;
        this.wEOI = false;
        if (this.floppyMode == 1) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.filename = this.reader.readFile(this.filename, -1, out);
            if (this.filename != null) {
                this.bytesToWrite = out.toByteArray();
                System.out.println("C1541 have " + this.bytesToWrite.length + " bytes to write");
                this.initWriteByte(this.bytesToWrite[0], cycles);
            } else {
                System.out.println("File not found... should signal error...");
                this.bytesToWrite = null;
                this.initWriteByte(0, cycles);
            }
        }
        if (this.floppyMode == 3) {
            System.out.println("Should write logical channel data!");
            this.bytesToWrite = this.channel[this.floppyChannel].getData();
            this.initWriteByte(this.bytesToWrite[0], cycles);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleATNByte(int data) {
        cmd = data & 240;
        dev = data & 31;
        secAdr = data & 15;
        System.out.println("ATN Byte: " + data + " " + Integer.toString(data, 16));
        switch (cmd) {
            case 64: 
            case 80: {
                this.role = 0;
                if (dev == 31) {
                    System.out.println("  >> UNTALK!!!");
                    break;
                }
                System.out.println("  Received TALK for dev: " + dev);
                if (dev != 8) break;
                System.out.println("### DEV: 8 ACTIVE as 1541!");
                this.role = 64;
                break;
            }
            case 32: 
            case 48: {
                this.role = 0;
                if (dev == 31) {
                    System.out.println("  >> UNLISTEN!!!");
                    if (this.floppyMode != 3) break;
                    out = new ByteArrayOutputStream();
                    this.tmpFilename = this.reader.readFile(this.tmpFilename, -1, out);
                    if (this.tmpFilename != null) {
                        this.channel[this.floppyChannel].setData(out.toByteArray());
                        System.out.println("Setting channel " + this.floppyChannel + " to " + this.tmpFilename + " size: " + this.channel[this.floppyChannel].getData().length);
                        this.channel[this.floppyChannel].setFilename(this.tmpFilename);
                        this.filename = this.tmpFilename;
                        break;
                    }
                    System.out.println("#### File not found error???");
                    break;
                }
                System.out.println("  Received LISTEN for dev: " + dev);
                if (dev != 8) break;
                System.out.println("### DEV: 8 ACTIVE as 1541!");
                this.role = 32;
                break;
            }
            case 240: {
                System.out.println("### OPEN sec addr: " + secAdr);
                this.tmpFilename = "";
                this.readMode = 1;
                if (secAdr != 0) ** GOTO lbl44
                System.out.println("### => LOAD File!");
                this.floppyMode = 1;
                ** GOTO lbl55
lbl44:
                // 1 sources

                if (secAdr != 1) ** GOTO lbl49
                System.out.println("### => SAVE File!");
                this.floppyMode = 2;
                this.readMode = 1;
                ** GOTO lbl55
lbl49:
                // 1 sources

                if (secAdr == 15) {
                    System.out.println("### => Error...");
                } else {
                    System.out.println("Logical channel: " + secAdr);
                    this.floppyMode = 3;
                    this.floppyChannel = secAdr;
                }
            }
lbl55:
            // 5 sources

            case 224: {
                System.out.println("### Close: secAdr: " + secAdr);
                this.channel[secAdr].close();
                break;
            }
            case 96: {
                System.out.println("### DATA sec addr: " + secAdr);
                System.out.println("Setting floppy channel!");
                this.floppyChannel = secAdr;
            }
        }
    }

    private void clockLo() {
        this.memory[68864] = this.memory[68864] & 0xFFFFFFBF;
    }

    private void clockHi() {
        this.memory[68864] = this.memory[68864] | 0x40;
    }

    public void dataLo() {
        this.memory[68864] = this.memory[68864] & 0xFFFFFF7F;
    }

    public void dataHi() {
        this.memory[68864] = this.memory[68864] | 0x80;
    }

    public void handleDisk(int data, long cycles) {
        System.out.print("EMU: ");
        C1541.printSerial(data);
        this.tick(cycles, false);
    }

    public static void printSerial(int data) {
        if ((data & 8) != 0) {
            System.out.print("A1");
        } else {
            System.out.print("A0");
        }
        int sdata = (data & 0x10) != 0 ? 1 : 0;
        System.out.print(" C" + sdata);
        sdata = (data & 0x20) != 0 ? 1 : 0;
        System.out.print(" D" + sdata);
        sdata = (data & 0x40) != 0 ? 1 : 0;
        System.out.print(" c" + sdata);
        sdata = (data & 0x80) != 0 ? 1 : 0;
        System.out.println(" d" + sdata + " (iec)");
    }
}

