/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C64Screen;
import com.dreamfabric.jac64.Keyboard;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;

public class C64Canvas
extends JPanel
implements KeyListener,
FocusListener {
    private static final long serialVersionUID = 5124260828376559537L;
    boolean integerScale = true;
    C64Screen scr;
    Keyboard keyboard;
    boolean autoScale;
    int w;
    int h;

    public C64Canvas(C64Screen screen, boolean dob, Keyboard keyboard) {
        this.autoScale = dob;
        this.scr = screen;
        this.keyboard = keyboard;
        this.setFont(new Font("Monospaced", 0, 11));
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public void setAutoscale(boolean val) {
        this.autoScale = val;
    }

    public void setIntegerScaling(boolean yes) {
        this.integerScale = yes;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.autoScale && (this.w != this.getWidth() || this.h != this.getHeight())) {
            this.w = this.getWidth();
            this.h = this.getHeight();
            double fac = 1.0 * (double)this.w / 384.0;
            if (fac > 1.0 * (double)this.h / 284.0) {
                fac = 1.0 * (double)this.h / 284.0;
            }
            if (this.integerScale && fac > 1.0) {
                fac = (int)fac;
            }
            this.scr.setDisplayFactor(fac);
            this.scr.setDisplayOffset((int)((double)this.w - fac * 384.0) / 2, (int)((double)this.h - fac * 284.0) / 2);
        }
        this.scr.paint(g);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.keyboard.keyPressed(event);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.keyboard.keyReleased(event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
        char chr = event.getKeyChar();
        if (chr == 'w' && (event.getModifiers() & 8) != 0) {
            this.scr.getAudioDriver().setFullSpeed(!this.scr.getAudioDriver().fullSpeed());
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
        this.keyboard.reset();
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.keyboard.reset();
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }
}

