/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.CPU;
import com.dreamfabric.jac64.DirEntry;
import com.dreamfabric.jac64.DiskListener;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class C64Reader {
    public static final int NONE = 0;
    public static final int TAPE = 1;
    public static final int DISK = 2;
    private int[] memory;
    private String label = "";
    private ArrayList dirNames = new ArrayList();
    private Hashtable dirEntries = new Hashtable();
    private DiskListener listener;
    private int type = 0;
    private int diskSize = 0;
    private byte[][] sectors = new byte[800][256];
    private int noBytes;
    private boolean lastEntry;
    private int nextSector;

    public void setCPU(CPU cpu) {
        this.memory = cpu.getMemory();
    }

    public void setDiskListener(DiskListener l) {
        this.listener = l;
    }

    public int getLoadedType() {
        return this.type;
    }

    public ArrayList getDirNames() {
        return this.dirNames;
    }

    public DirEntry getDirEntry(String name) {
        return (DirEntry)this.dirEntries.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readDisk(InputStream stream) {
        int sector = 0;
        int sectrak = 0;
        int trak = 1;
        int numRead = 0;
        DataInputStream reader = new DataInputStream(stream);
        this.dirNames.clear();
        this.dirEntries.clear();
        this.type = 2;
        try {
            while ((numRead = reader.read(this.sectors[sector])) > 0) {
                if (numRead < 256) {
                    reader.readFully(this.sectors[sector], numRead, 256 - numRead);
                }
                if (trak == 18) {
                    this.readDir(this.sectors[sector], trak, sectrak);
                }
                ++sector;
                if (!(trak < 18 && sectrak == 21 || trak >= 18 && trak < 25 && sectrak == 19 || trak >= 25 && trak < 31 && sectrak == 18) && (trak < 31 || trak >= 41 || ++sectrak != 17)) continue;
                sectrak = 0;
                ++trak;
            }
            System.out.println("Read " + sector + " sectors");
            this.diskSize = sector;
        }
        catch (Exception e) {
            System.out.println("Error reading sectors");
            System.out.println("Track: " + trak + " sec: " + sector);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        if (this.listener != null) {
            this.listener.diskChanged();
        }
        return true;
    }

    public byte[] getSector(int sector) {
        return this.sectors[sector];
    }

    public static int getSectorCount(int track) {
        if (track > 30) {
            return 17;
        }
        if (track > 24) {
            return 18;
        }
        if (track > 17) {
            return 19;
        }
        return 21;
    }

    public byte[] getSector(int trak, int sectrak) {
        int sector = this.getSecTrack(trak);
        return this.sectors[sector += sectrak];
    }

    private int getSecTrack(int trak) {
        int sector = 0;
        sector = trak < 18 ? (trak - 1) * 21 : (trak >= 18 && trak < 25 ? (trak - 1) * 19 + 34 : (trak >= 25 && trak < 31 ? (trak - 1) * 18 + 51 + 7 : (trak - 1) * 17 + 68 + 14 + 6));
        return sector;
    }

    public void writeDisk(OutputStream stream) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(stream);
        int n = this.diskSize;
        for (int i = 0; i < n; ++i) {
            out.write(this.sectors[i], 0, 256);
        }
        out.close();
    }

    public void setSector(int track, int sectrack, byte[] newSector) {
        int sector = this.getSecTrack(track);
        sector += sectrack;
        int n = 255;
        for (int i = 0; i < n; ++i) {
            this.sectors[sector][i] = newSector[i];
        }
    }

    private void readDir(byte[] data, int trak, int sec) {
        if (sec == 0) {
            this.label = "";
            for (int i = 0; i < 16; ++i) {
                if (data[144 + i] == -96) continue;
                this.label = this.label + (char)data[144 + i];
            }
            System.out.println("Directory listing of '" + this.label + "'");
            this.lastEntry = false;
            this.nextSector = trak;
            this.nextSector = 1;
        } else if (!this.lastEntry) {
            if (this.nextSector == sec && data[0] == 0) {
                this.lastEntry = true;
            } else {
                this.nextSector = data[1];
            }
            for (int start = 0; start < 255 && data[start + 2] != 0; start += 32) {
                int tp = data[start + 2] & 0xFF;
                String name = "";
                for (int i = 0; i < 16; ++i) {
                    name = data[start + 5 + i] != -96 ? name + (char)data[start + 5 + i] : name + " ";
                }
                int size = data[start + 30] & 255 + data[start + 31] * 256;
                DirEntry entry = new DirEntry(name, data[start + 3], data[start + 4], size, tp);
                this.dirNames.add(entry);
                this.dirEntries.put(name, entry);
            }
            if (this.lastEntry) {
                System.out.println("No more files.");
            }
        }
    }

    public String readFile(String str) {
        return this.readFile(str, -1);
    }

    public String readFile(String str, int adr) {
        return this.readFile(str, adr, null);
    }

    private void printDirListing(OutputStream out) {
        int i;
        byte[] dir = new byte[4096];
        int p = 0;
        int adr = 2049;
        dir[p++] = (byte)(adr & 0xFF);
        dir[p++] = (byte)(adr >> 8);
        dir[p++] = (byte)((adr += this.label.length() + 5) & 0xFF);
        dir[p++] = (byte)(adr >> 8);
        dir[p++] = 0;
        dir[p++] = 0;
        dir[p++] = 18;
        dir[p++] = 34;
        int n = this.label.length();
        for (i = 0; i < n; ++i) {
            dir[p++] = (byte)this.label.charAt(i);
        }
        dir[p++] = 34;
        dir[p++] = 0;
        n = this.dirNames.size();
        for (i = 0; i < n; ++i) {
            int j;
            DirEntry dire = (DirEntry)this.dirNames.get(i);
            adr += 26;
            int fill = 1;
            if (dire.size < 10) {
                fill = 3;
            } else if (dire.size < 100) {
                fill = 2;
            }
            dir[p++] = (byte)((adr += fill) & 0xFF);
            dir[p++] = (byte)(adr >> 8);
            dir[p++] = (byte)(dire.size & 0xFF);
            dir[p++] = (byte)(dire.size >> 8);
            int m = fill;
            for (j = 0; j < m; ++j) {
                dir[p++] = 32;
            }
            m = dire.name.length();
            for (j = 0; j < m; ++j) {
                dir[p++] = (byte)dire.name.charAt(j);
            }
            m = 18 - dire.name.length();
            for (j = 0; j < m; ++j) {
                dir[p++] = 32;
            }
            String type = dire.getTypeString();
            int m2 = type.length();
            for (int j2 = 0; j2 < m2; ++j2) {
                dir[p++] = (byte)type.charAt(j2);
            }
            dir[p++] = 0;
        }
        dir[p++] = 0;
        dir[p++] = 0;
        try {
            out.write(dir, 0, p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String readFile(String filename, int adr, OutputStream out) {
        int sindex = 0;
        DirEntry dire = null;
        System.out.println("Loading: '" + filename + "' at " + adr);
        sindex = filename.indexOf(42);
        if (sindex >= 0) {
            String match = filename.substring(0, sindex);
            System.out.println("Matcher: " + match);
            Enumeration names = this.dirEntries.keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(match)) continue;
                System.out.println("Found: " + name);
                dire = (DirEntry)this.dirEntries.get(name);
            }
        } else {
            if (filename.equals("$")) {
                this.printDirListing(out);
                return filename;
            }
            dire = (DirEntry)this.dirEntries.get(filename);
            if (dire == null) {
                int n = 16;
                for (int i = filename.length(); i < n; ++i) {
                    filename = filename + ' ';
                }
                dire = (DirEntry)this.dirEntries.get(filename);
            }
        }
        if (dire == null) {
            return null;
        }
        if (this.type == 1) {
            return this.readTapeFile(dire);
        }
        return this.readDiskFile(dire, filename, adr, out);
    }

    public String readDiskFile(DirEntry dire, String str, int adr, OutputStream out) {
        boolean reading;
        byte[] sec = this.getSector(dire.trk, dire.sec);
        int address = (sec[2] & 0xFF) + (sec[3] & 0xFF) * 256;
        System.out.println("*** Reading DISK file at " + Integer.toString(address, 16));
        if (out != null) {
            try {
                out.write(sec[2] & 0xFF);
                out.write(sec[3] & 0xFF);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (adr != -1) {
            System.out.println("Address override: " + address + " -> " + adr);
            address = adr;
        }
        int nextSector = sec[1] & 0xFF;
        int nextTrak = sec[0] & 0xFF;
        try {
            for (int i = 0; i < 252; ++i) {
                if (out != null) {
                    out.write(sec[i + 4] & 0xFF);
                    continue;
                }
                this.memory[i + address] = sec[i + 4] & 0xFF;
            }
        }
        catch (Exception e) {
            System.out.println("Could not write to output stream");
            e.printStackTrace();
        }
        address += 252;
        boolean bl = reading = nextTrak != 0;
        while (reading) {
            sec = this.getSector(nextTrak, nextSector);
            nextSector = sec[1] & 0xFF;
            nextTrak = sec[0] & 0xFF;
            reading = nextTrak != 0;
            try {
                for (int i = 0; i < 254; ++i) {
                    if (out != null) {
                        out.write(sec[i + 2] & 0xFF);
                        continue;
                    }
                    this.memory[i + address] = sec[i + 2] & 0xFF;
                }
            }
            catch (Exception e) {
                System.out.println("Could not write to output stream");
                e.printStackTrace();
            }
            address += 254;
        }
        address = address - 255 + nextSector;
        if (out == null) {
            this.setAddress(address);
        }
        System.out.println("*** File loaded - end at: " + Integer.toString(address, 16));
        return dire.name;
    }

    public String saveFile() {
        int startAdr = this.memory[43] + (this.memory[44] << 8);
        int lastAdr = this.memory[45] + (this.memory[46] << 8);
        System.out.println("Dumping mem from: " + startAdr + " to " + lastAdr);
        StringBuffer sb = new StringBuffer();
        if ((startAdr & 0xFF) < 16) {
            sb.append('0');
        }
        sb.append(Integer.toString(startAdr & 0xFF));
        if (startAdr >> 8 < 16) {
            sb.append('0');
        }
        sb.append(Integer.toString(startAdr >> 8));
        for (int i = startAdr; i < lastAdr; ++i) {
            int m = this.memory[i];
            if (m < 16) {
                sb.append('0');
            }
            sb.append(Integer.toString(this.memory[i], 16));
        }
        return sb.toString();
    }

    private void setAddress(int address) {
        if (address > 40704) {
            address = 40704;
        }
        this.memory[45] = address & 0xFF;
        this.memory[46] = (address & 0xFF00) >> 8;
        this.memory[47] = address & 0xFF;
        this.memory[48] = (address & 0xFF00) >> 8;
        this.memory[49] = address & 0xFF;
        this.memory[50] = (address & 0xFF00) >> 8;
    }

    private String readTapeFile(DirEntry dire) {
        int address = dire.sec;
        int offset = dire.trk;
        System.out.println("Reading from " + offset);
        System.out.println("Storing at: " + address);
        System.out.println("Size: " + dire.size);
        for (int i = 0; i < dire.size; ++i) {
            this.memory[address++] = this.sectors[i + offset >> 8][i + offset & 0xFF] & 0xFF;
        }
        this.setAddress(address);
        return dire.name;
    }

    private boolean readPGM(InputStream stream, int address) {
        byte[] start = new byte[2];
        try {
            DataInputStream reader = new DataInputStream(stream);
            reader.readFully(start);
            int sector = 0;
            int numRead = 0;
            int noBytes = 0;
            while ((numRead = this.readSector(reader, sector)) == 256) {
                ++sector;
            }
            noBytes = sector * 256 + numRead;
            System.out.println("Read " + noBytes + " program data");
            if (address == -1) {
                address = start[0] + start[1] * 256;
            }
            System.out.println("Storing at: " + address);
            for (int i = 0; i < noBytes; ++i) {
                this.memory[address++] = this.sectors[i >> 8][i & 0xFF] & 0xFF;
            }
            this.setAddress(address);
            return true;
        }
        catch (Exception e) {
            System.out.println("Error while reading pgm file " + e);
            return false;
        }
    }

    private boolean readTape(InputStream stream) {
        byte[] start = new byte[32];
        this.dirNames.clear();
        this.dirEntries.clear();
        this.type = 1;
        try {
            DataInputStream reader = new DataInputStream(stream);
            reader.readFully(start);
            String st = new String(start);
            if (st.startsWith("C64")) {
                int numRead;
                int i;
                System.out.println("Tape Archive found:");
                reader.readFully(start);
                int max = start[3] * 256 + start[2];
                int used = start[5] * 256 + start[4];
                if (used == 0) {
                    used = 1;
                }
                String name = "";
                System.out.println("Type: " + start[0] * 256 + start[1]);
                System.out.println("Max Entries: " + max);
                System.out.println("Used Entries: " + used);
                for (int i2 = 8; i2 < 32; ++i2) {
                    name = name + (char)start[i2];
                }
                System.out.println("Name: " + name);
                for (i = 0; i < used; ++i) {
                    reader.readFully(start);
                    int startAdr = (start[2] & 0xFF) + (start[3] & 0xFF) * 256;
                    int endAdr = (start[4] & 0xFF) + (start[5] & 0xFF) * 256;
                    int offset = (start[8] & 0xFF) + (start[9] & 0xFF) * 256;
                    System.out.println("---------------------");
                    System.out.println("Entry: " + i);
                    System.out.println("File Type: " + start[0]);
                    System.out.println("1541 Type: " + start[1]);
                    System.out.println("Start Adr: " + startAdr);
                    System.out.println("End Adr: " + endAdr + " -> size = " + (endAdr - startAdr));
                    System.out.println("Offset: " + offset);
                    name = "";
                    for (int j = 16; j < 32; ++j) {
                        name = name + (char)start[j];
                    }
                    System.out.println("File Name: " + name);
                    DirEntry entry = new DirEntry(name, offset - 32 * (max + 2), startAdr, endAdr - startAdr, start[1]);
                    this.dirNames.add(entry);
                    this.dirEntries.put(name, entry);
                }
                for (i = used; i < max; ++i) {
                    reader.readFully(start);
                }
                int sector = 0;
                while ((numRead = this.readSector(reader, sector)) == 256) {
                    ++sector;
                }
                this.noBytes = sector * 256 + numRead;
                System.out.println("Read " + this.noBytes + " program data");
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Error while reading tape");
            return false;
        }
    }

    private boolean readSID(InputStream stream) {
        byte[] start = new byte[22];
        try {
            DataInputStream reader = new DataInputStream(stream);
            reader.readFully(start);
            String st = new String(start);
            if (st.startsWith("PSID")) {
                int version = start[4] * 256 + start[5];
                int addr = start[8] * 256 + start[9];
                int iaddr = start[10] * 256 + start[11];
                int paddr = start[12] * 256 + start[13];
                int songs = start[14] * 256 + start[15];
                int startsong = start[16] * 256 + start[17];
                long speed = (start[18] << 24) + (start[19] << 16) + (start[20] << 8) + start[21];
                System.out.println("FOUND SID TUNE!");
                System.out.println("Version: " + version);
                System.out.println("LAddr: " + addr);
                System.out.println("IAddr: " + iaddr);
                System.out.println("PAddr: " + paddr);
                System.out.println("Songs: " + songs);
                System.out.println("StartSong: " + startsong);
                System.out.println("Speed: " + speed);
                byte[] str = new byte[32];
                for (int i = 0; i < songs; ++i) {
                    reader.readFully(str);
                    System.out.println("Song " + (i + 1));
                    System.out.println("Name      :" + new String(str));
                    reader.readFully(str);
                    System.out.println("Author    :" + new String(str));
                    reader.readFully(str);
                    System.out.println("Copyright :" + new String(str));
                }
                if (version == 2) {
                    byte[] garbage = new byte[6];
                    reader.readFully(garbage);
                }
                byte[] adr = new byte[2];
                reader.readFully(adr);
            }
        }
        catch (Exception e) {
            System.out.println("Error while reading SID");
        }
        return false;
    }

    private int readSector(DataInputStream reader, int sector) {
        int numRead = 0;
        try {
            int no = numRead = reader.read(this.sectors[sector]);
            while (numRead < 256) {
                no = reader.read(this.sectors[sector], numRead, 256 - numRead);
                if (no == -1) {
                    return numRead;
                }
                numRead += no;
            }
        }
        catch (Exception e) {
            System.out.println("Exception while reading file... " + e);
        }
        return numRead;
    }

    public boolean readDiskFromFile(String name) {
        try {
            System.out.println("Loading " + name);
            FileInputStream reader = new FileInputStream(name);
            return this.readDisk(reader);
        }
        catch (Exception e) {
            System.out.println("Error while opening file " + name + "  " + e);
            return false;
        }
    }

    public boolean readPGM(URL url, int address) {
        try {
            return this.readPGM(url.openConnection().getInputStream(), address);
        }
        catch (Exception e) {
            System.out.println("Error when opening url " + url + "  " + e);
            return false;
        }
    }

    public boolean readPGM(String file, int address) {
        try {
            return this.readPGM(new FileInputStream(file), address);
        }
        catch (Exception e) {
            System.out.println("Error when opening file " + file + "  " + e);
            return false;
        }
    }

    public boolean readDiskFromURL(URL url) {
        try {
            System.out.println("Loading from " + url);
            InputStream reader = url.openConnection().getInputStream();
            return this.readDisk(reader);
        }
        catch (Exception e) {
            System.out.println("Error when opening url " + url + "  " + e);
            return false;
        }
    }

    public boolean readTapeFromFile(String name) {
        try {
            System.out.println("Loading " + name);
            FileInputStream reader = new FileInputStream(name);
            return this.readTape(reader);
        }
        catch (Exception e) {
            System.out.println("Error while opening file " + name + "  " + e);
            return false;
        }
    }

    public boolean readTapeFromURL(URL url) {
        try {
            System.out.println("Loading from " + url);
            InputStream reader = url.openConnection().getInputStream();
            return this.readTape(reader);
        }
        catch (Exception e) {
            System.out.println("Error when opening url " + url + "  " + e);
            return false;
        }
    }

    public boolean readSIDFromFile(String name) {
        try {
            System.out.println("Loading SID " + name);
            FileInputStream reader = new FileInputStream(name);
            return this.readSID(reader);
        }
        catch (Exception e) {
            System.out.println("Error while opening file " + name + "  " + e);
            return false;
        }
    }

    public static void main(String[] args) {
        C64Reader cr = new C64Reader();
        cr.readDiskFromFile(args[0]);
        if (args.length > 1) {
            try {
                FileOutputStream fio = new FileOutputStream(args[2]);
                cr.readFile(args[1], 0, fio);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            cr.printDirListing(System.out);
        }
    }
}

