/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.ExtChip;
import com.dreamfabric.jac64.Hex;
import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.TimeEvent;

public class CIA {
    public static final boolean TIMER_DEBUG = false;
    public static final boolean WRITE_DEBUG = false;
    public static final int PRA = 0;
    public static final int PRB = 1;
    public static final int DDRA = 2;
    public static final int DDRB = 3;
    public static final int TIMALO = 4;
    public static final int TIMAHI = 5;
    public static final int TIMBLO = 6;
    public static final int TIMBHI = 7;
    public static final int TODTEN = 8;
    public static final int TODSEC = 9;
    public static final int TODMIN = 10;
    public static final int TODHRS = 11;
    public static final int SDR = 12;
    public static final int ICR = 13;
    public static final int CRA = 14;
    public static final int CRB = 15;
    CIATimer timerA;
    CIATimer timerB;
    int pra = 0;
    int prb = 0;
    int ddra = 0;
    int ddrb = 0;
    int tod10sec = 0;
    int todsec = 0;
    int todmin = 0;
    int todhour = 0;
    int sdr;
    int ciaicrRead;
    int ciaie = 0;
    public static final int TIMER_B_DIV_MASK = 96;
    public static final int TIMER_B_DIV_VAL = 64;
    public long nextCIAUpdate = 0L;
    private MOS6510Core cpu;
    private int offset;
    public int serialFake = 0;
    private ExtChip chips;
    public TimeEvent todEvent = new TimeEvent(0L){

        @Override
        public void execute(long cycle) {
            this.time += 100000L;
            int tmp = (CIA.this.tod10sec & 0xF) + 1;
            CIA.this.tod10sec = tmp % 10;
            if (tmp > 9) {
                tmp = (CIA.this.todsec & 0x7F) + 1;
                if ((tmp & 0xF) > 9) {
                    tmp += 6;
                }
                if (tmp > 89) {
                    tmp = 0;
                }
                CIA.this.todsec = tmp;
                if (tmp == 0) {
                    tmp = (CIA.this.todmin & 0x7F) + 1;
                    if ((tmp & 0xF) > 9) {
                        tmp += 6;
                    }
                    if (tmp > 89) {
                        tmp = 0;
                    }
                    CIA.this.todmin = tmp;
                    if (tmp == 0) {
                        tmp = (CIA.this.todhour & 0x1F) + 1;
                        if ((tmp & 0xF) > 9) {
                            tmp += 6;
                        }
                        if (tmp > 17) {
                            tmp = 0;
                        }
                        CIA.this.todhour = tmp;
                    }
                }
            }
            ((CIA)CIA.this).cpu.scheduler.addEvent(this);
        }
    };

    public CIA(MOS6510Core cpu, int offset, ExtChip chips) {
        this.cpu = cpu;
        this.offset = offset;
        this.chips = chips;
        this.timerA = new CIATimer("TimerA", 1, true, null);
        this.timerA.otherTimer = this.timerB = new CIATimer("TimerB", 2, false, this.timerA);
        this.todEvent.time = cpu.cycles + 10000L;
        cpu.scheduler.addEvent(this.todEvent);
    }

    public void reset() {
        this.ciaicrRead = 0;
        this.ciaie = 0;
        this.timerA.reset();
        this.timerB.reset();
        this.tod10sec = 0;
        this.todsec = 0;
        this.todmin = 0;
        this.todhour = 0;
        this.updateInterrupts();
    }

    public String ciaID() {
        return this.offset == 68608 ? "CIA 1" : "CIA 2";
    }

    public int performRead(int address, long cycles) {
        switch (address -= this.offset) {
            case 2: {
                return this.ddra;
            }
            case 3: {
                return this.ddrb;
            }
            case 0: {
                return (this.pra | ~this.ddra) & 0xFF;
            }
            case 1: {
                int data = (this.prb | ~this.ddrb) & 0xFF;
                if ((this.timerA.cr & 2) > 0) {
                    data &= 0xBF;
                    data = (this.timerA.cr & 4) > 0 ? (data |= this.timerA.flipflop ? 64 : 0) : (data |= this.timerA.underflow ? 64 : 0);
                }
                if ((this.timerB.cr & 2) > 0) {
                    data &= 0x7F;
                    data = (this.timerB.cr & 4) > 0 ? (data |= this.timerB.flipflop ? 128 : 0) : (data |= this.timerB.underflow ? 128 : 0);
                }
                return data;
            }
            case 4: {
                return this.timerA.getTimer(cycles) & 0xFF;
            }
            case 5: {
                return this.timerA.getTimer(cycles) >> 8;
            }
            case 6: {
                return this.timerB.getTimer(cycles) & 0xFF;
            }
            case 7: {
                return this.timerB.getTimer(cycles) & 0xFF;
            }
            case 8: {
                return this.tod10sec;
            }
            case 9: {
                return this.todsec;
            }
            case 10: {
                return this.todmin;
            }
            case 11: {
                return this.todhour;
            }
            case 12: {
                return this.sdr;
            }
            case 14: {
                return this.timerA.cr;
            }
            case 15: {
                return this.timerB.cr;
            }
            case 13: {
                int val = this.ciaicrRead;
                this.ciaicrRead = 0;
                this.updateInterrupts();
                return val;
            }
        }
        return 255;
    }

    public void performWrite(int address, int data, long cycles) {
        switch (address -= this.offset) {
            case 2: {
                this.ddra = data;
                break;
            }
            case 3: {
                this.ddrb = data;
                break;
            }
            case 0: {
                this.pra = data;
                break;
            }
            case 1: {
                this.prb = data;
                break;
            }
            case 4: {
                this.timerA.latch = this.timerA.latch & 0xFF00 | data;
                break;
            }
            case 5: {
                this.timerA.latch = this.timerA.latch & 0xFF | data << 8;
                if (this.timerA.state != 0) break;
                this.timerA.timer = this.timerA.latch;
                break;
            }
            case 6: {
                this.timerB.latch = this.timerB.latch & 0xFF00 | data;
                break;
            }
            case 7: {
                this.timerB.latch = this.timerB.latch & 0xFF | data << 8;
                if (this.timerB.state != 0) break;
                this.timerB.timer = this.timerB.latch;
                break;
            }
            case 8: {
                this.tod10sec = data;
                break;
            }
            case 9: {
                this.todsec = data;
                break;
            }
            case 10: {
                this.todmin = data;
                break;
            }
            case 11: {
                this.todhour = data;
                break;
            }
            case 13: {
                boolean val;
                boolean bl = val = (data & 0x80) != 0;
                this.ciaie = val ? (this.ciaie |= data & 0x7F) : (this.ciaie &= ~data);
                this.updateInterrupts();
                System.out.println(this.ciaID() + " ====> IE = " + this.ciaie);
                break;
            }
            case 14: {
                this.timerA.writeCR(cycles, data);
                this.timerA.countCycles = (data & 0x20) == 0;
                break;
            }
            case 15: {
                this.timerB.writeCR(cycles, data);
                this.timerB.countCycles = (data & 0x60) == 0;
                this.timerB.countUnderflow = (data & 0x60) == 64;
            }
        }
    }

    private void updateInterrupts() {
        if ((this.ciaie & this.ciaicrRead & 0x1F) != 0) {
            this.ciaicrRead |= 0x80;
            if (this.offset == 68608) {
                this.chips.setIRQ(2);
            } else {
                this.chips.setNMI(2);
            }
        } else if (this.offset == 68608) {
            this.chips.clearIRQ(2);
        } else {
            this.chips.clearNMI(2);
        }
    }

    private void println(String s) {
        System.out.println(this.ciaID() + ": " + s);
    }

    public void printStatus() {
        System.out.println("--------------------------");
        this.println(" status");
        System.out.println("Timer A state: " + this.timerA.state);
        System.out.println("Timer A next trigger: " + this.timerA.nextZero);
        System.out.println("CIA CRA: " + Hex.hex2(this.timerA.cr) + " => " + ((this.timerA.cr & 8) == 0 ? "cont" : "one-shot"));
        System.out.println("Timer A Latch: " + this.timerA.latch);
        System.out.println("Timer B state: " + this.timerB.state);
        System.out.println("Timer B next trigger: " + this.timerB.nextZero);
        System.out.println("CIA CRB: " + Hex.hex2(this.timerA.cr) + " => " + ((this.timerB.cr & 8) == 0 ? "cont" : "one-shot"));
        System.out.println("Timer B Latch: " + this.timerB.latch);
        System.out.println("--------------------------");
    }

    private class CIATimer {
        private static final int STOP = 0;
        private static final int WAIT = 1;
        private static final int LOAD_STOP = 2;
        private static final int LOAD_COUNT = 3;
        private static final int LOAD_WAIT_COUNT = 5;
        private static final int COUNT = 6;
        private static final int COUNT_STOP = 7;
        CIATimer otherTimer;
        int state = 0;
        int latch = 0;
        int timer = 0;
        long nextUpdate = 0L;
        long nextZero = 0L;
        long lastLatch = 0L;
        boolean interruptNext = false;
        boolean underflow = false;
        boolean flipflop = false;
        boolean countCycles = false;
        boolean countUnderflow = false;
        TimeEvent updateEvent = new TimeEvent(0L){

            @Override
            public void execute(long cycles) {
                CIATimer.this.doUpdate(cycles);
                if (CIATimer.this.state != 0) {
                    ((CIA)CIA.this).cpu.scheduler.addEvent(this, CIATimer.this.nextUpdate);
                }
            }
        };
        int writeCR = -1;
        int cr = 0;
        String id;
        int iflag;
        boolean updateOther;

        CIATimer(String id, int flag, boolean uo, CIATimer other) {
            this.id = id;
            this.otherTimer = other;
            this.iflag = flag;
            this.updateOther = uo;
        }

        private void reset() {
            this.latch = 65535;
            this.timer = 65535;
            this.countUnderflow = false;
            this.flipflop = false;
            this.state = 0;
            this.nextZero = 0L;
            this.nextUpdate = 0L;
            this.writeCR = -1;
            ((CIA)CIA.this).cpu.scheduler.removeEvent(this.updateEvent);
        }

        private int getTimer(long cycles) {
            if (this.state != 6) {
                return this.timer;
            }
            int t = (int)(this.nextZero - cycles);
            if (t < 0) {
                t = 0;
            }
            this.timer = t;
            return t;
        }

        private void loadTimer(long cycles) {
            this.timer = this.latch;
            this.nextZero = cycles + (long)this.latch;
        }

        private void triggerInterrupt(long cycles) {
            this.interruptNext = true;
            this.underflow = true;
            boolean bl = this.flipflop = !this.flipflop;
            if ((this.cr & 8) != 0) {
                this.cr &= 0xFE;
                this.writeCR &= 0xFE;
                this.state = 2;
            } else {
                this.state = 3;
            }
        }

        void writeCR(long cycles, int data) {
            this.writeCR = data;
            if (this.nextUpdate > cycles + 1L || !this.updateEvent.scheduled) {
                this.nextUpdate = cycles + 1L;
                ((CIA)CIA.this).cpu.scheduler.addEvent(this.updateEvent, this.nextUpdate);
            }
        }

        public void doUpdate(long cycles) {
            if (this.nextUpdate == 0L) {
                this.nextUpdate = cycles;
                this.nextZero = cycles;
            }
            if (cycles == this.nextUpdate) {
                this.update(cycles);
            } else {
                while (cycles >= this.nextUpdate) {
                    System.out.println(CIA.this.ciaID() + ": " + this.id + " ** update at: " + cycles + " expected: " + this.nextUpdate + " state: " + this.state);
                    this.update(this.nextUpdate);
                }
            }
        }

        public void update(long cycles) {
            this.underflow = false;
            this.nextUpdate = cycles + 1L;
            if (this.interruptNext) {
                CIA.this.ciaicrRead |= this.iflag;
                this.interruptNext = false;
                CIA.this.updateInterrupts();
            }
            this.getTimer(cycles);
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 6;
                    break;
                }
                case 2: {
                    this.loadTimer(cycles);
                    this.state = 0;
                    break;
                }
                case 3: {
                    this.loadTimer(cycles);
                    this.state = 6;
                    break;
                }
                case 5: {
                    if (this.nextZero == cycles + 1L) {
                        this.triggerInterrupt(cycles);
                    }
                    this.state = 1;
                    this.loadTimer(cycles);
                    break;
                }
                case 7: {
                    if (!this.countUnderflow) {
                        this.timer = (int)(cycles - this.nextZero);
                        if (this.timer < 0) {
                            this.timer = 0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 6: {
                    if (this.countUnderflow) {
                        if (this.otherTimer.underflow) {
                            --this.timer;
                        }
                        if (this.timer > 0) break;
                        this.triggerInterrupt(cycles);
                        break;
                    }
                    if (cycles >= this.nextZero && this.state != 0) {
                        this.state = 3;
                        this.triggerInterrupt(cycles);
                        break;
                    }
                    this.nextUpdate = this.nextZero;
                }
            }
            if (this.writeCR != -1) {
                this.delayedWrite(cycles);
                this.writeCR = -1;
            }
        }

        void delayedWrite(long cycles) {
            this.nextUpdate = cycles + 1L;
            switch (this.state) {
                case 0: 
                case 2: {
                    if ((this.writeCR & 1) > 0) {
                        if ((this.writeCR & 0x10) > 0) {
                            this.state = 5;
                            break;
                        }
                        this.loadTimer(cycles);
                        this.state = 1;
                        break;
                    }
                    if ((this.writeCR & 0x10) <= 0) break;
                    this.state = 2;
                    break;
                }
                case 6: {
                    if ((this.writeCR & 1) > 0) {
                        if ((this.writeCR & 0x10) <= 0) break;
                        this.state = 5;
                        break;
                    }
                    if ((this.writeCR & 0x10) > 0) {
                        this.state = 2;
                        break;
                    }
                    this.state = 7;
                    break;
                }
                case 1: 
                case 3: {
                    if ((this.writeCR & 1) > 0) {
                        if ((this.writeCR & 8) > 0) {
                            this.writeCR &= 0xFE;
                            this.state = 0;
                            break;
                        }
                        if ((this.writeCR & 0x10) <= 0) break;
                        this.state = 5;
                        break;
                    }
                    this.state = 7;
                }
            }
            this.cr = this.writeCR & 0xEF;
        }
    }
}

