/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.EventQueue;
import com.dreamfabric.jac64.ExtChip;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.MOS6510Ops;
import com.dreamfabric.jac64.PatchListener;
import java.io.BufferedInputStream;
import java.io.InputStream;

public abstract class MOS6510Core
extends MOS6510Ops {
    protected int[] memory;
    protected boolean debug = false;
    public static final int NMI_DELAY = 2;
    public static final int IRQ_DELAY = 2;
    public static final int NMI_INT = 1;
    public static final int IRQ_INT = 2;
    protected PatchListener list;
    protected ExtChip chips = null;
    protected IMonitor monitor;
    public String codebase;
    public boolean checkInterrupt = false;
    public boolean NMILow = false;
    public boolean NMILastLow = false;
    private boolean IRQLow = false;
    public int lastInterrupt = 0;
    public boolean busAvailable = true;
    public long baLowUntil = 0L;
    boolean sign = false;
    boolean zero = false;
    boolean overflow = false;
    boolean carry = false;
    boolean decimal = false;
    boolean brk = false;
    boolean resetFlag = false;
    protected int acc = 0;
    protected int x = 0;
    protected int y = 0;
    protected int s = 255;
    protected long nmiCycleStart = 0L;
    protected long irqCycleStart = 0L;
    protected EventQueue scheduler = new EventQueue();
    private String[] debugInfo;
    protected int jumpTo = -1;
    public long cycles = 0L;
    protected long lastMillis = 0L;
    protected long nr_ins = 0L;
    protected long nr_irq = 0L;
    protected long start = System.currentTimeMillis();
    protected int pc;
    protected int interruptInExec = 0;
    protected boolean disableInterupt = false;
    protected int rindex = 0;
    protected int lastReadOP = 0;

    public MOS6510Core(IMonitor m, String cb) {
        this.monitor = m;
        this.codebase = cb;
    }

    public abstract String getName();

    public int[] getMemory() {
        return this.memory;
    }

    public void jump(int pc) {
        this.jumpTo = pc;
        this.checkInterrupt = true;
    }

    public long getCycles() {
        return this.cycles;
    }

    public void setIRQLow(boolean low) {
        if (!this.IRQLow && low) {
            this.checkInterrupt = true;
            this.irqCycleStart = this.cycles + 2L;
        }
        this.IRQLow = low;
    }

    public void setNMILow(boolean low) {
        if (!this.NMILow && low) {
            this.checkInterrupt = true;
            this.nmiCycleStart = this.cycles + 2L;
        }
        this.NMILow = low;
        if (!low) {
            this.NMILastLow = low;
        }
    }

    public int getSP() {
        return this.s;
    }

    private final void doInterrupt(int adr, int status) {
        this.fetchByte(this.pc);
        this.fetchByte(this.pc + 1);
        this.push((this.pc & 0xFF00) >> 8);
        this.push(this.pc & 0xFF);
        this.push(status);
        ++this.interruptInExec;
        this.pc = this.fetchByte(adr + 1) << 8;
        this.pc += this.fetchByte(adr);
    }

    protected final int getStatusByte() {
        return (this.carry ? 1 : 0) + (this.zero ? 2 : 0) + (this.disableInterupt ? 4 : 0) + (this.decimal ? 8 : 0) + (this.brk ? 16 : 0) + 32 + (this.overflow ? 64 : 0) + (this.sign ? 128 : 0);
    }

    private final void setStatusByte(int status) {
        this.carry = (status & 1) != 0;
        this.zero = (status & 2) != 0;
        this.disableInterupt = (status & 4) != 0;
        this.decimal = (status & 8) != 0;
        this.brk = (status & 0x10) != 0;
        this.overflow = (status & 0x40) != 0;
        this.sign = (status & 0x80) != 0;
    }

    protected abstract int fetchByte(int var1);

    protected abstract void writeByte(int var1, int var2);

    private final void setZS(int data) {
        this.zero = data == 0;
        this.sign = data > 127;
    }

    private final void setCarry(int data) {
        this.carry = data > 127;
    }

    private final int pop() {
        this.s = this.s + 1 & 0xFF;
        int r = this.fetchByte(this.s | 0x100);
        return r;
    }

    private final void push(int data) {
        this.writeByte(this.s & 0xFF | 0x100, data);
        this.s = this.s - 1 & 0xFF;
    }

    private final void opADCimp(int data) {
        int tmp = data + this.acc + (this.carry ? 1 : 0);
        boolean bl = this.zero = (tmp & 0xFF) == 0;
        if (this.decimal) {
            tmp = (this.acc & 0xF) + (data & 0xF) + (this.carry ? 1 : 0);
            if (tmp > 9) {
                tmp += 6;
            }
            tmp = tmp <= 15 ? (tmp & 0xF) + (this.acc & 0xF0) + (data & 0xF0) : (tmp & 0xF) + (this.acc & 0xF0) + (data & 0xF0) + 16;
            this.overflow = ((this.acc ^ data) & 0x80) == 0 && ((this.acc ^ tmp) & 0x80) != 0;
            boolean bl2 = this.sign = (tmp & 0x80) > 0;
            if ((tmp & 0x1F0) > 144) {
                tmp += 96;
            }
            this.carry = tmp > 153;
        } else {
            this.overflow = ((this.acc ^ data) & 0x80) == 0 && ((this.acc ^ tmp) & 0x80) != 0;
            this.carry = tmp > 255;
            this.sign = (tmp & 0x80) > 0;
        }
        this.acc = tmp & 0xFF;
    }

    private final void branch(boolean branch, int adr, int cycDiff) {
        if (branch) {
            int oldPC = this.pc;
            this.pc = adr;
            if (cycDiff == 1) {
                this.fetchByte(this.pc);
            } else {
                if (this.pc < oldPC) {
                    this.fetchByte(this.pc + 256);
                } else {
                    this.fetchByte(this.pc - 256);
                }
                this.fetchByte(this.pc);
            }
        }
    }

    private final void opSBCimp(int data) {
        int tmp = this.acc - data - (this.carry ? 0 : 1);
        boolean nxtcarry = tmp >= 0;
        this.sign = ((tmp &= 0x1FF) & 0x80) == 128;
        this.zero = (tmp & 0xFF) == 0;
        boolean bl = this.overflow = ((this.acc ^ tmp) & 0x80) != 0 && ((this.acc ^ data) & 0x80) != 0;
        if (this.decimal) {
            tmp = (this.acc & 0xF) - (data & 0xF) - (this.carry ? 0 : 1);
            if (((tmp = (tmp & 0x10) > 0 ? tmp - 6 & 0xF | (this.acc & 0xF0) - (data & 0xF0) - 16 : tmp & 0xF | (this.acc & 0xF0) - (data & 0xF0)) & 0x100) > 0) {
                tmp -= 96;
            }
        }
        this.acc = tmp & 0xFF;
        this.carry = nxtcarry;
    }

    public void emulateOp() {
        if (this.checkInterrupt) {
            if (this.NMILow && !this.NMILastLow && this.cycles >= this.nmiCycleStart) {
                this.log("NMI interrupt at " + this.cycles);
                this.lastInterrupt = 1;
                this.doInterrupt(65530, this.getStatusByte() & 0xEF);
                this.disableInterupt = true;
                this.NMILastLow = this.NMILow;
                return;
            }
            if (this.IRQLow && this.cycles >= this.irqCycleStart || this.brk) {
                if (!this.disableInterupt) {
                    this.log("IRQ interrupt > " + this.IRQLow + " BRK: " + this.brk);
                    this.lastInterrupt = 2;
                    int status = this.getStatusByte();
                    if (this.brk) {
                        status |= 0x10;
                        ++this.pc;
                    } else {
                        status &= 0xEF;
                    }
                    this.doInterrupt(65534, status);
                    this.disableInterupt = true;
                    this.brk = false;
                    return;
                }
                this.brk = false;
                this.checkInterrupt = this.NMILow && !this.NMILastLow;
            } else if (this.resetFlag) {
                this.doReset();
            } else if (this.jumpTo != -1) {
                this.pc = this.jumpTo;
                this.jumpTo = -1;
            }
        }
        int data = INSTRUCTION_SET[this.fetchByte(this.pc++)];
        int op = data & 0xFF;
        int addrMode = data & 0xF00;
        boolean read = (data & 0x1000) != 0;
        boolean write = (data & 0x2000) != 0;
        int adr = 0;
        int tmp = 0;
        boolean nxtcarry = false;
        this.lastReadOP = this.rindex;
        int p1 = this.fetchByte(this.pc);
        switch (addrMode) {
            case 256: {
                ++this.pc;
                data = p1;
                break;
            }
            case 768: {
                ++this.pc;
                adr = (this.fetchByte(this.pc++) << 8) + p1;
                if (!read) break;
                data = this.fetchByte(adr);
                break;
            }
            case 512: {
                ++this.pc;
                adr = p1;
                if (!read) break;
                data = this.fetchByte(adr);
                break;
            }
            case 1024: 
            case 1280: {
                ++this.pc;
                this.fetchByte(p1);
                adr = addrMode == 1024 ? p1 + this.x & 0xFF : p1 + this.y & 0xFF;
                if (!read) break;
                data = this.fetchByte(adr);
                break;
            }
            case 1536: 
            case 1792: {
                ++this.pc;
                adr = this.fetchByte(this.pc++) << 8;
                p1 = addrMode == 1536 ? (p1 += this.x) : (p1 += this.y);
                data = this.fetchByte(adr + (p1 & 0xFF));
                adr += p1;
                if (!read || p1 <= 255 && !write) break;
                data = this.fetchByte(adr);
                break;
            }
            case 2048: {
                ++this.pc;
                adr = this.pc + (byte)p1;
                if (((adr ^ this.pc) & 0xFF00) > 0) {
                    tmp = 2;
                    break;
                }
                tmp = 1;
                break;
            }
            case 2816: {
                data = this.acc;
                write = false;
                break;
            }
            case 2304: {
                ++this.pc;
                this.fetchByte(p1);
                tmp = p1 + this.x & 0xFF;
                adr = this.fetchByte(tmp + 1) << 8;
                adr |= this.fetchByte(tmp);
                if (!read) break;
                data = this.fetchByte(adr);
                break;
            }
            case 2560: {
                ++this.pc;
                adr = this.fetchByte(p1 + 1) << 8;
                p1 = this.fetchByte(p1);
                data = this.fetchByte(adr + ((p1 += this.y) & 0xFF));
                adr += p1;
                if (!read || p1 <= 255 && !write) break;
                data = this.fetchByte(adr);
                break;
            }
            case 3072: {
                ++this.pc;
                adr = (this.fetchByte(this.pc) << 8) + p1;
                tmp = adr & 0xFFF00 | adr + 1 & 0xFF;
                adr = this.fetchByte(adr);
                adr += this.fetchByte(tmp) << 8;
            }
        }
        if (read && write) {
            this.writeByte(adr, data);
        }
        switch (op) {
            case 0: {
                this.brk = true;
                this.checkInterrupt = true;
                break;
            }
            case 11: {
                this.acc &= data;
                this.setZS(this.acc);
                break;
            }
            case 28: {
                this.opADCimp(data);
                break;
            }
            case 70: {
                this.opSBCimp(data);
                break;
            }
            case 1: {
                this.acc |= data;
                this.setZS(this.acc);
                break;
            }
            case 19: {
                this.acc ^= data;
                this.setZS(this.acc);
                break;
            }
            case 13: {
                this.sign = data > 127;
                this.overflow = (data & 0x40) > 0;
                this.zero = (this.acc & data) == 0;
                break;
            }
            case 21: {
                this.carry = (data & 1) != 0;
                this.zero = (data >>= 1) == 0;
                this.sign = false;
                break;
            }
            case 14: {
                data = (data << 1) + (this.carry ? 1 : 0);
                this.carry = (data & 0x100) != 0;
                this.setZS(data &= 0xFF);
                break;
            }
            case 30: {
                nxtcarry = (data & 1) != 0;
                data = (data >> 1) + (this.carry ? 128 : 0);
                this.carry = nxtcarry;
                this.setZS(data);
                break;
            }
            case 40: {
                this.acc = this.x;
                this.setZS(this.acc);
                break;
            }
            case 53: {
                this.x = this.acc;
                this.setZS(this.x);
                break;
            }
            case 44: {
                this.acc = this.y;
                this.setZS(this.acc);
                break;
            }
            case 55: {
                this.y = this.acc;
                this.setZS(this.y);
                break;
            }
            case 58: {
                this.x = this.s;
                this.setZS(this.x);
                break;
            }
            case 45: {
                this.s = this.x & 0xFF;
                break;
            }
            case 63: {
                data = data - 1 & 0xFF;
                this.setZS(data);
                break;
            }
            case 72: {
                data = data + 1 & 0xFF;
                this.setZS(data);
                break;
            }
            case 73: {
                this.x = this.x + 1 & 0xFF;
                this.setZS(this.x);
                break;
            }
            case 65: {
                this.x = this.x - 1 & 0xFF;
                this.setZS(this.x);
                break;
            }
            case 64: {
                this.y = this.y + 1 & 0xFF;
                this.setZS(this.y);
                break;
            }
            case 39: {
                this.y = this.y - 1 & 0xFF;
                this.setZS(this.y);
                break;
            }
            case 10: {
                ++this.pc;
                adr = (this.fetchByte(this.pc) << 8) + p1;
                this.fetchByte(this.s | 0x100);
                this.push((this.pc & 0xFF00) >> 8);
                this.push(this.pc & 0xFF);
                this.pc = adr;
                break;
            }
            case 24: {
                this.pc = adr;
                break;
            }
            case 27: {
                this.fetchByte(this.s | 0x100);
                this.pc = this.pop() + (this.pop() << 8);
                ++this.pc;
                this.fetchByte(this.pc);
                break;
            }
            case 18: {
                this.fetchByte(this.s | 0x100);
                tmp = this.pop();
                this.setStatusByte(tmp);
                this.pc = this.pop() + (this.pop() << 8);
                this.brk = false;
                --this.interruptInExec;
                this.checkInterrupt = true;
                break;
            }
            case 2: {
                this.monitor.info("TRAP Instruction executed");
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.setCarry(data);
                data = data << 1 & 0xFF;
                this.setZS(data);
                break;
            }
            case 22: {
                this.push(this.acc);
                break;
            }
            case 31: {
                this.fetchByte(this.s | 0x100);
                this.acc = this.pop();
                this.setZS(this.acc);
                break;
            }
            case 6: {
                this.brk = true;
                this.push(this.getStatusByte());
                this.brk = false;
                break;
            }
            case 15: {
                tmp = this.pop();
                this.setStatusByte(tmp);
                this.brk = false;
                this.checkInterrupt = true;
                break;
            }
            case 7: {
                this.acc &= data;
                this.setZS(this.acc);
                this.carry = (this.acc & 0x80) != 0;
                break;
            }
            case 61: {
                data = this.acc - data;
                this.carry = data >= 0;
                this.setZS(data & 0xFF);
                break;
            }
            case 69: {
                data = this.x - data;
                this.carry = data >= 0;
                this.setZS(data & 0xFF);
                break;
            }
            case 60: {
                data = this.y - data;
                this.carry = data >= 0;
                this.setZS(data & 0xFF);
                break;
            }
            case 42: {
                this.branch(!this.carry, adr, tmp);
                break;
            }
            case 56: {
                this.branch(this.carry, adr, tmp);
                break;
            }
            case 74: {
                this.branch(this.zero, adr, tmp);
                break;
            }
            case 67: {
                this.branch(!this.zero, adr, tmp);
                break;
            }
            case 25: {
                this.branch(!this.overflow, adr, tmp);
                break;
            }
            case 33: {
                this.branch(this.overflow, adr, tmp);
                break;
            }
            case 8: {
                this.branch(!this.sign, adr, tmp);
                break;
            }
            case 16: {
                this.branch(this.sign, adr, tmp);
                break;
            }
            case 9: {
                this.carry = false;
                break;
            }
            case 17: {
                this.carry = true;
                break;
            }
            case 68: {
                this.decimal = false;
                break;
            }
            case 75: {
                this.decimal = true;
                break;
            }
            case 57: {
                this.overflow = false;
                break;
            }
            case 34: {
                this.disableInterupt = true;
                break;
            }
            case 26: {
                this.disableInterupt = false;
                this.checkInterrupt = true;
                this.log(this.getName() + " Enabled interrupts: IRQ: " + this.chips.getIRQFlags() + " IRQLow: " + this.IRQLow);
                break;
            }
            case 50: {
                this.acc = data;
                this.setZS(data);
                break;
            }
            case 51: {
                this.x = data;
                this.setZS(data);
                break;
            }
            case 49: {
                this.y = data;
                this.setZS(data);
                break;
            }
            case 36: {
                data = this.acc;
                break;
            }
            case 38: {
                data = this.x;
                break;
            }
            case 37: {
                data = this.y;
                break;
            }
            case 41: {
                this.acc = p1 & this.x & (this.acc | 0xEE);
                this.setZS(this.acc);
                break;
            }
            case 32: {
                tmp = p1 & this.acc;
                int n = this.acc = this.carry ? tmp >> 1 | 0x80 : tmp >> 1;
                if (!this.decimal) {
                    this.setZS(this.acc);
                    this.carry = (this.acc & 0x40) != 0;
                    this.overflow = (this.acc & 0x40 ^ (this.acc & 0x20) << 1) != 0;
                    break;
                }
                this.sign = this.carry;
                this.zero = this.acc == 0;
                boolean bl = this.overflow = ((tmp ^ this.acc) & 0x40) != 0;
                if ((tmp & 0xF) + (tmp & 1) > 5) {
                    this.acc = this.acc & 0xF0 | this.acc + 6 & 0xF;
                }
                if (!(this.carry = (tmp + (tmp & 0x10) & 0x1F0) > 80)) break;
                this.acc += 96;
                break;
            }
            case 23: {
                this.acc &= data;
                nxtcarry = (this.acc & 1) != 0;
                this.acc >>= 1;
                this.carry = nxtcarry;
                this.setZS(this.acc);
                break;
            }
            case 62: {
                data = data - 1 & 0xFF;
                this.setZS(data);
                tmp = this.acc - data;
                this.carry = tmp >= 0;
                this.setZS(tmp & 0xFF);
                break;
            }
            case 71: {
                data = data + 1 & 0xFF;
                this.opSBCimp(data);
                break;
            }
            case 52: {
                this.acc = this.x = data;
                this.setZS(this.acc);
                break;
            }
            case 59: {
                this.x = this.s = data & this.s;
                this.acc = this.s;
                this.setZS(this.acc);
                break;
            }
            case 54: {
                this.x = this.acc = (this.acc | 0xEE) & p1;
                this.setZS(this.acc);
                break;
            }
            case 12: {
                data = (data << 1) + (this.carry ? 1 : 0);
                this.carry = (data & 0x100) != 0;
                this.acc &= (data &= 0xFF);
                this.zero = this.acc == 0;
                this.sign = this.acc > 127;
                break;
            }
            case 29: {
                nxtcarry = (data & 1) != 0;
                data = (data >> 1) + (this.carry ? 128 : 0);
                this.carry = nxtcarry;
                this.opADCimp(data);
                break;
            }
            case 66: {
                this.x = (this.acc & this.x) - p1;
                this.carry = this.x >= 0;
                this.x &= 0xFF;
                this.setZS(this.x);
                break;
            }
            case 43: {
                data = this.acc & this.x & (adr >> 8) + 1;
                break;
            }
            case 46: {
                data = this.acc & this.x & (adr >> 8) + 1;
                this.s = this.acc & this.x;
                break;
            }
            case 48: {
                data = this.x & (adr >> 8) + 1;
                break;
            }
            case 47: {
                data = this.y & (adr >> 8) + 1;
                break;
            }
            case 35: {
                data = this.acc & this.x;
                break;
            }
            case 20: {
                this.carry = (data & 1) != 0;
                this.acc ^= (data >>= 1);
                this.setZS(this.acc);
                break;
            }
            case 3: {
                this.setCarry(data);
                data = data << 1 & 0xFF;
                this.acc |= data;
                this.setZS(this.acc);
                break;
            }
            default: {
                this.unknownInstruction(this.pc, op);
            }
        }
        if (write) {
            this.writeByte(adr, data);
        } else if (addrMode == 2816) {
            this.acc = data;
        }
    }

    public void unknownInstruction(int pc, int op) {
        System.out.println("Unknown instruction: " + op);
    }

    public void init(ExtChip scr) {
        MOS6510Ops.init();
        this.installROMS();
        this.chips = scr;
    }

    protected abstract void installROMS();

    protected abstract void patchROM(PatchListener var1);

    public void hardReset() {
        for (int i = 0; i < 65536; ++i) {
            this.memory[i] = 0;
        }
        this.reset();
    }

    private void doReset() {
        this.sign = false;
        this.zero = false;
        this.overflow = false;
        this.carry = false;
        this.decimal = false;
        this.brk = false;
        this.disableInterupt = false;
        this.interruptInExec = 0;
        this.rindex = 0;
        this.checkInterrupt = false;
        this.NMILow = false;
        this.NMILastLow = false;
        this.IRQLow = false;
        this.log("Set IRQLOW to false...");
        this.resetFlag = false;
        this.scheduler.empty();
        this.chips.reset();
        this.pc = this.fetchByte(65532) + (this.fetchByte(65533) << 8);
        this.log("Reset to: " + this.pc);
        if (this.list != null) {
            this.patchROM(this.list);
        }
    }

    public void reset() {
        this.NMILow = false;
        this.brk = false;
        this.IRQLow = false;
        this.log("Set IRQLOW to false...");
        this.resetFlag = true;
        this.checkInterrupt = true;
    }

    public void setDebug(int adr, String msg) {
        if (this.debugInfo == null) {
            this.debugInfo = new String[65536];
        }
        this.debugInfo[adr & 0xFFFF] = msg;
    }

    public String getDebug(int adr) {
        if (this.debugInfo != null) {
            return this.debugInfo[adr & 0xFFFF];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadROM(InputStream ins, int startMem, int len) {
        block15: {
            try {
                BufferedInputStream stream = new BufferedInputStream(ins);
                if (stream == null) break block15;
                byte[] charBuf = new byte[len];
                int pos = 0;
                try {
                    int t;
                    while ((t = stream.read(charBuf, pos, len - pos)) > 0) {
                        pos += t;
                    }
                    this.monitor.info("Installing rom at :" + Integer.toString(startMem, 16) + " size:" + pos);
                    for (int i = 0; i < charBuf.length; ++i) {
                        this.memory[i + startMem] = charBuf[i] & 0xFF;
                    }
                }
                catch (Exception e) {
                    this.monitor.error("Problem reading rom file ");
                    e.printStackTrace();
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void log(String s) {
        if (this.debug) {
            this.monitor.info(this.getName() + " : " + s);
        }
    }

    public boolean getIRQLow() {
        return this.IRQLow;
    }
}

