/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.AudioDriver;
import com.dreamfabric.jac64.ExtChip;
import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.TimeEvent;
import resid.ISIDDefs;
import resid.SID;

public class RESIDChip
extends ExtChip {
    static final int SAMPLE_RATE = 44000;
    static final int DL_BUFFER_SIZE = 44000;
    int BUFFER_SIZE = 256;
    byte[] buffer = new byte[this.BUFFER_SIZE * 2];
    SID sid;
    int CPUFrq = 985248;
    int clocksPerSample = this.CPUFrq / 44000;
    int clocksPerSampleRest = 0;
    long nextSample = 0L;
    long lastCycles = 0L;
    private int nextRest = 0;
    private int pos = 0;
    private AudioDriver driver;
    private boolean removeSample = false;
    TimeEvent sampleEvent = new TimeEvent(0L, "resid event"){

        @Override
        public void execute(long cycles) {
            RESIDChip.this.nextSample += (long)RESIDChip.this.clocksPerSample;
            RESIDChip.this.nextRest = RESIDChip.this.nextRest + RESIDChip.this.clocksPerSampleRest;
            if (RESIDChip.this.nextRest > 1000) {
                RESIDChip.this.nextRest = RESIDChip.this.nextRest - 1000;
                ++RESIDChip.this.nextSample;
            }
            while (RESIDChip.this.lastCycles < cycles) {
                RESIDChip.this.sid.clock();
                ++RESIDChip.this.lastCycles;
            }
            int sample = RESIDChip.this.sid.output();
            RESIDChip.this.buffer[((RESIDChip)RESIDChip.this).pos++] = (byte)(sample & 0xFF);
            RESIDChip.this.buffer[((RESIDChip)RESIDChip.this).pos++] = (byte)(sample >> 8);
            if (RESIDChip.this.pos == RESIDChip.this.buffer.length) {
                RESIDChip.this.writeSamples();
            }
            this.time = RESIDChip.this.nextSample;
            if (!RESIDChip.this.removeSample) {
                RESIDChip.this.cpu.scheduler.addEvent(this);
            }
        }
    };

    public RESIDChip(MOS6510Core cpu, AudioDriver audio) {
        this.init(cpu);
        this.driver = audio;
        this.sid = new SID();
        this.lastCycles = cpu.cycles;
        this.nextSample = cpu.cycles;
        this.sid.set_sampling_parameters(this.CPUFrq, ISIDDefs.sampling_method.SAMPLE_FAST, 44000.0, -1.0, 0.97);
        this.clocksPerSampleRest = (int)((long)this.CPUFrq * 1000L / 44000L);
        this.clocksPerSampleRest -= this.clocksPerSample * 1000;
        System.out.println("ClocksPer Sample: " + this.clocksPerSample + "." + this.clocksPerSampleRest);
        this.sampleEvent.time = cpu.cycles + 5L;
        cpu.scheduler.addEvent(this.sampleEvent);
    }

    @Override
    public void clock(long cycles) {
    }

    private void writeSamples() {
        this.driver.write(this.buffer);
        this.pos = 0;
    }

    @Override
    public int performRead(int address, long cycles) {
        return this.sid.read(address - 12288 - 54272);
    }

    @Override
    public void performWrite(int address, int data, long cycles) {
        this.sid.write(address - 12288 - 54272, data);
    }

    @Override
    public void reset() {
        this.nextSample = this.cpu.cycles + 10L;
        this.lastCycles = this.cpu.cycles;
        this.cpu.scheduler.addEvent(this.sampleEvent, this.nextSample);
        this.sid.reset();
    }

    @Override
    public void stop() {
        this.removeSample = true;
    }

    public void setChipVersion(int version) {
        if (version == 1) {
            this.sid.set_chip_model(ISIDDefs.chip_model.MOS6581);
        } else {
            this.sid.set_chip_model(ISIDDefs.chip_model.MOS8580);
        }
    }
}

