/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.jac64.SIDVoice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;

public class SIDCanvas
extends JComponent {
    SIDVoice sid;
    private static final int ADSR_SIZE = 81;
    private static final int FRQ_SIZE = 81;
    private static final int SAMPLE_SIZE = 110;
    private int[] adsrBuffer = new int[81];
    private int[] frqBuffer = new int[81];
    private int[] sampleBuffer = new int[110];
    private int samplePos = 0;
    private int adsrPos;
    private int frqPos;
    private static final Color PENCOLOR = new Color(49152);
    private static final Color BORDERCOLOR = new Color(0x204020);

    public SIDCanvas(SIDVoice sid) {
        this.sid = sid;
        this.setFont(new Font("Monospaced", 0, 10));
        this.setForeground(Color.green);
        this.setBackground(Color.black);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(282, 80);
    }

    public void updateADSR(double value) {
        this.adsrBuffer[this.adsrPos] = (int)(value * 1000.0);
        this.adsrPos = (this.adsrPos + 1) % 81;
    }

    public void updateFRQ(long value) {
        if ((value /= 8L) > 128L) {
            value = 128L;
        }
        this.frqBuffer[this.frqPos] = (int)value;
        this.frqPos = (this.frqPos + 1) % 81;
    }

    public void updateSamples(int[] samples, int count) {
        int n = count;
        for (int i = 0; i < n; i += 2) {
            this.samplePos = (this.samplePos + 1) % 110;
            this.sampleBuffer[this.samplePos] = samples[i];
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int ix;
        int i;
        int height = this.getHeight();
        g.setColor(PENCOLOR);
        g.drawString("Osc Output", 6, 10);
        int last = height * this.sampleBuffer[this.samplePos % 110] / 16000;
        int n = 109;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = height - 10 - last;
            last = height * this.sampleBuffer[(this.samplePos + i2 + 1) % 110] / 16000;
            g.drawLine(i2, n2, i2 + 1, height - 10 - last);
        }
        int pos = 115;
        g.drawString("ADSR Lv", pos, 10);
        int n3 = 80;
        for (i = 0; i < n3; ++i) {
            ix = (this.adsrPos + i + 81) % 81;
            g.drawLine(pos + i, height - 10 - height * this.adsrBuffer[ix] / 1500, i + pos + 1, height - 10 - height * this.adsrBuffer[(ix + 1) % 81] / 1500);
        }
        g.drawString("Freq.", pos += 86, 10);
        n3 = 80;
        for (i = 0; i < n3; ++i) {
            ix = (this.adsrPos + i + 81) % 81;
            g.drawLine(pos + i, height - 10 - height * this.frqBuffer[ix] / 200, i + pos + 1, height - 10 - height * this.frqBuffer[(ix + 1) % 81] / 200);
        }
    }
}

