/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModUnits;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.ModuleUnits;
import com.vwp.sound.mod.modplay.module.Pattern;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.util.Util;
import com.vwp.sound.mod.util.io.RandomAccess;
import com.vwp.sound.mod.util.io.RandomAccessArray;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class ModLoader
extends ModuleLoader {
    private static final int ID_OFFSET = 1080;
    private Module module;

    public ModLoader(String name, byte[] data) throws InvalidFormatException, IOException {
        this.module = this.load(name, data);
    }

    private Module load(String name, byte[] data) throws InvalidFormatException, IOException {
        RandomAccessArray raf = new RandomAccessArray(data);
        String tracker = "";
        raf.seek(1080L);
        String id = ModLoader.readID(raf);
        IDInfo idInfo = ModLoader.getIdInfo(id);
        tracker = idInfo.tracker;
        id = idInfo.id;
        int tracks = idInfo.trackCount;
        int numberOfInstruments = idInfo.instrumentCount;
        raf.seek(0L);
        String modName = ModLoader.readName(raf);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        ModuleLoader.skip(dis, 20);
        Instrument[] instruments = this.loadInstruments(dis, numberOfInstruments);
        int numPos = dis.readByte() & 0xFF;
        byte restartPos = dis.readByte();
        raf.seek(20 + numberOfInstruments * 30 + 2);
        int[] patternOrder = ModLoader.loadPositions(numPos, raf);
        int numPatterns = ModLoader.getPatternCount(patternOrder);
        ModuleLoader.skip(dis, 128);
        if (!id.equals("NOID")) {
            ModuleLoader.skip(dis, 4);
        }
        Pattern[] patterns = this.loadPatterns(dis, numPatterns, tracks, numberOfInstruments, new ModUnits(7093789.2, false));
        this.loadSampleData(dis, instruments);
        double r = 0.0;
        double l = 1.0;
        double[] panning = new double[]{l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l, l, r, r, l};
        double[] pann = new double[tracks];
        double[] vol = new double[tracks];
        int n = 0;
        while (n < tracks) {
            pann[n] = panning[n];
            vol[n] = 1.0;
            ++n;
        }
        return new Module(modName, id, tracker, instruments, patterns, patternOrder, restartPos, 125, 6, 1.0, 1, vol, pann);
    }

    private void loadSampleData(DataInputStream dis, Instrument[] instruments) throws IOException {
        int n = 0;
        while (n < instruments.length) {
            Sample sample = instruments[n].getSampleByNum(0);
            short[] data = new short[sample.getLength()];
            int m = 0;
            while (m < data.length) {
                data[m] = (short)((dis.readByte() & 0xFF) << 8);
                ++m;
            }
            sample.setData(data);
            ++n;
        }
    }

    private Instrument[] loadInstruments(DataInputStream dis, int numberOfInstruments) throws IOException {
        Instrument[] instruments = new Instrument[numberOfInstruments];
        Sample[] samples = new Sample[numberOfInstruments];
        ModUnits moduleUnits = new ModUnits(7093789.2, false);
        int n = 0;
        while (n < numberOfInstruments) {
            String name = Util.readZeroPaddedString(dis, 22);
            int length = 2 * (dis.readShort() & 0xFFFF);
            int fineTune = dis.readByte();
            if (fineTune > 7) {
                fineTune |= 0xFFFFFFF0;
            }
            double fTune = (double)fineTune / 8.0;
            double volume = (double)dis.readByte() / 64.0;
            int loopStart = 2 * (dis.readShort() & 0xFFFF);
            int loopLength = 2 * (dis.readShort() & 0xFFFF);
            int loopType = loopLength > 2 ? 1 : 0;
            samples[n] = new Sample("sample-" + n, name, volume, 0.0, length, loopType, loopStart, loopLength, 0.0, fTune, moduleUnits);
            ++n;
        }
        int[] noteToSample = new int[60];
        int n2 = 0;
        while (n2 < numberOfInstruments) {
            instruments[n2] = new Instrument(samples[n2].getName(), noteToSample, new Sample[]{samples[n2]}, null, 0.0);
            ++n2;
        }
        return instruments;
    }

    private Pattern[] loadPatterns(DataInputStream dis, int numPatterns, int numTracks, int numSamples, ModuleUnits modUnits) throws InvalidFormatException, IOException {
        Pattern[] patterns = new Pattern[numPatterns];
        int p = 0;
        while (p < numPatterns) {
            Track[] tracks = new Track[numTracks];
            int n = 0;
            while (n < numTracks) {
                tracks[n] = new Track(64);
                ++n;
            }
            n = 0;
            while (n < 64) {
                int m = 0;
                while (m < numTracks) {
                    int data = dis.readInt();
                    int effectNum = (data & 0xF00) >> 8;
                    int effectArg1 = (data & 0xF0) >>> 4;
                    int effectArg2 = data & 0xF;
                    int period = (data & 0xFFF0000) >> 16;
                    effectNum = ModLoader.translateEffectNum(effectNum, effectArg1);
                    if ((double)period > 1712.0) {
                        period = 1712;
                    } else if (period > 0 && (double)period < 57.0) {
                        period = 57;
                    }
                    int note = period != 0 ? (int)Math.round(modUnits.period2note(period)) : -2;
                    int sampleNum = (data & 0xF0000000) >>> 24 | (data & 0xF000) >> 12;
                    if (--sampleNum >= numSamples || sampleNum < 0) {
                        sampleNum = -1;
                    }
                    tracks[m].initDivision(n, sampleNum, note, new int[]{effectNum}, new int[]{effectArg1}, new int[]{effectArg2});
                    ++m;
                }
                ++n;
            }
            patterns[p] = new Pattern(tracks, 64);
            ++p;
        }
        return patterns;
    }

    public Module getModule() {
        return this.module;
    }

    public static int translateEffectNum(int effectNum, int arg1) throws InvalidFormatException {
        switch (effectNum) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                switch (arg1) {
                    case 0: {
                        return 16;
                    }
                    case 1: {
                        return 17;
                    }
                    case 2: {
                        return 18;
                    }
                    case 3: {
                        return 19;
                    }
                    case 4: {
                        return 20;
                    }
                    case 5: {
                        return 21;
                    }
                    case 6: {
                        return 22;
                    }
                    case 7: {
                        return 23;
                    }
                    case 8: {
                        return 24;
                    }
                    case 9: {
                        return 25;
                    }
                    case 10: {
                        return 26;
                    }
                    case 11: {
                        return 27;
                    }
                    case 12: {
                        return 28;
                    }
                    case 13: {
                        return 29;
                    }
                    case 14: {
                        return 30;
                    }
                    case 15: {
                        return 31;
                    }
                }
                break;
            }
            case 15: {
                return 15;
            }
        }
        throw new InvalidFormatException("Illegal effect number: " + effectNum + ":" + arg1);
    }

    public static IDInfo getIdInfo(String id) {
        return IDInfo.getIDInfo(id);
    }

    public static String readID(RandomAccess raf) throws IOException {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        while (count++ < 4) {
            sb.append((char)raf.read());
        }
        return sb.toString();
    }

    public static String readName(RandomAccess raf) throws IOException {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        int data = -1;
        while (count++ < 20 && (data = raf.read()) != 0) {
            sb.append((char)data);
        }
        raf.skipBytes(20 - count);
        return sb.toString();
    }

    public static int[] loadPositions(int numPos, RandomAccess raf) throws IOException {
        int[] patternOrder = new int[numPos];
        int n = 0;
        while (n < numPos) {
            patternOrder[n] = raf.readByte() & 0xFF;
            ++n;
        }
        return patternOrder;
    }

    public static int getPatternCount(int[] positions) {
        int numPatterns = 0;
        int n = 0;
        while (n < positions.length) {
            if (numPatterns < positions[n]) {
                numPatterns = positions[n];
            }
            ++n;
        }
        return ++numPatterns;
    }

    public static class IDInfo {
        public static final String PROTRACKER = "ProTracker";
        public static final String FASTTRACKER_2 = "FastTracker 2";
        public static final String NOISETRACKER = "NoiseTracker";
        public static final String STARTREKKER = "StarTrekker";
        public static final String UNKNOWN_TRACKER = "Unknown";
        public static final String SOUNDTRACKER = "SoundTracker";
        public static final String TAKETRACKER = "TakeTracker";
        public static final String OCTALYZER = "Octalyzer";
        public static final String OKTALYZER = "Oktalyzer";
        public static final String ID_MK = "M.K.";
        public static final String ID_MK_EXT = "M!K!";
        public static final String ID_NT = "N.T.";
        public static final String ID_FLT4 = "FLT4";
        public static final String ID_FLT8 = "FLT8";
        public static final String ID_2CHN = "2CHN";
        public static final String ID_4CHN = "4CHN";
        public static final String ID_6CHN = "6CHN";
        public static final String ID_8CHN = "8CHN";
        public static final String ID_OKTA = "OKTA";
        public static final String ID_CD81 = "CD81";
        public static final String ID_OCTA = "OCTA";
        public static final String ID_POSTFIX_CH = "CH";
        public static final String ID_PREFIX_TDZ = "TDZ";
        public static final String ID_NONE = "NOID";
        public String tracker;
        public String id;
        public int trackCount;
        public int instrumentCount;

        public static IDInfo getIDInfo(String id) {
            String tracker = null;
            int trackCount = -1;
            int instrumentCount = -1;
            if (id.equals(ID_2CHN)) {
                tracker = FASTTRACKER_2;
                trackCount = 2;
                instrumentCount = 31;
            } else if (id.equals(ID_MK) || id.equals(ID_MK_EXT)) {
                tracker = PROTRACKER;
                trackCount = 4;
                instrumentCount = 31;
            } else if (id.equals(ID_NT)) {
                tracker = NOISETRACKER;
                trackCount = 4;
                instrumentCount = 31;
            } else if (id.equals(ID_FLT4)) {
                tracker = STARTREKKER;
                trackCount = 4;
                instrumentCount = 31;
            } else if (id.equals(ID_4CHN)) {
                tracker = UNKNOWN_TRACKER;
                trackCount = 4;
                instrumentCount = 31;
            } else if (id.equals(ID_6CHN)) {
                tracker = FASTTRACKER_2;
                trackCount = 6;
                instrumentCount = 31;
            } else if (id.equals(ID_8CHN)) {
                tracker = FASTTRACKER_2;
                trackCount = 8;
                instrumentCount = 31;
            } else if (id.equals(ID_FLT8)) {
                tracker = STARTREKKER;
                trackCount = 8;
                instrumentCount = 31;
            } else if (id.equals(ID_OKTA) || id.equals(ID_CD81)) {
                tracker = OKTALYZER;
                trackCount = 8;
                instrumentCount = 31;
            } else if (id.equals(ID_OCTA)) {
                tracker = OCTALYZER;
                trackCount = 8;
                instrumentCount = 31;
            } else if (id.endsWith(ID_POSTFIX_CH)) {
                trackCount = (short)Integer.parseInt(id.substring(0, 2));
                tracker = (trackCount & 1) == 0 ? FASTTRACKER_2 : TAKETRACKER;
                instrumentCount = 31;
            } else if (id.startsWith(ID_PREFIX_TDZ)) {
                tracker = TAKETRACKER;
                trackCount = (short)Integer.parseInt(id.substring(3, 1));
                instrumentCount = 31;
            } else {
                id = ID_NONE;
                tracker = SOUNDTRACKER;
                trackCount = 4;
                instrumentCount = 15;
            }
            IDInfo info = new IDInfo();
            info.trackCount = trackCount;
            info.instrumentCount = instrumentCount;
            info.tracker = tracker;
            info.id = id;
            return info;
        }
    }
}

