/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.module.ModuleUnits;

public class STMUnits
implements ModuleUnits {
    private static final String NAME = "stm";
    private double c3hz;
    private static final double root2_12 = 1.059463094;
    private static final double c3 = 48.0;

    public STMUnits(int c3hz) {
        this.c3hz = c3hz;
    }

    public double period2note(double period) {
        return this.rate2note(period);
    }

    public double note2period(double period) {
        return this.note2rate(period);
    }

    public double note2rate(double note) {
        double diff = note - 48.0;
        return this.c3hz * Math.pow(1.059463094, diff);
    }

    public double rate2note(double rate) {
        return Math.log(rate / this.c3hz) / Math.log(1.059463094) + 48.0;
    }

    public double addPeriod(double note, double period) {
        return this.period2note(this.note2period(note) + period);
    }

    public double getUpperNoteLimit() {
        return 120.0;
    }

    public double getLowerNoteLimit() {
        return 0.0;
    }

    public String getName() {
        return NAME;
    }
}

