/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.module.ModuleUnits;

public class XmUnits
implements ModuleUnits {
    private static final String NAME = "xm";
    private static double maxNote;
    private static double minNote;
    public static final double MAX_NOTE = 96.0;
    public static final double MIN_NOTE = 0.0;

    public XmUnits() {
        maxNote = 96.0;
        minNote = 0.0;
    }

    public double period2rate(double period) {
        return 8363.0 * Math.pow(2.0, (4608.0 - period) / 768.0);
    }

    public double rate2period(double rate) {
        return -768.0 * Math.log(rate / 8363.0) / Math.log(2.0) + 4608.0;
    }

    public double period2note(double period) {
        return (period - 7680.0) / -64.0;
    }

    public double note2period(double note) {
        return 7680.0 - note * 16.0 * 4.0;
    }

    public double note2rate(double note) {
        return this.period2rate(this.note2period(note));
    }

    public double rate2note(double rate) {
        return this.period2note(this.rate2period(rate));
    }

    public double addPeriod(double note, double period) {
        return this.period2note(this.note2period(note) + period);
    }

    public double getUpperNoteLimit() {
        return maxNote;
    }

    public double getLowerNoteLimit() {
        return minNote;
    }

    public String getName() {
        return NAME;
    }
}

