/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Pattern;
import java.util.HashMap;
import java.util.Map;

public class Module {
    private String name;
    private String id;
    private String tracker;
    private String description;
    private Instrument[] instruments;
    private Pattern[] patterns;
    private int[] patternOrder;
    private int restartPos;
    private int initialBPM;
    private int initialSpeed;
    private double initialVolume;
    private double[] initialPanning;
    private double[] initialTrackVolume;
    private int panningType;
    private Map properties = new HashMap();
    public static final int TRACK_PANNING = 1;
    public static final int SAMPLE_PANNING = 2;
    public static final int INSTRUMENT_PANNING = 3;

    public Module(String name, String id, String tracker, Instrument[] instruments, Pattern[] patterns, int[] patternOrder, int restartPos, int initialBPM, int initialSpeed, double initialVolume, int panningType, double[] initialTrackVolume, double[] initialPanning) {
        this.name = name;
        this.id = id;
        this.tracker = tracker;
        this.instruments = instruments;
        this.patterns = patterns;
        this.patternOrder = patternOrder;
        this.restartPos = restartPos;
        this.initialBPM = initialBPM;
        this.initialSpeed = initialSpeed;
        this.initialVolume = initialVolume;
        this.panningType = panningType;
        this.initialTrackVolume = initialTrackVolume;
        this.initialPanning = initialPanning;
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Name:    ");
        sb.append(this.pad(this.getName(), 25, ' '));
        sb.append(" Chan: ");
        sb.append(this.pad(String.valueOf(this.getPatternAtPos(0).getTrackCount()), 3, ' '));
        sb.append(" Pos: ");
        sb.append(this.getNumberOfPositions());
        sb.append("\n");
        sb.append("Type:    ");
        sb.append(this.pad(this.getId(), 25, ' '));
        sb.append(" Inst: ");
        sb.append(this.pad(String.valueOf(this.getNumberOfInstruments()), 3, ' '));
        sb.append(" Pat: ");
        sb.append(this.getNumberOfPatterns());
        sb.append("\n");
        sb.append("Tracker: ");
        sb.append(this.getTracker());
        sb.append("\n");
        return sb.toString();
    }

    private String pad(String str, int len, char padding) {
        StringBuffer sb = new StringBuffer();
        if (str.length() > len) {
            sb.append(str.substring(0, len));
        } else {
            sb.append(str);
        }
        while (sb.length() < len) {
            sb.append(padding);
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTracker() {
        return this.tracker;
    }

    public int getNumberOfInstruments() {
        return this.instruments.length;
    }

    public Instrument getInstrument(int n) {
        if (n >= this.instruments.length || n < 0) {
            return null;
        }
        return this.instruments[n];
    }

    public Instrument[] getInstruments() {
        return this.instruments;
    }

    public int getNumberOfPatterns() {
        return this.patterns.length;
    }

    public int getNumberOfPositions() {
        return this.patternOrder.length;
    }

    public int getPatternIndexAtPos(int n) {
        return this.patternOrder[n];
    }

    public Pattern getPattern(int n) {
        return this.patterns[n];
    }

    public Pattern getPatternAtPos(int n) {
        return this.getPattern(this.getPatternIndexAtPos(n));
    }

    public int getRestartPos() {
        return this.restartPos;
    }

    public int getInitialBpm() {
        return this.initialBPM;
    }

    public int getInitialSpeed() {
        return this.initialSpeed;
    }

    public double getInitialVolume() {
        return this.initialVolume;
    }

    public int getPanningType() {
        return this.panningType;
    }

    public double getInitialVolume(int track) {
        return this.initialTrackVolume[track];
    }

    public double getInitialPanning(int track) {
        return this.initialPanning[track];
    }

    public int getTrackCount() {
        return this.getPatternAtPos(0).getTrackCount();
    }
}

