/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player.effect;

import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.ModuleUnits;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.player.TrackState;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.modplay.player.effect.Effect;

public class LocalEffects
implements Effect {
    public double tremoloValue;
    public double volumeSlide;
    private double volumeSlideSpeed;
    private double volumeFineSlideSpeed;
    private int tremoloWaveform = 0;
    private boolean tremoloRetrigger = true;
    public double panningSlide = 0.0;
    private double panningSlideSpeed;
    public double noteTune;
    public double noteSlide;
    private double noteSlideSmooth;
    private int noteSlideDest;
    private int noteSlideToSpeed;
    private double noteSlideSpeed;
    private double noteFineSlideSpeed;
    private double noteExtraFineSlideSpeed;
    private int vibratoWaveform = 0;
    private boolean vibratoRetrigger = true;
    private boolean glissando = false;
    private int retriggerInterval = 0;
    private int retriggerVolumeChange = 0;
    public static final int SINE_TREMOLO = 0;
    public static final int SAWTOOTH_TREMOLO = 1;
    public static final int SQUARE_TREMOLO = 2;
    private double tremoloPeriod;
    private double tremoloAmplitude;
    private int tremoloTick;
    public static final int SINE_VIBRATO = 0;
    public static final int SAWTOOTH_VIBRATO = 1;
    public static final int SQUARE_VIBRATO = 2;
    private double vibratoPeriod;
    private double vibratoAmplitude;
    private int vibratoTick;

    public LocalEffects() {
        this.reset();
    }

    public void preEffect(TrackState state, int track, int pattern, int division, int tick, int effectNumber, int arg1, int arg2) {
        switch (effectNumber) {
            case 29: {
                this.modExtendedDelaySample(state, track, tick, effectNumber, arg1, arg2);
            }
        }
    }

    public void doEffect(TrackState state, int track, int pattern, int division, int tick, int effectNumber, int arg1, int arg2) {
        this.noteTune = 0.0;
        this.tremoloValue = 0.0;
        switch (effectNumber) {
            case 0: {
                this.modArpeggio(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 1: {
                this.modSlideUp(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 2: {
                this.modSlideDown(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 3: {
                this.modSlideToNote(state, track, pattern, division, tick, effectNumber, arg1, arg2);
                break;
            }
            case 4: {
                this.modVibrato(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 5: {
                this.modSlideToNote(state, track, pattern, division, tick, effectNumber, 0, 0);
                this.modVolumeSlide(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 6: {
                this.modVibrato(state, track, tick, effectNumber, 0, 0);
                this.modVolumeSlide(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 7: {
                this.modTremolo(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 8: {
                this.modPanning(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 9: {
                this.modSetSampleOffset(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 10: {
                this.modVolumeSlide(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 12: {
                this.modSetVolume(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 17: {
                this.modExtendedFineSlideUp(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 18: {
                this.modExtendedFineSlideDown(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 19: {
                if (arg2 == 1) {
                    this.glissando = true;
                    break;
                }
                if (arg2 != 0) break;
                this.glissando = false;
                break;
            }
            case 20: {
                this.modExtendedSetVibratoWaveform(arg2);
                break;
            }
            case 21: {
                this.modExtendedFineTune(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 23: {
                this.modExtendedSetTremoloWaveform(arg2);
                break;
            }
            case 24: {
                this.modExtendedRoughPanning(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 25: {
                this.modExtendedRetriggerSample(state, track, tick, effectNumber, arg1, arg2, pattern);
                break;
            }
            case 26: {
                this.modExtendedFineVolumeSlideUp(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 27: {
                this.modExtendedFineVolumeSlideDown(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 28: {
                this.modExtendedCutSample(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 31: {
                System.err.println("Invert loop not supported @ LocalEffect.doEffect()");
                break;
            }
            case 40: {
                this.xmSlideUp(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 41: {
                this.xmSlideDown(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 42: {
                this.xmSlideToNote(state, track, pattern, division, tick, effectNumber, arg1, arg2);
                break;
            }
            case 43: {
                this.xmVolumeSlide(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 44: {
                this.xmExtendedFineSlideUp(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 45: {
                this.xmExtendedFineSlideDown(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 46: {
                this.xmExtendedFineVolumeSlideUp(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 47: {
                this.xmExtendedFineVolumeSlideDown(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 51: {
                if (tick != 0) break;
                state.setEnvelopePosition(arg1 * 16 + arg2);
                break;
            }
            case 52: {
                this.xmPanningSlide(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 53: {
                this.xmMultiRetriggerNote(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 55: {
                this.xmExtraFineSlideUp(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 56: {
                this.xmExtraFineSlideDown(state, track, tick, effectNumber, arg1, arg2);
                break;
            }
            case 50: {
                this.keyOff(state, track, tick);
                break;
            }
            case 60: {
                this.s3mTremor(state, track, tick, effectNumber, arg1, arg2);
            }
        }
    }

    public void postEffect(TrackState state, int track, int pattern, int division, int tick, int effectNumber, int arg1, int arg2) {
        switch (effectNumber) {
            case 60: {
                this.s3mTremorStop(state, track, tick, effectNumber, arg1, arg2);
            }
        }
    }

    public void newNote(int note) {
        this.reset();
    }

    public void newInstrument(int instrument) {
    }

    public void newNoteAndInstrument(int note, int instrument) {
        this.reset();
    }

    public void reset() {
        if (this.vibratoRetrigger) {
            this.vibratoTick = 0;
        }
        if (this.tremoloRetrigger) {
            this.tremoloTick = 0;
        }
        this.noteTune = 0.0;
        this.noteSlide = 0.0;
        this.noteSlideSmooth = 0.0;
        this.volumeSlide = 0.0;
        this.tremoloValue = 0.0;
        this.panningSlide = 0.0;
    }

    private void modArpeggio(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (arg1 == 0 && arg2 == 0) {
            return;
        }
        if ((tick %= 3) != 0) {
            if (tick == 1) {
                this.noteTune += (double)arg1;
            } else if (tick == 2) {
                this.noteTune += (double)arg2;
            }
        }
    }

    private void modSlideUp(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick > 0) {
            double newNote;
            ModuleUnits mu = sample.getUnits();
            double maxNote = mu.getUpperNoteLimit();
            double minPeriod = mu.note2period(maxNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) - (double)(arg1 * 16 + arg2);
            if (period < minPeriod) {
                period = minPeriod;
            }
            if ((newNote = mu.period2note(period)) > maxNote) {
                newNote = maxNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void modSlideDown(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick > 0) {
            double newNote;
            ModuleUnits mu = sample.getUnits();
            double minNote = mu.getLowerNoteLimit();
            double maxPeriod = mu.note2period(minNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) + (double)(arg1 * 16 + arg2);
            if (period > maxPeriod) {
                period = maxPeriod;
            }
            if ((newNote = mu.period2note(period)) < minNote) {
                newNote = minNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void modSlideToNote(TrackState state, int track, int pattern, int division, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0) {
            int note = state.getModule().getPatternAtPos(pattern).getTrack(track).getNote(division);
            if (note != -2) {
                this.noteSlideDest = note;
            }
            if (arg1 * 16 + arg2 != 0) {
                this.noteSlideToSpeed = arg1 * 16 + arg2;
            }
        } else {
            double note;
            ModuleUnits mu = sample.getUnits();
            double maxNote = mu.getUpperNoteLimit();
            double minPeriod = mu.note2period(maxNote);
            double minNote = mu.getLowerNoteLimit();
            double maxPeriod = mu.note2period(minNote);
            double newNote = note = (double)state.getNote() + this.noteSlideSmooth;
            if ((double)this.noteSlideDest > note) {
                double period = mu.note2period(note) - (double)this.noteSlideToSpeed;
                if (period < minPeriod) {
                    period = minPeriod;
                }
                if ((newNote = mu.period2note(period)) > (double)this.noteSlideDest) {
                    newNote = this.noteSlideDest;
                }
            } else if ((double)this.noteSlideDest < note) {
                double period = mu.note2period(note) + (double)this.noteSlideToSpeed;
                if (period > maxPeriod) {
                    period = maxPeriod;
                }
                if ((double)this.noteSlideDest > (newNote = mu.period2note(period))) {
                    newNote = this.noteSlideDest;
                }
            }
            this.noteSlideSmooth += newNote - note;
            this.noteSlide = this.glissando ? (double)Math.round(this.noteSlideSmooth) : this.noteSlideSmooth;
        }
    }

    private void modVibrato(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        double dNote;
        if (tick == 0) {
            if (arg1 != 0) {
                this.vibratoPeriod = arg1;
            }
            if (arg2 != 0) {
                this.vibratoAmplitude = arg2;
            }
        }
        this.noteTune = dNote = this.getVibratoLevel(this.vibratoPeriod, this.vibratoAmplitude, this.vibratoTick, this.vibratoWaveform);
        ++this.vibratoTick;
    }

    private double getVibratoLevel(double period, double amplitude, int vTick, int type) {
        double level = 0.0;
        switch (type) {
            case 0: {
                level = Math.sin((double)(vTick * 2) * 3.1416 * period / 64.0);
                break;
            }
            case 2: {
                level = (int)((double)(16 * vTick) * period / 64.0) % 16 < 8 ? 1 : -1;
                break;
            }
            case 1: {
                double v2;
                int v = (int)((double)(16 * vTick) * period / 64.0) % 16;
                level = v2 = 1.0 - (double)v / 8.0;
            }
        }
        return level *= amplitude / 16.0;
    }

    public void modTremolo(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            if (arg1 != 0) {
                this.tremoloPeriod = arg1;
            }
            if (arg2 != 0) {
                this.tremoloAmplitude = arg2;
            }
        }
        double dVolume = this.getTremoloLevel(this.tremoloPeriod, this.tremoloTick, this.tremoloWaveform);
        this.tremoloValue = dVolume * this.tremoloAmplitude * (double)(state.getModuleState().getTicksInDivision() - 1) / 64.0;
        ++this.tremoloTick;
    }

    private double getTremoloLevel(double period, int tTick, int type) {
        double level = 0.0;
        switch (type) {
            case 0: {
                level = Math.sin((double)(tTick * 2) * 3.1416 * period / 64.0);
                break;
            }
            case 2: {
                level = (int)((double)(16 * tTick) * period / 64.0) % 16 < 8 ? 1 : -1;
                break;
            }
            case 1: {
                double v2;
                int v = (int)((double)(16 * tTick) * period / 64.0) % 16;
                level = v2 = 1.0 - (double)v / 8.0;
            }
        }
        return level;
    }

    private void modPanning(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            state.setPanning((double)(arg1 * 16 + arg2) / 256.0);
        }
    }

    private void modSetSampleOffset(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            state.setSampleOffset(arg1 * 4096 + arg2 * 256);
        }
    }

    private void modVolumeSlide(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick > 0) {
            if (arg1 != 0) {
                this.volumeSlide += (double)arg1 / 64.0;
            } else if (arg2 != 0) {
                this.volumeSlide -= (double)arg2 / 64.0;
            }
        }
    }

    private void modSetVolume(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            state.setVolume((double)(arg1 * 16 + arg2) / 64.0);
        }
    }

    private void modExtendedFineSlideUp(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0) {
            double newNote;
            ModuleUnits mu = sample.getUnits();
            double maxNote = mu.getUpperNoteLimit();
            double minPeriod = mu.note2period(maxNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) - (double)arg2;
            if (period < minPeriod) {
                period = minPeriod;
            }
            if ((newNote = mu.period2note(period)) > maxNote) {
                newNote = maxNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void modExtendedFineSlideDown(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0) {
            double newNote;
            ModuleUnits mu = sample.getUnits();
            double minNote = mu.getLowerNoteLimit();
            double maxPeriod = mu.note2period(minNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) + (double)arg2;
            if (period > maxPeriod) {
                period = maxPeriod;
            }
            if ((newNote = mu.period2note(period)) < minNote) {
                newNote = minNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void modExtendedFineTune(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            if ((arg2 & 8) != 0) {
                arg2 |= 0xFFFFFFF0;
            }
            state.setFineTune((double)arg2 / 16.0);
        }
    }

    private void modExtendedSetTremoloWaveform(int arg2) {
        if (arg2 > 3) {
            this.tremoloRetrigger = true;
            arg2 -= 4;
        } else {
            this.tremoloRetrigger = false;
        }
        if (arg2 == 3) {
            arg2 = (int)(Math.random() * 3.0);
        }
        this.tremoloWaveform = arg2;
    }

    private void modExtendedSetVibratoWaveform(int arg2) {
        if (arg2 > 3) {
            this.vibratoRetrigger = true;
            arg2 -= 4;
        } else {
            this.vibratoRetrigger = false;
        }
        if (arg2 == 3) {
            arg2 = (int)(Math.random() * 3.0);
        }
        this.vibratoWaveform = arg2;
    }

    private void modExtendedRoughPanning(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        state.setPanning((double)arg2 / 16.0);
    }

    private void modExtendedRetriggerSample(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2, int pattern) {
        if (arg2 == 0 && tick == 0 || arg2 != 0 && tick % arg2 == 0) {
            state.setSampleOffset(0.0);
        }
    }

    private void modExtendedFineVolumeSlideUp(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            this.volumeSlide += (double)arg2 / 64.0;
        }
    }

    private void modExtendedFineVolumeSlideDown(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            this.volumeSlide -= (double)arg2 / 64.0;
        }
    }

    private void modExtendedCutSample(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick >= arg2) {
            state.setVolume(0.0);
        }
    }

    private void modExtendedDelaySample(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            state.setSampleDelay(arg2);
        }
    }

    private void xmSlideUp(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0 && (arg1 != 0 || arg2 != 0)) {
            this.noteSlideSpeed = (arg1 * 16 + arg2) * 4;
        }
        if (tick > 0) {
            double newNote;
            ModuleUnits mu = sample.getUnits();
            double maxNote = mu.getUpperNoteLimit();
            double minPeriod = mu.note2period(maxNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) - this.noteSlideSpeed;
            if (period < minPeriod) {
                period = minPeriod;
            }
            if ((newNote = mu.period2note(period)) > maxNote) {
                newNote = maxNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void xmSlideDown(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0 && (arg1 != 0 || arg2 != 0)) {
            this.noteSlideSpeed = (arg1 * 16 + arg2) * 4;
        }
        if (tick > 0) {
            double newNote;
            ModuleUnits mu = sample.getUnits();
            double minNote = mu.getLowerNoteLimit();
            double maxPeriod = mu.note2period(minNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) + this.noteSlideSpeed;
            if (period > maxPeriod) {
                period = maxPeriod;
            }
            if ((newNote = mu.period2note(period)) < minNote) {
                newNote = minNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void xmSlideToNote(TrackState state, int track, int pattern, int division, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0) {
            int note = state.getModule().getPatternAtPos(pattern).getTrack(track).getNote(division);
            if (note != -2) {
                this.noteSlideDest = note;
            }
            if (arg1 * 16 + arg2 != 0) {
                this.noteSlideToSpeed = arg1 * 16 + arg2;
            }
        } else {
            double note;
            ModuleUnits mu = sample.getUnits();
            double maxNote = mu.getUpperNoteLimit();
            double minPeriod = mu.note2period(maxNote);
            double minNote = mu.getLowerNoteLimit();
            double maxPeriod = mu.note2period(minNote);
            double newNote = note = (double)state.getNote() + this.noteSlideSmooth;
            if ((double)this.noteSlideDest > note) {
                double period = mu.note2period(note) - (double)(this.noteSlideToSpeed * 4);
                if (period < minPeriod) {
                    period = minPeriod;
                }
                if ((newNote = mu.period2note(period)) > (double)this.noteSlideDest) {
                    newNote = this.noteSlideDest;
                }
            } else if ((double)this.noteSlideDest < note) {
                double period = mu.note2period(note) + (double)(this.noteSlideToSpeed * 4);
                if (period > maxPeriod) {
                    period = maxPeriod;
                }
                if ((double)this.noteSlideDest > (newNote = mu.period2note(period))) {
                    newNote = this.noteSlideDest;
                }
            }
            this.noteSlideSmooth += newNote - note;
            this.noteSlide = this.glissando ? (double)Math.round(this.noteSlideSmooth) : this.noteSlideSmooth;
        }
    }

    private void xmVolumeSlide(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            if (arg1 != 0) {
                this.volumeSlideSpeed = (double)arg1 / 64.0;
            } else if (arg2 != 0) {
                this.volumeSlideSpeed = (double)(-arg2) / 64.0;
            }
        }
        if (tick > 0) {
            this.volumeSlide += this.volumeSlideSpeed;
        }
    }

    private void xmExtendedFineSlideUp(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0) {
            double newNote;
            if (arg2 != 0) {
                this.noteFineSlideSpeed = arg2 * 4;
            }
            ModuleUnits mu = sample.getUnits();
            double maxNote = mu.getUpperNoteLimit();
            double minPeriod = mu.note2period(maxNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) - this.noteFineSlideSpeed;
            if (period < minPeriod) {
                period = minPeriod;
            }
            if ((newNote = mu.period2note(period)) > maxNote) {
                newNote = maxNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void xmExtendedFineSlideDown(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0) {
            double newNote;
            if (arg2 != 0) {
                this.noteFineSlideSpeed = arg2 * 4;
            }
            ModuleUnits mu = sample.getUnits();
            double minNote = mu.getLowerNoteLimit();
            double maxPeriod = mu.note2period(minNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) + this.noteFineSlideSpeed;
            if (period > maxPeriod) {
                period = maxPeriod;
            }
            if ((newNote = mu.period2note(period)) < minNote) {
                newNote = minNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void xmExtendedFineVolumeSlideUp(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            if (arg2 != 0) {
                this.volumeFineSlideSpeed = (double)arg2 / 64.0;
            }
            this.volumeSlide += this.volumeFineSlideSpeed;
        }
    }

    private void xmExtendedFineVolumeSlideDown(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            if (arg2 != 0) {
                this.volumeFineSlideSpeed = (double)arg2 / 64.0;
            }
            this.volumeSlide -= this.volumeFineSlideSpeed;
        }
    }

    private void xmPanningSlide(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            if (arg1 != 0) {
                this.panningSlideSpeed = (double)arg1 / 256.0;
            } else if (arg2 != 0) {
                this.panningSlideSpeed = (double)(-arg2) / 256.0;
            }
        }
        if (tick > 0) {
            this.panningSlide += this.panningSlideSpeed;
        }
    }

    private void xmMultiRetriggerNote(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == 0) {
            if (arg1 != 0) {
                this.retriggerVolumeChange = arg1;
            }
            if (arg2 != 0) {
                this.retriggerInterval = arg2;
            }
        }
        if (this.retriggerInterval != 0 && tick % this.retriggerInterval == 0 && tick != 0) {
            state.setSampleOffset(0.0);
            switch (this.retriggerVolumeChange) {
                case 0: {
                    break;
                }
                case 1: {
                    state.setVolume(state.getVolume() - 0.015625);
                    break;
                }
                case 2: {
                    state.setVolume(state.getVolume() - 0.03125);
                    break;
                }
                case 3: {
                    state.setVolume(state.getVolume() - 0.0625);
                    break;
                }
                case 4: {
                    state.setVolume(state.getVolume() - 0.125);
                    break;
                }
                case 5: {
                    state.setVolume(state.getVolume() - 0.25);
                    break;
                }
                case 6: {
                    state.setVolume(state.getVolume() * 2.0 / 3.0);
                    break;
                }
                case 7: {
                    state.setVolume(state.getVolume() * 2.0);
                    break;
                }
                case 9: {
                    state.setVolume(state.getVolume() + 0.015625);
                    break;
                }
                case 10: {
                    state.setVolume(state.getVolume() + 0.03125);
                    break;
                }
                case 11: {
                    state.setVolume(state.getVolume() + 0.0625);
                    break;
                }
                case 12: {
                    state.setVolume(state.getVolume() + 0.125);
                    break;
                }
                case 13: {
                    state.setVolume(state.getVolume() + 0.25);
                    break;
                }
                case 14: {
                    state.setVolume(state.getVolume() * 3.0 / 2.0);
                    break;
                }
                case 15: {
                    state.setVolume(state.getVolume() * 2.0);
                }
            }
        }
    }

    private void xmExtraFineSlideUp(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0) {
            double newNote;
            if (arg2 != 0) {
                this.noteExtraFineSlideSpeed = arg2;
            }
            ModuleUnits mu = sample.getUnits();
            double maxNote = mu.getUpperNoteLimit();
            double minPeriod = mu.note2period(maxNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) - this.noteExtraFineSlideSpeed;
            if (period < minPeriod) {
                period = minPeriod;
            }
            if ((newNote = mu.period2note(period)) > maxNote) {
                newNote = maxNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void xmExtraFineSlideDown(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        Sample sample = state.getSample();
        if (sample == null) {
            return;
        }
        if (tick == 0) {
            double newNote;
            if (arg2 != 0) {
                this.noteExtraFineSlideSpeed = arg2;
            }
            ModuleUnits mu = sample.getUnits();
            double minNote = mu.getLowerNoteLimit();
            double maxPeriod = mu.note2period(minNote);
            double note = (double)state.getNote() + this.noteSlideSmooth;
            if (note == -2.0) {
                return;
            }
            double period = mu.note2period(note) + this.noteExtraFineSlideSpeed;
            if (period > maxPeriod) {
                period = maxPeriod;
            }
            if ((newNote = mu.period2note(period)) < minNote) {
                newNote = minNote;
            }
            this.noteSlide = this.noteSlideSmooth += newNote - note;
        }
    }

    private void s3mTremor(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick < arg1 * 16 + arg2) {
            this.volumeSlide -= 5.0;
        }
    }

    private void s3mTremorStop(TrackState state, int track, int tick, int effectNumber, int arg1, int arg2) {
        if (tick == arg1 * 16 + arg2 || arg1 * 16 + arg2 >= state.getModuleState().getTicksInDivision()) {
            this.volumeSlide += 5.0;
        }
    }

    public void keyOff(TrackState state, int track, int tick) {
        if (tick != 0) {
            return;
        }
        int instr = state.getInstrument();
        if (instr == -1) {
            return;
        }
        Instrument i = state.getModule().getInstrument(instr);
        AutoEffect[] af = i.getAutoEffects();
        int n = 0;
        while (af != null && n < af.length) {
            af[n].keyOff(track);
            ++n;
        }
    }
}

