/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.internalfilesystem;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import jemu.core.device.internalfilesystem.BeauchampEncoder;

public final class BeauchampKoala2PNG {
    final byte[] unused = new byte[2];
    final byte[] bitmap = new byte[8000];
    final byte[][] mcolor = new byte[25][40];
    final byte[][] color = new byte[25][40];
    final byte[] background = new byte[1];
    static final Color[] c64Colors = new Color[]{new Color(0, 0, 0), new Color(255, 255, 255), new Color(136, 0, 0), new Color(170, 255, 238), new Color(204, 68, 204), new Color(0, 204, 85), new Color(0, 0, 170), new Color(238, 238, 119), new Color(221, 136, 85), new Color(102, 68, 0), new Color(255, 119, 119), new Color(51, 51, 51), new Color(119, 119, 119), new Color(170, 255, 102), new Color(0, 136, 255), new Color(187, 187, 187)};
    public static final int koala_width = 320;
    public static final int koala_height = 200;
    public static final int koala_colors = 16;

    static byte low_nibble(byte x) {
        return (byte)(x & 0xF);
    }

    static byte high_nibble(byte x) {
        return (byte)(x >> 4 & 0xF);
    }

    byte getColor(byte row, byte col, int index) {
        if (index == 0) {
            return BeauchampKoala2PNG.low_nibble(this.background[0]);
        }
        if (index == 1) {
            return BeauchampKoala2PNG.high_nibble(this.mcolor[row][col]);
        }
        if (index == 2) {
            return BeauchampKoala2PNG.low_nibble(this.mcolor[row][col]);
        }
        return BeauchampKoala2PNG.low_nibble(this.color[row][col]);
    }

    byte[] convertFile(String theFile) {
        try {
            int i;
            int pixelDepth = 24;
            FileInputStream inFile = new FileInputStream(theFile);
            int read = inFile.read(this.unused);
            read = inFile.read(this.bitmap);
            for (i = 0; i < 25; ++i) {
                read = inFile.read(this.mcolor[i]);
            }
            for (i = 0; i < 25; ++i) {
                read = inFile.read(this.color[i]);
            }
            read = inFile.read(this.background);
            BufferedImage myImage = new BufferedImage(320, 200, pixelDepth == 8 ? 13 : 6);
            Graphics g = myImage.getGraphics();
            g.fillRect(0, 0, 320, 200);
            int row = 0;
            int col = 0;
            int p = 0;
            for (row = 0; row < 200; ++row) {
                int row8 = row / 8;
                int pos = row8 * 320 + row % 8;
                int x = 0;
                int index = 0;
                int oldindex = -1;
                for (col = 0; col < 40; ++col) {
                    p = this.bitmap[pos];
                    if (p < 0) {
                        p += 256;
                    }
                    for (int i2 = 0; i2 < 4; ++i2) {
                        oldindex = index;
                        index = this.getColor((byte)row8, (byte)col, p & 3);
                        g.setColor(c64Colors[index]);
                        g.drawLine(x + 6 - i2 * 2, row, x + 6 - i2 * 2 + 1, row);
                        p >>= 2;
                    }
                    x += 8;
                    pos += 8;
                }
            }
            int compressionLevel = 9;
            int filter = 0;
            boolean encodeAlpha = false;
            BeauchampEncoder png = new BeauchampEncoder(myImage, encodeAlpha, filter, compressionLevel);
            byte[] pngBytes = png.pngEncode();
            return pngBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            args = new String[]{"d:/ersterversuch.kla", "d:/erstversuch.png"};
            if (args.length < 2) {
                System.out.print(new String(new BeauchampKoala2PNG().convertFile(args[0])));
                System.exit(0);
            } else {
                FileOutputStream outfile = new FileOutputStream(args[1]);
                outfile.write(new BeauchampKoala2PNG().convertFile(args[0]));
                System.exit(0);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Parameters: [1] koa-file [2] png-file");
            System.err.println("http://www.beauchamp.de/cbm");
            System.err.println("You forgot to specify the filenames !");
        }
        catch (Exception e) {
            System.err.println("Parameters: [1] koa-file [2] png-file");
            System.err.println("http://www.beauchamp.de/cbm");
            System.err.println("Some other exception occured!");
            e.printStackTrace(System.err);
        }
    }
}

