/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jemu.core.device.sound.AY_3_8910;
import jemu.core.device.sound.AudioFilter;
import jemu.core.device.sound.SunAudio;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.ui.Desktop;
import jemu.ui.Switches;

public class JavaSound
extends SunAudio {
    public static AudioFilter filter;
    public static int SAMPLE_RATE;
    protected static AudioFormat MONO_FORMAT;
    protected static AudioFormat STEREO_FORMAT;
    protected SourceDataLine line;
    protected SourceDataLine lineMono;
    public static byte[] data;
    public static byte[] dataMono;
    protected int offset;
    protected int offsetMono;
    protected int channels;
    protected long startCount;
    protected int rate;
    int rightChannel;
    boolean flip;
    public static int buffersize;
    public static int updatecount;
    int[] circlebuffer = new int[1600];
    int writepos = 1599;
    int readpos = 0;

    public JavaSound(int samples, boolean stereo) {
        super(samples, stereo);
    }

    @Override
    public int getSampleRate() {
        return SAMPLE_RATE;
    }

    @Override
    public void init() {
        this.rate = Integer.parseInt(Settings.get("samplerate", "1"));
        SAMPLE_RATE = this.frequencies[this.rate];
        if (filter == null) {
            filter = new AudioFilter();
        }
        filter.setSampleRate(this.rate);
        System.out.println("Samplerate is " + SAMPLE_RATE + "hz");
        MONO_FORMAT = new AudioFormat(SAMPLE_RATE, 8, 2, false, true);
        STEREO_FORMAT = new AudioFormat(SAMPLE_RATE, 8, 2, false, true);
        this.format = 2;
        this.channels = this.stereo ? 2 : 1;
        data = new byte[this.samples * this.channels];
        dataMono = new byte[this.samples * 2];
        AudioFormat fmt = this.stereo ? STEREO_FORMAT : MONO_FORMAT;
        AudioFormat fmtMono = STEREO_FORMAT;
        try {
            if (this.line != null) {
                this.line.flush();
                this.line.close();
            }
            this.line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, fmt));
            this.line.open();
            if (this.lineMono != null) {
                this.lineMono.flush();
                this.lineMono.close();
            }
            this.lineMono = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, fmtMono));
            this.lineMono.open();
            System.out.println("Line for PSG AY started!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("JavaSound: " + this.samples + " x " + this.channels);
        System.out.println("Line Buffer: " + this.line.getBufferSize() + " for " + this.line.getClass());
        JavaSound.clear();
        this.resync();
    }

    @Override
    public void resync() {
        int samp;
        int len;
        if (this.line == null) {
            this.reset();
        }
        if (CPC.disableresync && Switches.turbo == 1) {
            return;
        }
        this.line.flush();
        this.lineMono.flush();
        this.startCount = this.line.getLongFramePosition();
        for (samp = SAMPLE_RATE / 10 * this.channels; samp > 0; samp -= len) {
            len = Math.min(data.length, samp);
            this.line.write(data, 0, len);
        }
        for (samp = SAMPLE_RATE / 10; samp > 0; samp -= len) {
            len = Math.min(dataMono.length, samp);
            this.lineMono.write(dataMono, 0, len);
        }
        if (Switches.turbo > 1) {
            --Switches.turbo;
        } else {
            System.out.println("resync: start=" + this.startCount);
        }
    }

    @Override
    public long getCount() {
        return this.line.getLongFramePosition() - this.startCount - 100L;
    }

    @Override
    public long getDeviation() {
        return SAMPLE_RATE / 10;
    }

    @Override
    public void play() {
        this.resync();
        this.line.start();
        this.lineMono.start();
    }

    @Override
    public void stop() {
        this.line.stop();
        this.lineMono.stop();
    }

    @Override
    public void dispose() {
        this.line.close();
        this.lineMono.close();
    }

    @Override
    public void writeMono(int value) {
        this.rightChannel = value ^= 0x80;
        if (!CPC.trueaudio) {
            JavaSound.dataMono[this.offsetMono++] = -128;
            JavaSound.dataMono[this.offsetMono] = (byte)value;
        } else {
            if (Switches.dbeffect) {
                this.buffer_write(this.rightChannel);
                this.rightChannel = this.buffer_read();
            }
            JavaSound.dataMono[this.offsetMono++] = (byte)value;
            JavaSound.dataMono[this.offsetMono] = (byte)this.rightChannel;
        }
        if (++this.offsetMono == dataMono.length) {
            this.lineMono.write(dataMono, 0, dataMono.length);
            this.offsetMono = 0;
        }
    }

    public static void clear() {
        if (data == null) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            JavaSound.data[i] = -128;
        }
    }

    @Override
    public void writeStereo(int a, int b) {
        if (AY_3_8910.digiblast) {
            a ^= 0x80;
            b ^= 0x80;
        }
        AudioFilter.highpass = AY_3_8910.Speaker;
        if (AudioFilter.highpass) {
            a = filter.HighpassFilterLeft(a);
            b = filter.HighpassFilterRight(b);
        } else if (AudioFilter.lowpass) {
            a = filter.LowpassFilterLeft(a);
            b = filter.LowpassFilterRight(b);
        }
        if (!AY_3_8910.digiblast) {
            a ^= 0x80;
            b ^= 0x80;
        }
        if (AY_3_8910.digiblast && AY_3_8910.Speaker) {
            a ^= 0x80;
            b ^= 0x80;
        }
        try {
            JavaSound.data[this.offset] = (byte)a;
            JavaSound.data[this.offset + 1] = (byte)b;
            if ((this.offset += 2) == data.length) {
                if (Desktop.cap != null) {
                    if (CPC.showAudioCapture && !Desktop.cap.isVisible()) {
                        Desktop.cap.showCapture();
                    }
                    if (!CPC.showAudioCapture && Desktop.cap.isVisible() && data != null) {
                        Desktop.cap.PaintBuffer(data);
                    }
                    if (CPC.showAudioCapture && Desktop.cap.isVisible()) {
                        Desktop.cap.setVisible(true);
                        CPC.showAudioCapture = false;
                    }
                }
                if (Desktop.cap != null && Desktop.cap.doCapture) {
                    Desktop.cap.Capture(data, data.length);
                }
                this.offset = 0;
                this.line.write(data, 0, data.length);
            }
            ++this.updates;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.offset = 0;
        }
    }

    protected void updateBuffer() {
        if (buffersize != this.circlebuffer.length) {
            System.out.println("Changing buffersize to: " + buffersize);
            try {
                this.writepos = buffersize - 1;
                this.readpos = 0;
                this.circlebuffer = new int[buffersize];
            }
            catch (Exception e) {
                updatecount = 1;
            }
        }
    }

    void buffer_write(int val) {
        try {
            this.circlebuffer[this.writepos] = val;
            this.writepos = (this.writepos + 1) % this.circlebuffer.length;
        }
        catch (Exception e) {
            updatecount = 1;
        }
    }

    int buffer_read() {
        try {
            int val = this.circlebuffer[this.readpos];
            this.readpos = (this.readpos + 1) % this.circlebuffer.length;
            return val;
        }
        catch (Exception e) {
            updatecount = 1;
            return 0;
        }
    }

    static {
        SAMPLE_RATE = 44100;
        buffersize = 1600;
        updatecount = 0;
    }
}

