/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import java.io.InputStream;
import jemu.core.device.sound.SoundPlayer2;
import jemu.core.device.sound.SoundUtil;

public class SunAudio2
extends SoundPlayer2
implements Runnable {
    protected final int[] frequencies = new int[]{49716, 44100, 32000, 22050, 16000, 11025, 8000, 6000, 11025};
    protected AudioStream stream;
    protected boolean playing = false;
    protected int samples;
    protected boolean stereo;
    protected int updates;

    public synchronized void stop(InputStream as) {
    }

    public synchronized void start(InputStream as) {
    }

    public SunAudio2(int samples, boolean stereo) {
        this.samples = samples;
        this.stereo = stereo;
        this.init();
    }

    @Override
    public void init() {
        this.stream = new AudioStream(this.samples);
    }

    @Override
    public int getSampleRate() {
        return 8000;
    }

    @Override
    public long getDeviation() {
        return 1600L;
    }

    @Override
    public long getUpdates() {
        int result = this.updates;
        this.updates = 0;
        return result;
    }

    @Override
    public long getCount() {
        return System.currentTimeMillis();
    }

    @Override
    public void play() {
        if (!this.playing) {
            this.stream.sync();
            this.playing = true;
            Thread thread = new Thread(this);
            thread.setPriority(10);
            thread.start();
        }
    }

    @Override
    public void stop() {
        if (this.playing) {
            this.stop(this.stream);
            this.playing = false;
        }
    }

    @Override
    public void dispose() {
        this.stop();
    }

    @Override
    public void resync() {
        this.stream.sync();
    }

    @Override
    public void run() {
        if (this.playing) {
            this.start(this.stream);
        }
        while (this.playing) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeStereo(int a, int b) {
        this.stream.writeulaw((byte)(a | b));
        switch (this.format) {
            case 0: {
                this.stream.writeulaw((byte)(a | b));
                break;
            }
            case 1: {
                this.stream.writeulaw(SoundUtil.pcm8ToULaw((byte)(a | b)));
                break;
            }
            case 2: {
                this.stream.writeulaw(SoundUtil.upcm8ToULaw((byte)(a | b)));
                break;
            }
            case 3: {
                this.stream.writeulaw(SoundUtil.pcm16ToULaw(a + b));
                break;
            }
            case 4: {
                this.stream.writeulaw(SoundUtil.upcm16ToULaw(a + b));
            }
        }
        ++this.updates;
    }

    protected class AudioStream
    extends InputStream {
        byte[] buffer;
        int pos = 0;
        int wrPos = 0;
        int size = 0;

        protected AudioStream(int samples) {
            this.buffer = new byte[samples];
        }

        @Override
        public int read() {
            this.waitForData(1);
            int result = this.buffer[this.pos] & 0xFF;
            this.pos = (this.pos + 1) % this.buffer.length;
            --this.size;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForData(int count) {
            while (this.size < count) {
                AudioStream audioStream = this;
                synchronized (audioStream) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public int read(byte[] buff, int offs, int len) {
            this.waitForData(len);
            int end = len + offs;
            while (offs < end) {
                buff[offs] = this.buffer[this.pos];
                this.pos = (this.pos + 1) % this.buffer.length;
                ++offs;
            }
            this.size -= len;
            return len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeulaw(byte value) {
            this.buffer[this.wrPos] = value;
            this.wrPos = (this.wrPos + 1) % this.buffer.length;
            ++this.size;
            AudioStream audioStream = this;
            synchronized (audioStream) {
                this.notify();
            }
        }

        @Override
        public int available() {
            return 8000;
        }

        @Override
        public void close() {
            SunAudio2.this.playing = false;
        }

        public void sync() {
        }
    }
}

