/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.speech;

import jemu.core.Util;
import jemu.core.device.speech.Speech;
import jemu.core.device.speech.SpeechDevice;

public class DKTronics
extends SpeechDevice {
    public static int LRQ;
    protected int SBY;
    protected boolean DEBUG = false;
    protected int speechCount = 0;
    protected int speechlength = 0;
    protected int length = 0;
    protected int phonemelength = 0;
    public boolean doCycle = false;
    protected Speech speech = new Speech();
    int counter;

    public DKTronics() {
        super("DK'Tronics Speech Synthesizer");
        LRQ = 127;
        this.SBY = 0;
    }

    @Override
    public int readPort(int port) {
        if (Speech.enabled && !Speech.SSA) {
            if (this.DEBUG) {
                System.out.println("Port read on " + Util.hex((short)port) + " - " + Util.hex((short)(LRQ | this.SBY)));
            }
            return LRQ | this.SBY;
        }
        return 255;
    }

    @Override
    public void writePort(int port, int value) {
        if (Speech.enabled && !Speech.SSA) {
            LRQ = 255;
            this.speechCount = 0;
            this.doCycle = true;
            this.phonemelength = Speech.lengths[value &= 0x3F];
            this.speechlength += this.phonemelength * 256;
            this.length = this.speechlength;
            this.speech.SpeechByte = this.speech.SpeechByte + Util.hex(value).substring(6) + ",";
            if (this.DEBUG) {
                System.out.println("Port write to " + Util.hex((short)port) + " - Value:" + Util.hex((short)value));
            }
        }
    }

    @Override
    public void reset() {
        LRQ = 127;
        this.SBY = 0;
        this.speech.SpeechByte = "";
        this.doCycle = false;
    }

    @Override
    public void cycle() {
        if (this.counter == 0) {
            this.counter = this.length;
        }
        this.SBY = this.speechCount++ < this.phonemelength ? 64 : 0;
        if (this.speechCount == this.counter && this.SBY == 0) {
            this.counter = 0;
            this.speechlength = 0;
            this.speechCount = 0;
            this.speech.Translate(this.speech.SpeechByte);
            this.doCycle = false;
            this.SBY = 0;
        }
    }
}

