/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.tape;

public abstract class CDT2WAVBaseOutput {
    private static final int LOAMP = 38;
    private static final int HIAMP = 218;
    private static final int NOAMP = 128;
    private double z80_freq = 3500000.0;
    private byte[] buf = null;
    private int bufPos = 0;
    private double frequency = 44100.0;
    private double cycle = 0.0;
    private int amp = 38;

    public CDT2WAVBaseOutput(int freq) {
        this.frequency = freq;
        this.cycle = this.frequency / this.z80_freq;
        this.init();
    }

    public void dispose() {
        this.buf = null;
    }

    protected abstract void init();

    protected abstract void write(int var1);

    protected abstract void stop();

    protected double getFrequency() {
        return this.frequency;
    }

    protected void outputSeek(int pos) {
        this.bufPos = pos;
    }

    protected int outputTell() {
        return this.bufPos;
    }

    protected final void outputByte(byte b) {
        if (this.buf != null) {
            this.buf[this.bufPos] = b;
        }
        ++this.bufPos;
    }

    protected final void outputByte(byte b, int count) {
        if (this.buf != null) {
            int p = this.bufPos;
            for (int i = 0; i < count; ++i) {
                this.buf[p++] = b;
            }
        }
        this.bufPos += count;
    }

    public void setOutputBuffer(byte[] buf) {
        this.buf = buf;
        this.bufPos = 0;
    }

    public int samples(int tstates) {
        return (int)(0.5 + this.cycle * (double)tstates);
    }

    public void setAmp(boolean high) {
        this.amp = high ? 218 : 38;
    }

    public void setAmpLow() {
        this.amp = 38;
    }

    public void setAmpNo() {
        this.amp = 128;
    }

    public void toggleAmp() {
        this.amp = this.isLowAmp() ? 218 : 38;
    }

    protected boolean isLowAmp() {
        return this.amp == 38;
    }

    protected boolean isNoAmp() {
        return this.amp == 128;
    }

    public void play(int numsamples) {
        this.write(numsamples);
    }

    public void pause(int ms) {
        int p = (int)((double)ms * this.frequency / 1000.0);
        this.play(p);
    }
}

