/*
 * Decompiled with CFR 0.152.
 */
package jemu.settings;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Properties;
import jemu.settings.DSettings;
import jemu.settings.Palette;
import jemu.settings.RSettings;

public class Settings {
    static int tried;
    private static File file;
    private static final Settings instance;
    private final Properties props = new Properties();
    public static final String CPCDOS = "cpc_dos";
    public static final String DOSPATH = "dos_path";
    public static final String JAVACPCPATH = "javacpc_path";
    public static final String TIMESTAMP = "lastdayrun";
    public static final String THUMBSIZE = "thumbsize";
    public static final String MOUSEWHEEL = "mousewheel_zoom";
    public static final String MEMDISPLAY = "display_mem";
    public static final String SF3MOUSE = "sf3_mouse";
    public static final String RECORDFULLTAPE = "record_full_tape";
    public static final String TAPESIZE = "tape_size";
    public static final String KEYCLASH = "keyboard_clash";
    public static final String HIDEMOUSE = "hidemouse";
    public static final String CHIPNOISE = "chipnoise";
    public static final String FILECHOOSERWIDTH = "filechooser_width";
    public static final String FILECHOOSERHEIGHT = "filechooser_height";
    public static final String FILECHOOSERX = "filechooser_x";
    public static final String FILECHOOSERY = "filechooser_y";
    public static final String FOS_VERSION = "futureos_version";
    public static final String DMP = "dmp_printer";
    public static final String RASTERPATH = "rasterpath";
    public static final String RASTERFILE = "rasterfile";
    public static final String DISPLAYZOOM = "zoomfactor";
    public static final String MAGICCPCDISKIMAGE = "magicdisc_";
    public static final String CHAT = "chat";
    public static final String ACCELERATE = "3d_acceleration";
    public static final String FDCENABLED = "fdc_enabled";
    public static final String LASTLIST = "bdd_lastlist";
    public static final String BDD_CNGSOFT = "bdd_cngsoft";
    public static final String BDD_CPCPOWER = "bdd_cpcpower";
    public static final String BDD_AMSTRADEU = "bdd_amstradeu";
    public static final String BDD_JAVACPCGAMES = "bdd_javacpc_games";
    public static final String BDD_JAVACPCDEMOS = "bdd_javacpc_demos";
    public static final String GAMESGENRE = "cpcgamescd_genre";
    public static final String GAMESCDPATH = "cpcgamescd_path";
    public static final String AUDIOPUFFER = "audio_puffersize";
    public static final String MEMORY4MB = "memory_4mb";
    public static final String Z80TURBO = "z80_turbo";
    public static final String LANGUAGE = "language";
    public static final String SAMPLESET = "wincpc_floppy_samples";
    public static final String PLAYCITY = "playcity";
    public static final String SYNC = "sync_64bit";
    public static final String FSPATH = "filesystem_path";
    public static final String GA_TYPE = "ga_type";
    public static final String ENABLE32ROMS = "32_roms_enabled";
    public static final String RAMDISK = "ramdisk_image";
    public static final String HASRAMDISK = "ramdisk_available";
    public static final String NATIVEKEYS = "native_keyboard";
    public static final String USE3D = "use_3d";
    public static final String SIMPLETEX = "simple_textures";
    public static final String JOYBUTTON1 = "joystick_button_1";
    public static final String JOYBUTTON2 = "joystick_button_2";
    public static final String AYVOLUME = "ay_volume_";
    public static final String CARTRIDGE = "cpr_file";
    public static final String SPEAKER = "speaker";
    public static final String FILTER = "filter";
    public static final String LOCALIZE = "localize_roms";
    public static final String MULTIFACE = "multiface";
    public static final String USERNAME = "username";
    public static final String USERMAIL = "usermail";
    public static final String USERCODE = "usercode";
    public static final String SUPERPAL = "superpal";
    public static final String PAL = "pal";
    public static final String PALVALUE = "pal_value";
    public static final String PALDOUBLE = "pal_double";
    public static final String PALSNOW = "pal_snow";
    public static final String VERSION = "version";
    public static final String CRTCPATCH = "crtcpatch";
    public static final String DISKTOOLPATH = "dsktool_path";
    public static final String FASTDISK = "fastdisk";
    public static final String SAMPLERATE = "samplerate";
    public static final String SIGNED = "signed";
    public static final String FREQUENCY = "frequency";
    public static final String SPEECH = "speech";
    public static final String SPO = "use_spo";
    public static final String SSA = "ssa1_mode";
    public static final String LASTDISK = "last_disk";
    public static final String LASTTAPE = "last_tape";
    public static final String LASTSNAP = "last_snap";
    public static final String LASTOPEN = "last_open";
    public static final String LASTYM = "last_ym";
    public static final String MASK = "mask";
    public static final String INTERLACE = "de-interlace";
    public static final String EMULATOR = "emulator";
    public static final String CONSOLE = "console";
    public static final String SHOWWELCOME = "welcome";
    public static final String STATUSBAR = "status_bar";
    public static final String DISABLEROMS = "disable_roms";
    public static final String REALTIME = "realtime_clock";
    public static final String INSPECTOR = "fileinspector";
    public static final String FLOPPYX = "floppy_xpos";
    public static final String FLOPPYY = "floppy_ypos";
    public static final String FRAMEX = "frame_xpos";
    public static final String FRAMEY = "frame_ypos";
    public static final String FLOPPYZOOM = "floppy_zoom";
    public static final String DF0HEAD = "df0_head";
    public static final String DF1HEAD = "df1_head";
    public static final String DF2HEAD = "df2_head";
    public static final String DF3HEAD = "df3_head";
    public static final String DIAGNOSE = "diagnostic";
    public static final String Settings = "settings";
    public static final String DIMENSION = "keep_display_propertions";
    public static final String SHOWDRIVE = "showdrive";
    public static final String POLARITY = "changePolarity";
    public static final String OVERRIDEP = "override_p";
    public static final String CRTC = "crtc";
    public static final String GZIP = "gzip_compression";
    public static final String TAPELABEL = "tapelabel";
    public static final String KEYREC = "keyboard_recording";
    public static final String BREAKPOINTS = "breakpoints";
    public static final String BREAKINST = "breakinstructions";
    public static final String KHZ44 = "recrate44";
    public static final String KHZ11 = "recrate11";
    public static final String PRINTER = "printer";
    public static final String FIRSTRUN = "firstrun";
    public static final String LOWPERFORMANCE = "lowperformance";
    public static final String WATCH = "observe_performance";
    public static final String FIRETIMER = "autofiretime";
    public static final String COMPUTERNAME = "computername";
    public static final String DIGIBLASTER = "digiblaster";
    public static final String AMDRUM = "amdrum";
    public static final String FLOPPYTURBO = "floppyturbo";
    public static final String DBVOLUME = "digiblaster_volume";
    public static final String VSOFT = "vsoft_output";
    public static final String CPCE95 = "cpce95_output";
    public static final String KAYOut = "hacker_kay_output";
    public static final String HACKER = "hacker_kay_II_output";
    public static final String LION = "lion_output";
    public static final String AYEFFECT = "ay_effect";
    public static final String DBEFFECT = "db_effect";
    public static final String LINEAR = "linear_sound";
    public static final String VHOLD = "vertical_hold";
    public static final String SKINNED = "useskin";
    public static final String EXPANSION = "expansion";
    public static final String MEMORY = "memory";
    public static final String LARGE = "large";
    public static final String TRIPLE = "triple_size";
    public static final String QUADRO = "quadro_size";
    public static final String DOUBLE = "double_size";
    public static final String FREE = "free_size";
    public static final String FULLSCREEN = "full_screen";
    public static final String AUDIO = "audio";
    public static final String MESSAGE = "show_about";
    public static final String AUTOCHECK = "autocheck";
    public static final String AUTOSAVE = "autosave";
    public static final String CHECKSAVE = "checksave";
    public static final String CHECKRENAME = "never_rename";
    public static final String AUTOBOOT = "autoboot";
    public static final String LASTPATH = "last_path";
    public static final String DRIVE_FILE = "file.drive";
    public static final String LOADDRIVE = "loaddrive";
    public static final String TAPE_FILE = "file.tape";
    public static final String LOADTAPE = "loadtape";
    public static final String FLOPPYSOUND = "floppy_sound";
    public static final String KEYSOUND = "key_sound";
    public static final String ONTOP = "on_top";
    public static final String HIDEFRAME = "hide_frame";
    public static final String NOTEBOOK = "notebook";
    public static final String STANDALONE = "standalone";
    public static final String SYSTEM = "system";
    public static final String VOLUME = "volume";
    public static final String MONITOR = "monitor";
    public static final String BRIGHTNESS = "brightness";
    public static final String JOYSTICK = "joystick";
    public static final String OSD = "onscreendisplay";
    public static final String AUTOLOAD = "autoload";
    public static final String AUTOTYPE = "autotype";
    public static final String MOUSEJOY = "mousejoy";
    public static final String SCANLINES = "scanlines";
    public static final String FILTER_VALUE = "filtervalue";
    public static final String FILTER_DOSBOXB = "filter_dosboxb";
    public static final String FILTER_DOSBOX = "filter_dosbox";
    public static final String FILTER_EAGLE = "filter_eagle";
    public static final String FILTER_ADVMAME = "filter_advmame";
    public static final String FILTER_EAGLE_SMOOTH = "filter_eagle_smooth";
    public static final String FILTER_ADVMAME_SMOOTH = "filter_advmame_smooth";
    public static final String FILTER_EMBOSSED = "filter_embossed";
    public static final String SCANEFFECT = "display_effect";
    public static final String BILINEAR = "bilinear";
    public static final String SHOWMENU = "show_menu";

    public static void resetSettings() {
        while (file.exists()) {
            try {
                file.delete();
                Thread.sleep(100L);
                if (++tried <= 10) continue;
                System.out.println("Clearing the config failed...");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Palette.resetSettings();
        DSettings.resetSettings();
        RSettings.resetSettings();
    }

    private Settings() {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkRead(file.getAbsolutePath());
            }
            this.props.load(new FileInputStream(file));
            System.out.println("loaded " + this.props.size() + " user settings");
        }
        catch (Throwable t) {
            System.out.println("can't load user settings (" + t.getMessage() + ")");
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = jemu.settings.Settings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static int getInt(String key, int defaultValue) {
        String value = jemu.settings.Settings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static void setBoolean(String key, boolean value) {
        jemu.settings.Settings.instance.props.setProperty(key, value ? "true" : "false");
        jemu.settings.Settings.save();
    }

    public static String get(String key, String defaultValue) {
        String value = jemu.settings.Settings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void set(String key, String value) {
        if (value.equals(jemu.settings.Settings.get(key, null))) {
            return;
        }
        jemu.settings.Settings.instance.props.setProperty(key, value);
        jemu.settings.Settings.save();
    }

    private static void save() {
        try {
            File f = new File(System.getProperty("user.home"), "JavaCPC");
            f.mkdir();
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkWrite(file.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(file);
            jemu.settings.Settings.instance.props.store(fos, "[Settings]");
            fos.close();
            StringBuilder contents = new StringBuilder();
            BufferedReader reader = null;
            FileReader fre = new FileReader(file);
            reader = new BufferedReader(fre);
            String text = null;
            while ((text = reader.readLine()) != null) {
                contents.append(text).append(System.getProperty("line.separator"));
            }
            reader.close();
            fre.close();
            String result = contents.toString();
            String[] res = result.split("\n");
            Arrays.sort(res);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            for (int i = 0; i < res.length; ++i) {
                bos.write((res[i] + '\n').getBytes("UTF-8"));
            }
            bos.close();
        }
        catch (Throwable t) {
            System.out.println("can't save user settings (" + t.getMessage() + ")");
        }
    }

    static {
        file = new File(System.getProperty("user.home"), "/JavaCPC/javacpc.ini");
        instance = new Settings();
    }
}

