/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import jemu.system.cpc.CPC;
import jemu.ui.JEMU;
import jemu.ui.wavtocpc.Util;

public class MemoryMap
extends JPanel {
    int[] pixels = new int[65536];
    int[] pixelsb = new int[65536];
    BufferedImage RAMLabels = new BufferedImage(40, 256, 1);
    BufferedImage first64k = new BufferedImage(256, 256, 1);
    BufferedImage second64k = new BufferedImage(256, 256, 1);
    BufferedImage dfirst64k = new BufferedImage(256, 512, 1);
    BufferedImage dsecond64k = new BufferedImage(256, 512, 1);
    int[] color = new int[256];
    WritableRaster raster = this.first64k.getRaster();
    WritableRaster rasterb = this.second64k.getRaster();
    private JLabel firstrow;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel secondrow;

    public MemoryMap() {
        this.initComponents();
        for (int i = 0; i < this.color.length; ++i) {
            this.color[i] = i == 0 ? 0 : 0xFFFFFF;
        }
        int first = 16;
        Graphics g = this.RAMLabels.getGraphics();
        g.setColor(Color.yellow);
        for (int i = 0; i < 65535; i += 4096) {
            g.drawLine(20, first, 40, first);
            g.drawString("&" + Util.hex((short)(i + 4096)), 2, first - 1);
            g.drawString("&" + Util.hex((short)(i + 4096)), 3, first - 1);
            first += 16;
        }
        BufferedImage buf = new BufferedImage(40, 512, 1);
        buf.getGraphics().drawImage(this.RAMLabels, 0, 0, 40, 512, this);
        this.firstrow.setIcon(new ImageIcon(buf));
        this.secondrow.setIcon(new ImageIcon(buf));
    }

    public void update(CPC cpc) {
        if (JEMU.tabss.getSelectedIndex() != 1) {
            return;
        }
        byte[] ram = cpc.getRAM();
        int index = 0;
        int rampos = 0;
        for (int i = index; i < index + 65536; ++i) {
            this.pixels[i] = this.color[ram[rampos++] & 0xFF];
        }
        index += 65536;
        int px2 = 0;
        for (int i = 0; i < 65536; ++i) {
            this.pixelsb[px2++] = this.color[ram[i + index] & 0xFF];
        }
        this.raster.setDataElements(0, 0, 256, 256, this.pixels);
        this.rasterb.setDataElements(0, 0, 256, 256, this.pixelsb);
        this.dfirst64k.getGraphics().drawImage(this.first64k, 0, 0, 256, 512, this);
        this.dsecond64k.getGraphics().drawImage(this.second64k, 0, 0, 256, 512, this);
        this.jLabel2.setIcon(new ImageIcon(this.dfirst64k));
        this.jLabel1.setIcon(new ImageIcon(this.dsecond64k));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.secondrow = new JLabel();
        this.firstrow = new JLabel();
        this.jLabel1.setPreferredSize(new Dimension(256, 512));
        this.jLabel2.setPreferredSize(new Dimension(256, 512));
        this.secondrow.setPreferredSize(new Dimension(40, 512));
        this.firstrow.setPreferredSize(new Dimension(40, 512));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.firstrow, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secondrow, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.firstrow, -2, -1, -2).addComponent(this.secondrow, -2, -1, -2).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jLabel2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

