/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc.plus;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import jemu.core.Util;
import jemu.core.device.Device;
import jemu.settings.Settings;
import jemu.ui.Desktop;

public class CPRLoader {
    protected byte[][] cprdata;
    public boolean DEBUG = false;
    protected boolean[] loaded = new boolean[32];
    protected String CPRHeader = "RIFF";
    protected String CPRIdentifier = "AMS!";
    protected int CPRBegin = 16;
    protected int CPRSize;

    public static void main(String[] args) {
        CPRLoader load = new CPRLoader();
        load.DEBUG = true;
        load.OpenCPR();
    }

    public void OpenCPR() {
        String filename = null;
        try {
            FileDialog filedia = new FileDialog(new Frame(), "Open CPR cartridge", 0);
            filedia.setFile("*.CPR");
            filedia.setVisible(true);
            filename = filedia.getFile();
            if (filename != null) {
                filename = filedia.getDirectory() + filedia.getFile();
            }
        }
        catch (Exception e) {
            System.err.println("Load failed...");
            return;
        }
        if (filename == null) {
            Settings.set("cpr_file", "CPC_PLUS.CPR");
            this.openCPR("CPC_PLUS.CPR");
            Desktop.cprfile.setText("CPC_PLUS.CPR");
            return;
        }
        this.openCPR(filename);
    }

    public void openCPR(String filename) {
        File t = new File(filename);
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(t));
            byte[] data = new byte[bin.available()];
            bin.read(data);
            bin.close();
            this.init();
            this.readCPR(data);
            Settings.set("cpr_file", filename);
            String setname = filename;
            while (setname.contains("\\")) {
                setname = setname.substring(1);
            }
            Desktop.cprfile.setText(setname);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init() {
        this.cprdata = new byte[32][];
    }

    public byte[] getData(int index) {
        return this.cprdata[index];
    }

    public void readCPR(byte[] data) {
        if (this.CPRHeader.equals(new String(data, 0, this.CPRHeader.length()).toUpperCase()) && this.CPRIdentifier.equals(new String(data, 8, this.CPRIdentifier.length()).toUpperCase())) {
            int length;
            int i;
            for (i = 0; i < 32; ++i) {
                this.loaded[i] = false;
            }
            this.CPRSize = Device.getDWord(data, 4);
            for (i = 0; i < 32; ++i) {
                this.cprdata[i] = new byte[16384];
            }
            for (int pos = 12; pos < this.CPRSize; pos += length) {
                byte check1 = data[pos++];
                byte check2 = data[pos++];
                byte index1 = data[pos++];
                byte index2 = data[pos++];
                length = Device.getDWord(data, pos);
                pos += 4;
                if (check1 != 99 || check2 != 98) continue;
                int index = 0;
                String a = "" + (char)index1 + "" + (char)index2;
                try {
                    index = Integer.parseInt(a);
                }
                catch (Exception e) {
                    System.err.println("An error occured!");
                    return;
                }
                if (!this.loaded[index &= 0x1F]) {
                    System.arraycopy(data, pos, this.cprdata[index], 0, length);
                    this.loaded[index] = true;
                    System.out.println("Storing to position: " + index);
                } else {
                    System.out.println("Tried to fill position " + index + " but it's already loaded.");
                    System.out.println("Comparing data now...");
                    for (int j = 0; j < length; ++j) {
                        if (data[j] == this.cprdata[index][j]) continue;
                        System.out.println("Difference encountered!");
                        System.arraycopy(data, pos, this.cprdata[index], 0, length);
                        break;
                    }
                }
                if (!this.DEBUG) continue;
                System.out.println(Util.dumpBytes(this.cprdata[index]));
            }
        }
    }
}

