/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.Timer;
import jemu.ui.Desktop;

class Clock
extends JComponent {
    private Calendar systemTime = Calendar.getInstance();
    private int centerX = 100;
    private int centerY = 100;
    BufferedImage clockFace;
    protected int zoom = 2;
    protected Color shadow = new Color(0, 0, 0, 96);
    protected Color black = new Color(0, 0, 0);
    protected Color red = new Color(255, 0, 0);
    protected Color blue = new Color(0, 0, 255);
    protected Color green = new Color(0, 255, 0);
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Clock.this.systemTime.setTimeInMillis(System.currentTimeMillis());
            Clock.this.repaint();
        }
    };
    Timer fireUpdate = new Timer(1000, this.update);

    Clock() {
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.clockFace == null) {
            this.clockFace = new BufferedImage(400 / this.zoom, 400 / this.zoom, 2);
        }
        try {
            if (Desktop.showGlass.isSelected()) {
                this.drawTiks(graphics);
            }
        }
        catch (Exception e) {
            this.drawTiks(graphics);
        }
        this.drawHour(graphics);
        this.drawMinute(graphics);
        this.drawSecond(graphics);
        graphics.drawImage(this.clockFace, null, 0, 0);
    }

    private void drawSecond(Graphics2D graphics) {
        int seconds = this.systemTime.get(13);
        int secondsAngle = seconds * 6;
        this.drawHands(graphics, 0, 0, 0.0, 14, this.shadow, true);
        this.drawHands(graphics, -30 / this.zoom, 160 / this.zoom, secondsAngle, 2, this.shadow, true);
        this.drawHands(graphics, -30 / this.zoom, 160 / this.zoom, secondsAngle, 2, this.red, false);
        this.drawHands(graphics, 0, 0, 0.0, 18, this.red, false);
        this.drawHands(graphics, 0, 0, 0.0, 2, this.black, false);
    }

    private void drawMinute(Graphics2D graphics) {
        int minutes = this.systemTime.get(12);
        double minuteAngle = minutes * 6;
        this.drawHands(graphics, 0, 150 / this.zoom, minuteAngle, 4, this.shadow, true);
        this.drawHands(graphics, 0, 150 / this.zoom, minuteAngle, 4, this.green, false);
    }

    private void drawHour(Graphics2D graphics) {
        int hours = this.systemTime.get(10);
        double hourAngle = ((double)hours + (double)this.systemTime.get(12) / 60.0) * 30.0;
        this.drawHands(graphics, 0, 110 / this.zoom, hourAngle, 6, this.shadow, true);
        this.drawHands(graphics, 0, 110 / this.zoom, hourAngle, 6, this.blue, false);
    }

    private void drawTiks(Graphics2D graphics) {
        int x = 0;
        while (true) {
            int add = 0;
            int y = 180 / this.zoom;
            if (x % 30 == 0) {
                add = 2;
                y = 170 / this.zoom;
            }
            this.drawHands(graphics, y, 180 / this.zoom, x, 2 + add, this.shadow, true);
            this.drawHands(graphics, y, 180 / this.zoom, x, 2 + add, this.black, false);
            if (x == 360) break;
            x += 6;
        }
    }

    private void drawHands(Graphics2D graphics, int startRadius, int endRadius, double teta, int width, Color hand, boolean shift) {
        double radian = Math.toRadians(teta - 90.0);
        int startX = this.centerX + (int)((double)startRadius * Math.cos(radian));
        int startY = this.centerY + (int)((double)startRadius * Math.sin(radian));
        int endX = this.centerX + (int)((double)endRadius * Math.cos(radian));
        int endY = this.centerY + (int)((double)endRadius * Math.sin(radian));
        if (shift) {
            startX += 2;
            startY += 2;
            endX += 2;
            endY += 2;
        }
        BasicStroke line = new BasicStroke(width, 1, 1);
        graphics.setStroke(line);
        graphics.setPaint(hand);
        graphics.drawLine(startX, startY, endX, endY);
    }
}

