/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jemu.core.samples.Samples;
import jemu.system.cpc.CPC;
import jemu.ui.copyURL;

public class GameBrowser
extends JInternalFrame
implements KeyListener,
MouseListener {
    String website = "";
    String[] history;
    int histcount = 0;
    int pagecount = 0;
    public static JEditorPane pane;
    protected GridBagConstraints gbcConstraints = null;
    JButton home = new JButton("Home");
    JButton refresh = new JButton("Reload");
    JButton back = new JButton("<");
    JButton forward = new JButton(">");
    JButton goTo = new JButton("Goto");
    JButton gamerev = new JButton("CPC-GameReviews");
    public static JProgressBar prog;
    final String gameRev = "http://www.cpcgamereviews.com/a/index.html";
    JButton gameb = new JButton("Games");
    JButton demob = new JButton("Demos");
    final String gamesRev = "http://cpc.devilmarkus.de/jgame.php";
    final String demosRev = "http://cpc.devilmarkus.de/jdemo.php";
    JButton homecomp = new JButton("Homecomputerworld");
    final String homeComp = "http://www.homecomputerworld.com/0-9-cpc.html";
    JTextField address = new JTextField();
    JEditorPane browsercontent = new JEditorPane();
    public static JCheckBox bootfile;

    private GridBagConstraints getGridBagConstraints(int x, int y, double weightx, double weighty, int width, int fill) {
        if (this.gbcConstraints == null) {
            this.gbcConstraints = new GridBagConstraints();
        }
        this.gbcConstraints.gridx = x;
        this.gbcConstraints.gridy = y;
        this.gbcConstraints.weightx = weightx;
        this.gbcConstraints.weighty = weighty;
        this.gbcConstraints.gridwidth = width;
        this.gbcConstraints.fill = fill;
        return this.gbcConstraints;
    }

    public void home() {
        try {
            URL url = new URL(this.website);
            this.address.setText(url.toString());
            this.browsercontent.setPage(url);
            this.history[this.pagecount] = url.toString();
            this.pagecount = this.pagecount < 4999 ? ++this.pagecount : 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GameBrowser(String weburl, String name) {
        this.history = new String[5000];
        this.website = weburl;
        this.address.addKeyListener(this);
        this.address.addMouseListener(this);
        this.home.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = new URL(GameBrowser.this.website);
                    GameBrowser.this.address.setText(url.toString());
                    GameBrowser.this.browsercontent.setPage(url);
                    GameBrowser.this.history[GameBrowser.this.pagecount] = url.toString();
                    GameBrowser.this.pagecount = GameBrowser.this.pagecount < 4999 ? ++GameBrowser.this.pagecount : 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (GameBrowser.this.histcount > 0) {
                        --GameBrowser.this.histcount;
                        GameBrowser.this.browsercontent.setPage(GameBrowser.this.history[GameBrowser.this.histcount]);
                        GameBrowser.this.address.setText(GameBrowser.this.history[GameBrowser.this.histcount]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.forward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (GameBrowser.this.histcount < GameBrowser.this.pagecount - 1) {
                        ++GameBrowser.this.histcount;
                        GameBrowser.this.browsercontent.setPage(GameBrowser.this.history[GameBrowser.this.histcount]);
                        GameBrowser.this.address.setText(GameBrowser.this.history[GameBrowser.this.histcount]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.goTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String adr = GameBrowser.this.address.getText();
                    if (!adr.startsWith("http://") && !adr.startsWith("ftp://")) {
                        adr = "http://" + adr;
                    }
                    if (adr.startsWith("http://tacgr")) {
                        return;
                    }
                    URL url = new URL(adr);
                    GameBrowser.this.address.setText(url.toString());
                    ++GameBrowser.this.histcount;
                    GameBrowser.this.history[GameBrowser.this.histcount] = url.toString();
                    GameBrowser.this.pagecount = GameBrowser.this.pagecount < 4999 ? ++GameBrowser.this.pagecount : 0;
                    GameBrowser.this.browsercontent.setPage(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.goTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String adr = GameBrowser.this.address.getText();
                    if (!adr.startsWith("http://") && !adr.startsWith("ftp://")) {
                        adr = "http://" + adr;
                    }
                    if (adr.startsWith("http://tacgr")) {
                        return;
                    }
                    URL url = new URL(adr);
                    GameBrowser.this.address.setText(url.toString());
                    ++GameBrowser.this.histcount;
                    GameBrowser.this.history[GameBrowser.this.histcount] = url.toString();
                    GameBrowser.this.pagecount = GameBrowser.this.pagecount < 4999 ? ++GameBrowser.this.pagecount : 0;
                    GameBrowser.this.browsercontent.setPage(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.gamerev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = new URL("http://www.cpcgamereviews.com/a/index.html");
                    GameBrowser.this.address.setText(url.toString());
                    ++GameBrowser.this.histcount;
                    GameBrowser.this.history[GameBrowser.this.histcount] = url.toString();
                    GameBrowser.this.pagecount = GameBrowser.this.pagecount < 4999 ? ++GameBrowser.this.pagecount : 0;
                    GameBrowser.this.browsercontent.setPage(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.homecomp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = new URL("http://www.homecomputerworld.com/0-9-cpc.html");
                    GameBrowser.this.address.setText(url.toString());
                    ++GameBrowser.this.histcount;
                    GameBrowser.this.history[GameBrowser.this.histcount] = url.toString();
                    GameBrowser.this.pagecount = GameBrowser.this.pagecount < 4999 ? ++GameBrowser.this.pagecount : 0;
                    GameBrowser.this.browsercontent.setPage(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.gameb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = new URL("http://cpc.devilmarkus.de/jgame.php");
                    GameBrowser.this.address.setText(url.toString());
                    ++GameBrowser.this.histcount;
                    GameBrowser.this.history[GameBrowser.this.histcount] = url.toString();
                    GameBrowser.this.pagecount = GameBrowser.this.pagecount < 4999 ? ++GameBrowser.this.pagecount : 0;
                    GameBrowser.this.browsercontent.setPage(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.demob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = new URL("http://cpc.devilmarkus.de/jdemo.php");
                    GameBrowser.this.address.setText(url.toString());
                    ++GameBrowser.this.histcount;
                    GameBrowser.this.history[GameBrowser.this.histcount] = url.toString();
                    GameBrowser.this.pagecount = GameBrowser.this.pagecount < 4999 ? ++GameBrowser.this.pagecount : 0;
                    GameBrowser.this.browsercontent.setPage(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        bootfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CPC.shouldBoot = bootfile.isSelected();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        bootfile.setFocusable(false);
        bootfile.setFocusPainted(false);
        this.setDefaultCloseOperation(1);
        this.setLayout(new GridBagLayout());
        try {
            URL url = new URL(this.website);
            this.address.setText(url.toString());
            this.history[this.histcount] = this.address.getText();
            this.pagecount = this.pagecount < 4999 ? ++this.pagecount : 0;
            this.browsercontent.setPage(url);
            this.browsercontent.setAutoscrolls(true);
            this.browsercontent.setEditable(false);
            this.browsercontent.addHyperlinkListener(new Hyperactive());
        }
        catch (Exception url) {
            // empty catch block
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d = new Dimension(800, 600);
        this.add((Component)this.home, this.getGridBagConstraints(1, 1, 0.0, 0.0, 1, 1));
        this.add((Component)this.back, this.getGridBagConstraints(2, 1, 0.0, 0.0, 1, 1));
        this.add((Component)this.forward, this.getGridBagConstraints(3, 1, 0.0, 0.0, 1, 1));
        this.add((Component)this.refresh, this.getGridBagConstraints(4, 1, 0.0, 0.0, 1, 1));
        this.add((Component)this.goTo, this.getGridBagConstraints(5, 1, 0.0, 0.0, 1, 1));
        this.add((Component)bootfile, this.getGridBagConstraints(6, 1, 0.0, 0.0, 1, 1));
        this.add((Component)this.address, this.getGridBagConstraints(7, 1, 0.0, 0.0, 1, 1));
        this.add((Component)new JScrollPane(this.browsercontent), this.getGridBagConstraints(1, 2, 1.0, 1.0, 7, 1));
        this.add((Component)this.gameb, this.getGridBagConstraints(1, 3, 0.0, 0.0, 1, 1));
        this.add((Component)this.demob, this.getGridBagConstraints(2, 3, 0.0, 0.0, 1, 1));
        this.add((Component)this.gamerev, this.getGridBagConstraints(3, 3, 0.0, 0.0, 1, 1));
        this.add((Component)this.homecomp, this.getGridBagConstraints(4, 3, 0.0, 0.0, 1, 1));
        this.add((Component)prog, this.getGridBagConstraints(5, 3, 0.0, 0.0, 7, 1));
        this.home.setFocusable(false);
        this.setFocusable(false);
        this.setSize(d);
        this.setVisible(true);
        this.browsercontent.setFocusable(false);
    }

    public void Download(final String download) {
        Thread pokes = new Thread(){

            @Override
            public void run() {
                String extension = download;
                extension = extension.replace("%20", " ");
                extension = extension.replace("%2F", "/");
                extension = extension.replace("%3A", ":");
                extension = extension.replace("%3F", "?");
                extension = extension.replace("%3D", "=");
                extension = extension.replace("%26", "&");
                extension = extension.replace("%28", "(");
                extension = extension.replace("%29", ")");
                extension = extension.replace("%5B", "[");
                extension = extension.replace("%5D", "]");
                extension = extension.replace("%27", "'");
                System.out.println(extension + " - " + extension.length());
                String extension2 = extension;
                while (extension.contains("/")) {
                    extension = extension.substring(1);
                }
                if (extension.startsWith("download.php")) {
                    while (!extension.startsWith("fichier=")) {
                        extension = extension.substring(1);
                    }
                    extension = extension.replace("fichier=", "");
                }
                FileDialog filedia = new FileDialog(new Frame(), "Download file...", 1);
                filedia.setFile(extension);
                filedia.setVisible(true);
                String filename = filedia.getDirectory() + filedia.getFile();
                if (filename != null && !filename.startsWith("null")) {
                    System.out.println("Saving to " + filename);
                    String[] arg = new String[]{extension2, filename};
                    copyURL.download(arg, false);
                }
            }
        };
        pokes.start();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.address && e.getKeyCode() == 10) {
            try {
                String adr = this.address.getText();
                if (!adr.startsWith("http://") && !adr.startsWith("ftp://")) {
                    adr = "http://" + adr;
                }
                URL url = new URL(adr);
                this.address.setText(url.toString());
                this.browsercontent.setPage(url);
                ++this.histcount;
                this.history[this.histcount] = adr;
                this.pagecount = this.pagecount < 4999 ? ++this.pagecount : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.address.selectAll();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    static {
        prog = new JProgressBar();
        bootfile = new JCheckBox("Boot game");
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        if (e.getURL().toString().toLowerCase().contains("tacgr")) {
                            return;
                        }
                        if (e.getURL().toString().toLowerCase().contains("cpcgamereviews.com/index.html")) {
                            return;
                        }
                        if (e.getURL().toString().toLowerCase().endsWith(".jpg") || e.getURL().toString().toLowerCase().contains("orion.cpcscene.com") || e.getURL().toString().toLowerCase().endsWith(".gif") || e.getURL().toString().toLowerCase().endsWith(".pdf") || e.getURL().toString().toLowerCase().endsWith(".zip") || e.getURL().toString().toLowerCase().endsWith(".jar") || e.getURL().toString().toLowerCase().endsWith(".dsk") || e.getURL().toString().toLowerCase().endsWith(".bin") || e.getURL().toString().toLowerCase().endsWith(".bas") || e.getURL().toString().toLowerCase().endsWith(".sna") || e.getURL().toString().toLowerCase().endsWith(".cdt") || e.getURL().toString().toLowerCase().endsWith(".mpg") || e.getURL().toString().toLowerCase().endsWith(".mp3") || e.getURL().toString().toLowerCase().endsWith(".mpeg") || e.getURL().toString().toLowerCase().endsWith(".wmv") || e.getURL().toString().toLowerCase().endsWith(".png") || e.getURL().toString().toLowerCase().endsWith(".rar") || e.getURL().toString().toLowerCase().endsWith(".avi") || e.getURL().toString().toLowerCase().endsWith(".bmp") || e.getURL().toString().toLowerCase().endsWith(".exe") || e.getURL().toString().toLowerCase().endsWith(".msi")) {
                            String old;
                            Samples.LOADING.play();
                            String download = e.getURL().toString();
                            CPC.Oldpage = old = GameBrowser.this.address.getText();
                            if (download.toLowerCase().endsWith(".dsk") || download.toLowerCase().endsWith(".cdt") || download.toLowerCase().endsWith(".sna") || download.toLowerCase().endsWith(".zip") || download.toLowerCase().endsWith(".csw")) {
                                prog.setIndeterminate(true);
                                CPC.Download(download);
                            } else {
                                GameBrowser.this.Download(download);
                            }
                            return;
                        }
                        pane.setPage(e.getURL());
                        GameBrowser.this.address.setText(e.getURL().toString());
                        ++GameBrowser.this.histcount;
                        GameBrowser.this.history[GameBrowser.this.histcount] = GameBrowser.this.address.getText();
                        GameBrowser.this.pagecount = GameBrowser.this.pagecount < 4999 ? ++GameBrowser.this.pagecount : 0;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

