/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Rumbler;

public class GamePadController {
    public boolean haveJoystick;
    public static final int NUM_BUTTONS = 12;
    public static final int NUM_COMPASS_DIRS = 9;
    public static final int NW = 0;
    public static final int NORTH = 1;
    public static final int NE = 2;
    public static final int WEST = 3;
    public static final int NONE = 4;
    public static final int EAST = 5;
    public static final int SW = 6;
    public static final int SOUTH = 7;
    public static final int SE = 8;
    private Controller controller;
    private Component[] comps;
    private int xAxisIdx;
    private int yAxisIdx;
    private int zAxisIdx;
    private int rzAxisIdx;
    private int povIdx;
    private int[] buttonsIdx;
    private Rumbler[] rumblers;
    private int rumblerIdx;
    private boolean rumblerOn = false;

    public GamePadController() {
        try {
            ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
            Controller[] cs = ce.getControllers();
            if (cs.length == 0) {
                System.out.println("No controllers found");
                this.haveJoystick = false;
            } else {
                this.haveJoystick = true;
                System.out.println("Num. controllers: " + cs.length);
            }
            this.controller = this.findGamePad(cs);
            System.out.println("Game controller: " + this.controller.getName() + ", " + this.controller.getType());
            this.findCompIndices(this.controller);
            this.findRumblers(this.controller);
        }
        catch (Exception e) {
            this.haveJoystick = false;
        }
    }

    private Controller findGamePad(Controller[] cs) {
        Controller.Type type;
        int i;
        for (i = 0; i < cs.length && (type = cs[i].getType()) != Controller.Type.GAMEPAD && type != Controller.Type.STICK; ++i) {
        }
        if (i == cs.length) {
            System.out.println("No game pad found");
            this.haveJoystick = false;
            return null;
        }
        System.out.println("Game pad index: " + i);
        this.haveJoystick = true;
        return cs[i];
    }

    private void findCompIndices(Controller controller) {
        this.comps = controller.getComponents();
        if (this.comps.length == 0) {
            System.out.println("No Components found");
            System.exit(0);
        } else {
            System.out.println("Num. Components: " + this.comps.length);
        }
        this.xAxisIdx = this.findCompIndex(this.comps, Component.Identifier.Axis.X, "x-axis");
        this.yAxisIdx = this.findCompIndex(this.comps, Component.Identifier.Axis.Y, "y-axis");
        this.zAxisIdx = this.findCompIndex(this.comps, Component.Identifier.Axis.Z, "z-axis");
        this.rzAxisIdx = this.findCompIndex(this.comps, Component.Identifier.Axis.RZ, "rz-axis");
        this.povIdx = this.findCompIndex(this.comps, Component.Identifier.Axis.POV, "POV hat");
        this.findButtons(this.comps);
    }

    private int findCompIndex(Component[] comps, Component.Identifier id, String nm) {
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (c.getIdentifier() != id || c.isRelative()) continue;
            System.out.println("Found " + c.getName() + "; index: " + i);
            return i;
        }
        System.out.println("No " + nm + " component found");
        return -1;
    }

    private void findButtons(Component[] comps) {
        this.buttonsIdx = new int[12];
        int numButtons = 0;
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (!this.isButton(c)) continue;
            if (numButtons == 12) {
                System.out.println("Found an extra button; index: " + i + ". Ignoring it");
                continue;
            }
            this.buttonsIdx[numButtons] = i;
            System.out.println("Found " + c.getName() + "; index: " + i);
            ++numButtons;
        }
        if (numButtons < 12) {
            System.out.println("Too few buttons (" + numButtons + "); expecting " + '\f');
            while (numButtons < 12) {
                this.buttonsIdx[numButtons] = -1;
                ++numButtons;
            }
        }
    }

    private boolean isButton(Component c) {
        String className;
        return !c.isAnalog() && !c.isRelative() && (className = c.getIdentifier().getClass().getName()).endsWith("Button");
    }

    private void findRumblers(Controller controller) {
        this.rumblers = controller.getRumblers();
        if (this.rumblers.length == 0) {
            System.out.println("No Rumblers found");
            this.rumblerIdx = -1;
        } else {
            System.out.println("Rumblers found: " + this.rumblers.length);
            this.rumblerIdx = this.rumblers.length - 1;
        }
    }

    public void poll() {
        this.controller.poll();
    }

    public int getXYStickDir() {
        if (this.xAxisIdx == -1 || this.yAxisIdx == -1) {
            return 4;
        }
        return this.getCompassDir(this.xAxisIdx, this.yAxisIdx);
    }

    public int getZRZStickDir() {
        if (this.zAxisIdx == -1 || this.rzAxisIdx == -1) {
            return 4;
        }
        return this.getCompassDir(this.zAxisIdx, this.rzAxisIdx);
    }

    private int getCompassDir(int xA, int yA) {
        float xCoord = this.comps[xA].getPollData();
        float yCoord = this.comps[yA].getPollData();
        int xc = Math.round(xCoord);
        int yc = Math.round(yCoord);
        if (yc == -1 && xc == -1) {
            return 0;
        }
        if (yc == -1 && xc == 0) {
            return 1;
        }
        if (yc == -1 && xc == 1) {
            return 2;
        }
        if (yc == 0 && xc == -1) {
            return 3;
        }
        if (yc == 0 && xc == 0) {
            return 4;
        }
        if (yc == 0 && xc == 1) {
            return 5;
        }
        if (yc == 1 && xc == -1) {
            return 6;
        }
        if (yc == 1 && xc == 0) {
            return 7;
        }
        if (yc == 1 && xc == 1) {
            return 8;
        }
        System.out.println("Unknown (x,y): (" + xc + "," + yc + ")");
        return 4;
    }

    public int getHatDir() {
        if (this.povIdx == -1) {
            return 4;
        }
        float povDir = this.comps[this.povIdx].getPollData();
        if (povDir == 0.0f) {
            return 4;
        }
        if (povDir == 0.75f) {
            return 7;
        }
        if (povDir == 0.875f) {
            return 6;
        }
        if (povDir == 0.625f) {
            return 8;
        }
        if (povDir == 1.0f) {
            return 3;
        }
        if (povDir == 0.5f) {
            return 5;
        }
        if (povDir == 0.25f) {
            return 1;
        }
        if (povDir == 0.125f) {
            return 0;
        }
        if (povDir == 0.375f) {
            return 2;
        }
        return 4;
    }

    public boolean[] getButtons() {
        boolean[] buttons = new boolean[12];
        for (int i = 0; i < 12; ++i) {
            if (this.buttonsIdx[i] <= 0) continue;
            float value = this.comps[this.buttonsIdx[i]].getPollData();
            buttons[i] = value != 0.0f;
        }
        return buttons;
    }

    public boolean isButtonPressed(int pos) {
        if (pos < 1 || pos > 12) {
            return false;
        }
        if (this.buttonsIdx[pos - 1] == -1) {
            return false;
        }
        float value = this.comps[this.buttonsIdx[pos - 1]].getPollData();
        return value != 0.0f;
    }

    public void setRumbler(boolean switchOn) {
        if (this.rumblerIdx != -1) {
            if (switchOn) {
                this.rumblers[this.rumblerIdx].rumble(0.8f);
            } else {
                this.rumblers[this.rumblerIdx].rumble(0.0f);
            }
            this.rumblerOn = switchOn;
        }
    }

    public boolean isRumblerOn() {
        return this.rumblerOn;
    }
}

