/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class LCDDisplay
extends JLabel {
    final URL bk = this.getClass().getResource("lcd2.png");
    final Image back = this.getToolkit().getImage(this.bk);
    protected int width = 320;
    protected int height = 200;
    public int filledPixel = -14080200;
    public int sfilledPixel = 690562872;
    public int emptyPixel = 8094819;
    public int[] shades = new int[]{-8682397, -9406628, -9735846, -10064809, -10394028, -10788782, -11118001, -11446964, -11776182, -12105401, -12434363, -12763582, -13092801, -13487555, -13816774, -14080200};
    protected BufferedImage LCDpanel;
    protected BufferedImage LCDshadow;
    protected BufferedImage LCD;
    protected int[] pixels;
    protected WritableRaster raster;
    protected int[] spixels;
    protected WritableRaster sraster;
    int red;
    int green;
    int blue;
    int pixel;

    public LCDDisplay(int w, int h) {
        this.width = w >> 1 << 1;
        this.height = h >> 1 << 1;
        this.LCDpanel = new BufferedImage(this.width, this.height, 2);
        this.LCDshadow = new BufferedImage(this.width, this.height, 2);
        this.LCD = new BufferedImage(this.width, this.height, 1);
        this.raster = this.LCDpanel.getRaster();
        this.sraster = this.LCDshadow.getRaster();
        this.pixels = new int[this.width * this.height];
        this.spixels = new int[this.width * this.height];
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = this.emptyPixel;
            this.spixels[i] = this.emptyPixel;
        }
        this.raster.setDataElements(0, 0, this.width, this.height, this.pixels);
        this.sraster.setDataElements(0, 0, this.width, this.height, this.spixels);
        this.setSize(w, h);
        this.setPreferredSize(new Dimension(w, h));
        this.setDoubleBuffered(true);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void updateDisplay() {
        this.raster.setDataElements(0, 0, this.width, this.height, this.pixels);
        this.sraster.setDataElements(0, 0, this.width, this.height, this.spixels);
        this.paint(this.getGraphics());
    }

    public void setPixel(int x, int y, int r, int g, int b) {
        x = x >> 1 << 1;
        y = y >> 1 << 1;
        int value = b + (g << 8) + (r << 16);
        this.setPixel(x, y, value);
    }

    public void setPixels(int[] pix) {
        if (pix.length < this.pixels.length) {
            System.arraycopy(pix, 0, this.pixels, 0, pix.length);
        } else {
            System.arraycopy(pix, 0, this.pixels, 0, this.pixels.length);
        }
        for (int x = 0; x < this.width; x += 2) {
            for (int y = 0; y < this.height; y += 2) {
                this.red = (this.pixels[x + y * this.width] >> 16 & 0xFF) >> 4;
                this.green = (this.pixels[x + y * this.width] >> 8 & 0xFF) >> 4;
                this.blue = (this.pixels[x + y * this.width] & 0xFF) >> 4;
                this.pixel = 15 - (this.red + this.green + this.blue) / 3;
                this.pixels[x + 1 + this.width * (y + 1)] = this.shades[this.pixel];
                this.pixels[x + this.width * (y + 1)] = this.shades[this.pixel];
                this.pixels[x + 1 + this.width * y] = this.shades[this.pixel];
                this.pixels[x + this.width * y] = this.shades[this.pixel];
            }
        }
    }

    public void setPixel(int x, int y, int shade) {
        this.red = (shade >> 16 & 0xFF) >> 4;
        this.green = (shade >> 8 & 0xFF) >> 4;
        this.blue = (shade & 0xFF) >> 4;
        int p = 15 - (this.red + this.green + this.blue) / 3;
        x = x >> 1 << 1;
        y = y >> 1 << 1;
        this.pixels[x + 1 + this.width * (y + 1)] = this.shades[p];
        this.pixels[x + this.width * (y + 1)] = this.shades[p];
        this.pixels[x + 1 + this.width * y] = this.shades[p];
        this.pixels[x + this.width * y] = this.shades[p];
    }

    public void setPixel(int x, int y, boolean on) {
        this.pixels[x + 1 + this.width * (y + 1)] = on ? this.filledPixel : this.emptyPixel;
        this.pixels[x + this.width * (y + 1)] = on ? this.filledPixel : this.emptyPixel;
        this.pixels[x + 1 + this.width * y] = on ? this.filledPixel : this.emptyPixel;
        this.pixels[x + this.width * y] = on ? this.filledPixel : this.emptyPixel;
        this.spixels[x + 1 + this.width * (y + 1)] = on ? this.sfilledPixel : this.emptyPixel;
        this.spixels[x + this.width * (y + 1)] = on ? this.sfilledPixel : this.emptyPixel;
        this.spixels[x + 1 + this.width * y] = on ? this.sfilledPixel : this.emptyPixel;
        this.spixels[x + this.width * y] = on ? this.sfilledPixel : this.emptyPixel;
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        Graphics2D d = this.LCD.createGraphics();
        d.setColor(new Color(this.emptyPixel));
        d.fillRect(0, 0, this.width, this.height);
        d.drawImage(this.back, 0, 0, this.width, this.height, null);
        d.drawImage((Image)this.LCDshadow, 1, 1, null);
        d.drawImage((Image)this.LCDshadow, 2, 2, null);
        d.drawImage((Image)this.LCDshadow, 3, 3, null);
        d.drawImage((Image)this.LCDpanel, 0, 0, null);
        g.drawImage(this.LCD, 0, 0, this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public static void main(String[] args) {
        JFrame fram = new JFrame();
        LCDDisplay pane = new LCDDisplay(512, 512);
        fram.setLayout(new BorderLayout());
        fram.add((Component)pane, "Center");
        fram.pack();
        fram.setDefaultCloseOperation(3);
        fram.setVisible(true);
        try {
            while (true) {
                Thread.sleep(20L);
                for (int x = 0; x < pane.width; x += 2) {
                    for (int y = 0; y < pane.height; y += 2) {
                        int sd = (int)(Math.random() * 255.0);
                        boolean on = (int)(Math.random() * 10.0) < 5;
                        pane.setPixel(x, y, sd, sd, sd);
                    }
                }
                pane.updateDisplay();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

