/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jemu.core.Util;
import jemu.core.device.Computer;
import jemu.ui.EDisassembler;
import jemu.ui.EMemory;
import jemu.ui.ERegisters;
import jemu.ui.EStackPointer;

public class MultiMem
extends JFrame {
    Computer computer;
    int[] RAMbanks = new int[]{192, 196, 197, 198, 199, 204, 205, 206, 207, 212, 213, 214, 215, 220, 221, 222, 223, 228, 229, 230, 231, 236, 237, 238, 239, 244, 245, 246, 247, 252, 253, 254, 255};
    String[] RAM128k = new String[]{"C0", "C4", "C5", "C6", "C7"};
    String[] RAM256k = new String[]{"C0", "C4", "C5", "C6", "C7", "CC", "CD", "CE", "CF", "D4", "D5", "D6", "D7", "DC", "DD", "DE", "DF"};
    String[] RAM256kSilicon = new String[]{"C0", "E4", "E5", "E6", "E7", "EC", "ED", "EE", "EF", "F4", "F5", "F6", "F7", "FC", "FD", "FE", "FF"};
    String[] RAM512k = new String[]{"C0", "C4", "C5", "C6", "C7", "CC", "CD", "CE", "CF", "D4", "D5", "D6", "D7", "DC", "DD", "DE", "DF", "E4", "E5", "E6", "E7", "EC", "ED", "EE", "EF", "F4", "F5", "F6", "F7", "FC", "FD", "FE", "FF"};
    int lastaddress = 0;
    int lastbank = 0;
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiMem.this.updateUI();
        }
    };
    Timer fireUpdate = new Timer(100, this.update);
    private EDisassembler eDisassembler1;
    private EMemory eMemory1;
    private ERegisters eRegisters1;
    private EStackPointer eStackPointer1;
    private JCheckBox jCheckBox1;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTextField jTextField1;
    private JCheckBox read;

    public MultiMem(Computer computer, int address) {
        this.initComponents();
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.RAM512k));
        this.changeComputer(computer, address);
    }

    public void changeComputer(Computer computer, int address) {
        this.computer = computer;
        this.eDisassembler1.setComputer(computer);
        this.eMemory1.setComputer(computer);
        this.eMemory1.setMemory(computer.getMemory());
        this.eRegisters1.setDevice(computer.getProcessor());
        this.eStackPointer1.setComputer(computer);
        this.setAddress(address, 0);
        this.jComboBox1.setSelectedIndex(0);
    }

    public void setAddress(final int address, int rambank) {
        System.out.println(rambank);
        this.lastaddress = address;
        this.lastbank = rambank;
        this.eMemory1.forcedbank = this.eStackPointer1.forcedbank = this.RAMbanks[this.lastbank];
        this.eDisassembler1.forcedbank = this.eStackPointer1.forcedbank;
        this.eDisassembler1.setAddress(address, true);
        this.eMemory1.setAddress(address);
        this.eStackPointer1.setAddress(address, true);
        this.eRegisters1.setValues();
        this.eDisassembler1.read = this.read.isSelected();
        this.eStackPointer1.read = this.read.isSelected();
        this.eMemory1.read = this.read.isSelected();
        this.jTextField1.setText(Util.hex((short)address));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiMem.this.eMemory1.setSelection(address);
                MultiMem.this.eMemory1.scrollRectToVisible(MultiMem.this.eMemory1.getRect(address));
                MultiMem.this.eMemory1.repaint();
            }
        });
    }

    public void updateUI() {
        this.eMemory1.forcedbank = this.eStackPointer1.forcedbank = this.RAMbanks[this.lastbank];
        this.eDisassembler1.forcedbank = this.eStackPointer1.forcedbank;
        this.eDisassembler1.repaint();
        this.eMemory1.repaint();
        this.eRegisters1.repaint();
        this.eStackPointer1.repaint();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.eRegisters1 = new ERegisters();
        this.eStackPointer1 = new EStackPointer();
        this.jLabel2 = new JLabel();
        this.read = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.jSplitPane1 = new JSplitPane();
        this.eDisassembler1 = new EDisassembler();
        this.jScrollPane1 = new JScrollPane();
        this.eMemory1 = new EMemory();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("MultiDebugger");
        this.setResizable(false);
        this.jLabel1.setText("Address:");
        this.jTextField1.setColumns(4);
        this.jTextField1.setText("0000");
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MultiMem.this.jTextField1KeyReleased(evt);
            }
        });
        GroupLayout eRegisters1Layout = new GroupLayout(this.eRegisters1);
        this.eRegisters1.setLayout(eRegisters1Layout);
        eRegisters1Layout.setHorizontalGroup(eRegisters1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 193, Short.MAX_VALUE));
        eRegisters1Layout.setVerticalGroup(eRegisters1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 335, Short.MAX_VALUE));
        this.jLabel2.setText("Stackpointer");
        this.read.setText("READ");
        this.read.setFocusable(false);
        this.read.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiMem.this.readActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("Auto update");
        this.jCheckBox1.setFocusable(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiMem.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(350);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setTopComponent(this.eDisassembler1);
        this.jScrollPane1.setPreferredSize(new Dimension(464, 100));
        this.jScrollPane1.setViewportView(this.eMemory1);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jLabel3.setText("RAM Bank:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"C0", "C4", "C5", "C6", "C7"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiMem.this.jComboBox1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2).addGap(6, 6, 6).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.read).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1)).addComponent(this.jSplitPane1, -2, 518, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.eRegisters1, -2, -1, -2).addComponent(this.eStackPointer1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.read).addComponent(this.jCheckBox1).addComponent(this.jLabel3).addComponent(this.jComboBox1, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.eRegisters1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eStackPointer1, -1, 190, Short.MAX_VALUE)).addComponent(this.jSplitPane1)).addContainerGap()));
        this.pack();
    }

    private void jTextField1KeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            String value = this.jTextField1.getText();
            int address = Util.hexValue(value);
            this.setAddress(address, this.lastbank);
        }
    }

    private void readActionPerformed(ActionEvent evt) {
        String value = this.jTextField1.getText();
        int address = Util.hexValue(value);
        this.setAddress(address, this.lastbank);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox1.isSelected()) {
            this.fireUpdate.start();
        } else {
            this.fireUpdate.stop();
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.setAddress(this.lastaddress, this.jComboBox1.getSelectedIndex());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MultiMem.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MultiMem.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MultiMem.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MultiMem.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MultiMem(null, 0).setVisible(true);
            }
        });
    }
}

