/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jemu.ui.Display;
import jemu.ui.gfx.AnimatedGifEncoder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class ScreenCapture
extends JPanel {
    private AnimatedGifEncoder capture;
    JFileChooser chooser = new JFileChooser();
    String dir = "c:\\";
    public static boolean record;
    BufferedImage tempimg;
    File temp;
    int position = 0;
    int count = 0;
    public JPanel desktoppane;
    BufferedImage out;
    BufferedImage cap;
    String ending = "bmp";
    int prog;
    Thread runner;
    public static JCheckBox frameskip;
    private JCheckBox gif;
    private ButtonGroup imageformat;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JCheckBox jpg;
    private JCheckBox png;
    private JProgressBar progress;
    private JCheckBox simple;
    private JSlider skip;
    private JLabel skiplabel;
    public static JCheckBox vsync;

    public ScreenCapture() {
        this.initComponents();
        this.progress.setVisible(false);
        this.capture = new AnimatedGifEncoder();
        this.desktoppane = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                if (ScreenCapture.this.out == null) {
                    ScreenCapture.this.out = new BufferedImage(768, 544, 4);
                }
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g = g2;
                if (Display.image != null) {
                    ++ScreenCapture.this.count;
                    if (ScreenCapture.this.count >= ScreenCapture.this.skip.getValue()) {
                        ScreenCapture.this.out.getGraphics().drawImage(Display.image, 0, 0, 768, 544, null);
                        ScreenCapture.this.count = 0;
                        if (record) {
                            ScreenCapture.this.record();
                        }
                    }
                }
                g.drawImage(ScreenCapture.this.out, 0, 0, 384, 272, this);
            }
        };
        this.desktoppane.setBorder(BorderFactory.createEtchedBorder());
        this.desktoppane.setFocusable(false);
        this.jPanel4.add((Component)this.desktoppane, new AbsoluteConstraints(20, 30, 384, 272));
    }

    public void prepareRec() {
        this.chooser.setCurrentDirectory(new File("."));
        this.chooser.setDialogTitle("Choose directory");
        this.chooser.setFileSelectionMode(1);
        this.chooser.setAcceptAllFileFilterUsed(false);
        if (this.chooser.showOpenDialog(this) == 0) {
            this.dir = "" + this.chooser.getSelectedFile();
            System.out.println(this.dir);
        } else {
            this.dir = "c:\\";
            System.out.println("No Selection ");
        }
    }

    public void record() {
        if (this.cap == null) {
            this.cap = new BufferedImage(384, 272, 4);
        }
        this.ending = this.jpg.isSelected() ? "jpg" : (this.png.isSelected() ? "png" : (this.gif.isSelected() ? "gif" : "bmp"));
        int i = this.position;
        String prenumber = "";
        if (i < 10000000) {
            prenumber = "0";
        }
        if (i < 1000000) {
            prenumber = "00";
        }
        if (i < 100000) {
            prenumber = "000";
        }
        if (i < 10000) {
            prenumber = "0000";
        }
        if (i < 1000) {
            prenumber = "00000";
        }
        if (i < 100) {
            prenumber = "000000";
        }
        if (i < 10) {
            prenumber = "0000000";
        }
        this.temp = new File(this.dir + "\\capture_" + prenumber + this.position + "." + this.ending);
        try {
            if (this.simple.isSelected()) {
                this.cap.getGraphics().drawImage(Display.image, 0, 0, 384, 272, null);
                ImageIO.write((RenderedImage)this.cap, this.ending, this.temp);
            } else {
                ImageIO.write((RenderedImage)Display.image, this.ending, this.temp);
            }
        }
        catch (Exception e) {
            record = false;
            --this.position;
            return;
        }
        ++this.position;
    }

    public void buildGif() {
        this.runner = new Thread(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScreenCapture.this.progress.setValue(ScreenCapture.this.prog);
                    }
                });
                ScreenCapture.this.runner.setPriority(1);
                ScreenCapture.this.progress.setMaximum(ScreenCapture.this.position);
                ScreenCapture.this.progress.setVisible(true);
                ScreenCapture.this.capture.start(ScreenCapture.this.dir + "\\capture.gif");
                ScreenCapture.this.capture.setDelay(ScreenCapture.this.skip.getValue() * 2);
                ScreenCapture.this.capture.setRepeat(0);
                BufferedImage img = null;
                for (int i = 0; i <= ScreenCapture.this.position; ++i) {
                    ScreenCapture.this.prog = i;
                    ScreenCapture.this.progress.setValue(i);
                    try {
                        String prenumber = "";
                        if (i < 10000000) {
                            prenumber = "0";
                        }
                        if (i < 1000000) {
                            prenumber = "00";
                        }
                        if (i < 100000) {
                            prenumber = "000";
                        }
                        if (i < 10000) {
                            prenumber = "0000";
                        }
                        if (i < 1000) {
                            prenumber = "00000";
                        }
                        if (i < 100) {
                            prenumber = "000000";
                        }
                        if (i < 10) {
                            prenumber = "0000000";
                        }
                        img = ImageIO.read(new File(ScreenCapture.this.dir + "\\capture_" + prenumber + i + "." + ScreenCapture.this.ending));
                        ScreenCapture.this.capture.addFrame(img);
                        File delthis = new File(ScreenCapture.this.dir + "\\capture_" + prenumber + i + "." + ScreenCapture.this.ending);
                        delthis.delete();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ScreenCapture.this.capture.finish();
                ScreenCapture.this.progress.setVisible(false);
            }
        };
        this.runner.start();
    }

    private void initComponents() {
        this.imageformat = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jButton4 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton5 = new JButton();
        this.jButton3 = new JButton();
        this.progress = new JProgressBar();
        this.skip = new JSlider();
        this.skiplabel = new JLabel();
        vsync = new JCheckBox();
        frameskip = new JCheckBox();
        this.simple = new JCheckBox();
        this.jpg = new JCheckBox();
        this.png = new JCheckBox();
        this.gif = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.setDoubleBuffered(false);
        this.setName("Screencapture");
        this.setLayout(new AbsoluteLayout());
        this.jPanel2.setFocusable(false);
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.jPanel4.setFocusable(false);
        this.jPanel4.setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("GIF-Sequence"));
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.jButton4.setText("Cancel");
        this.jButton4.setFocusable(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenCapture.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton4, new AbsoluteConstraints(460, 50, -1, -1));
        this.jButton6.setText("Stop");
        this.jButton6.setFocusable(false);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenCapture.this.jButton6ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton6, new AbsoluteConstraints(390, 50, 60, -1));
        this.jButton7.setText("Pause");
        this.jButton7.setFocusable(false);
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenCapture.this.jButton7ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton7, new AbsoluteConstraints(310, 50, 70, -1));
        this.jButton5.setText("Start");
        this.jButton5.setFocusable(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenCapture.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton5, new AbsoluteConstraints(230, 50, 70, -1));
        this.jButton3.setText("Select output folder");
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenCapture.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton3, new AbsoluteConstraints(20, 50, -1, -1));
        this.jPanel1.add((Component)this.progress, new AbsoluteConstraints(10, 30, 520, -1));
        this.jPanel4.add((Component)this.jPanel1, new AbsoluteConstraints(10, 320, 540, 90));
        this.skip.setMaximum(10);
        this.skip.setMinimum(1);
        this.skip.setMinorTickSpacing(1);
        this.skip.setOrientation(1);
        this.skip.setPaintTicks(true);
        this.skip.setSnapToTicks(true);
        this.skip.setValue(5);
        this.skip.setFocusable(false);
        this.skip.setInverted(true);
        this.skip.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ScreenCapture.this.skipStateChanged(evt);
            }
        });
        this.jPanel4.add((Component)this.skip, new AbsoluteConstraints(420, 20, -1, 170));
        this.skiplabel.setText("10 FP/s");
        this.skiplabel.setFocusable(false);
        this.jPanel4.add((Component)this.skiplabel, new AbsoluteConstraints(460, 170, -1, -1));
        vsync.setText("wait for vSync");
        vsync.setFocusable(false);
        this.jPanel4.add((Component)vsync, new AbsoluteConstraints(420, 200, -1, 20));
        frameskip.setText("No frameskip");
        frameskip.setFocusable(false);
        this.jPanel4.add((Component)frameskip, new AbsoluteConstraints(420, 220, -1, 20));
        this.simple.setText("Simple sized only");
        this.simple.setFocusable(false);
        this.jPanel4.add((Component)this.simple, new AbsoluteConstraints(420, 240, -1, 20));
        this.jpg.setText("Save as JPG");
        this.jpg.setFocusable(false);
        this.jpg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenCapture.this.jpgActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jpg, new AbsoluteConstraints(420, 300, -1, 20));
        this.png.setText("Save as PNG");
        this.png.setFocusable(false);
        this.png.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenCapture.this.pngActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.png, new AbsoluteConstraints(420, 280, -1, 20));
        this.gif.setText("Save as GIF");
        this.gif.setFocusable(false);
        this.gif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenCapture.this.gifActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.gif, new AbsoluteConstraints(420, 260, -1, 20));
        this.jLabel1.setText("Frames:");
        this.jPanel4.add((Component)this.jLabel1, new AbsoluteConstraints(460, 150, -1, -1));
        this.jPanel2.add((Component)this.jPanel4, new AbsoluteConstraints(10, 0, 560, 420));
        this.add((Component)this.jPanel2, new AbsoluteConstraints(0, 0, -1, -1));
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.prepareRec();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.position = 0;
        record = true;
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        record = false;
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        record = false;
        this.buildGif();
    }

    private void skipStateChanged(ChangeEvent evt) {
        this.skiplabel.setText(50 / this.skip.getValue() + " FP/s");
    }

    private void pngActionPerformed(ActionEvent evt) {
        if (this.png.isSelected()) {
            this.jpg.setSelected(false);
            this.gif.setSelected(false);
        }
    }

    private void jpgActionPerformed(ActionEvent evt) {
        if (this.jpg.isSelected()) {
            this.png.setSelected(false);
            this.gif.setSelected(false);
        }
    }

    private void gifActionPerformed(ActionEvent evt) {
        if (this.gif.isSelected()) {
            this.png.setSelected(false);
            this.jpg.setSelected(false);
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        record = false;
    }
}

