/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.cpcgamescd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.ui.Desktop;
import jemu.ui.JEMU;
import jemu.ui.cpcgamescd.CPCFileSystem;

public class CPCGamesCDGUI
extends JPanel {
    CPC cpc;
    Desktop desktop;
    String[] drives = new String[]{"Folder", "D:", "E:", "F:", "G:", "H:", "I:", "J:", "K:", "L:", "M:", "N:", "O:", "P:", "Q:", "R:", "S:", "T:", "U:", "V:", "W:", "X:", "Y:", "Z:"};
    boolean hascd = false;
    String CDFolder = null;
    String[] list;
    String[] genres = new String[]{"Arcade", "Board", "Compilation", "Educational", "Graphic Adventure", "Other", "Sport", "Strategy", "Text Adventure", "Type-In"};
    boolean toggleScreen;
    BufferedImage renderBuffer;
    BufferedImage renderBuffer2;
    BufferedImage screenBuffer;
    String filepath;
    byte[][] diskdata;
    String[] diskfiles;
    int diskpos;
    CPCFileSystem sys = new CPCFileSystem();
    String INPUT_GZIP_FILE;
    String OUTPUT_FILE;
    String mappath;
    int gamepos;
    boolean generate;
    private JButton bwd;
    private JComboBox cdrom;
    private JTextField dskname;
    private JList files;
    private JButton fwd;
    private JComboBox genre;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JLabel language;
    private JButton map;
    private JLabel publisher;
    private JLabel shot;
    private JLabel shot1;
    private JLabel title;
    private JLabel year;

    public CPCGamesCDGUI(CPC cpc, Desktop desktop) {
        int i;
        this.cpc = cpc;
        this.desktop = desktop;
        this.initComponents();
        String p = Settings.get("cpcgamescd_path", null);
        if (p != null) {
            for (i = 0; i < this.drives.length; ++i) {
                if (!p.equals(this.drives[i])) continue;
                this.cdrom.setSelectedIndex(i);
                break;
            }
        }
        if (p != null) {
            p = Settings.get("cpcgamescd_genre", null);
            if (p != null) {
                for (i = 0; i < this.genres.length; ++i) {
                    if (!p.equals(this.genres[i])) continue;
                    this.genre.setSelectedIndex(i);
                    break;
                }
            }
            this.scan();
        }
    }

    protected void getFolder() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.showOpenDialog(null);
        File folder = fileChooser.getSelectedFile();
        this.CDFolder = folder.getPath();
        Settings.set("cpcgamescd_path", this.CDFolder);
    }

    protected String getPath() {
        this.CDFolder = Settings.get("cpcgamescd_path", this.drives[this.cdrom.getSelectedIndex()]);
        if (this.CDFolder == null || this.CDFolder.equals("Folder")) {
            this.getFolder();
        }
        if (this.CDFolder == null) {
            return "";
        }
        return this.CDFolder;
    }

    protected void scan() {
        String path = this.getPath();
        File a = new File(path + "/Arcade/");
        if (a.exists() && (a = new File(path + "/Board/")).exists() && (a = new File(path + "/Compilation/")).exists() && (a = new File(path + "/Educational/")).exists() && (a = new File(path + "/Graphic Adventure/")).exists() && (a = new File(path + "/Other/")).exists() && (a = new File(path + "/Simulation/")).exists() && (a = new File(path + "/Sport/")).exists() && (a = new File(path + "/Strategy/")).exists() && (a = new File(path + "/Text Adventure/")).exists() && (a = new File(path + "/Type-In/")).exists()) {
            this.hascd = true;
            if (this.cdrom.getSelectedIndex() > 0) {
                Settings.set("cpcgamescd_path", this.drives[this.cdrom.getSelectedIndex()]);
            }
        }
        System.out.println("Found CD: " + this.hascd);
        this.genre.setEnabled(this.hascd);
        this.files.setEnabled(this.hascd);
        this.jButton2.setEnabled(this.hascd);
        this.jButton3.setEnabled(this.hascd);
        this.dskname.setEnabled(this.hascd);
        if (this.hascd) {
            this.scan(this.genres[this.genre.getSelectedIndex()]);
        }
    }

    protected void scan(String scanpath) {
        if (!this.hascd) {
            this.files.setEnabled(this.hascd);
            this.genre.setEnabled(this.hascd);
            this.files.setEnabled(this.hascd);
            this.jButton2.setEnabled(this.hascd);
            this.jButton3.setEnabled(this.hascd);
            this.dskname.setEnabled(this.hascd);
            return;
        }
        Settings.set("cpcgamescd_genre", this.genres[this.genre.getSelectedIndex()]);
        String path = this.getPath() + "/" + scanpath + "/";
        File g = new File(path);
        this.list = g.list();
        if (this.list == null) {
            this.files.setModel(new AbstractListModel(){
                String[] strings = new String[]{"Empty"};

                @Override
                public int getSize() {
                    return this.strings.length;
                }

                @Override
                public Object getElementAt(int i) {
                    return this.strings[i];
                }
            });
            this.hascd = false;
            this.files.setEnabled(this.hascd);
            this.genre.setEnabled(this.hascd);
            this.files.setEnabled(this.hascd);
            this.jButton2.setEnabled(this.hascd);
            this.jButton3.setEnabled(this.hascd);
            this.dskname.setEnabled(this.hascd);
            return;
        }
        this.files.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return CPCGamesCDGUI.this.list.length;
            }

            @Override
            public Object getElementAt(int i) {
                return CPCGamesCDGUI.this.list[i];
            }
        });
        this.files.setSelectedIndex(0);
        this.read(0);
    }

    protected void toggleScreen() {
    }

    protected void insertDisk(boolean generate) {
        if (this.cpc == null) {
            return;
        }
        try {
            if (generate) {
                this.generateGame();
            } else {
                this.cpc.DSK_Load("name", this.diskdata[this.diskpos]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void generateGame() {
        int i;
        if (this.list == null) {
            return;
        }
        if (this.files == null) {
            return;
        }
        String name = System.getProperty("user.home") + "/JavaCPC/" + this.list[this.files.getSelectedIndex()];
        String path = this.filepath;
        File a = new File(path);
        String[] n = a.list();
        int pos = 0;
        for (i = 0; i < n.length; ++i) {
            a = new File(path + n[i]);
            if (a.isDirectory()) {
                File c = new File(path + n[i] + "/");
                a = new File(name + "_" + n[i].toLowerCase() + ".dsk");
                ++pos;
                while (a.exists()) {
                    a.delete();
                }
                continue;
            }
            if (n[i].toLowerCase().contains("file_id.diz")) continue;
            a = new File(name + ".dsk");
            while (a.exists()) {
                a.delete();
            }
            ++pos;
        }
        this.diskdata = new byte[pos][];
        this.diskfiles = new String[pos];
        this.diskpos = 0;
        pos = 0;
        for (i = 0; i < n.length; ++i) {
            a = new File(path + n[i]);
            System.out.println(path + n[i]);
            if (a.isDirectory()) {
                this.addDisk(path + n[i] + "/", null, name + "_" + n[i].toLowerCase() + ".dsk");
                this.diskfiles[pos++] = name + "_" + n[i].toLowerCase() + ".dsk";
                continue;
            }
            if (n[i].toLowerCase().contains("file_id.diz")) continue;
            String add = "";
            if (n[i].toLowerCase().endsWith(".gz")) {
                add = "_disk" + (pos + 1);
            }
            this.addDisk(path, n[i], name + add + ".dsk");
            this.diskfiles[pos++] = name + add + ".dsk";
        }
        for (i = 0; i < this.diskfiles.length; ++i) {
            try {
                a = new File(this.diskfiles[i]);
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
                this.diskdata[i] = new byte[(int)a.length()];
                bin.read(this.diskdata[i]);
                bin.close();
                while (a.exists()) {
                    a.delete();
                }
                continue;
            }
            catch (Exception e) {
                String[] dskfiles = new String[i];
                System.arraycopy(this.diskfiles, 0, dskfiles, 0, dskfiles.length);
                this.diskfiles = new String[i];
                System.arraycopy(dskfiles, 0, this.diskfiles, 0, dskfiles.length);
                break;
            }
        }
        this.dskname.setText(this.getDiskName());
        boolean hasmore = this.diskfiles.length > 1;
        this.bwd.setEnabled(hasmore);
        this.fwd.setEnabled(hasmore);
        this.insertDisk(false);
    }

    protected String getDiskName() {
        String name = this.diskfiles[this.diskpos];
        if (name.contains("/")) {
            while (name.contains("/")) {
                name = name.substring(1);
            }
        }
        if (name.contains("\\")) {
            while (name.contains("\\")) {
                name = name.substring(1);
            }
        }
        return name;
    }

    protected void addDisk(String path, String dskname, String name) {
        System.out.println("Creating: " + path + " - " + name);
        if (dskname != null && dskname.toLowerCase().endsWith(".gz")) {
            this.INPUT_GZIP_FILE = path + dskname;
            this.OUTPUT_FILE = name;
            this.gunzipIt();
            return;
        }
        if (dskname != null && dskname.toLowerCase().endsWith(".dsk")) {
            File ta = new File(path + dskname);
            File tb = new File(name);
            Path a = ta.toPath();
            Path b = tb.toPath();
            StandardCopyOption option = StandardCopyOption.REPLACE_EXISTING;
            try {
                Files.copy(a, b, option);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        File a = new File(name);
        if (!a.exists()) {
            this.sys.get(name);
        }
        if (dskname != null) {
            this.sys.DIR();
            this.sys.copyToDSK(path, dskname, name);
        } else {
            a = new File(path);
            String[] l = a.list();
            for (int i = 0; i < l.length; ++i) {
                if (!(l[i].toLowerCase().contains("file_id.diz") || l[i].toLowerCase().endsWith(".dsk") || l[i].toLowerCase().endsWith(".gz"))) {
                    this.sys.DIR();
                    this.sys.copyToDSK(path, l[i], name);
                    continue;
                }
                if (l[i] == null || !l[i].toLowerCase().endsWith(".gz")) continue;
                this.INPUT_GZIP_FILE = path + l[i];
                this.OUTPUT_FILE = name;
                this.gunzipIt();
            }
        }
    }

    public void gunzipIt() {
        byte[] buffer = new byte[1024];
        try {
            int len;
            GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(this.INPUT_GZIP_FILE));
            FileOutputStream out = new FileOutputStream(this.OUTPUT_FILE);
            while ((len = gzis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            gzis.close();
            out.close();
            System.out.println("Done");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void setInfo(String info) {
        this.filepath = info;
        File a = new File(info + "file_id.diz");
        if (!a.exists()) {
            return;
        }
        byte[] g = new byte[(int)a.length()];
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
            bin.read(g);
            bin.close();
            StringBuilder k = new StringBuilder();
            for (int i = 0; i < g.length; ++i) {
                k.append((char)g[i]);
            }
            String[] h = k.toString().split("\n");
            this.title.setText("unknown");
            this.year.setText("unknown");
            this.publisher.setText("unknown");
            this.language.setText("unknown");
            for (int i = 0; i < h.length; ++i) {
                String b = h[i];
                if (b.toLowerCase().startsWith("title:")) {
                    b = b.substring(6);
                    while (b.startsWith(" ")) {
                        b = b.substring(1);
                    }
                    this.title.setText(b);
                }
                if (b.toLowerCase().startsWith("year:")) {
                    b = b.substring(5);
                    while (b.startsWith(" ")) {
                        b = b.substring(1);
                    }
                    this.year.setText(b);
                }
                if (b.toLowerCase().startsWith("publisher:")) {
                    b = b.substring(10);
                    while (b.startsWith(" ")) {
                        b = b.substring(1);
                    }
                    this.publisher.setText(b);
                }
                if (b.toLowerCase().startsWith("company:")) {
                    b = b.substring(8);
                    while (b.startsWith(" ")) {
                        b = b.substring(1);
                    }
                    this.publisher.setText(b);
                }
                if (!b.toLowerCase().startsWith("language:")) continue;
                b = b.substring(9);
                while (b.startsWith(" ")) {
                    b = b.substring(1);
                }
                this.language.setText(b);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void read(int index) {
        if (!this.hascd) {
            return;
        }
        String g = this.getPath() + "/Snap/";
        String map = this.getPath() + "/Maps/maps/";
        String f = this.list[index];
        String k = f.toLowerCase().charAt(0) + "";
        if (k.contains("'")) {
            k = f.toLowerCase().charAt(1) + "";
        }
        try {
            int v = Integer.parseInt(k);
            k = "#";
        }
        catch (Exception v) {
            // empty catch block
        }
        g = g + k + "/" + f + ".png";
        map = map + f;
        File c = new File(map);
        this.mappath = null;
        this.map.setEnabled(c.exists());
        if (this.map.isEnabled()) {
            this.mappath = map;
        }
        if (this.mappath == null) {
            map = this.getPath() + "/Maps/";
            map = map + f;
            c = new File(map);
            this.mappath = null;
            this.map.setEnabled(c.exists());
            if (this.map.isEnabled()) {
                this.mappath = map;
            }
        }
        File a = new File(g);
        try {
            this.screenBuffer = ImageIO.read(a);
            this.renderBuffer = new BufferedImage(384, 272, 1);
            this.renderBuffer.createGraphics().drawImage((Image)this.screenBuffer, 0, 0, this);
            this.renderBuffer2 = new BufferedImage(384, 272, 1);
            this.renderBuffer2.createGraphics().drawImage((Image)this.screenBuffer, 0, -272, this);
            this.shot.setIcon(new ImageIcon(this.renderBuffer));
            this.shot1.setIcon(new ImageIcon(this.renderBuffer2));
            this.toggleScreen = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInfo(this.getPath() + "/" + this.genres[this.genre.getSelectedIndex()] + "/" + this.list[index] + "/");
    }

    public static void main(String[] args) {
        JFrame fram = new JFrame("CPCGamesCD - Test GUI");
        fram.setLayout(new BorderLayout());
        CPCGamesCDGUI gui = new CPCGamesCDGUI(null, null);
        fram.setDefaultCloseOperation(3);
        fram.add((Component)gui, "Center");
        fram.pack();
        fram.setVisible(true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cdrom = new JComboBox();
        this.jButton1 = new JButton();
        this.genre = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.files = new JList();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.language = new JLabel();
        this.publisher = new JLabel();
        this.year = new JLabel();
        this.title = new JLabel();
        this.bwd = new JButton();
        this.dskname = new JTextField();
        this.fwd = new JButton();
        this.jButton3 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.shot = new JLabel();
        this.shot1 = new JLabel();
        this.jButton2 = new JButton();
        this.map = new JButton();
        this.jLabel7 = new JLabel();
        this.jButton4 = new JButton();
        this.jLabel1.setText("Select CD-Rom drive:");
        this.cdrom.setModel(new DefaultComboBoxModel<String>(new String[]{"Folder", "D:", "E:", "F:", "G:", "H:", "I:", "J:", "K:", "L:", "M:", "N:", "O:", "P:", "Q:", "R:", "S:", "T:", "U:", "V:", "W:", "X:", "Y:", "Z:"}));
        this.cdrom.setFocusable(false);
        this.jButton1.setText("Scan CD");
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPCGamesCDGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.genre.setModel(new DefaultComboBoxModel<String>(new String[]{"Arcade", "Board", "Compilation", "Educational", "Graphic Adventure", "Other", "Sport", "Strategy", "Text Adventure", "Type-In"}));
        this.genre.setEnabled(false);
        this.genre.setFocusable(false);
        this.genre.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CPCGamesCDGUI.this.genreItemStateChanged(evt);
            }
        });
        this.jLabel2.setText("Genre:");
        this.files.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Empty"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.files.setEnabled(false);
        this.files.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CPCGamesCDGUI.this.filesMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                CPCGamesCDGUI.this.filesMouseReleased(evt);
            }
        });
        this.files.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CPCGamesCDGUI.this.filesKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.files);
        this.jLabel3.setText("Title:");
        this.jLabel4.setText("Year:");
        this.jLabel5.setText("Publisher:");
        this.jLabel6.setText("Language:");
        this.language.setText("none");
        this.publisher.setText("none");
        this.year.setText("none");
        this.title.setText("none");
        this.bwd.setText("<");
        this.bwd.setEnabled(false);
        this.bwd.setFocusable(false);
        this.bwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPCGamesCDGUI.this.bwdActionPerformed(evt);
            }
        });
        this.dskname.setEnabled(false);
        this.dskname.setFocusable(false);
        this.fwd.setText(">");
        this.fwd.setEnabled(false);
        this.fwd.setFocusable(false);
        this.fwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPCGamesCDGUI.this.fwdActionPerformed(evt);
            }
        });
        this.jButton3.setText("Insert");
        this.jButton3.setEnabled(false);
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPCGamesCDGUI.this.jButton3ActionPerformed(evt);
            }
        });
        this.shot.setMaximumSize(new Dimension(384, 272));
        this.shot.setMinimumSize(new Dimension(384, 272));
        this.shot.setPreferredSize(new Dimension(384, 272));
        this.shot.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                CPCGamesCDGUI.this.shotMouseReleased(evt);
            }
        });
        this.jTabbedPane1.addTab("Loading screen", this.shot);
        this.shot1.setMaximumSize(new Dimension(384, 272));
        this.shot1.setMinimumSize(new Dimension(384, 272));
        this.shot1.setPreferredSize(new Dimension(384, 272));
        this.shot1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                CPCGamesCDGUI.this.shot1MouseReleased(evt);
            }
        });
        this.jTabbedPane1.addTab("Screenshot", this.shot1);
        this.jButton2.setText("Boot");
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPCGamesCDGUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.map.setText("Map");
        this.map.setFocusable(false);
        this.map.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPCGamesCDGUI.this.mapActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Get CPCGamesCD");
        this.jButton4.setText("Visit Website");
        this.jButton4.setFocusable(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPCGamesCDGUI.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 389, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.year, -1, -1, Short.MAX_VALUE).addComponent(this.publisher, -1, -1, Short.MAX_VALUE).addComponent(this.language, -1, -1, Short.MAX_VALUE).addComponent(this.title, -1, 328, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cdrom, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 106, Short.MAX_VALUE).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.genre, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4)).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.bwd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.map).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.dskname).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fwd))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cdrom, -2, -1, -2).addComponent(this.jButton1).addComponent(this.genre, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel7).addComponent(this.jButton4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 271, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.title)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.year)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.publisher)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.language))).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bwd).addComponent(this.dskname, -2, -1, -2).addComponent(this.fwd)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton3).addComponent(this.jButton2).addComponent(this.map)))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.cdrom.getSelectedIndex() == 0) {
            this.CDFolder = "Folder";
            Settings.set("cpcgamescd_path", this.CDFolder);
        }
        this.scan();
    }

    private void genreItemStateChanged(ItemEvent evt) {
        this.scan(this.genres[this.genre.getSelectedIndex()]);
    }

    private void filesMouseReleased(MouseEvent evt) {
        this.read(this.files.getSelectedIndex());
    }

    private void shotMouseReleased(MouseEvent evt) {
        this.toggleScreen();
    }

    private void filesKeyReleased(KeyEvent evt) {
        this.read(this.files.getSelectedIndex());
        if (evt.getKeyCode() == 10) {
            this.generate = this.gamepos != this.files.getSelectedIndex();
            this.gamepos = this.files.getSelectedIndex();
            this.insertDisk(true);
            this.boot();
        }
    }

    private void fwdActionPerformed(ActionEvent evt) {
        if (this.diskpos < this.diskfiles.length - 1) {
            ++this.diskpos;
            this.dskname.setText(this.getDiskName());
        }
    }

    private void bwdActionPerformed(ActionEvent evt) {
        if (this.diskpos > 0) {
            --this.diskpos;
            this.dskname.setText(this.getDiskName());
        }
    }

    private void filesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.generate = this.gamepos != this.files.getSelectedIndex();
            this.gamepos = this.files.getSelectedIndex();
            this.insertDisk(true);
            this.boot();
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.generate = this.gamepos != this.files.getSelectedIndex();
        this.gamepos = this.files.getSelectedIndex();
        this.insertDisk(this.generate);
    }

    private void shot1MouseReleased(MouseEvent evt) {
        this.toggleScreen();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.boot();
    }

    private void boot() {
        if (this.cpc != null) {
            Thread g = new Thread(){

                @Override
                public void run() {
                    CPCGamesCDGUI.this.cpc.reset();
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CPCGamesCDGUI.this.cpc.bootDisk();
                }
            };
            g.start();
        }
    }

    private void mapActionPerformed(ActionEvent evt) {
        try {
            if (this.mappath != null) {
                java.awt.Desktop.getDesktop().open(new File(this.mappath));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        JEMU.openWebPage("http://cpcgamescd.amstrad.es/");
    }
}

