/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import jemu.ui.paint.importPCX;
import jemu.ui.paint.importTGA;
import org.monte.ilbmdemo.ILBMViewer;

public class ImageImporter {
    importTGA tga;
    importPCX pcx;
    ILBMViewer ilbm;
    protected String PBM_HEADER = "PBM";
    protected String ILBM_HEADER = "ILBM";
    public String filetype;

    public String getFileType() {
        return this.filetype;
    }

    public BufferedImage readImage(String filename) throws IOException {
        if (this.tga == null) {
            this.tga = new importTGA();
        }
        if (this.pcx == null) {
            this.pcx = new importPCX();
        }
        if (this.ilbm == null) {
            this.ilbm = new ILBMViewer();
        }
        File input = new File(filename);
        byte[] data = new byte[50];
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(input));
        bin.read(data);
        bin.close();
        BufferedImage bo = null;
        if (this.PBM_HEADER.equals(new String(data, 8, this.PBM_HEADER.length()))) {
            bo = this.ilbm.getAmigaPicture(filename);
            this.filetype = "PBM";
        } else if (this.ILBM_HEADER.equals(new String(data, 8, this.ILBM_HEADER.length()))) {
            bo = this.ilbm.getAmigaPicture(filename);
            this.filetype = "ILBM";
        } else if (filename.toLowerCase().endsWith(".tga")) {
            this.filetype = "TGA";
            bo = this.tga.getImage(filename, false);
        } else if (filename.toLowerCase().endsWith(".pcx")) {
            this.filetype = "PCX";
            bo = importPCX.getImage(filename);
        } else {
            if (filename.contains(".")) {
                String n = filename;
                while (n.contains(".")) {
                    n = n.substring(1);
                }
                this.filetype = n = n.toUpperCase();
            }
            File imagein = new File(filename);
            BufferedImage bi = ImageIO.read(imagein);
            bo = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
            bo.getGraphics().drawImage(bi, 0, 0, null);
        }
        return bo;
    }
}

