/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.lhadecompressor.LhDecoder;
import net.sourceforge.lhadecompressor.LhaException;

public class Lh2Decoder
extends LhDecoder {
    private static final int N_CHAR = 314;
    private static final int TREESIZE_CODE = 628;
    private static final int TREESIZE_POSITION = 256;
    private static final int TREESIZE = 884;
    private static final int ROOT_CODE = 0;
    private static final int ROOT_POSITION = 628;
    private int nMax = 286;
    private int maxMatch = 256;
    private int[] child;
    private int[] parent;
    private int[] block;
    private int[] edge;
    private int[] stock;
    private int[] sNode;
    private int[] freq;
    private int avail;
    private int n1;
    private int totalPosition;
    private int mostPosition;
    private int nn = 8192;
    private long nextCount;

    public Lh2Decoder(InputStream in, long originalSize) {
        super(in, originalSize, 13, 253);
    }

    private void initCodeDynamic() {
        this.child = new int[884];
        this.parent = new int[884];
        this.block = new int[884];
        this.edge = new int[884];
        this.stock = new int[884];
        this.sNode = new int[442];
        this.freq = new int[884];
        this.n1 = this.nMax >= 256 + this.maxMatch - 3 + 1 ? 512 : this.nMax - 1;
        for (int i = 0; i < 628; ++i) {
            this.stock[i] = i;
            this.block[i] = 0;
        }
        int j = this.nMax * 2 - 2;
        int i = 0;
        while (i < this.nMax) {
            this.freq[j] = 1;
            this.child[j] = ~i;
            this.sNode[i] = j;
            this.block[j] = 1;
            ++i;
            --j;
        }
        this.avail = 2;
        this.edge[1] = this.nMax - 1;
        i = this.nMax * 2 - 2;
        while (j >= 0) {
            int f = this.freq[j] = this.freq[i] + this.freq[i - 1];
            this.child[j] = i;
            int n = j;
            this.parent[i - 1] = n;
            this.parent[i] = n;
            this.block[j] = f == this.freq[j + 1] ? this.block[j + 1] : this.stock[this.avail++];
            this.edge[this.block[j]] = j;
            i -= 2;
            --j;
        }
    }

    private void initPositionDynamic() {
        this.freq[628] = 1;
        this.child[628] = -315;
        this.sNode[314] = 628;
        this.block[628] = this.stock[this.avail++];
        this.edge[this.block[628]] = 628;
        this.mostPosition = 628;
        this.totalPosition = 0;
        this.nextCount = 64L;
    }

    private void reconstruct(int begin, int end) {
        int k;
        int i;
        int j = begin;
        int b = this.block[begin];
        for (i = begin; i < end; ++i) {
            k = this.child[i];
            if (k < 0) {
                this.freq[j] = (this.freq[i] + 1) / 2;
                this.child[j] = k;
                ++j;
            }
            if (this.edge[b = this.block[i]] != i) continue;
            this.stock[--this.avail] = b;
        }
        --j;
        int l = end - 2;
        i = end - 1;
        while (i >= begin) {
            while (i >= l) {
                this.freq[i] = this.freq[j];
                this.child[i] = this.child[j];
                --i;
                --j;
            }
            int f = this.freq[l] + this.freq[l + 1];
            k = begin;
            while (f < this.freq[k]) {
                ++k;
            }
            while (j >= k) {
                this.freq[i] = this.freq[j];
                this.child[i] = this.child[j];
                --i;
                --j;
            }
            this.freq[i] = f;
            this.child[i] = l + 1;
            --i;
            l -= 2;
        }
        int f = 0;
        for (int i2 = begin; i2 < end; ++i2) {
            j = this.child[i2];
            if (j < 0) {
                this.sNode[j ^ 0xFFFFFFFF] = i2;
            } else {
                int n = i2;
                this.parent[j - 1] = n;
                this.parent[j] = n;
            }
            int g = this.freq[i2];
            if (g == f) {
                this.block[i2] = b;
                continue;
            }
            b = this.block[i2] = this.stock[this.avail++];
            this.edge[b] = i2;
            f = g;
        }
    }

    private int swapInc(int p) {
        int b = this.block[p];
        int q = this.edge[b];
        if (q != p) {
            int s;
            int r = this.child[p];
            this.child[p] = s = this.child[q];
            this.child[q] = r;
            if (r >= 0) {
                int n = q;
                this.parent[r - 1] = n;
                this.parent[r] = n;
            } else {
                this.sNode[r ^ 0xFFFFFFFF] = q;
            }
            if (s >= 0) {
                int n = p;
                this.parent[s - 1] = n;
                this.parent[s] = n;
            } else {
                this.sNode[s ^ 0xFFFFFFFF] = p;
            }
            p = q;
            int n = b;
            this.edge[n] = this.edge[n] + 1;
            int n2 = p;
            this.freq[n2] = this.freq[n2] + 1;
            if (this.freq[p] == this.freq[p - 1]) {
                this.block[p] = this.block[p - 1];
            } else {
                this.block[p] = this.stock[this.avail++];
                this.edge[this.block[p]] = p;
            }
        } else if (b == this.block[p + 1]) {
            int n = b;
            this.edge[n] = this.edge[n] + 1;
            int n3 = p;
            this.freq[n3] = this.freq[n3] + 1;
            if (this.freq[p] == this.freq[p - 1]) {
                this.block[p] = this.block[p - 1];
            } else {
                this.block[p] = this.stock[this.avail++];
                this.edge[this.block[p]] = p;
            }
        } else {
            int n = p;
            this.freq[n] = this.freq[n] + 1;
            if (this.freq[n] == this.freq[p - 1]) {
                this.stock[--this.avail] = b;
                this.block[p] = this.block[p - 1];
            }
        }
        return this.parent[p];
    }

    private void updateCode(int p) {
        if (this.freq[0] == 32768) {
            this.reconstruct(0, this.nMax * 2 - 1);
        }
        this.freq[0] = this.freq[0] + 1;
        int q = this.sNode[p];
        while ((q = this.swapInc(q)) != 0) {
        }
    }

    private void updatePosition(int p) {
        if (this.totalPosition == 32768) {
            this.reconstruct(628, this.mostPosition + 1);
            this.totalPosition = this.freq[628];
            this.freq[628] = 65535;
        }
        int q = this.sNode[p + 314];
        while (q != 628) {
            q = this.swapInc(q);
        }
        ++this.totalPosition;
    }

    private void makeNewNode(int p) {
        int r = this.mostPosition + 1;
        int q = r + 1;
        this.child[r] = this.child[this.mostPosition];
        this.child[this.child[r] ^ 0xFFFFFFFF] = r;
        this.child[q] = ~(p + 314);
        this.child[this.mostPosition] = q;
        this.freq[r] = this.freq[this.mostPosition];
        this.freq[q] = 0;
        this.block[r] = this.block[this.mostPosition];
        if (this.mostPosition == 628) {
            this.freq[628] = 65535;
            int n = this.block[628];
            this.edge[n] = this.edge[n] + 1;
        }
        this.parent[r] = this.parent[q] = this.mostPosition;
        this.block[q] = this.stock[this.avail++];
        this.sNode[p + 314] = this.mostPosition = q;
        this.edge[this.block[q]] = this.mostPosition;
        this.updatePosition(p);
    }

    @Override
    protected void initRead() throws LhaException, IOException {
        this.fillBitBuffer(16);
        this.initCodeDynamic();
        this.initPositionDynamic();
    }

    @Override
    protected int decodeCode() throws IOException {
        int c = this.child[0];
        int b = this.bitBuffer;
        int count = 0;
        do {
            c = (b & 0x8000) != 0 ? this.child[c - 1] : this.child[c];
            b <<= 1;
            if (++count != 16) continue;
            this.fillBitBuffer(16);
            b = this.bitBuffer;
            count = 0;
        } while (c > 0);
        this.fillBitBuffer(count);
        this.updateCode(c ^= 0xFFFFFFFF);
        if (c == this.n1) {
            c += this.getBits(8);
        }
        return c;
    }

    @Override
    protected int decodePosition() throws IOException {
        while (this.decodeCount > this.nextCount) {
            this.makeNewNode((int)(this.nextCount / 64L));
            this.nextCount += 64L;
            if (this.nextCount < (long)this.nn) continue;
            this.nextCount = 0xFFFFFFFFL;
        }
        int c = this.child[628];
        int b = this.bitBuffer;
        int count = 0;
        while (c > 0) {
            c = (b & 0x8000) != 0 ? this.child[c - 1] : this.child[c];
            b <<= 1;
            if (++count != 16) continue;
            this.fillBitBuffer(16);
            b = this.bitBuffer;
            count = 0;
        }
        this.fillBitBuffer(count);
        c = ~c - 314;
        this.updatePosition(c);
        return (c << 6) + this.getBits(6);
    }
}

