/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.InputStream;
import net.sourceforge.lhadecompressor.LhaException;
import net.sourceforge.lhadecompressor.SlidingDicDecoder;

public abstract class LhDecoder
extends SlidingDicDecoder {
    protected static final int NPT = 128;
    protected static final int NC = 510;
    protected static final int POSITION_TABLE_SIZE = 256;
    protected int[] treeLeft = new int[1019];
    protected int[] treeRight = new int[1019];
    protected int[] positionTable = new int[256];
    protected int[] positionLength = new int[128];

    public LhDecoder(InputStream in, long originalSize, int dictionaryBit, int positionAdjust) {
        super(in, originalSize, dictionaryBit, positionAdjust);
    }

    protected final void makeTable(int nchar, int[] bitLength, int tableBits, int[] table) throws LhaException {
        int i;
        int[] countTable = new int[17];
        int[] weightTable = new int[17];
        int[] startTable = new int[17];
        for (i = 1; i <= 16; ++i) {
            countTable[i] = 0;
            weightTable[i] = 1 << 16 - i;
        }
        for (i = 0; i < nchar; ++i) {
            if (bitLength[i] > 16) {
                throw new LhaException("Bad table.");
            }
            int n = bitLength[i];
            countTable[n] = countTable[n] + 1;
        }
        int total = 0;
        for (i = 1; i <= 16; ++i) {
            startTable[i] = total;
            total += weightTable[i] * countTable[i];
        }
        if ((total & 0xFFFF) != 0 || tableBits > 16) {
            throw new LhaException("Bad table.");
        }
        int m = 16 - tableBits;
        i = 1;
        while (i <= tableBits) {
            int n = i;
            startTable[n] = startTable[n] >>> m;
            int n2 = i++;
            weightTable[n2] = weightTable[n2] >>> m;
        }
        int j = startTable[tableBits + 1] >>> m;
        int k = 1 << tableBits;
        if (k > 4096) {
            k = 4096;
        }
        if (j != 0) {
            for (i = j; i < k; ++i) {
                table[i] = 0;
            }
        }
        int avail = nchar;
        for (j = 0; j < nchar; ++j) {
            k = bitLength[j];
            if (k == 0) continue;
            int l = startTable[k] + weightTable[k];
            if (k <= tableBits) {
                if (l > 4096) {
                    l = 4096;
                }
                for (int i2 = startTable[k]; i2 < l; ++i2) {
                    table[i2] = j;
                }
            } else {
                int[] t = table;
                int start = startTable[k];
                int p = start >>> m;
                if (p > 4096) {
                    throw new LhaException("Bad table.");
                }
                start <<= tableBits;
                for (int n = k - tableBits; n > 0; --n) {
                    if (t[p] == 0) {
                        this.treeLeft[avail] = 0;
                        this.treeRight[avail] = 0;
                        t[p] = avail++;
                    }
                    p = t[p];
                    t = (start & 0x8000) != 0 ? this.treeRight : this.treeLeft;
                    start <<= 1;
                }
                t[p] = j;
            }
            startTable[k] = l;
        }
    }
}

